/*
 * Makefile for labjack test applications
 *
 * Copyright (c) 2003 Eric Sorton <erics@cfl.rr.com>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <stdio.h>
#include <errno.h>

int main(int argc, char *argv[])
{
	int fd;
	int rtn;
	unsigned char sendBuffer[8];
	unsigned char readBuffer[8];
	float version;

	fd = open("/dev/usb/labjack0", O_RDWR);
	if (fd == -1) {
		printf("open(/dev/usb/labjack0) gescheitert\n");
		perror("open");
		exit(1);
	}
	printf("open(/dev/usb/labjack0) erfolgreich: fd=%d\n",fd);

	memset(sendBuffer, 0, 8);
	sendBuffer[0]=1;
	sendBuffer[5]=83;
	if ((rtn = write(fd, sendBuffer, 8)) == -1) {
		perror("write");
		close(fd);
		exit(1);
	}
	printf("write() erfolgreich\n");

	memset(readBuffer, 0, 8);
	if ((rtn = read(fd, readBuffer, 8)) == -1) {
		perror("read");
		close(fd);
		exit(1);
	}

	version = ((float)readBuffer[0]) + readBuffer[1]*0.01;
	printf("labjack firmware version: %.2f\n", version);

	close(fd);

	exit(0);
}
