// lauflicht.cc

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include "ljackv112.h"

void printerror(char *s,long er)
{
 char str[80];
 GetErrorString(er,str); printf("%s%s\n",s,str);
}
int printfirmware()
{
 char buf[8];
 int n,fd=open("/dev/usb/labjack0",O_RDWR);
 if(fd<0) {printf("kein Labjack gefunden\n"); return -1;}
 memset(buf,0,8); buf[5]=0x53; buf[0]=1;
 n=write(fd,buf,8); //Bug im Labjack: erster Zugriff wird ignoriert
 if(n!=8) {printf("Fehler in write: %d\n",n); return -2;}
 n=write(fd,buf,8);
 if(n!=8) {printf("Fehler in write: %d\n",n); return -2;}
 n=read(fd,buf,8);
 printf("Firmware: %d.%02d\n",buf[0],buf[1]);
 close(fd);
 return 0;
}

void msleep(long msec) {usleep(1000*msec);}

int main (int argc, char *argv[])
{
  float analogout[2]={0.5,1.0};
  float analogin[8];
  long id=0, er;
  int i,j,k;
  char str[80];

  InitLabjack();
  if(printfirmware()<0) exit(0);

  // Test Analog Outs (Using EAnalogOut)
  printf("Testing analog outs  AO0: %.3lf AO1: %.3lf\n",
	 analogout[0],analogout[1]);
  er=EAnalogOut(&id,0,analogout[0],analogout[1]);
  if(er!=0) printerror("Error Analog Outs: ",er);
  //printf("id=%ld\n",id);//test

  int channel,state;
  for(j=0;j<3;j++) //3 mal blinken
    {er=EDigitalOut(&id,0,channel=0,0,state=1); msleep(200);
     if(er!=0) printerror("Error EDigitalOut: ",er);
     er=EDigitalOut(&id,0,channel=0,0,state=0); msleep(200);
     if(er!=0) printerror("Error EDigitalOut: ",er);
    }

  long trisD=0,trisIO=0xF,stateD=0,stateIO,update=1,outputD;
  for(j=0;j<5;j++) //5 mal Lauflicht
  for(k=1;k<0x10;k<<=1)
    {stateIO=k;
     er=DigitalIO(&id,0,&trisD,trisIO,&stateD,&stateIO,update,&outputD);
     if(er!=0) printerror("Error DigitalIO: ",er);
     msleep(100);
    }
}
