// zahn1.cc   Variante mit Library

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include "ljackv112.h"

void printerror(char *s,long er)
{
 char str[80];
 GetErrorString(er,str); printf("%s%s\n",s,str);
}
int printfirmware()
{
 char buf[8];
 int n,fd=open("/dev/usb/labjack0",O_RDWR);
 if(fd<0) {printf("kein Labjack gefunden\n"); return -1;}
 memset(buf,0,8); buf[5]=0x53; buf[0]=1;
 n=write(fd,buf,8); //Bug im Labjack: erster Zugriff wird ignoriert
 if(n!=8) {printf("Fehler in write: %d\n",n); return -2;}
 n=write(fd,buf,8);
 if(n!=8) {printf("Fehler in write: %d\n",n); return -2;}
 n=read(fd,buf,8);
 printf("Firmware: %d.%02d\n",buf[0],buf[1]);
 close(fd);
 return 0;
}

void msleep(long msec) {usleep(1000*msec);}

int main (int argc, char *argv[])
{
 float analogout[2]={0.5,1.0};
 double analogin[8];
 int i,j,k;
 long er,id=0;
 char str[80];
 if(printfirmware()<0) exit(0);

 // Test Analog Outs
 for(j=0;j<100;j++)
 for(i=0;i<=10;i++)
  {analogout[0]=0.5*i; analogout[1]=5.0-0.5*i;
   er=EAnalogOut(&id,0,analogout[0],analogout[1]);
   if(er!=0) printerror("Error Analog Outs: ",er);
   //sleep(3);
  }
}
