<?php
/* mg.php				letzte Aenderung: 8.2.2006
#define VERSION "1.7"

Verwendung:
Nach Eingabe einer Formel wird das Molekulargewicht auf 3 Nachkommastellen
genau berechnet.
Aufrufbeispiel: mg.php?formel=CH3-CH2-OH&flags=i
Beispiele:
> mg CH3-CH2-OH  -->  46.069
> mg -i CH3-CH2-OH  -->  46.042
> mg "CH3-(CH2)2-OH" --> 60.096
> mg Boc-Ala-Aib-OMe --> 288.344

History:
Datum      Version  Kommentar
17.8.2004	Uebernommen von mg.cc Version 1.6 (27.2.)
19.8.04		Gleiche Anpassungen wie in mg.cc
28.10.04	Unterstuetzen auch von z.B. -(CH_2)_3,
		ist_leer() korrigiert '*' ist kein Leerzeichen, stattdessen
		in Hauptschlaufen nach '*' abfragen (bei while(isform..).
		Wichtig fuer z.B. *5H2O
8.2.06	  1.7	Gleiche Korrekturen wie in mg.cc
*/
?>
<HTML>
<HEAD><TITLE>MG-Rechner PHP-Variante</TITLE></HEAD>
<BODY>
<?php
function digit($c)
{
 if($c>='a') return $c-'a'+10;
 if($c>='A') return $c-'A'+10;
 return $c-'0';
}
/*
function filtern($formel)
{
 for($s="",$t="",$formel,$i=0,$j=0; ($c = $s[$i++])!=0;)
   {if($c=='%')
     {$c1= $s[$i++]; $c2= $s[$i++]; $c=($digit($c1)<<4)+$digit($c2);}
    $t[$j++] = $c;
   }
 $t[$j]=0;
 return $t;
}
*/
function plus($f) {$f=substr($f,1);}
function plusplus($f) {$c=$f[0]; $f=substr($f,1); return $c;}
function isupper($c) {return $c>='A' && $c<='Z';}
function islower($c) {return $c>='a' && $c<='z';}
function isdigit($c) {return $c>='0' && $c<='9';}
function dann($c1,$c2) {return ord($c1)+256*ord($c2);}
function elem($c) {return ord($c[0])+256*ord($c[1]);}
function isdigitu($c) {return $c=='_' || ($c>='0' && $c<='9');}
function plusplusu($f)
{
 $c=$f[0]; if($c=='_') {$f=substr($f,1); $c=$f[0];}
 $f=substr($f,1);
 return $c;
}

/******************************* Tabellen *****************************/
//#define DANN *256+

function mol_wight($formel,$zs) /*  Berechne Molekulargewicht */
{
 $summe=0.0;
 $m=0.0;
 $s='';
 $einzelzeichen = array(
/* A */	 0., 10.811, 12.011, 2.014102, 0., 18.9984, 0., 1.00794, 126.9044,
/* J */	 126.9044, 39.0983, 0., 0., 14.0067, 15.9994, 30.9738, 0., 0.,
/* S */	 32.066, 0., 238.0289, 50.9415, 183.85, 0., 88.9059, 135.1424);
/* letzter Wert Z = Schutzgruppe C6H5-CH2-O-CO- */
 while(isformelzeichen($c= $formel[0]) && $c!=')' && $c!=']' && $c!='*')
  {if($c=='(' || $c=='[')
	{if($c=='[') $klamzu=']'; else $klamzu=')';
	 plus(&$formel);
	 $m=mol_wight($formel,&$s);
	 $formel=$s;
	 if(plusplus(&$formel)!=$klamzu) {echo "fehlende $klamzu Klammer: '$s'<br>\n"; break;}
	}
   else {if(!isupper($c))
		{printf("ungueltige Formel:%s<BR>\n",$formel); break;}
	 if(islower($formel[1]) || ($formel[1]=='Z' && ($c=='P' || $c=='M')))
	    {switch (dann($formel[0],$formel[1]))
		{
		 case elem('Ac'): $m=227.0278;	break;
		 case elem('Ag'): $m=107.8682;	break;
		 case elem('Al'): if($formel[2]=='a')
					{$m=71.0788; plus(&$formel);} /*-Ala-*/
				    else $m=26.9815; /*Aluminium*/	break;
		 case elem('Ai'): if($formel[2]=='b')
					{$m=85.1057; plus(&$formel);} /*-Aib-*/
				    else $m=0.0; 	break;
		 case elem('Ar'): if($formel[2]=='g') {$m=156.1875; plus(&$formel);}
				    else $m=39.948;	break;
		 case elem('As'): if($formel[2]=='n') {$m=114.1038; plus(&$formel);}
				    else if($formel[2]=='p')
						       {$m=115.0886; plus(&$formel);}
				    else  $m=74.9216;	break;
		 case elem('Am'): $m=243.0614;	break;
		 case elem('At'): $m=209.9871;	break;
		 case elem('Au'): $m=196.9665;	break;
		 case elem('Ba'): $m=137.327;	break;
		 case elem('Be'): $m=9.01218;	break;
		 case elem('Bi'): $m=208.9804;	break;
		 case elem('Bk'): $m=247.0703;	break;
		 case elem('Br'): $m=79.909;	break;
		 case elem('Bo'): if($formel[2]=='c') {$m=101.1253; plus(&$formel);} /*Boc-*/
				    else $m=0.0; break;
		 case elem('Bz'): if($formel[2]=='l') {$m=91.1326; plus(&$formel);} /*Benzyl*/
				    else $m=0.0; break;
		 case elem('Bu'): $m=57.11546;	break; /* Butyl */
		 case elem('Ca'): $m=40.078;	break;
		 case elem('Cd'): $m=112.411;	break;
		 case elem('Ce'): $m=140.115;	break;
		 case elem('Cf'): $m=251.0796;	break;
		 case elem('Cl'): $m=35.453;	break;
		 case elem('Cm'): $m=247.0703;	break;
		 case elem('Cp'): $m=65.0947;  break;
		 case elem('Cr'): $m=51.9961;	break;
		 case elem('Cs'): $m=132.9051;	break;
		 case elem('Co'): $m=58.9332;	break;
		 case elem('Cu'): $m=63.546;	break;
		 case elem('Cy'): if($formel[2]=='s') {$m=103.1448; plus(&$formel);}
				    else $m=0.0;	break;
		 case elem('Dy'): $m=162.5;	break;
		 case elem('Er'): $m=167.26;	break;
		 case elem('Es'): $m=252.0829;	break;
		 case elem('Et'): $m=29.0617;	break;
		 case elem('Eu'): $m=151.965;	break;
		 case elem('Fe'): $m=55.847;	break;
		 case elem('Fm'): if($formel[2]=='o' && $formel[3]=='c')
				{$m=223.25114; plus(&$formel); plus(&$formel);} /* Fmoc */
				    else $m=257.0951;	break;
		 case elem('Fr'): $m=223.0197;	break;
		 case elem('Ga'): $m=69.723;	break;
		 case elem('Gd'): $m=157.25;	break;
		 case elem('Ge'): $m=72.61;	break;
		 case elem('Gl'): if($formel[2]=='y') {$m=57.0519; plus(&$formel);} /*-Gly-*/
				    else if($formel[2]=='n') {$m=128.1307; plus(&$formel);}
				    else if($formel[2]=='u') {$m=129.1155; plus(&$formel);}
				    else $m=0.0; break;
		 case elem('He'): $m=4.002602;	break;
		 case elem('Hf'): $m=178.49;	break;
		 case elem('Hg'): $m=200.59;	break;
		 case elem('Ho'): $m=164.9303;	break;
		 case elem('Hi'): if($formel[2]=='s') {$m=137.1411; plus(&$formel);}
				    else $m=0.0;	break;
		 case elem('Il'): if($formel[2]=='e') {$m=113.1594; plus(&$formel);}
				    else $m=0.0;	break;
		 case elem('In'): $m=114.82;	break;
		 case elem('Ir'): $m=192.22;	break;
		 case elem('Kr'): $m=83.80;	break;
		 case elem('La'): $m=138.9055;	break;
		 case elem('Le'): if($formel[2]=='u') {$m=113.1594; plus(&$formel);}
				    else $m=0.0;	break;
		 case elem('Ly'): if($formel[2]=='s') {$m=128.1741; plus(&$formel);}
				    else $m=0.0;	break;
		 case elem('Li'): $m=6.941;	break;
		 case elem('Lr'): $m=260.1053;	break;
		 case elem('Lu'): $m=174.967;	break;
		 case elem('Md'): $m=258.0986;	break;
		 case elem('Me'): if($formel[2]=='t') {$m=131.1986; plus(&$formel);}
				    else $m=15.0348;	break;
		 case elem('Mg'): $m=24.305;	break;
		 case elem('Mn'): $m=54.938;	break;
		 case elem('Mo'): $m=95.94;	break;
		 case elem('Mz'): $m=269.2798; break; /*Mz-Schutzgruppe*/
		 case elem('MZ'): $m=269.2798; break; /*Mz-Schutzgruppe*/
		 case elem('Na'): $m=22.9897;	break;
		 case elem('Nb'): $m=92.90638;	break;
		 case elem('Nd'): $m=144.24;	break;
		 case elem('Ne'): $m=20.1797;	break;
		 case elem('Ni'): $m=58.69;	break;
		 case elem('No'): $m=259.1009;	break;
		 case elem('Np'): $m=237.0482;	break;
		 case elem('Os'): $m=190.2;	break;
		 case elem('Pa'): $m=231.0359;	break;
		 case elem('Pb'): $m=207.2;	break;
		 case elem('Pd'): $m=106.42;	break;
		 case elem('Ph'): if($formel[2]=='e') {$m=147.1766; plus(&$formel);}
				    else $m=77.1057;	break;
		 case elem('Pm'): $m=146.9151;	break;
		 case elem('Po'): $m=208.9824;	break;
		 case elem('Pr'): if($formel[2]=='o') {$m=97.1167; plus(&$formel);}
				    else $m=140.9077;	break;
		 case elem('Pt'): $m=195.08;	break;
		 case elem('Pu'): $m=244.0642;	break;
		 case elem('Pz'): $m=239.2535; break; /*Pz-Schutzgruppe*/
		 case elem('PZ'): $m=239.2535; break; /*Pz-Schutzgruppe*/
		 case elem('Ra'): $m=226.0254;	break;
		 case elem('Rb'): $m=85.4678;	break;
		 case elem('Re'): $m=186.207;	break;
		 case elem('Rh'): $m=102.9055;	break;
		 case elem('Rn'): $m=222.0176;	break;
		 case elem('Ru'): $m=101.07;	break;
		 case elem('Sb'): $m=121.75;	break;
		 case elem('Sc'): $m=44.95591;	break;
		 case elem('Se'): if($formel[2]=='r') {$m=87.0782; plus(&$formel);}
				    else $m=78.96;	break;
		 case elem('Si'): $m=28.0855;	break;
		 case elem('Sm'): $m=150.36;	break;
		 case elem('Sn'): $m=118.710;	break;
		 case elem('Sr'): $m=87.62;	break;
		 case elem('Ta'): $m=180.9479;	break;
		 case elem('Tb'): $m=158.9253;	break;
		 case elem('Tc'): $m=98.9063;	break;
		 case elem('Te'): $m=127.60;	break;
		 case elem('Th'): if($formel[2]=='r') {$m=101.1051; plus(&$formel);}
				    else $m=232.0381;	break;
		 case elem('Ti'): $m=47.88;	break;
		 case elem('Tl'): $m=204.3833;	break;
		 case elem('Tm'): $m=168.9342;	break;
		 case elem('Tr'): if($formel[2]=='p') {$m=186.2132; plus(&$formel);}
				    else $m=0.0;	break;
		 case elem('Ty'): if($formel[2]=='r') {$m=163.1760; plus(&$formel);}
				    else $m=0.0;	break;
		 case elem('Va'): if($formel[2]=='l') {$m=99.1326; plus(&$formel);}
				    else $m=0.0;	break;
		 case elem('Xe'): $m=131.29;	break;
		 case elem('Yb'): $m=173.04;	break;
		 case elem('Zn'): $m=65.39;	break;
		 case elem('Zr'): $m=91.224;	break;
		 default :	    $m=0.0;	break;
		}
	     plus(&$formel);
	    }
	 else 	    {$m=$einzelzeichen[ord($c)-ord('A')];}
	 plus(&$formel);
	}
   if($m==0) {printf("Unbekannt:%s\n",$formel); break;}
   if(isdigitu($formel[0]))
	{$c = plusplusu(&$formel) - '0';
	 while(isdigit($formel[0]))
		{ $c= 10*$c + plusplus(&$formel) - '0';}
	}
   else $c=1;
   $summe += $c*$m;
//   echo "m=$m c=$c summe=$summe<br>"; //test
   while(ist_leer($formel[0])) plus(&$formel);
  }
 if($c=='*')
  {plus(&$formel);
   if(isdigit($c= $formel[0]))
	{$c = plusplus(&$formel) - '0';
	 while(isdigit($formel[0]))
		{ $c= 10*$c + plusplus(&$formel) - '0';}
	}
   else	$c=1;
   $summe += $c*mol_wight($formel,&$s);
   $formel=$s;
  }
 $zs = $formel;
 return $summe;
}

function mol_wight_iso($formel,$zs) /* nur hufigste Isotope */
{
 $summe=0.0;
 $m=0.0;
 $s='';
 $einzelzeichen = array(
/* A */	 0., 11.0093, 12.000, 2.014102, 0., 18.9984, 0., 1.007825, 126.9044,
/* J */	 126.9044, 38.9637, 0., 0., 14.00307, 15.9949, 30.9738, 0., 0.,
/* S */	 31.97207, 0., 238.05076, 50.94398, 183.95099, 0., 88.90543, 135.0446);
/* letzter Wert Z = Schutzgruppe C6H5-CH2-O-CO- */
/* printf("mol_wight_iso('%s')\n",formel);/* test */
 while(isformelzeichen($c= $formel[0]) && $c!=')' && $c!=']' && $c!='*')
  {if($c=='(' || $c=='[')
	{if($c=='[') $klamzu=']'; else $klamzu=')';
	 plus(&$formel);
	 $m=mol_wight_iso($formel,&$s);
	 $formel=$s;
	 if(plusplus(&$formel)!=$klamzu) {echo "fehlende $klamzu Klammer: '$zs'<br>\n"; break;}
	}
   else 	{if(!isupper($c))
		{printf("ungueltige formel:%s<BR>\n",$formel); break;}
	 if(islower($formel[1]) || ($formel[1]=='Z' && ($c=='P' || $c=='M')))
	    {switch (dann($formel[0],$formel[1]))
		{
		 case elem('Ac'): $m=227.0278;	break;
		 case elem('Ag'): $m=106.90497; break;
		 case elem('Al'): if($formel[2]=='a')
					{$m=71.0371; plus(&$formel);} /*-Ala-*/
				    else $m=26.9815;	 break;
		 case elem('Ai'): if($formel[2]=='b')
					{$m=85.0527; plus(&$formel);} /*-Aib-*/
				    else $m=0.0; 	break;
		 case elem('Ar'): if($formel[2]=='g') {$m=156.1011; plus(&$formel);}
				    else $m=39.96238;	 break;
		 case elem('As'): if($formel[2]=='n') {$m=114.0429; plus(&$formel);}
				    else if($formel[2]=='p')
						       {$m=115.0269; plus(&$formel);}
				    else  $m=74.9216;	 break;
		 case elem('Am'): $m=243.0614;	break;
		 case elem('At'): $m=209.9871;	break;
		 case elem('Au'): $m=196.9665;	 break;
		 case elem('Ba'): $m=137.90501; break;
		 case elem('Be'): $m=9.01218;	 break;
		 case elem('Bi'): $m=208.9804;	 break;
		 case elem('Bk'): $m=247.0703;	break;
		 case elem('Br'): $m=78.91835;	 break;
		 case elem('Bo'): if($formel[2]=='c') {$m=101.0602; plus(&$formel);} /*Boc-*/
				    else $m=0.0; break;
		 case elem('Bz'): if($formel[2]=='l') {$m=91.0548; plus(&$formel);} /*Benzyl*/
				    else $m=0.0; break;
		 case elem('Bu'): $m=57.070425;	break; /* Butyl */
		 case elem('Ca'): $m=39.96259;  break;
		 case elem('Cd'): $m=113.90357; break;
		 case elem('Ce'): $m=139.90528; break;
		 case elem('Cf'): $m=251.0796;	break;
		 case elem('Cl'): $m=34.96885;  break;
		 case elem('Cm'): $m=247.0703;	break;
		 case elem('Cp'): $m=65.039125; break;
		 case elem('Cr'): $m=51.94051;  break;
		 case elem('Cs'): $m=132.9051;	 break;
		 case elem('Co'): $m=58.9332;	 break;
		 case elem('Cu'): $m=62.9296;	 break;
		 case elem('Cy'): if($formel[2]=='s') {$m=103.0092; plus(&$formel);}
				    else $m=0.0;	break;
		 case elem('Dy'): $m=162.5;	break;
		 case elem('Er'): $m=167.26;	break;
		 case elem('Es'): $m=252.0829;	break;
		 case elem('Et'): $m=29.039125;break;
		 case elem('Eu'): $m=151.965;	break;
		 case elem('Fe'): $m=55.93493;	 break;
		 case elem('Fm'): if($formel[2]=='o' && $formel[3]=='c')
				{$m=223.075875; plus(&$formel); plus(&$formel);} /* Fmoc */
				    else $m=257.0951;	break;
		 case elem('Fr'): $m=223.0197;	break;
		 case elem('Ga'): $m=68.92568;	 break;
		 case elem('Gd'): $m=157.25;	break;
		 case elem('Ge'): $m=73.92115;	 break;
		 case elem('Gl'): if($formel[2]=='y') {$m=57.0214; plus(&$formel);} /*-Gly-*/
				    else if($formel[2]=='n') {$m=128.0585; plus(&$formel);}
				    else if($formel[2]=='u') {$m=129.0425; plus(&$formel);}
				    else $m=0.0; break;
		 case elem('He'): $m=4.002604;	 break;
		 case elem('Hf'): $m=179.94681; break;
		 case elem('Hg'): $m=201.97063; break;
		 case elem('Ho'): $m=164.9303;	 break;
		 case elem('Hi'): if($formel[2]=='s') {$m=137.0589; plus(&$formel);}
				    else $m=0.0;	break;
		 case elem('Il'): if($formel[2]=='e') {$m=113.0840; plus(&$formel);}
				    else $m=0.0;	break;
		 case elem('In'): $m=114.90407; break;
		 case elem('Ir'): $m=192.96328; break;
		 case elem('Kr'): $m=83.9115;	 break;
		 case elem('La'): $m=138.90606; break;
		 case elem('Li'): $m=7.016005;	 break;
		 case elem('Lr'): $m=260.1053;	break;
		 case elem('Lu'): $m=174.967;	break;
		 case elem('Le'): if($formel[2]=='u') {$m=113.0840; plus(&$formel);}
				    else $m=0.0;	break;
		 case elem('Ly'): if($formel[2]=='s') {$m=128.0949; plus(&$formel);}
				    else $m=0.0;	break;
		 case elem('Md'): $m=258.0986;	break;
		 case elem('Me'): if($formel[2]=='t') {$m=131.0405; plus(&$formel);}
				    else $m=15.023475; break;
		 case elem('Mg'): $m=23.98505;	 break;
		 case elem('Mn'): $m=54.938;	 break;
		 case elem('Mo'): $m=97.90551;	 break;
		 case elem('Mz'): $m=269.0926; break; /*Mz-Schutzgruppe*/
		 case elem('MZ'): $m=269.0926; break; /*MZ-Schutzgruppe*/
		 case elem('Na'): $m=22.98977;	 break;
		 case elem('Nb'): $m=92.90638;	 break;
		 case elem('Nd'): $m=141.90748; break;
		 case elem('Ne'): $m=19.99244;	 break;
		 case elem('Ni'): $m=57.93534;	 break;
		 case elem('No'): $m=259.1009;	break;
		 case elem('Np'): $m=237.0482;	break;
		 case elem('Os'): $m=191.96141; break;
		 case elem('Pa'): $m=231.0359;	break;
		 case elem('Pb'): $m=207.97664; break;
		 case elem('Pd'): $m=105.9032;	 break;
		 case elem('Ph'): if($formel[2]=='e') {$m=147.0684; plus(&$formel);}
				    else $m=77.0391;	break;
		 case elem('Pm'): $m=146.9151;	break;
		 case elem('Po'): $m=208.9824;	break;
		 case elem('Pr'): if($formel[2]=='o') {$m=97.0257; plus(&$formel);}
				    else $m=140.9077;	break;
		 case elem('Pt'): $m=194.96482; break;
		 case elem('Pu'): $m=244.0642;	break;
		 case elem('Pz'): $m=239.0820; break; /*Pz-Schutzgruppe*/
		 case elem('PZ'): $m=239.0820; break; /*Pz-Schutzgruppe*/
		 case elem('Ra'): $m=226.0254;	break;
		 case elem('Rb'): $m=84.91171;	 break;
		 case elem('Re'): $m=186.95596; break;
		 case elem('Rh'): $m=102.9055;	break;
		 case elem('Rn'): $m=222.0176;	break;
		 case elem('Ru'): $m=101.07;	break;
		 case elem('Sb'): $m=120.90375; break;
		 case elem('Sc'): $m=44.95591;	 break;
		 case elem('Se'): if($formel[2]=='r') {$m=87.0320; plus(&$formel);}
				    else $m=79.91651;	 break;
		 case elem('Si'): $m=27.9769;	break;
		 case elem('Sm'): $m=150.36;	break;
		 case elem('Sn'): $m=119.90213; break;
		 case elem('Sr'): $m=87.90561;	 break;
		 case elem('Ta'): $m=180.9479;	break;
		 case elem('Tb'): $m=158.9253;	break;
		 case elem('Tc'): $m=98.9063;	break;
		 case elem('Te'): $m=129.9067;	 break;
		 case elem('Th'): if($formel[2]=='r') {$m=101.0476; plus(&$formel);}
				    else $m=232.0381;	 break;
		 case elem('Ti'): $m=47.94795;	 break;
		 case elem('Tl'): $m=204.97446; break;
		 case elem('Tm'): $m=168.9342;	break;
		 case elem('Tr'): if($formel[2]=='p') {$m=186.0793; plus(&$formel);}
				    else $m=0.0;	break;
		 case elem('Ty'): if($formel[2]=='r') {$m=163.0633; plus(&$formel);}
				    else $m=0.0;	break;
		 case elem('Va'): if($formel[2]=='l') {$m=99.0684; plus(&$formel);}
				    else $m=0.0;	break;
		 case elem('Xe'): $m=131.90416; break;
		 case elem('Yb'): $m=173.93902; break;
		 case elem('Zn'): $m=63.92915;	 break;
		 case elem('Zr'): $m=89.90432;	 break;
		 default :	 $m=0.0;	break;
		}
	     plus(&$formel);
	    }
	 else 	    {$m=$einzelzeichen[ord($c)-ord('A')];}
	 plus(&$formel);
	}
   if($m==0) {printf("Unbekannt:%s\n",formel); break;}
   if(isdigitu($formel[0]))
	{$c = plusplusu(&$formel) - '0';
	 while(isdigit($formel[0]))
		{ $c= 10*$c + plusplus(&$formel) - '0';}
	}
   else $c=1;
   $summe += $c*$m;
   while(ist_leer($formel[0])) plus(&$formel);
  }
 if($c=='*')
  {plus(&$formel);
   if(isdigit($c= $formel[0]))
	{$c = plusplus(&$formel) - '0';
	 while(isdigit($formel[0]))
		{ $c= 10*$c + plusplus(&$formel) - '0';}
	}
   else	$c=1;
   $summe += $c*mol_wight_iso($formel,&$s);
   $formel=$s;
  }
 $zs = $formel;
 return $summe;
}


function isfirstformelzeichen($c)
{
 return (isupper($c) || $c=='(' || $c=='[');
}

function ist_leer($c)
{
 return ($c=='-' || $c=='=' || $c=='_');
}

function isformelzeichen($c)
{
 if($c=='') return false;
 return (isfirstformelzeichen(c) || islower(c) || ist_leer(c)
	 || $c==')' || $c==']');
}

/***************************** Hauptprogramm **************************/
// $formel=filtern($formel);
/*
 char *s,cstr[40];
 $nachkomma=3;
 sprintf(cstr,"Molgewicht = %%.%dlf\n",nachkomma);
*/
 $s='';
 echo "Formel = $formel<BR>";
 if($flags=="i" || $flags=="I") {$mg=mol_wight_iso($formel,&$s); echo "iso ";}
 else $mg=mol_wight($formel,&$s);
 echo "MG = $mg";
?>
</BODY>
</HTML>
