/* mgkern.c				letzte Aenderung: 15.1.2012
  zum Einfuegen in mg.cc und in mgwpalm.c
  15.1.2012: Anpassungen um statt double auch Klasse Fliesszahl benutzen zu koennen
*/
//#define FLIESSZAHLKLASSE

const int ISO=1,DACH=2;

int klammertest(const char *text)
{
 int k1=0,k2=0,c;
 for(;*text!=0;)
   {c= *text++;
    if(c=='(') k1++; else if(c==')') --k1;
    else if(c=='[') k2++; else if(c==']') --k2;
   }
 if(k1!=0) return k1;
 return k2;
}

void formel_normieren(const char *quelle,char *ziel,int imax,int jmax)
{
 /* Sonderzeichen ~ zum Umschalten auf Kurzschreibweise von Peptidketten
    werden hier entfernt und die Peptide auf die 3-Buchstabenschreibweise
    erweitert. Zudem noch allfaellige Leerzeichen entfernt.
 */
 const int normal=0,kette=1;
 int i,j,c,modus=normal;
 const char *peptid;
 for(i=1,j=4;i<imax && (c= *quelle++)!=0 && j<jmax;i++)
   {
    if(c & 0x80) {fehler0("Sonderzeichen ignoriert",c);}
    else if(c=='~') {modus=kette-modus; *ziel++ = '-'; j++;}
    else if(c==' ' || c=='\n' || c=='\t') ;//Leerzeichen entfernen
    else if(modus==kette)
      {switch(c)
	{case 'A': peptid="Ala"; break;
	 case 'R': peptid="Arg"; break;
	 case 'N': peptid="Asn"; break;
	 case 'D': peptid="Asp"; break;
	 case 'C': peptid="Cys"; break;
	 case 'Q': peptid="Gln"; break;
	 case 'E': peptid="Glu"; break;
	 case 'G': peptid="Gly"; break;
	 case 'H': peptid="His"; break;
	 case 'I': peptid="Ile"; break;
	 case 'L': peptid="Leu"; break;
	 case 'K': peptid="Lys"; break;
	 case 'M': peptid="Met"; break;
	 case 'F': peptid="Phe"; break;
	 case 'P': peptid="Pro"; break;
	 case 'S': peptid="Ser"; break;
	 case 'T': peptid="Thr"; break;
	 case 'W': peptid="Trp"; break;
	 case 'Y': peptid="Tyr"; break;
	 case 'V': peptid="Val"; break;
	 case 'B': peptid="Aib"; break;
	 case 'J': peptid="Aha"; break;
	 default: peptid=NULL;
	}
       if(peptid!=NULL) {*ziel++ = peptid[0]; *ziel++ = peptid[1]; j+=2; c=peptid[2];}
       *ziel++ = c; j++;
      }
    else /*if(modus==normal)*/
      {*ziel++ = c; j++;}
   }
 *ziel=0;
}

inline bool isfirstformelzeichen(char c)
{
 return (isupper(c) || c=='(' || c=='[' || c=='^');
}

bool ist_leer(char c)
{
 return (c=='-' || c=='=' || c=='_');
}

bool isformelzeichen(char c)
{
 return (isfirstformelzeichen(c) || islower(c) || ist_leer(c)
	 || c==')' || c==']');
}

#define DANN *256+

double mol_wight(char* formel,char** zs) /*  Berechne Molekulargewicht */
{
 int c,klamzu;
 char *s;
 double m, summe=0;
#ifdef FLIESSZAHLKLASSE
 static int initflag=1;
 static Fliesszahl einzelzeichen['Z'-'A'+1];
 static const char *fliess['Z'-'A'+1]=
/* A */	{"0", "10.811", "12.011", "2.014102", "0", "18.9984", "0", "1.00794", "126.9044",
/* J */	 "126.9044", "39.0983", "0", "0", "14.0067", "15.9994", "30.9738", "0", "0",
/* S */	 "32.066", "3.01605", "238.0289", "50.9415", "183.85", "0", "88.9059", "135.1424"};
 if(initflag==1)
  {initflag=0; for(c=1;c<='Z'-'A';c++) einzelzeichen[c]=Fliesszahl(fliess[c],0);}
#else
 static double einzelzeichen['Z'-'A'+1]=
/* A */	{0, 10.811, 12.011, 2.014102, 0, 18.9984, 0, 1.00794, 126.9044,
/* J */	 126.9044, 39.0983, 0, 0, 14.0067, 15.9994, 30.9738, 0, 0,
/* S */	 32.066, 3.01605, 238.0289, 50.9415, 183.85, 0, 88.9059, 135.1424};
/* letzter Wert Z = Schutzgruppe C6H5-CH2-O-CO- */
#endif
/* printf("mol_wight('%s')\n",formel);// test */
 while(isformelzeichen(c= *formel) && c!=')' && c!=']')
  {if(c=='(' || c=='[')
	{if(c=='[') klamzu=']'; else klamzu=')';
	 m=mol_wight(++formel,&s);
	 formel=s;
	 if(*formel++!=klamzu) {fehler1("fehlende Klammer"); break;}
	}
   else if(c=='^' && isdigit(formel[1]))
        {m=sterndach(formel,&s,DACH);
	 formel=s;
	}
   else {if(!isupper(c))
		{fehler2("ungueltige Formel:",formel); break;}
	 if(islower(formel[1]) || (formel[1]=='Z' && (c=='P' || c=='M')))
	    {switch (formel[0] DANN formel[1])
		{
		 case 'A' DANN 'c': if(formel[2]=='e')
					{m=43.04522; formel++;} /*-Ace-*/
				    else {m=227.0278; actinium++;}  break;
		 case 'A' DANN 'g': m=107.8682;	break;
		 case 'A' DANN 'l': if(formel[2]=='a')
					{m=71.0788; formel++;} /*-Ala-*/
				    else m=26.9815; /*Aluminium*/	break;
		 case 'A' DANN 'i': if(formel[2]=='b')
					{m=85.1057; formel++;} /*-Aib-*/
				    else m=0; 	break;
		 case 'A' DANN 'h': if(formel[2]=='a')
					{m=126.11784; formel++;} /*-Aha-*/
				    else m=0; 	break;
		 case 'A' DANN 'r': if(formel[2]=='g') {m=156.1875; formel++;}
				    else m=39.948;	break;
		 case 'A' DANN 's': if(formel[2]=='n') {m=114.1038; formel++;}
				    else if(formel[2]=='p')
						       {m=115.0886; formel++;}
				    else  m=74.9216;	break;
		 case 'A' DANN 'm': m=243.0614;	break;
		 case 'A' DANN 't': m=209.9871;	break;
		 case 'A' DANN 'u': m=196.9665;	break;
		 case 'B' DANN 'a': m=137.327;	break;
		 case 'B' DANN 'e': m=9.01218;	break;
		 case 'B' DANN 'i': m=208.9804;	break;
		 case 'B' DANN 'k': m=247.0703;	break;
		 case 'B' DANN 'r': m=79.909;	break;
		 case 'B' DANN 'o': if(formel[2]=='c') {m=101.1253; formel++;} /*Boc-*/
				    else m=0; break;
		 case 'B' DANN 'z': if(formel[2]=='l') {m=91.1326; formel++;} /*Benzyl*/
				    else m=0; break;
		 case 'B' DANN 'u': m=57.11546;	break; /* Butyl */
		 case 'C' DANN 'a': m=40.078;	break;
		 case 'C' DANN 'd': m=112.411;	break;
		 case 'C' DANN 'e': m=140.115;	break;
		 case 'C' DANN 'f': m=251.0796;	break;
		 case 'C' DANN 'l': m=35.453;	break;
		 case 'C' DANN 'm': m=247.0703;	break;
		 case 'C' DANN 'p': m=65.0947;  break;
		 case 'C' DANN 'r': m=51.9961;	break;
		 case 'C' DANN 's': m=132.9051;	break;
		 case 'C' DANN 'o': m=58.9332;	break;
		 case 'C' DANN 'u': m=63.546;	break;
		 case 'C' DANN 'y': if(formel[2]=='s') {m=103.1448; formel++;}
				    else m=0;	break;
		 case 'D' DANN 'y': m=162.5;	break;
		 case 'E' DANN 'r': m=167.26;	break;
		 case 'E' DANN 's': m=252.0829;	break;
		 case 'E' DANN 't': m=29.0617;	break;
		 case 'E' DANN 'u': m=151.965;	break;
		 case 'F' DANN 'e': m=55.847;	break;
		 case 'F' DANN 'm': if(formel[2]=='o' && formel[3]=='c')
				{m=223.25114; formel++; formel++;} /* Fmoc */
				    else m=257.0951;	break;
		 case 'F' DANN 'r': m=223.0197;	break;
		 case 'G' DANN 'a': m=69.723;	break;
		 case 'G' DANN 'd': m=157.25;	break;
		 case 'G' DANN 'e': m=72.61;	break;
		 case 'G' DANN 'l': if(formel[2]=='y') {m=57.0519; formel++;} /*-Gly-*/
				    else if(formel[2]=='n') {m=128.1307; formel++;}
				    else if(formel[2]=='u') {m=129.1155; formel++;}
				    else m=0; break;
		 case 'H' DANN 'e': m=4.002602;	break;
		 case 'H' DANN 'f': m=178.49;	break;
		 case 'H' DANN 'g': m=200.59;	break;
		 case 'H' DANN 'o': m=164.9303;	break;
		 case 'H' DANN 'i': if(formel[2]=='s') {m=137.1411; formel++;}
				    else m=0;	break;
		 case 'I' DANN 'l': if(formel[2]=='e') {m=113.1594; formel++;}
				    else m=0;	break;
		 case 'I' DANN 'n': m=114.82;	break;
		 case 'I' DANN 'r': m=192.22;	break;
		 case 'K' DANN 'r': m=83.80;	break;
		 case 'L' DANN 'a': m=138.9055;	break;
		 case 'L' DANN 'e': if(formel[2]=='u') {m=113.1594; formel++;}
				    else m=0;	break;
		 case 'L' DANN 'y': if(formel[2]=='s') {m=128.1741; formel++;}
				    else m=0;	break;
		 case 'L' DANN 'i': m=6.941;	break;
		 case 'L' DANN 'r': m=260.1053;	break;
		 case 'L' DANN 'u': m=174.967;	break;
		 case 'M' DANN 'd': m=258.0986;	break;
		 case 'M' DANN 'e': if(formel[2]=='t') {m=131.1986; formel++;}
				    else m=15.0348;	break;
		 case 'M' DANN 'g': m=24.305;	break;
		 case 'M' DANN 'n': m=54.938;	break;
		 case 'M' DANN 'o': m=95.94;	break;
		 case 'M' DANN 'z': m=269.2798; break; /*Mz-Schutzgruppe*/
		 case 'M' DANN 'Z': m=269.2798; break; /*Mz-Schutzgruppe*/
		 case 'N' DANN 'a': m=22.9897;	break;
		 case 'N' DANN 'b': m=92.90638;	break;
		 case 'N' DANN 'd': m=144.24;	break;
		 case 'N' DANN 'e': m=20.1797;	break;
		 case 'N' DANN 'i': m=58.69;	break;
		 case 'N' DANN 'o': m=259.1009;	break;
		 case 'N' DANN 'p': m=237.0482;	break;
		 case 'O' DANN 's': m=190.2;	break;
		 case 'P' DANN 'a': m=231.0359;	break;
		 case 'P' DANN 'b': m=207.2;	break;
		 case 'P' DANN 'd': m=106.42;	break;
		 case 'P' DANN 'h': if(formel[2]=='e') {m=147.1766; formel++;}
				    else m=77.1057;	break;
		 case 'P' DANN 'm': m=146.9151;	break;
		 case 'P' DANN 'o': m=208.9824;	break;
		 case 'P' DANN 'r': if(formel[2]=='o') {m=97.1167; formel++;}
				    else m=140.9077;	break;
		 case 'P' DANN 't': m=195.08;	break;
		 case 'P' DANN 'u': m=244.0642;	break;
		 case 'P' DANN 'z': m=239.2535; break; /*Pz-Schutzgruppe*/
		 case 'P' DANN 'Z': m=239.2535; break; /*Pz-Schutzgruppe*/
		 case 'R' DANN 'a': m=226.0254;	break;
		 case 'R' DANN 'b': m=85.4678;	break;
		 case 'R' DANN 'e': m=186.207;	break;
		 case 'R' DANN 'h': m=102.9055;	break;
		 case 'R' DANN 'n': m=222.0176;	break;
		 case 'R' DANN 'u': m=101.07;	break;
		 case 'S' DANN 'b': m=121.75;	break;
		 case 'S' DANN 'c': m=44.95591;	break;
		 case 'S' DANN 'e': if(formel[2]=='r') {m=87.0782; formel++;}
				    else m=78.96;	break;
		 case 'S' DANN 'i': m=28.0855;	break;
		 case 'S' DANN 'm': m=150.36;	break;
		 case 'S' DANN 'n': m=118.710;	break;
		 case 'S' DANN 'r': m=87.62;	break;
		 case 'T' DANN 'a': m=180.9479;	break;
		 case 'T' DANN 'b': m=158.9253;	break;
		 case 'T' DANN 'c': m=98.9063;	break;
		 case 'T' DANN 'e': m=127.60;	break;
		 case 'T' DANN 'h': if(formel[2]=='r') {m=101.1051; formel++;}
				    else m=232.0381;	break;
		 case 'T' DANN 'i': m=47.88;	break;
		 case 'T' DANN 'l': m=204.3833;	break;
		 case 'T' DANN 'm': m=168.9342;	break;
		 case 'T' DANN 'r': if(formel[2]=='p') {m=186.2132; formel++;}
				    else m=0;	break;
		 case 'T' DANN 'y': if(formel[2]=='r') {m=163.1760; formel++;}
				    else m=0;	break;
		 case 'V' DANN 'a': if(formel[2]=='l') {m=99.1326; formel++;}
				    else m=0;	break;
		 case 'X' DANN 'e': m=131.29;	break;
		 case 'Y' DANN 'b': m=173.04;	break;
		 case 'Z' DANN 'n': m=65.39;	break;
		 case 'Z' DANN 'r': m=91.224;	break;
		 default :	    m=0;	break;
		}
	     formel++;
	    }
	 else 	    {m=einzelzeichen[c-'A'];}
	 formel++;
	}
   if(m==0) {fehler2("Unbekannt:",formel); break;}
   if(isdigit(*formel))
	{c = *formel++ - '0';
	 while(isdigit(*formel))
		{ c= 10*c + *formel++ - '0';}
	}
   else c=1;
   summe += c*m;
   while(ist_leer(*formel)) formel++;
  }
 if(c=='*')
  {formel++;
   if(isdigit(c= *formel))
	{c = *formel++ - '0';
	 while(isdigit(*formel))
		{ c= 10*c + *formel++ - '0';}
	}
   else if(c=='^')
	{//Trick: z.B. *^13C2 soll 2 schon gezaehlte C als 13C rechnen
	 summe += sterndach(formel,&s,0);
	 formel=s;
	 c=1;
	}
   else	c=1;
   summe += c*mol_wight(formel,&s);
   formel=s;
  }
 *zs = formel;
/* printf("summe=%lf  *zs='%s'\n",summe,*zs);// test */
 return summe;
}

double mol_wight_iso(char* formel,char** zs) /* nur hufigste Isotope */
{
 int c,klamzu;
 char *s;
 double m, summe=0;
#ifdef FLIESSZAHLKLASSE
 static int initflag=1;
 static Fliesszahl einzelzeichen['Z'-'A'+1];
 static const char *fliess['Z'-'A'+1]=
/* A */	{"0", "11.0093", "12.000", "2.014102", "0", "18.9984", "0", "1.007825", "126.9044",
/* J */	 "126.9044", "38.9637", "0", "0", "14.00307", "15.9949", "30.9738", "0", "0",
/* S */	 "31.97207", "3.01605", "238.05076", "50.94398", "183.95099", "0", "88.90543", "135.0446"};
 if(initflag==1)
  {initflag=0; for(c=1;c<='Z'-'A';c++) einzelzeichen[c]=Fliesszahl(fliess[c],0);}
#else
 static double einzelzeichen['Z'-'A'+1]=
/* A */	{0, 11.0093, 12.000, 2.014102, 0, 18.9984, 0, 1.007825, 126.9044,
/* J */	 126.9044, 38.9637, 0, 0, 14.00307, 15.9949, 30.9738, 0, 0,
/* S */	 31.97207, 3.01605, 238.05076, 50.94398, 183.95099, 0, 88.90543, 135.0446};
#endif
/* letzter Wert Z = Schutzgruppe C6H5-CH2-O-CO- */
/* printf("mol_wight_iso('%s')\n",formel);// test */
 while(isformelzeichen(c= *formel) && c!=')' && c!=']')
  {if(c=='(' || c=='[')
	{if(c=='[') klamzu=']'; else klamzu=')';
	 m=mol_wight_iso(++formel,&s);
	 formel=s;
	 if(*formel++!=klamzu) {fehler1("fehlende Klammer"); break;}
	}
   else if(c=='^' && isdigit(formel[1]))
        {m=sterndach(formel,&s,DACH);
	 formel=s;
	}
   else {if(!isupper(c))
              {fehler2("ungueltige Formel:",formel); break;}
	 if(islower(formel[1]) || (formel[1]=='Z' && (c=='P' || c=='M')))
	    {switch (formel[0] DANN formel[1])
		{
		 case 'A' DANN 'c': if(formel[2]=='e')
					{m=43.018375; formel++;} /*-Ace-*/
				    else {m=227.0278; actinium++;}  break;
		 case 'A' DANN 'g': m=106.90497; break;
		 case 'A' DANN 'l': if(formel[2]=='a')
					{m=71.0371; formel++;} /*-Ala-*/
				    else m=26.9815;	 break;
		 case 'A' DANN 'i': if(formel[2]=='b')
					{m=85.0527; formel++;} /*-Aib-*/
				    else m=0; 	break;
		 case 'A' DANN 'h': if(formel[2]=='a')
					{m=126.05413; formel++;} /*-Aha-*/
				    else m=0; 	break;
		 case 'A' DANN 'r': if(formel[2]=='g') {m=156.1011; formel++;}
				    else m=39.96238;	 break;
		 case 'A' DANN 's': if(formel[2]=='n') {m=114.0429; formel++;}
				    else if(formel[2]=='p')
						       {m=115.0269; formel++;}
				    else  m=74.9216;	 break;
		 case 'A' DANN 'm': m=243.0614;	break;
		 case 'A' DANN 't': m=209.9871;	break;
		 case 'A' DANN 'u': m=196.9665;	 break;
		 case 'B' DANN 'a': m=137.90501; break;
		 case 'B' DANN 'e': m=9.01218;	 break;
		 case 'B' DANN 'i': m=208.9804;	 break;
		 case 'B' DANN 'k': m=247.0703;	break;
		 case 'B' DANN 'r': m=78.91835;	 break;
		 case 'B' DANN 'o': if(formel[2]=='c') {m=101.0602; formel++;} /*Boc-*/
				    else m=0; break;
		 case 'B' DANN 'z': if(formel[2]=='l') {m=91.0548; formel++;} /*Benzyl*/
				    else m=0; break;
		 case 'B' DANN 'u': m=57.070425; break; /* Butyl */
		 case 'C' DANN 'a': m=39.96259;  break;
		 case 'C' DANN 'd': m=113.90357; break;
		 case 'C' DANN 'e': m=139.90528; break;
		 case 'C' DANN 'f': m=251.0796;	break;
		 case 'C' DANN 'l': m=34.96885;  break;
		 case 'C' DANN 'm': m=247.0703;	break;
		 case 'C' DANN 'p': m=65.039125; break;
		 case 'C' DANN 'r': m=51.94051;  break;
		 case 'C' DANN 's': m=132.9051;	 break;
		 case 'C' DANN 'o': m=58.9332;	 break;
		 case 'C' DANN 'u': m=62.9296;	 break;
		 case 'C' DANN 'y': if(formel[2]=='s') {m=103.0092; formel++;}
				    else m=0;	break;
		 case 'D' DANN 'y': m=162.5;	break;
		 case 'E' DANN 'r': m=167.26;	break;
		 case 'E' DANN 's': m=252.0829;	break;
		 case 'E' DANN 't': m=29.039125;break;
		 case 'E' DANN 'u': m=151.965;	break;
		 case 'F' DANN 'e': m=55.93493;	 break;
		 case 'F' DANN 'm': if(formel[2]=='o' && formel[3]=='c')
				{m=223.075875; formel++; formel++;} /* Fmoc */
				    else m=257.0951;	break;
		 case 'F' DANN 'r': m=223.0197;	break;
		 case 'G' DANN 'a': m=68.92568;	 break;
		 case 'G' DANN 'd': m=157.25;	break;
		 case 'G' DANN 'e': m=73.92115;	 break;
		 case 'G' DANN 'l': if(formel[2]=='y') {m=57.0214; formel++;} /*-Gly-*/
				    else if(formel[2]=='n') {m=128.0585; formel++;}
				    else if(formel[2]=='u') {m=129.0425; formel++;}
				    else m=0; break;
		 case 'H' DANN 'e': m=4.002604;	 break;
		 case 'H' DANN 'f': m=179.94681; break;
		 case 'H' DANN 'g': m=201.97063; break;
		 case 'H' DANN 'o': m=164.9303;	 break;
		 case 'H' DANN 'i': if(formel[2]=='s') {m=137.0589; formel++;}
				    else m=0;	break;
		 case 'I' DANN 'l': if(formel[2]=='e') {m=113.0840; formel++;}
				    else m=0;	break;
		 case 'I' DANN 'n': m=114.90407; break;
		 case 'I' DANN 'r': m=192.96328; break;
		 case 'K' DANN 'r': m=83.9115;	 break;
		 case 'L' DANN 'a': m=138.90606; break;
		 case 'L' DANN 'i': m=7.016005;	 break;
		 case 'L' DANN 'r': m=260.1053;	break;
		 case 'L' DANN 'u': m=174.967;	break;
		 case 'L' DANN 'e': if(formel[2]=='u') {m=113.0840; formel++;}
				    else m=0;	break;
		 case 'L' DANN 'y': if(formel[2]=='s') {m=128.0949; formel++;}
				    else m=0;	break;
		 case 'M' DANN 'd': m=258.0986;	break;
		 case 'M' DANN 'e': if(formel[2]=='t') {m=131.0405; formel++;}
				    else m=15.023475; break;
		 case 'M' DANN 'g': m=23.98505;	 break;
		 case 'M' DANN 'n': m=54.938;	 break;
		 case 'M' DANN 'o': m=97.90551;	 break;
		 case 'M' DANN 'z': m=269.0926; break; /*Mz-Schutzgruppe*/
		 case 'M' DANN 'Z': m=269.0926; break; /*MZ-Schutzgruppe*/
		 case 'N' DANN 'a': m=22.98977;	 break;
		 case 'N' DANN 'b': m=92.90638;	 break;
		 case 'N' DANN 'd': m=141.90748; break;
		 case 'N' DANN 'e': m=19.99244;	 break;
		 case 'N' DANN 'i': m=57.93534;	 break;
		 case 'N' DANN 'o': m=259.1009;	break;
		 case 'N' DANN 'p': m=237.0482;	break;
		 case 'O' DANN 's': m=191.96141; break;
		 case 'P' DANN 'a': m=231.0359;	break;
		 case 'P' DANN 'b': m=207.97664; break;
		 case 'P' DANN 'd': m=105.9032;	 break;
		 case 'P' DANN 'h': if(formel[2]=='e') {m=147.0684; formel++;}
				    else m=77.0391;	break;
		 case 'P' DANN 'm': m=146.9151;	break;
		 case 'P' DANN 'o': m=208.9824;	break;
		 case 'P' DANN 'r': if(formel[2]=='o') {m=97.0257; formel++;}
				    else m=140.9077;	break;
		 case 'P' DANN 't': m=194.96482; break;
		 case 'P' DANN 'u': m=244.0642;	break;
		 case 'P' DANN 'z': m=239.0820; break; /*Pz-Schutzgruppe*/
		 case 'P' DANN 'Z': m=239.0820; break; /*Pz-Schutzgruppe*/
		 case 'R' DANN 'a': m=226.0254;	break;
		 case 'R' DANN 'b': m=84.91171;	 break;
		 case 'R' DANN 'e': m=186.95596; break;
		 case 'R' DANN 'h': m=102.9055;	break;
		 case 'R' DANN 'n': m=222.0176;	break;
		 case 'R' DANN 'u': m=101.07;	break;
		 case 'S' DANN 'b': m=120.90375; break;
		 case 'S' DANN 'c': m=44.95591;	 break;
		 case 'S' DANN 'e': if(formel[2]=='r') {m=87.0320; formel++;}
				    else m=79.91651;	 break;
		 case 'S' DANN 'i': m=27.9769;	break;
		 case 'S' DANN 'm': m=150.36;	break;
		 case 'S' DANN 'n': m=119.90213; break;
		 case 'S' DANN 'r': m=87.90561;	 break;
		 case 'T' DANN 'a': m=180.9479;	break;
		 case 'T' DANN 'b': m=158.9253;	break;
		 case 'T' DANN 'c': m=98.9063;	break;
		 case 'T' DANN 'e': m=129.9067;	 break;
		 case 'T' DANN 'h': if(formel[2]=='r') {m=101.0476; formel++;}
				    else m=232.0381;	 break;
		 case 'T' DANN 'i': m=47.94795;	 break;
		 case 'T' DANN 'l': m=204.97446; break;
		 case 'T' DANN 'm': m=168.9342;	break;
		 case 'T' DANN 'r': if(formel[2]=='p') {m=186.0793; formel++;}
				    else m=0;	break;
		 case 'T' DANN 'y': if(formel[2]=='r') {m=163.0633; formel++;}
				    else m=0;	break;
		 case 'V' DANN 'a': if(formel[2]=='l') {m=99.0684; formel++;}
				    else m=0;	break;
		 case 'X' DANN 'e': m=131.90416; break;
		 case 'Y' DANN 'b': m=173.93902; break;
		 case 'Z' DANN 'n': m=63.92915;	 break;
		 case 'Z' DANN 'r': m=89.90432;	 break;
		 default :	    m=0;	break;
		}
	     formel++;
	    }
	 else 	    {m=einzelzeichen[c-'A'];}
	 formel++;
	}
   if(m==0) {fehler2("Unbekannt:",formel); break;}
   if(isdigit(*formel))
	{c = *formel++ - '0';
	 while(isdigit(*formel))
		{ c= 10*c + *formel++ - '0';}
	}
   else c=1;
   summe += c*m;
   while(ist_leer(*formel)) formel++;
  }
 if(c=='*')
  {formel++;
   if(isdigit(c= *formel))
	{c = *formel++ - '0';
	 while(isdigit(*formel))
		{ c= 10*c + *formel++ - '0';}
	}
   else if(c=='^')
	{//Trick: z.B. *^13C2 soll 2 schon gezaehlte C als 13C rechnen
	 summe += sterndach(formel,&s,ISO);
	 formel=s;
	 c=1;
	}
   else	c=1;
   summe += c*mol_wight_iso(formel,&s);
   formel=s;
  }
 *zs = formel;
/* printf("summe=%lf  *zs='%s'\n",summe,*zs);// test */
 return summe;
}

/************* Erweiterung fuer Isotope ******************/
/*
 Beispiel: Boc-Ala-Gly-Ala*^13C-Aib-OMe sollte 417.464 (417.227) geben
           (nicht 429.47 (429.23) wie mit alter Version)
 z.B. *^13C2 soll 2 _schon_gezaehlte_ C als 13C rechnen
 (im Gegensatz zu ^13C2 (ohne *) wo das wirklich 2 zusaetzliche C sind)
 Spezialfall Deuterium: z.B. *^D12

 Die Funktion sterndach() soll als Formel etwas in der Form
 "^<Zahl><Atom><Zahl>..." bekommen. (Der Stern wurde schon verarbeitet).
 Als Rueckgabewert soll die Differenzmasse berechnet werden, also markiertes
 minus nicht markiertes. zs soll dann noch die Restformel zurueckgeben.
 Beispiele: ^18O, ^13C6, ^6Li, ^208Pb, ^2H11, ^D11
 Spezialfall Deuterium: statt ^2H11 sollte ^D11 benutzt werden (genauer weil
 Deuterium nicht 2.000 sondern 2.014102 hat).
*/
double sterndach(char* formel,char** zs,int isoflag)
{
 char atom[3],*s;
 double summe,masse,alt;
 int c,k,anzahl;
 if(formel[0]!='^') fehler1("sterndach-Syntaxfehler");//test
 if(formel[1]=='D' || formel[1]=='T') //Spezialfall Deuterium u. Tritium
   {atom[0]=formel[1]; atom[1]=0;
    masse=mol_wight(atom,&s);
    atom[0]='H';
    k=2;
   }
 else //Normalfall
   {for(masse=0,k=1;(c=formel[k])!=0 && isdigit(c);k++)
          masse=10*masse+c-'0';
    if(masse<=1 || !isupper(formel[k])) fehler1("falsche Isotop-Syntax");
    atom[0]=formel[k++];
    c=formel[k];
    if(islower(c)) k++; else c=0;
    atom[1]=c;
    atom[2]=0;
   }
 for(anzahl=0;(c=formel[k])!=0 && isdigit(c);k++)
    anzahl=10*anzahl+c-'0';
 if(anzahl==0) anzahl=1;
 while(ist_leer(formel[k])) k++;
 *zs = &formel[k];
 alt = (isoflag==ISO) ? mol_wight_iso(atom,&s) : mol_wight(atom,&s);
 if(alt==0 || alt-masse>5 || masse-alt>5) fehler1("Falsches-Isotop");
 if(isoflag==DACH)
   summe = masse * anzahl;
 else
   summe = (masse - alt) * anzahl;
 return summe;
}
