/* mgkern.c				letzte Aenderung: 27.1.2012

Allgemeiner Teil zum Einfuegen im Hauptprogramm

Aenderungen:
15.1.2012    Anpassungen um statt double auch Klasse Fliesszahl benutzen zu koennen
24.1.2012    Vereinfachungen: Uebersichtliche Tabellen anstatt riesige switch-Anweisungen
26.1.2012    Erweiterung um Summenformeln fuer MS-Vorhersagen.
             Fehlermeldungen hier eingefuegt (war vorher im Hauptprogramm).

*/
//#define FLIESSZAHLKLASSE
//#define SUMMENFORMELN

#include "mgkern.h"

int klammertest(const char *text)
{
 int k1=0,k2=0,c;
 for(;*text!=0;)
   {c= *text++;
    if(c=='(') k1++; else if(c==')') --k1;
    else if(c=='[') k2++; else if(c==']') --k2;
   }
 if(k1!=0) return k1;
 return k2;
}

/** Diese Variante fuer Anpassung an Option fuer Summenformelausgabe: **/
#ifdef SUMMENFORMELN
struct Abkuerzungen {const char *sym; const char *summenformel;};
//summenformel wird noch nicht gebraucht, wird aber nuetzlich sein bei
//Erweiterung fuer MS-Vorhersagen.

static Abkuerzungen aminos[]=
 {
  {"Ala", "C3H5NO"}, //'A'
  {"Aib", "C4H7NO"}, //'B'
  {"Cys", "C3H5NOS"}, //'C'
  {"Asp", "C4H5NO3"}, //'D'
  {"Glu", "C5H7NO3"}, //'E'
  {"Phe", "C9H9NO"}, //'F'
  {"Gly", "C2H3NO"}, //'G'
  {"His", "C6H7N3O"}, //H
  {"Ile", "C6H11NO"}, //I
  {"Aha", "C4H6N4O"}, //J
  {"Lys", "C6H12N2O"}, //K
  {"Leu", "C6H11NO"}, //L
  {"Met", "C5H9NOS"}, //M
  {"Asn", "C4H6N2O2"}, //N
  {"Oxx", ""}, //O
  {"Pro", "C5H7NO"}, //P
  {"Gln", "C5H8N2O2"}, //Q
  {"Arg", "C6H12N4O"}, //R
  {"Ser", "C3H5NO2"}, //S
  {"Thr", "C4H7NO2"}, //T
  {"Uxx", ""}, //U
  {"Val", "C5H9NO"}, //V
  {"Trp", "C11H10N2O"}, //W
  {"Xxx", ""},        //'X' 
  {"Tyr", "C9H9NO2"}, //'Y'
  {"Zxx", ""}         //'Z'
 };

const char *einbuchstaben_auf_dreibuchstaben_abkuerzung_erweitern(int c)
{
 const char *peptid;
 peptid=aminos[c-'A'].sym; //Einfache Auswertung weil Alfabetisch sortiert
 return peptid;
}

int dreibuchstaben_auf_einbuchstaben_abkuerzung_reduzieren(const char *peptid)
{
 int c;
 for(c='A';c<='Z';c++)
  {
   if(strcmp(peptid,aminos[c-'A'].sym)==0) return c;
  }
 return 0;
}
#endif
/**/

void formel_normieren(const char *quelle,char *ziel,int imax,int jmax)
{
 /* Sonderzeichen ~ zum Umschalten auf Kurzschreibweise von Peptidketten
    werden hier entfernt und die Peptide auf die 3-Buchstabenschreibweise
    erweitert. Zudem noch allfaellige Leerzeichen entfernt.
 */
 const int normal=0,kette=1;
 int i,j,c,modus=normal;
 const char *peptid;
 for(i=1,j=4;i<imax && (c= *quelle++)!=0 && j<jmax;i++)
   {
    if(c & 0x80) {fehler0("Sonderzeichen ignoriert",c);}
    else if(c=='~') {modus=kette-modus; *ziel++ = '-'; j++;}
    else if(c==' ' || c=='\n' || c=='\t') ;//Leerzeichen entfernen
    else if(modus==kette)
     {
#ifdef SUMMENFORMELN
      peptid = (c>='A' && c<='Z') ? aminos[c-'A'].sym : NULL;
#else
      //Editor-Fenster breit einstellen damit folgende Tabelle uersichtlich wird:
      const char x[] =  {'A',  'R',  'N',  'D',  'C',  'Q',  'E',  'G',  'H',  'I',  'L',  'K',  'M',  'F',  'P',  'S',  'T',  'W',  'Y',  'V',  'B',  'J',  'O',  'U',  'X'};
      const char *sym[]={"Ala","Arg","Asn","Asp","Cys","Gln","Glu","Gly","His","Ile","Leu","Lys","Met","Phe","Pro","Ser","Thr","Trp","Tyr","Val","Aib","Aha","Oxx","Uxx","Xxx"};
      //Die Eingraege Xxx sind Platzhalter fuer weitere Aminosaeuren
      unsigned int k;
      for(k=0,peptid=NULL;k<sizeof(x);k++)
       {
	if(c==x[k]) {peptid=sym[k]; break;}
       }
#endif
      if(peptid!=NULL) {*ziel++ = peptid[0]; *ziel++ = peptid[1]; j+=2; c=peptid[2];}
      *ziel++ = c; j++;
     }
    else /*if(modus==normal)*/
      {*ziel++ = c; j++;}
   }
 *ziel=0;
}

inline bool isfirstformelzeichen(char c)
{
 return (isupper(c) || c=='(' || c=='[' || c=='^');
}

bool ist_leer(char c)
{
 return (c=='-' || c=='=' || c=='_');
}

bool isformelzeichen(char c)
{
 return (isfirstformelzeichen(c) || islower(c) || ist_leer(c)
	 || c==')' || c==']');
}

struct mgtab {const char *symbol; double wert;};
static mgtab mgtabelle[]=
  {
    {"Ace", 43.04522}, //Acethyl (H3C-C=O)
    {"Ac", 227.0278 }, //Actinium
    {"Ag", 107.8682 },
    {"Ala", 71.0788 }, 
    {"Al",  26.9815 }, //Aluminium
    {"Aib", 85.1057 },
    {"Aha",126.11784},
    {"Arg",156.1875 },
    {"Ar",  39.948  },
    {"Asn",114.1038 },
    {"Asp",115.0886 },
    {"As",  74.9216 },
    {"Am", 243.0614 },
    {"At", 209.9871 },
    {"Au", 196.9665 },
    {"Ba", 137.327  },
    {"Be",   9.01218},
    {"Bi", 208.9804 },
    {"Bk", 247.0703 },
    {"Br",  79.909  },
    {"Boc",101.1253 },
    {"Bzl", 91.1326 },
    {"Bu", 57.11546 }, // Butyl
    {"Ca",  40.078  },
    {"Cd", 112.411  },
    {"Ce", 140.115  },
    {"Cf", 251.0796 },
    {"Cl",  35.453  },
    {"Cm", 247.0703 },
    {"Cp",  65.0947 },
    {"Cr",  51.9961 },
    {"Cs", 132.9051 },
    {"Co",  58.9332 },
    {"Cu",  63.546  },
    {"Cys",103.1448 },
    {"Dy", 162.5    },
    {"Er", 167.26   },
    {"Es", 252.0829 },
    {"Et",  29.0617 }, // Ethyl
    {"Eu", 151.965  },
    {"Fe",  55.847  },
    {"Fmoc",223.25114}, //Fmoc-Schutzgruppe
    {"Fm", 257.0951 },
    {"Fr", 223.0197 },
    {"Ga",  69.723  },
    {"Gd", 157.25   },
    {"Ge",  72.61   },
    {"Gly", 57.0519 },
    {"Gln",128.1307 },
    {"Glu",129.1155 },
    {"He", 4.002602 },
    {"Hf", 178.49 },
    {"Hg", 200.59 },
    {"Ho", 164.9303 },
    {"His", 137.1411 },
    {"Ile", 113.1594 },
    {"In", 114.82 },
    {"Ir", 192.22 },
    {"Kr", 83.80 },
    {"La", 138.9055 },
    {"Li", 6.941 },
    {"Lr", 260.1053 },
    {"Lu", 174.967 },
    {"Leu", 113.1594 },
    {"Lys", 128.1741 },
    {"Md", 258.0986 },
    {"Met",131.1986 }, //Methionin
    {"Me",  15.03482}, //Methyl
    {"Mg", 24.305 },
    {"Mn", 54.938 },
    {"Mo", 95.94 },
    {"Mz", 269.2798 }, //Mz-Schutzgruppe
    {"MZ", 269.2798 }, //Mz-Schutzgruppe
    {"Na", 22.9897 },
    {"Nb", 92.90638 },
    {"Nd", 144.24 },
    {"Ne", 20.1797 },
    {"Ni", 58.69 },
    {"No", 259.1009 },
    {"Np", 237.0482 },
    {"Os", 190.2 },
    {"Pa", 231.0359 },
    {"Pb", 207.2 },
    {"Pd", 106.42 },
    {"Phe",147.1766 }, //Phenylalanin
    {"Ph",  77.1057 }, //Phenyl (C6H5)
    {"Pm", 146.9151 },
    {"Po", 208.9824 }, //Polonium
    {"Pro", 97.1167 }, //Prolin
    {"Pr", 140.9077 }, //Praseodym (Praseodymium)
    {"Pt", 195.08 },
    {"Pu", 244.0642 },
    {"Pz", 239.2535 }, //Pz-Schutzgruppe
    {"PZ", 239.2535 }, //Pz-Schutzgruppe
    {"Ra", 226.0254 },
    {"Rb", 85.4678 },
    {"Re", 186.207 },
    {"Rh", 102.9055 },
    {"Rn", 222.0176 },
    {"Ru", 101.07 },
    {"Sb", 121.75 },
    {"Sc", 44.95591 },
    {"Ser", 87.0782 }, //Serin
    {"Se",  78.96   }, //Selen
    {"Si", 28.0855 },
    {"Sm", 150.36 },
    {"Sn", 118.710 },
    {"Sr", 87.62 },
    {"Ta", 180.9479 },
    {"Tb", 158.9253 },
    {"Tc",  98.9063 },
    {"Te", 127.60 },
    {"Thr",101.1051 }, //Threonin
    {"Th", 232.0381 }, //Thorium
    {"Ti",  47.88 },
    {"Tl", 204.3833 },
    {"Tm", 168.9342 },
    {"Trp",186.2132 },
    {"Tyr", 163.1760 }, //Tyrosin
    {"Val", 99.1326 },
    {"Xe", 131.29 },
    {"Yb", 173.04 },
    {"Zn", 65.39 },
    {"Zr", 91.224 },

    //hier koennen noch weitere Abkuerzungen eingefuegt werden
  };

static mgtab mgtabelle_iso[]=
  {
    {"Ace", 43.018375}, //Acethyl (H3C-C=O)
    {"Ac", 227.0278  }, //Actinium
    {"Ag", 106.90497 },
    {"Ala", 71.0371  }, //Alanin
    {"Al",  26.9815  }, //Aluminium
    {"Aib", 85.0527  }, //Aib
    {"Aha",126.05413 }, //Azidohomoalanin
    {"Arg",156.1011  },
    {"Ar",  39.96238 },
    {"Asn",114.0429 },
    {"Asp",115.0269 },
    {"As",  74.9216 },
    {"Am", 243.0614 },
    {"At", 209.9871 },
    {"Au", 196.9665 },
    {"Ba", 137.90501},
    {"Be",   9.01218},
    {"Bi", 208.9804 },
    {"Bk", 247.0703 },
    {"Br",  78.91835},
    {"Boc",101.0602 }, //Boc-Schutzgruppe
    {"Bzl", 91.0548 }, //Benzyl
    {"Bu", 57.070425}, //Butyl
    {"Ca", 39.96259 },
    {"Cd", 113.90357 },
    {"Ce", 139.90528 },
    {"Cf", 251.0796 },
    {"Cl",  34.96885 },
    {"Cm", 247.0703 },
    {"Cp",  65.039125 },
    {"Cr",  51.94051 },
    {"Cs", 132.9051 },
    {"Co",  58.9332 },
    {"Cu",  62.9296 },
    {"Cys", 103.0092 },
    {"Dy", 162.5 },
    {"Er", 167.26 },
    {"Es", 252.0829 },
    {"Et", 29.039125 },
    {"Eu", 151.965 },
    {"Fe", 55.93493 },
    {"Fmoc",223.075875}, //Fmoc-Schutzgruppe
    {"Fm",  257.0951 },
    {"Fr", 223.0197 },
    {"Ga", 68.92568 },
    {"Gd", 157.25 },
    {"Ge", 73.92115 },
    {"Gly", 57.0214 }, //Glycine
    {"Gln",128.0585 },
    {"Glu",129.0425 },
    {"He", 4.002604 },
    {"Hf", 179.94681 },
    {"Hg", 201.97063 },
    {"Ho", 164.9303 },
    {"His", 137.0589 },
    {"Ile", 113.0840 },
    {"In", 114.90407 },
    {"Ir", 192.96328 },
    {"Kr", 83.9115 },
    {"La", 138.90606 },
    {"Li", 7.016005 },
    {"Lr", 260.1053 },
    {"Lu", 174.967 },
    {"Leu", 113.0840 },
    {"Lys", 128.0949 },
    {"Md", 258.0986 },
    {"Met", 131.0405 },
    {"Me",  15.023475 }, //Methyl
    {"Mg", 23.98505 },
    {"Mn", 54.938 },
    {"Mo", 97.90551 },
    {"Mz", 269.0926 }, /*Mz-Schutzgruppe*/
    {"MZ", 269.0926 }, /*MZ-Schutzgruppe*/
    {"Na", 22.98977 },
    {"Nb", 92.90638 },
    {"Nd", 141.90748 },
    {"Ne", 19.99244 },
    {"Ni", 57.93534 },
    {"No", 259.1009 },
    {"Np", 237.0482 },
    {"Os", 191.96141 },
    {"Pa", 231.0359 },
    {"Pb", 207.97664 },
    {"Pd", 105.9032 },
    {"Phe", 147.0684 }, //Phenylalanin
    {"Ph",   77.0391 }, //Phenyl (C6H5)
    {"Pm", 146.9151 },
    {"Po", 208.9824 },
    {"Pro", 97.0257 },
    {"Pr", 140.9077 },
    {"Pt", 194.96482},
    {"Pu", 244.0642 },
    {"Pz", 239.0820 }, //Pz-Schutzgruppe
    {"PZ", 239.0820 }, //Pz-Schutzgruppe
    {"Ra", 226.0254 },
    {"Rb", 84.91171 },
    {"Re", 186.95596},
    {"Rh", 102.9055 },
    {"Rn", 222.0176 },
    {"Ru", 101.07 },
    {"Sb", 120.90375 },
    {"Sc", 44.95591 },
    {"Ser", 87.0320 },
    {"Se", 79.91651 }, //Selen
    {"Si", 27.9769 },
    {"Sm", 150.36 },
    {"Sn", 119.90213 },
    {"Sr", 87.90561 },
    {"Ta", 180.9479 },
    {"Tb", 158.9253 },
    {"Tc", 98.9063 },
    {"Te", 129.9067 },
    {"Thr", 101.0476 },
    {"Th", 232.0381 },
    {"Ti", 47.94795 },
    {"Tl", 204.97446 },
    {"Tm", 168.9342 },
    {"Trp", 186.0793 },
    {"Tyr", 163.0633 },
    {"Val", 99.0684 },
    {"Xe", 131.90416 },
    {"Yb", 173.93902 },
    {"Zn", 63.92915 },
    {"Zr", 89.90432 },

    //hier koennen noch weitere Abkuerzungen eingefuegt werden
  };

double mol_weight(char* formel,char** zs,int isoflag) // Berechne Molekulargewicht
{
 // Wenn isoflag gesetzt ist, werden nur haeufigste Isotope verwendet,
 // sonst wird das durchschnittliche Molekulargewicht berechnet.
 int c,klamzu;
 char *s;
 double m, summe=0;

 //Die folgende Tabelle enthaelt alle Elemente welche mit nur einem Buchstaben abgekuerzt werden.
#ifdef FLIESSZAHLKLASSE
 static int initflag=1;
 static Fliesszahl einzelzeichen['Z'-'A'+1];
 static const char *fliess['Z'-'A'+1]=
/* A */	{"0", "10.811", "12.011", "2.014102", "0", "18.9984", "0", "1.00794", "126.9044",
/* J */	 "126.9044", "39.0983", "0", "0", "14.0067", "15.9994", "30.9738", "0", "0",
/* S */	 "32.066", "3.01605", "238.0289", "50.9415", "183.85", "0", "88.9059", "135.1424"};
#else
 static double einzelzeichen['Z'-'A'+1]=
/* A */	{0, 10.811, 12.011, 2.014102, 0, 18.9984, 0, 1.00794, 126.9044,
/* J */	 126.9044, 39.0983, 0, 0, 14.0067, 15.9994, 30.9738, 0, 0,
/* S */	 32.066, 3.01605, 238.0289, 50.9415, 183.85, 0, 88.9059, 135.1424};
/* letzter Wert Z = Schutzgruppe C6H5-CH2-O-CO- */
#endif

 //das gleiche fuer Isotope:
#ifdef FLIESSZAHLKLASSE
 static Fliesszahl einzelzeichen_iso['Z'-'A'+1];
 static const char *fliess_iso['Z'-'A'+1]=
/* A */	{"0", "11.0093", "12.000", "2.014102", "0", "18.9984", "0", "1.007825", "126.9044",
/* J */	 "126.9044", "38.9637", "0", "0", "14.00307", "15.9949", "30.9738", "0", "0",
/* S */	 "31.97207", "3.01605", "238.05076", "50.94398", "183.95099", "0", "88.90543", "135.0446"};
 if(initflag==1)
  {
   for(c=1;c<='Z'-'A';c++)
    {einzelzeichen[c]     = Fliesszahl(fliess[c],0);
     einzelzeichen_iso[c] = Fliesszahl(fliess_iso[c],0);
    }
   initflag=0; 
  }
#else
 static double einzelzeichen_iso['Z'-'A'+1]=
/* A */	{0, 11.0093, 12.000, 2.014102, 0, 18.9984, 0, 1.007825, 126.9044,
/* J */	 126.9044, 38.9637, 0, 0, 14.00307, 15.9949, 30.9738, 0, 0,
/* S */	 31.97207, 3.01605, 238.05076, 50.94398, 183.95099, 0, 88.90543, 135.0446};
/* letzter Wert Z = Schutzgruppe C6H5-CH2-O-CO- */
#endif

// printf("mol_weight('%s')\n",formel);//test
 while(isformelzeichen(c= *formel) && c!=')' && c!=']')
  {if(c=='(' || c=='[')
	{if(c=='[') klamzu=']'; else klamzu=')';
	 m=mol_weight(++formel,&s,isoflag);
	 formel=s;
	 if(*formel++!=klamzu) {fehler1("fehlende Klammer"); break;}
	}
   else if(c=='^' && isdigit(formel[1]))
        {m=sterndach(formel,&s,isoflag|DACH);
	 formel=s;
	}
   else
        {if(!isupper(c))
		{fehler2("ungueltige Formel:",formel); break;}
         if(islower(formel[1]) || (formel[1]=='Z' && (c=='P' || c=='M'))) //ist naechster Buchstabe ein Kleinbuchstabe, oder Ausnahmen PZ oder MZ?
	    {int i,k;                                                     //ja: Abkuerzung aus der Tabelle auslesen
	     mgtab *zmgtabelle = (isoflag==0) ? mgtabelle : mgtabelle_iso;
	     for(i=0,m=0;i<sizeof(mgtabelle)/sizeof(mgtab);i++)
	      {
	       if(zmgtabelle[i].symbol[0]==c)
		{k=strlen(zmgtabelle[i].symbol);
		 if(strncmp(&zmgtabelle[i].symbol[1],&formel[1],k-1)==0)
		   {m=zmgtabelle[i].wert; formel+=k; break;}
		}
	      }
	     if(i==1) set_actinium_warnung(); //Fuer Warnung um nicht Acethyl mit Actinium zu verwechseln
	    }
	 else
	    {m = (isoflag==0) ? einzelzeichen[c-'A'] : einzelzeichen_iso[c-'A'];   //nein: dann ist es ein Element, das mit nur einem Buchstaben abgekuerzt wird.
	     if(m!=0) formel++;
	    }
        }
   if(m==0) {fehler2("Unbekannt:",formel); formel++; break;}
   if(isdigit(*formel))
	{c = *formel++ - '0';
	 while(isdigit(*formel))
		{ c= 10*c + *formel++ - '0';}
	}
   else c=1;
   summe += c*m;
   while(ist_leer(*formel)) formel++;
  }
 if(c=='*')
  {formel++;
   if(isdigit(c= *formel))
	{c = *formel++ - '0';
	 while(isdigit(*formel))
		{ c= 10*c + *formel++ - '0';}
	}
   else if(c=='^')
	{//Trick: z.B. *^13C2 soll 2 schon gezaehlte C als 13C rechnen
	 summe += sterndach(formel,&s,isoflag);
	 formel=s;
	 c=1;
	}
   else	c=1;
   summe += c*mol_weight(formel,&s,isoflag);
   formel=s;
  }
 *zs = formel;
 // printf("summe=%lf  *zs='%s'\n",summe,*zs);//test
 return summe;
}

/******************* Erweiterung fuer Isotope ************************/
/*
 Beispiel: Boc-Ala-Gly-Ala*^13C-Aib-OMe sollte 417.464 (417.227) geben
           (nicht 429.47 (429.23) wie mit alter Version)
 z.B. *^13C2 soll 2 _schon_gezaehlte_ C als 13C rechnen
 (im Gegensatz zu ^13C2 (ohne *) wo das wirklich 2 zusaetzliche C sind)
 Spezialfall Deuterium: z.B. *^D12

 Die Funktion sterndach() soll als Formel etwas in der Form
 "^<Zahl><Atom><Zahl>..." bekommen. (Der Stern wurde schon verarbeitet).
 Als Rueckgabewert soll die Differenzmasse berechnet werden, also markiertes
 minus nicht markiertes. zs soll dann noch die Restformel zurueckgeben.
 Beispiele: ^18O, ^13C6, ^6Li, ^208Pb, ^2H11, ^D11
 Spezialfall Deuterium: statt ^2H11 sollte ^D11 benutzt werden (genauer weil
 Deuterium nicht 2.000 sondern 2.014102 hat).
*/
double sterndach(char* formel,char** zs,int flags)
{
 char atom[3],*s;
 double summe,masse,alt;
 int c,k,anzahl;
 if(formel[0]!='^') fehler1("sterndach-Syntaxfehler");//test
 if(formel[1]=='D' || formel[1]=='T') //Spezialfall Deuterium u. Tritium
   {atom[0]=formel[1]; atom[1]=0;
    masse=mol_weight(atom,&s,0);
    atom[0]='H';
    k=2;
   }
 else //Normalfall
   {for(masse=0,k=1;(c=formel[k])!=0 && isdigit(c);k++)
          masse=10*masse+c-'0';
    if(masse<=1 || !isupper(formel[k])) fehler1("falsche Isotop-Syntax");
    atom[0]=formel[k++];
    c=formel[k];
    if(islower(c)) k++; else c=0;
    atom[1]=c;
    atom[2]=0;
   }
 for(anzahl=0;(c=formel[k])!=0 && isdigit(c);k++)
    anzahl=10*anzahl+c-'0';
 if(anzahl==0) anzahl=1;
 while(ist_leer(formel[k])) k++;
 *zs = &formel[k];
 alt = mol_weight(atom,&s,flags&ISO);
 if(alt==0 || alt-masse>5 || masse-alt>5) fehler1("Falsches-Isotop");
 if(flags&DACH)
   summe = masse * anzahl;
 else
   summe = (masse - alt) * anzahl;
 return summe;
}

/********************** Fehlermeldungen *************************/
static int errorflag=0;
static int actinium_warnung=0; //fuer Warnung um Actinium nicht mit Acetyl zu verwechseln
static char scratch[400],*errorstring=NULL,*warningstring=NULL;

void error_reset(char *errstr,char *warnstr)
{
 errorflag=0;
 actinium_warnung=0;
 errorstring=errstr;
 warningstring=warnstr;
}

void fehler1(const char *text)
{
 if(errorstring!=NULL) strcpy(errorstring,text);
 else printf("%s\n",text);
 errorflag++;
}

void fehler0(const char *text,int c)
{
 sprintf(scratch,"%s %c",text,c);
 fehler1(scratch);
}

void fehler2(const char *text1,char *text2)
{
 sprintf(scratch,"%s%s",text1,text2);
 fehler1(scratch);
}

void set_actinium_warnung() {actinium_warnung++;}
int  get_actinium_warnung() {return actinium_warnung;}

void warnung1(const char *text)
{
 if(warningstring!=NULL) strcpy(warningstring,text);
}

/************************ Hauptaufruf ***************************/
double calculate_mol_weight(const char *formel,int isoflag)
{
 //char normierteformel[800], *s;
 char *normierteformel, *s;
 double result=0;
 int n,max2;
 error_reset(NULL,NULL);
 max2=3*strlen(formel)+1;
 normierteformel=(char*)calloc(max2,1);
 if(normierteformel==NULL)
  {fehler1("zu wenig Speicher"); return result;}
 formel_normieren(formel,normierteformel,strlen(formel)+1,max2);
 n=klammertest(normierteformel);
 if(n<0)
  fehler1("fehlende Klammer auf");
 else if(n>0)
  fehler1("fehlende Klammer zu");
 else
  {
   result=mol_weight(normierteformel,&s,isoflag);
   if(actinium_warnung>0) warnung1("Hinweis: Ac = Actinium, Ace = Acetyl");
  }
 free(normierteformel);
 return result;
}

/*****************Erweiterung fuer Summenformeln *********************/
#ifdef SUMMENFORMELN

const char *getsummenformel_pep(const char *peptid)
{
 int c=dreibuchstaben_auf_einbuchstaben_abkuerzung_reduzieren(peptid);
 return aminos[c-'A'].summenformel;
}

char *getsymbol(const char *s)
{
 static char sym[8];
 char *p;
 sym[0]=0;
 if(!isupper(*s)) return sym;
 for(p=sym, *p++ = *s++; islower(*s);)
   *p++ = *s++;
 *p = 0;
 return sym;
}

int getnumber(const char *s)
{
 int c,z=0;
 while(isdigit(*s))
  {
   c = *s++;
   z=10*z+c-'0';
  }
 return z;
}

const char* elemente[]=
 {"D","H","He",
  "Li","Be","B", "C", "N", "O", "F", "Ne",
  "Na","Mg","Al","Si","P", "S", "Cl","Ar",
  "K", "Ca","Sc","Ti","V", "Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr",
  "Rb","Sr","Y", "Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I", "Xe",
  "Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf",
                      "Ta","W", "Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn",
  "Fr","Ra","Ac","Th","Pa","U", "Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr" //bis Elemnt nr=103
 };

const char* getelementsymbol(int nr)
{
 return elemente[nr];
}

int elementnummer(const char *symbol)
{
 int nr;
 if(strcmp(symbol,"J")==0) symbol="I"; //Spezialfall: Jod mit 'J' abgekuerzt statt 'I'
 for(nr=0;nr<sizeof(elemente)/sizeof(char*);nr++)
  if(strcmp(symbol,elemente[nr])==0) return nr;
 return nr;
}

static Abkuerzungen summenformeltabelle[]=
 {
  {"Bzl", "C7H7"},
  {"Ace", "C2H3O"}, //Acethyl (H3C-C=O)
  {"Z",   "C8H7O2"},
  {"Boc", "C5H11O2"},
  {"Fmoc", "C15H11O2"},
  {"Me", "CH3"},
  {"Et", "C2H5"},
  {"Bu", "C4H9"},
  {"Ph", "C6H5"},
  {"PZ", "C14H11N2O2"},
  {"Pz", "C14H11N2O2"},
  {"MZ", "C15H13N2O3"},
  {"Mz", "C15H13N2O3"},

 };

const char *getsummenformel(const char *formel,const char **zs,int startflag)
{
 const char *s,*sym,*neu;
 static char summenformel[400];
 int i,c,index,z,klamzu;
 static int element[120];
 printf("getsummenformel('%s',zs,startflag=%d)\n",formel,startflag);//test
 if(startflag)  {for(i=0;i<120;i++) element[i]=0;}
 while((c= *formel)!=0 && c!=')' && c!=']' && c!=',')
  {
   if(ist_leer(c)) {++formel; continue;}
   if(c=='(' || c=='[')
     {
      if(c=='(') klamzu=')'; else klamzu=']';
      neu=getsummenformel(++formel,&s,0);
      formel=s;
      if(*formel++ != klamzu) fehler1("Klammerfehler");
      printf("bisherige Summenformel='%s' Restformel='%s'\n",neu,formel);//test
     }
   else
     {
      Abkuerzungen *p;
      sym=getsymbol(formel);
      printf("sym=getsymbol('%s') --> '%s'\n",formel,sym);//test
      if(*sym==0) {fehler1("Fehler in getsummenformel()"); return "";}
      neu="";
      for(p=aminos,i=0;i<sizeof(aminos)/sizeof(Abkuerzungen);i++,p++)
	{
	 if(strcmp(sym,p->sym)==0) {neu=p->summenformel; break;}
	}
      if(*neu==0)
       for(p=summenformeltabelle,i=0;i<sizeof(summenformeltabelle)/sizeof(Abkuerzungen);i++,p++)
	{
	 if(strcmp(sym,p->sym)==0) {neu=p->summenformel; break;}
	}
      if(*neu==0)
        neu=sym;
      formel += strlen(sym);
     }
   if(isdigit(*formel))
    {
     printf("isdigit('%s') -->",formel);//test
     index=getnumber(formel); while(isdigit(*formel)) formel++;
     printf(" %d\n",index);//test
    }
   else
    index=1;
   while(*neu!=0)
    {
     int n=elementnummer(neu);
     c = *(++neu);
     if(c>='a' && c<='z') neu++;
     if(isdigit(*neu))
      {
       z=getnumber(neu); while(isdigit(*neu)) neu++;
      }
     else
      z=1;
     element[n] += z*index;
    }
  }
 if(zs!=NULL) *zs=formel;
 char zahltext[40],*st;
 for(st=summenformel,i=0;i<120;i++)
  {
   if(element[i]!=0)
    {
     sym=getelementsymbol(i);
     while((c= *sym++)!=0) *st++ = c;
     if(element[i]>1)
      {sprintf(zahltext,"%d",element[i]);
       for(sym=zahltext;(c= *sym++)!=0;) *st++ = c;
      }
    }
  }
 *st=0;
 return summenformel;
}

#endif
