//
//  MainViewController.m
//  MGWcalc
//
//  Created by Rolf Pfister on 06.02.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "MainViewController.h"
#include "mgw.h"

@implementation MainViewController

@synthesize managedObjectContext = _managedObjectContext;
@synthesize flipsidePopoverController = _flipsidePopoverController;

@synthesize eingabefeld = _eingabefeld;
@synthesize ausgabefeldnorm = _ausgabefeldnorm;
@synthesize ausgabefeldsumm = _ausgabefeldsumm;
@synthesize ausgabefeldmg = _ausgabefeldmg;
@synthesize ausgabefeldmg2 = _ausgabefeldmg2;
@synthesize ausgabefeldwarning = _ausgabefeldwarning;
@synthesize ausgabefelderror = _ausgabefelderror;

@synthesize beisp1label = _beisp1label;
@synthesize beisp2label = _beisp2label;
@synthesize beisp3label = _beisp3label;
@synthesize beisp4label = _beisp4label;
@synthesize beisp5label = _beisp5label;
@synthesize beisp1name = _beisp1name;
@synthesize beisp2name = _beisp2name;
@synthesize beisp3name = _beisp3name;
@synthesize beisp4name = _beisp4name;
@synthesize beisp5name = _beisp5name;
@synthesize nameEingabefeld = _nameEingabefeld;
@synthesize beispielelabel = _beispielelabel;

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Release any cached data, images, etc that aren't in use.
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.

    [_beisp4label setText:@"H~MLSDEDFKAVFGJTRCAFANLPLWKQQNLKKEKGLF~OH*CHCONH-(C6H3(SO3H)-N)2-H"];//test
    [_beisp4name setTitle:@"Met52Aha-AY" forState:UIControlStateNormal];//test
    //Dieses Beispiel sollte 4598.290280 (4595.163605) und Summenformel C205H307N55O58S4 ergeben

}

- (void)viewDidUnload
{
    [self setEingabefeld:nil];
    [self setAusgabefeldnorm:nil];
    [self setAusgabefeldsumm:nil];
    [self setAusgabefeldmg:nil];
    [self setAusgabefeldmg2:nil];
    [self setAusgabefeldwarning:nil];
    [self setAusgabefelderror:nil];
    [self setBeisp1label:nil];
    [self setBeisp2label:nil];
    [self setBeisp3label:nil];
    [self setBeisp4label:nil];
    [self setBeisp5label:nil];
    [self setBeisp1name:nil];
    [self setBeisp2name:nil];
    [self setBeisp3name:nil];
    [self setBeisp4name:nil];
    [self setBeisp5name:nil];
    [self setNameEingabefeld:nil];
    [self setBeispielelabel:nil];
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
}

- (void)viewWillDisappear:(BOOL)animated
{
	[super viewWillDisappear:animated];
}

- (void)viewDidDisappear:(BOOL)animated
{
	[super viewDidDisappear:animated];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Return YES for supported orientations
    if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) {
        return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
    } else {
        return YES;
    }
}

#pragma mark - Flipside View Controller

- (void)flipsideViewControllerDidFinish:(FlipsideViewController *)controller
{
    if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) {
        [self dismissModalViewControllerAnimated:YES];
    } else {
        [self.flipsidePopoverController dismissPopoverAnimated:YES];
        self.flipsidePopoverController = nil;
    }
}

- (void)popoverControllerDidDismissPopover:(UIPopoverController *)popoverController
{
    self.flipsidePopoverController = nil;
}

- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender
{
    if ([[segue identifier] isEqualToString:@"showAlternate"]) {
        [[segue destinationViewController] setDelegate:self];
        
        if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad) {
            UIPopoverController *popoverController = [(UIStoryboardPopoverSegue *)segue popoverController];
            self.flipsidePopoverController = popoverController;
            popoverController.delegate = self;
        }
    }
}

- (IBAction)togglePopover:(id)sender
{
    if (self.flipsidePopoverController) {
        [self.flipsidePopoverController dismissPopoverAnimated:YES];
        self.flipsidePopoverController = nil;
    } else {
        [self performSegueWithIdentifier:@"showAlternate" sender:sender];
    }
}

- (IBAction)clearknopf:(id)sender {
    [_eingabefeld setText:@""];
    [_ausgabefeldnorm setText:@""]; //Normierte Formel loeschen
    [_ausgabefeldsumm setText:@""]; //Summenformel loeschen    
    [_ausgabefelderror setText:nil]; //Fehlertext loeschen
    [_ausgabefeldwarning setText:nil]; //Warnungstext loeschen
}

- (IBAction)saveknopf:(id)sender {
    
    [self startknopf:nil];
    if([[_ausgabefelderror text] length]==0) {
    
    static int beispnr=5;
    NSString *beispielformat;
    if(strncmp([[_beispielelabel text] UTF8String],"Ex",2)==0)
         beispielformat=@"Example%d";
    else beispielformat=@"Beispiel%d";
    NSString *name = [_nameEingabefeld text];
    NSString *bname = [NSString stringWithFormat:beispielformat,beispnr];
    if([name length]==0)
         name = bname;
    
    if([[_beisp1label text] length]==0)
      {
       [_beisp1label setText:[_eingabefeld text]];
       [_beisp1name setTitle:name forState:UIControlStateNormal];
      }
    else if([[_beisp2label text] length]==0)
      {
       [_beisp2label setText:[_eingabefeld text]];
       [_beisp2name setTitle:name forState:UIControlStateNormal];
      }
    else if([[_beisp3label text] length]==0)
      {
       [_beisp3label setText:[_eingabefeld text]];
       [_beisp3name setTitle:name forState:UIControlStateNormal];
      }
    else if([[_beisp4label text] length]==0)
      {
       [_beisp4label setText:[_eingabefeld text]];
       [_beisp4name setTitle:name forState:UIControlStateNormal];
      }
    else
      {
       if([[_beisp5label text] length]!=0)
         {
           [_beisp1label setText:[_beisp2label text]];
           [_beisp1name setTitle:[[_beisp2name titleLabel] text] forState:UIControlStateNormal];
           [_beisp2label setText:[_beisp3label text]];
           [_beisp2name setTitle:[[_beisp3name titleLabel] text] forState:UIControlStateNormal];
           [_beisp3label setText:[_beisp4label text]];
           [_beisp3name setTitle:[[_beisp4name titleLabel] text] forState:UIControlStateNormal];           
           [_beisp4label setText:[_beisp5label text]];
           [_beisp4name setTitle:[[_beisp5name titleLabel] text] forState:UIControlStateNormal];           
         }
       [_beisp5label setText:[_eingabefeld text]];
       [_beisp5name setTitle:name forState:UIControlStateNormal];
       //[_beisp5name setTitle:name forState:UIControlStateHighlighted];
       //[_beisp5name setTitle:name forState:UIControlStateSelected];

      }
    if([[_eingabefeld text] length]!=0)
      {
          if(strcmp([name UTF8String],[bname UTF8String])==0) ++beispnr;
          name = [NSString stringWithFormat:beispielformat,beispnr];
          [_nameEingabefeld setText:name];
      }
        
    }
}

- (IBAction)startknopf:(id)sender {
    
    char normiertertext[600],ausgabetext[200];
    const char *eingabetext, *summenformel;
    double resultat,resultat2;
    char errortext[200],warningtext[200];
    
    eingabetext = [[_eingabefeld text] UTF8String];

    if(strncmp(eingabetext,"Hier",4)==0)
        strcpy(normiertertext,"Zuerst Clear-Knopf druecken!");
    else if(strncmp(eingabetext,"Enter",5)==0)
        strcpy(normiertertext,"First press Clear button!");
    else
        formel_norm(eingabetext,normiertertext,600);

    [_ausgabefeldnorm setText:[NSString stringWithUTF8String:normiertertext]];
    resultat = mgw(normiertertext,0,errortext,warningtext);
    resultat2 = mgw(normiertertext,ISO,errortext,warningtext);
    sprintf(ausgabetext,"%.4f",resultat);
    [_ausgabefeldmg  setText:[NSString stringWithUTF8String:ausgabetext]];
    sprintf(ausgabetext,"%.4f",resultat2);
    [_ausgabefeldmg2 setText:[NSString stringWithUTF8String:ausgabetext]];
    
    [_ausgabefeldwarning setText:[NSString stringWithUTF8String:warningtext]];
    [_ausgabefelderror   setText:[NSString stringWithUTF8String:errortext]];
    
    summenformel=getsummenformel(normiertertext,NULL);
    [_ausgabefeldsumm setText:[NSString stringWithUTF8String:summenformel]];
    free((void*)summenformel);
    
}

- (IBAction)beisp1knopf:(id)sender {
    [_eingabefeld setText:[_beisp1label text]];
    [self startknopf:nil];
}

- (IBAction)beisp2knopf:(id)sender {
    [_eingabefeld setText:[_beisp2label text]];
    [self startknopf:nil];
}

- (IBAction)beisp3knopf:(id)sender {
    [_eingabefeld setText:[_beisp3label text]];
    [self startknopf:nil];
}

- (IBAction)beisp4knopf:(id)sender {
    [_eingabefeld setText:[_beisp4label text]];
    [self startknopf:nil];
}

- (IBAction)beisp5knopf:(id)sender {
    [_eingabefeld setText:[_beisp5label text]];
    [self startknopf:nil];
}
- (IBAction)tasteneingabe:(id)sender {
    //UIButton *taste=sender;
    NSString *symbol = [[sender titleLabel] text];
    NSString *text = [NSString stringWithFormat:@"%@%@",[_eingabefeld text],symbol];
    [_eingabefeld setText:text];
    
}
@end
