// mgkern.h
#ifndef MGKERN_H
#define MGKERN_H

//--------------------------------------------------------
// benoetigt fuer iPad-Version:
#define SUMMENFORMELN

#ifndef __cplusplus
#ifndef bool
#define bool int
#define inline
#endif
#endif

bool isfirstformelzeichen(char c);
bool ist_leer(char c);
bool isformelzeichen(char c);
const char *einbuchstaben_auf_dreibuchstaben_abkuerzung_erweitern(int c);
int dreibuchstaben_auf_einbuchstaben_abkuerzung_reduzieren(const char *peptid);
char *getsymbol(const char **zs);
int getnumber(const char **zs);
const char* getelementsymbol(int nr);
int elementnummer(const char *symbol);
const char *getsymbolundzahl(char **zs);
void einfuegen(char *puffer,const char *sym);
void einsortieren(char *puffer,const char *sym);
void summesortieren(char *summenformel);
const char *getsummenformel_pep(const char *peptid);

// Rest sollte gleich sein wie Normale Version
//--------------------------------------------------------

int klammertest(const char *text);
void formel_normieren(const char *quelle,char *ziel,int imax,int jmax);
double mol_weight(char* formel,char** zs,int isoflag);
double sterndach(char* formel,char** zs,int flags);
//erlaubte Werte fuer flags:
#define ISO 1
#define DACH 2

void error_reset(char *errstr,char *warnstr);
void fehler0(const char *text,int c);
void fehler1(const char *text);
void fehler2(const char *text1,const char *text2);
void set_actinium_warnung(void);
int get_actinium_warnung(void);
void warnung1(const char *text);

double calculate_mol_weight(const char *formel,int isoflag);

#ifdef SUMMENFORMELN
char *getsummenformel(const char *formel,const char **zs);
void summesortieren(char *summenformel);
#endif

#endif
