<?php
/* mg.php				letzte Aenderung: 20.12.2012
#define VERSION "2.03"

Verwendung:
Nach Eingabe einer Formel wird das Molekulargewicht auf 3 Nachkommastellen
genau berechnet.
Aufrufbeispiel: mg.php?formel=CH3-CH2-OH&flags=i
Beispiele:
> mg CH3-CH2-OH  -->  46.069
> mg -i CH3-CH2-OH  -->  46.042
> mg "CH3-(CH2)2-OH" --> 60.096
> mg Boc-Ala-Aib-OMe --> 288.344

History:
Datum     Version  Kommentar
17.8.2004	Uebernommen von mg.cc Version 1.6 (27.2.)
19.8.04		Gleiche Anpassungen wie in mg.cc
28.10.04	Unterstuetzen auch von z.B. -(CH_2)_3,
		ist_leer() korrigiert '*' ist kein Leerzeichen, stattdessen
		in Hauptschlaufen nach '*' abfragen (bei while(isform..).
		Wichtig fuer z.B. *5H2O
8.2.06	  1.7	Gleiche Korrekturen wie in mg.cc
15.2.06	  1.8	Gleiche Korrekturen wie in mg.cc
5.10.06	  1.9	Gleiche Aenderungen wie in mg.cc
4.10.10	  	Gleiche Aenderungen wie in mg.cc: Aha eingefuegt
6.2.12    2.0   Genauigkeit verbessert, Zahlenvertauscher beim Prolin korrigiert,
	  	Zahlenwerte aus mgkern.c Version 2.02 uebernommen
                (noch nicht alle ueberprueft)
11.12.12  2.02  Pbf-Schutzgruppe eingefuegt
20.12.12  2.03  Versuch der Unterstuetzung von Seitenketten-Schutzgruppen (wie -p beim mg.cc)

*/
?>
<HTML>
<HEAD><TITLE>MG-Rechner PHP-Variante</TITLE></HEAD>
<BODY>
<?php
function digit($c)
{
 if($c>='a') return $c-'a'+10;
 if($c>='A') return $c-'A'+10;
 return $c-'0';
}
/*
function filtern($formel)
{
 for($s="",$t="",$formel,$i=0,$j=0; ($c = $s[$i++])!=0;)
   {if($c=='%')
     {$c1= $s[$i++]; $c2= $s[$i++]; $c=($digit($c1)<<4)+$digit($c2);}
    $t[$j++] = $c;
   }
 $t[$j]=0;
 return $t;
}
*/
function plus(&$f) {$f=substr($f,1);}
function plusgleich($f,$k) {$f=substr($f,$k);}
function plusplus(&$f) {$c=$f[0]; $f=substr($f,1); return $c;}
function isupper($c) {return $c>='A' && $c<='Z';}
function islower($c) {return $c>='a' && $c<='z';}
function isdigit($c) {return $c>='0' && $c<='9';}
function dann($c1,$c2) {return ord($c1)+256*ord($c2);}
function elem($c) {return ord($c[0])+256*ord($c[1]);}
function isdigitu($c) {return $c=='_' || ($c>='0' && $c<='9');}
function plusplusu(&$f)
{
 $c=$f[0]; if($c=='_') {$f=substr($f,1); $c=$f[0];}
 $f=substr($f,1);
 return $c;
}

function klammertest($text)
{
 $k1=0;
 $k2=0;
 $c=0;
 for(;$text!='';)
   {$c=plusplus($text);
    if($c=='(') $k1++; else if($c==')') --$k1;
    else if($c=='[') $k2++; else if($c==']') --$k2;
   }
 if($k1!=0) return $k1;
 return $k2;
}

function formel_normieren($quelle,$pflag)
{
 /* Sonderzeichen ~ zum Umschalten auf Kurzschreibweise von Peptidketten
    werden hier entfernt und die Peptide auf die 3-Buchstabenschreibweise
    erweitert. Zudem noch allfaellige Leerzeichen entfernt.
 */
 $modus=0;
 $c=' ';
 $ziel='';
 for($i=1;$quelle!='';$i++)
   {$c=plusplus($quelle);
    if($c=='~') {$modus=1-$modus;}
    else if($c==' ' || $c=='\n' || $c=='\t') ;//Leerzeichen entfernen
    else if($modus==1)
      {$peptid='';
       if($pflag==1)
       {switch($c)
	{case 'A': $peptid="C3H5NO"; break; //Ala
	 case 'R': $peptid="C19H28N4O4S"; break; //Arg(Pbf)
	 case 'N': $peptid="C23H20N2O2"; break; //Asn(Trt)
	 case 'D': $peptid="C8H13NO3"; break; //Asp(tBu)
	 case 'C': $peptid="C22H19NOS"; break; //Cys(Trt)
	 case 'Q': $peptid="C24H22N2O2"; break; //Gln(Trt)
	 case 'E': $peptid="C9H15NO3"; break; //Glu(tBu)
	 case 'G': $peptid="C2H3NO"; break; //Gly
	 case 'H': $peptid="C25H21N3O"; break; //His(Trt)
	 case 'I': $peptid="C6H11NO"; break; //Ile
	 case 'L': $peptid="C6H11NO"; break; //Leu
	 case 'K': $peptid="C11H20N2O3"; break; //Lys(Boc)
	 case 'M': $peptid="C5H9NOS"; break; //Lys(Boc)
	 case 'F': $peptid="C9H9NO"; break; //Phe
	 case 'P': $peptid="C5H7NO"; break; //Pro
	 case 'S': $peptid="C7H13NO2"; break; //Ser(tBu)
	 case 'T': $peptid="C8H15NO2"; break; //Thr(tBu)
	 case 'W': $peptid="C16H18N2O3"; break; //Trp(Boc)
	 case 'Y': $peptid="C13H17NO2"; break; //Tyr(tBu)
	 case 'V': $peptid="C5H9NO"; break; //Val
	 case 'B': $peptid="C4H7NO"; break; //Aib
	 case 'J': $peptid="C4H6N4O"; break; //Aha
	}
       }	
       else
       {switch($c)
	{case 'A': $peptid="Ala"; break;
	 case 'R': $peptid="Arg"; break;
	 case 'N': $peptid="Asn"; break;
	 case 'D': $peptid="Asp"; break;
	 case 'C': $peptid="Cys"; break;
	 case 'Q': $peptid="Gln"; break;
	 case 'E': $peptid="Glu"; break;
	 case 'G': $peptid="Gly"; break;
	 case 'H': $peptid="His"; break;
	 case 'I': $peptid="Ile"; break;
	 case 'L': $peptid="Leu"; break;
	 case 'K': $peptid="Lys"; break;
	 case 'M': $peptid="Met"; break;
	 case 'F': $peptid="Phe"; break;
	 case 'P': $peptid="Pro"; break;
	 case 'S': $peptid="Ser"; break;
	 case 'T': $peptid="Thr"; break;
	 case 'W': $peptid="Trp"; break;
	 case 'Y': $peptid="Tyr"; break;
	 case 'V': $peptid="Val"; break;
	 case 'B': $peptid="Aib"; break;
	 case 'J': $peptid="Aha"; break;
	}
       }	
       if($peptid!='') {$ziel="$ziel$peptid";}
       else $ziel="$ziel$c";
      }
    else
      {$ziel="$ziel$c";}
   }
 return $ziel;
}

function isfirstformelzeichen($c)
{
 return (isupper($c) || $c=='(' || $c=='[' || $c=='^');
}

function ist_leer($c)
{
 return ($c=='-' || $c=='=' || $c=='_');
}

function isformelzeichen($c)
{
 if($c=='') return false;
 return (isfirstformelzeichen($c) || islower($c) || ist_leer($c)
	 || $c==')' || $c==']');
}

/******************************* Tabellen *****************************/
//#define DANN *256+

function mol_wight($formel,&$zs,&$actinium) /*  Berechne Molekulargewicht */
{
 $summe=0.0;
 $m=0.0;
 $s='';
 $einzelzeichen = array(
/* A */	 0., 10.811, 12.011, 2.014102, 0., 18.9984, 0., 1.00794, 126.9044,
/* J */	 126.9044, 39.0983, 0., 0., 14.0067, 15.9994, 30.9738, 0., 0.,
/* S */	 32.066, 3.01605, 238.0289, 50.9415, 183.85, 0., 88.9059, 135.14238);
/* letzter Wert Z = Schutzgruppe C6H5-CH2-O-CO- */
 while(isformelzeichen($c= $formel[0]) && $c!=')' && $c!=']' && $c!='*')
  {if($c=='(' || $c=='[')
	{if($c=='[') $klamzu=']'; else $klamzu=')';
	 plus($formel);
	 $m=mol_wight($formel,$s,$actinium);
	 $formel=$s;
	 if(plusplus($formel)!=$klamzu) {echo "fehlende $klamzu Klammer: '$s'<br>\n"; break;}
	}
   else if($c=='^' && isdigit($formel[1]))
        {$m=sterndach($formel,$s,2);
	 $formel=$s;
	}
   else {if(!isupper($c))
		{printf("ungueltige Formel:%s<BR>\n",$formel); break;}
	 if(islower($formel[1]) || ($formel[1]=='Z' && ($c=='P' || $c=='M')))
	    {switch (dann($formel[0],$formel[1]))
		{
		 case elem('Ac'): if($formel[2]=='e')
					{$m=43.04522; plus($formel);}/*-Ace-*/
				    else {$m=227.0278; $actinium++;}  break;
		 case elem('Ag'): $m=107.8682;	break;
		 case elem('Al'): if($formel[2]=='a')
					{$m=71.0788; plus($formel);} /*-Ala-*/
				    else $m=26.9815; /*Aluminium*/	break;
		 case elem('Ai'): if($formel[2]=='b')
					{$m=85.10568; plus($formel);} /*-Aib-*/
				    else $m=0.0; 	break;
		 case elem('Ah'): if($formel[2]=='a')
					{$m=126.11784; plus($formel);} /*-Aha-*/
				    else $m=0.0; 	break;
		 case elem('Ar'): if($formel[2]=='g') {$m=156.18748; plus($formel);}
				    else $m=39.948;	break;
		 case elem('As'): if($formel[2]=='n') {$m=114.10384; plus($formel);}
				    else if($formel[2]=='p')
						       {$m=115.08860; plus($formel);}
				    else  $m=74.9216;	break;
		 case elem('Am'): $m=243.0614;	break;
		 case elem('At'): $m=209.9871;	break;
		 case elem('Au'): $m=196.9665;	break;
		 case elem('Ba'): $m=137.327;	break;
		 case elem('Be'): $m=9.01218;	break;
		 case elem('Bi'): $m=208.9804;	break;
		 case elem('Bk'): $m=247.0703;	break;
		 case elem('Br'): $m=79.909;	break;
		 case elem('Bo'): if($formel[2]=='c') {$m=101.12526; plus($formel);} /*Boc-*/
				    else $m=0.0; break;
		 case elem('Bz'): if($formel[2]=='l') {$m=91.13258; plus($formel);} /*Benzyl*/
				    else $m=0.0; break;
		 case elem('Bu'): $m=57.11546;	break; /* Butyl */
		 case elem('Ca'): $m=40.078;	break;
		 case elem('Cd'): $m=112.411;	break;
		 case elem('Ce'): $m=140.115;	break;
		 case elem('Cf'): $m=251.0796;	break;
		 case elem('Cl'): $m=35.453;	break;
		 case elem('Cm'): $m=247.0703;	break;
		 case elem('Cp'): $m=65.0947;  break;
		 case elem('Cr'): $m=51.9961;	break;
		 case elem('Cs'): $m=132.9051;	break;
		 case elem('Co'): $m=58.9332;	break;
		 case elem('Cu'): $m=63.546;	break;
		 case elem('Cy'): if($formel[2]=='s') {$m=103.14480; plus($formel);}
				    else $m=0.0;	break;
		 case elem('Dy'): $m=162.5;	break;
		 case elem('Er'): $m=167.26;	break;
		 case elem('Es'): $m=252.0829;	break;
		 case elem('Et'): $m=29.0617;	break;
		 case elem('Eu'): $m=151.965;	break;
		 case elem('Fe'): $m=55.847;	break;
		 case elem('Fm'): if($formel[2]=='o' && $formel[3]=='c')
				{$m=223.25114; plus($formel); plus($formel);} /* Fmoc */
				    else $m=257.0951;	break;
		 case elem('Fr'): $m=223.0197;	break;
		 case elem('Ga'): $m=69.723;	break;
		 case elem('Gd'): $m=157.25;	break;
		 case elem('Ge'): $m=72.61;	break;
		 case elem('Gl'): if($formel[2]=='y') {$m=57.05192; plus($formel);} /*-Gly-*/
				    else if($formel[2]=='n') {$m=128.13072; plus($formel);}
				    else if($formel[2]=='u') {$m=129.11548; plus($formel);}
				    else $m=0.0; break;
		 case elem('He'): $m=4.002602;	break;
		 case elem('Hf'): $m=178.49;	break;
		 case elem('Hg'): $m=200.59;	break;
		 case elem('Ho'): $m=164.9303;	break;
		 case elem('Hi'): if($formel[2]=='s') {$m=137.14108; plus($formel);}
				    else $m=0.0;	break;
		 case elem('Il'): if($formel[2]=='e') {$m=113.15944; plus($formel);}
				    else $m=0.0;	break;
		 case elem('In'): $m=114.82;	break;
		 case elem('Ir'): $m=192.22;	break;
		 case elem('Kr'): $m=83.80;	break;
		 case elem('La'): $m=138.9055;	break;
		 case elem('Le'): if($formel[2]=='u') {$m=113.15944; plus($formel);}
				    else $m=0.0;	break;
		 case elem('Ly'): if($formel[2]=='s') {$m=128.17408; plus($formel);}
				    else $m=0.0;	break;
		 case elem('Li'): $m=6.941;	break;
		 case elem('Lr'): $m=260.1053;	break;
		 case elem('Lu'): $m=174.967;	break;
		 case elem('Md'): $m=258.0986;	break;
		 case elem('Me'): if($formel[2]=='t') {$m=131.19856; plus($formel);}
				    else $m=15.03482;	break;
		 case elem('Mg'): $m=24.305;	break;
		 case elem('Mn'): $m=54.938;	break;
		 case elem('Mo'): $m=95.94;	break;
		 case elem('Mz'): $m=269.27982; break; /*Mz-Schutzgruppe*/
		 case elem('MZ'): $m=269.27982; break; /*Mz-Schutzgruppe*/
		 case elem('Na'): $m=22.9897;	break;
		 case elem('Nb'): $m=92.90638;	break;
		 case elem('Nd'): $m=144.24;	break;
		 case elem('Ne'): $m=20.1797;	break;
		 case elem('Ni'): $m=58.69;	break;
		 case elem('No'): $m=259.1009;	break;
		 case elem('Np'): $m=237.0482;	break;
		 case elem('Os'): $m=190.2;	break;
		 case elem('Pa'): $m=231.0359;	break;
		 case elem('Pb'): if($formel[2]=='f')
					{$m=253.34218; plus($formel);} /*Pbf-Schutzgruppe*/
				    else $m=207.2;	break;
		 case elem('Pd'): $m=106.42;	break;
		 case elem('Ph'): if($formel[2]=='e') {$m=147.17656; plus($formel);}
				    else $m=77.1057;	break;
		 case elem('Pm'): $m=146.9151;	break;
		 case elem('Po'): $m=208.9824;	break;
		 case elem('Pr'): if($formel[2]=='o') {$m=97.11668; plus($formel);}
				    else $m=140.9077;	break;
		 case elem('Pt'): $m=195.08;	break;
		 case elem('Pu'): $m=244.0642;	break;
		 case elem('Pz'): $m=239.25354; break; /*Pz-Schutzgruppe*/
		 case elem('PZ'): $m=239.25354; break; /*Pz-Schutzgruppe*/
		 case elem('Ra'): $m=226.0254;	break;
		 case elem('Rb'): $m=85.4678;	break;
		 case elem('Re'): $m=186.207;	break;
		 case elem('Rh'): $m=102.9055;	break;
		 case elem('Rn'): $m=222.0176;	break;
		 case elem('Ru'): $m=101.07;	break;
		 case elem('Sb'): $m=121.75;	break;
		 case elem('Sc'): $m=44.95591;	break;
		 case elem('Se'): if($formel[2]=='r') {$m=87.07820; plus($formel);}
				    else $m=78.96;	break;
		 case elem('Si'): $m=28.0855;	break;
		 case elem('Sm'): $m=150.36;	break;
		 case elem('Sn'): $m=118.710;	break;
		 case elem('Sr'): $m=87.62;	break;
		 case elem('Ta'): $m=180.9479;	break;
		 case elem('Tb'): $m=158.9253;	break;
		 case elem('Tc'): $m=98.9063;	break;
		 case elem('Te'): $m=127.60;	break;
		 case elem('Th'): if($formel[2]=='r') {$m=101.10508; plus($formel);}
				    else $m=232.0381;	break;
		 case elem('Ti'): $m=47.88;	break;
		 case elem('Tl'): $m=204.3833;	break;
		 case elem('Tm'): $m=168.9342;	break;
		 case elem('Tr'): if($formel[2]=='p') {$m=186.21320; plus($formel);}
				    else $m=0.0;	break;
		 case elem('Ty'): if($formel[2]=='r') {$m=163.17596; plus($formel);}
				    else $m=0.0;	break;
		 case elem('Va'): if($formel[2]=='l') {$m=99.13256; plus($formel);}
				    else $m=0.0;	break;
		 case elem('Xe'): $m=131.29;	break;
		 case elem('Yb'): $m=173.04;	break;
		 case elem('Zn'): $m=65.39;	break;
		 case elem('Zr'): $m=91.224;	break;
		 default:	    $m=0.0;	break;
		}
	     plus($formel);
	    }
	 else 	    {$m=$einzelzeichen[ord($c)-ord('A')];}
	 plus($formel);
	}
   if($m==0) {printf("Unbekannt:%s\n",$formel); break;}
   if(isdigitu($formel[0]))
	{$c = plusplusu($formel) - '0';
	 while(isdigit($formel[0]))
		{ $c= 10*$c + plusplus($formel) - '0';}
	}
   else $c=1;
   $summe += $c*$m;
//   echo "m=$m c=$c summe=$summe<br>"; //test
   while(ist_leer($formel[0])) plus($formel);
  }
 if($c=='*')
  {plus($formel);
   if(isdigit($c= $formel[0]))
	{$c = plusplus($formel) - '0';
	 while(isdigit($formel[0]))
		{ $c= 10*$c + plusplus($formel) - '0';}
	}
   else if($c=='^')
	{//Trick: z.B. *^13C2 soll 2 schon gezaehlte C als 13C rechnen
	 $summe += sterndach($formel,$s,0);
	 $formel=$s;
	 $c=1;
	}
   else	$c=1;
   $summe += $c*mol_wight($formel,$s,$actinium);
   $formel=$s;
  }
 $zs = $formel;
 return $summe;
}

function mol_wight_iso($formel,&$zs) /* nur hufigste Isotope */
{
 $summe=0.0;
 $m=0.0;
 $s='';
 $einzelzeichen = array(
/* A */	 0., 11.0093, 12.000, 2.014102, 0., 18.9984, 0., 1.007825, 126.9044,
/* J */	 126.9044, 38.9637, 0., 0., 14.00307, 15.9949, 30.9738, 0., 0.,
/* S */	 31.97207, 3.01605, 238.05076, 50.94398, 183.95099, 0., 88.90543, 135.044575);
/* letzter Wert Z = Schutzgruppe C6H5-CH2-O-CO- */
/* printf("mol_wight_iso('%s')\n",formel);/* test */
 while(isformelzeichen($c= $formel[0]) && $c!=')' && $c!=']' && $c!='*')
  {if($c=='(' || $c=='[')
	{if($c=='[') $klamzu=']'; else $klamzu=')';
	 plus($formel);
	 $m=mol_wight_iso($formel,$s);
	 $formel=$s;
	 if(plusplus($formel)!=$klamzu) {echo "fehlende $klamzu Klammer: '$zs'<br>\n"; break;}
	}
   else if($c=='^' && isdigit($formel[1]))
        {$m=sterndach($formel,$s,2);
	 $formel=$s;
	}
   else {if(!isupper($c))
		{printf("ungueltige formel:%s<BR>\n",$formel); break;}
	 if(islower($formel[1]) || ($formel[1]=='Z' && ($c=='P' || $c=='M')))
	    {switch (dann($formel[0],$formel[1]))
		{
		 case elem('Ac'): if($formel[2]=='e')
					{$m=43.018375; plus($formel);}/*-Ace-*/
				    else {$m=227.0278; $actinium++;}  break;
		 case elem('Ag'): $m=106.90497; break;
		 case elem('Al'): if($formel[2]=='a')
					{$m=71.0371; plus($formel);} /*-Ala-*/
				    else $m=26.9815;	 break;
		 case elem('Ai'): if($formel[2]=='b')
					{$m=85.0527; plus($formel);} /*-Aib-*/
				    else $m=0.0; 	break;
		 case elem('Ah'): if($formel[2]=='a')
					{$m=126.05413; plus($formel);} /*-Aha-*/
				    else $m=0.0; 	break;
		 case elem('Ar'): if($formel[2]=='g') {$m=156.1011; plus($formel);}
				    else $m=39.96238;	 break;
		 case elem('As'): if($formel[2]=='n') {$m=114.0429; plus($formel);}
				    else if($formel[2]=='p')
						       {$m=115.0269; plus($formel);}
				    else  $m=74.9216;	 break;
		 case elem('Am'): $m=243.0614;	break;
		 case elem('At'): $m=209.9871;	break;
		 case elem('Au'): $m=196.9665;	 break;
		 case elem('Ba'): $m=137.90501; break;
		 case elem('Be'): $m=9.01218;	 break;
		 case elem('Bi'): $m=208.9804;	 break;
		 case elem('Bk'): $m=247.0703;	break;
		 case elem('Br'): $m=78.91835;	 break;
		 case elem('Bo'): if($formel[2]=='c') {$m=101.0602; plus($formel);} /*Boc-*/
				    else $m=0.0; break;
		 case elem('Bz'): if($formel[2]=='l') {$m=91.0548; plus($formel);} /*Benzyl*/
				    else $m=0.0; break;
		 case elem('Bu'): $m=57.070425;	break; /* Butyl */
		 case elem('Ca'): $m=39.96259;  break;
		 case elem('Cd'): $m=113.90357; break;
		 case elem('Ce'): $m=139.90528; break;
		 case elem('Cf'): $m=251.0796;	break;
		 case elem('Cl'): $m=34.96885;  break;
		 case elem('Cm'): $m=247.0703;	break;
		 case elem('Cp'): $m=65.039125; break;
		 case elem('Cr'): $m=51.94051;  break;
		 case elem('Cs'): $m=132.9051;	 break;
		 case elem('Co'): $m=58.9332;	 break;
		 case elem('Cu'): $m=62.9296;	 break;
		 case elem('Cy'): if($formel[2]=='s') {$m=103.0092; plus($formel);}
				    else $m=0.0;	break;
		 case elem('Dy'): $m=162.5;	break;
		 case elem('Er'): $m=167.26;	break;
		 case elem('Es'): $m=252.0829;	break;
		 case elem('Et'): $m=29.039125;break;
		 case elem('Eu'): $m=151.965;	break;
		 case elem('Fe'): $m=55.93493;	 break;
		 case elem('Fm'): if($formel[2]=='o' && $formel[3]=='c')
				{$m=223.075875; plus($formel); plus($formel);} /* Fmoc */
				    else $m=257.0951;	break;
		 case elem('Fr'): $m=223.0197;	break;
		 case elem('Ga'): $m=68.92568;	 break;
		 case elem('Gd'): $m=157.25;	break;
		 case elem('Ge'): $m=73.92115;	 break;
		 case elem('Gl'): if($formel[2]=='y') {$m=57.0214; plus($formel);} /*-Gly-*/
				    else if($formel[2]=='n') {$m=128.0585; plus($formel);}
				    else if($formel[2]=='u') {$m=129.0425; plus($formel);}
				    else $m=0.0; break;
		 case elem('He'): $m=4.002604;	 break;
		 case elem('Hf'): $m=179.94681; break;
		 case elem('Hg'): $m=201.97063; break;
		 case elem('Ho'): $m=164.9303;	 break;
		 case elem('Hi'): if($formel[2]=='s') {$m=137.0589; plus($formel);}
				    else $m=0.0;	break;
		 case elem('Il'): if($formel[2]=='e') {$m=113.0840; plus($formel);}
				    else $m=0.0;	break;
		 case elem('In'): $m=114.90407; break;
		 case elem('Ir'): $m=192.96328; break;
		 case elem('Kr'): $m=83.9115;	 break;
		 case elem('La'): $m=138.90606; break;
		 case elem('Li'): $m=7.016005;	 break;
		 case elem('Lr'): $m=260.1053;	break;
		 case elem('Lu'): $m=174.967;	break;
		 case elem('Le'): if($formel[2]=='u') {$m=113.0840; plus($formel);}
				    else $m=0.0;	break;
		 case elem('Ly'): if($formel[2]=='s') {$m=128.0949; plus($formel);}
				    else $m=0.0;	break;
		 case elem('Md'): $m=258.0986;	break;
		 case elem('Me'): if($formel[2]=='t') {$m=131.0405; plus($formel);}
				    else $m=15.023475; break;
		 case elem('Mg'): $m=23.98505;	 break;
		 case elem('Mn'): $m=54.938;	 break;
		 case elem('Mo'): $m=97.90551;	 break;
		 case elem('Mz'): $m=269.0926; break; /*Mz-Schutzgruppe*/
		 case elem('MZ'): $m=269.0926; break; /*MZ-Schutzgruppe*/
		 case elem('Na'): $m=22.98977;	 break;
		 case elem('Nb'): $m=92.90638;	 break;
		 case elem('Nd'): $m=141.90748; break;
		 case elem('Ne'): $m=19.99244;	 break;
		 case elem('Ni'): $m=57.93534;	 break;
		 case elem('No'): $m=259.1009;	break;
		 case elem('Np'): $m=237.0482;	break;
		 case elem('Os'): $m=191.96141; break;
		 case elem('Pa'): $m=231.0359;	break;
		 case elem('Pb'): if($formel[2]=='f')
					{$m=253.089795; plus($formel);} /*Pbf-Schutzgruppe*/
				    else $m=207.97664;	break;
		 case elem('Pd'): $m=105.9032;	 break;
		 case elem('Ph'): if($formel[2]=='e') {$m=147.0684; plus($formel);}
				    else $m=77.0391;	break;
		 case elem('Pm'): $m=146.9151;	break;
		 case elem('Po'): $m=208.9824;	break;
		 case elem('Pr'): if($formel[2]=='o') {$m=97.052745; plus($formel);}
				    else $m=140.9077;	break;
		 case elem('Pt'): $m=194.96482; break;
		 case elem('Pu'): $m=244.0642;	break;
		 case elem('Pz'): $m=239.082015; break; /*Pz-Schutzgruppe*/
		 case elem('PZ'): $m=239.082015; break; /*Pz-Schutzgruppe*/
		 case elem('Ra'): $m=226.0254;	break;
		 case elem('Rb'): $m=84.91171;	 break;
		 case elem('Re'): $m=186.95596; break;
		 case elem('Rh'): $m=102.9055;	break;
		 case elem('Rn'): $m=222.0176;	break;
		 case elem('Ru'): $m=101.07;	break;
		 case elem('Sb'): $m=120.90375; break;
		 case elem('Sc'): $m=44.95591;	 break;
		 case elem('Se'): if($formel[2]=='r') {$m=87.0320; plus($formel);}
				    else $m=79.91651;	 break;
		 case elem('Si'): $m=27.9769;	break;
		 case elem('Sm'): $m=150.36;	break;
		 case elem('Sn'): $m=119.90213; break;
		 case elem('Sr'): $m=87.90561;	 break;
		 case elem('Ta'): $m=180.9479;	break;
		 case elem('Tb'): $m=158.9253;	break;
		 case elem('Tc'): $m=98.9063;	break;
		 case elem('Te'): $m=129.9067;	 break;
		 case elem('Th'): if($formel[2]=='r') {$m=101.0476; plus($formel);}
				    else $m=232.0381;	 break;
		 case elem('Ti'): $m=47.94795;	 break;
		 case elem('Tl'): $m=204.97446; break;
		 case elem('Tm'): $m=168.9342;	break;
		 case elem('Tr'): if($formel[2]=='p') {$m=186.0793; plus($formel);}
				    else $m=0.0;	break;
		 case elem('Ty'): if($formel[2]=='r') {$m=163.0633; plus($formel);}
				    else $m=0.0;	break;
		 case elem('Va'): if($formel[2]=='l') {$m=99.0684; plus($formel);}
				    else $m=0.0;	break;
		 case elem('Xe'): $m=131.90416; break;
		 case elem('Yb'): $m=173.93902; break;
		 case elem('Zn'): $m=63.92915;	 break;
		 case elem('Zr'): $m=89.90432;	 break;
		 default :	 $m=0.0;	break;
		}
	     plus($formel);
	    }
	 else 	    {$m=$einzelzeichen[ord($c)-ord('A')];}
	 plus($formel);
	}
   if($m==0) {printf("Unbekannt:%s\n",$formel); break;}
   if(isdigitu($formel[0]))
	{$c = plusplusu($formel) - '0';
	 while(isdigit($formel[0]))
		{ $c= 10*$c + plusplus($formel) - '0';}
	}
   else $c=1;
   $summe += $c*$m;
   while(ist_leer($formel[0])) plus($formel);
  }
 if($c=='*')
  {plus($formel);
   if(isdigit($c= $formel[0]))
	{$c = plusplus($formel) - '0';
	 while(isdigit($formel[0]))
		{ $c= 10*$c + plusplus($formel) - '0';}
	}
   else if($c=='^')
	{//Trick: z.B. *^13C2 soll 2 schon gezaehlte C als 13C rechnen
	 $summe += sterndach($formel,$s,1);
	 $formel=$s;
	 $c=1;
	}
   else	$c=1;
   $summe += $c*mol_wight_iso($formel,$s);
   $formel=$s;
  }
 $zs = $formel;
 return $summe;
}

function fehler1($text)
{
 echo "$text<br>\n";
}

function zahl($c)
{
 return ord($c)-ord('0');
}

function sterndach($formel,&$zs,$isoflag)
{
/*
 Beispiel: Boc-Ala-Gly-Ala*^13C-Aib-OMe sollte 417.464 (417.227) geben
           (nicht 429.47 (429.23) wie mit alter Version)
 z.B. *^13C2 soll 2 _schon_gezaehlte_ C als 13C rechnen
 (im Gegensatz zu ^13C2 (ohne *) wo das wirklich 2 zusaetzliche C sind)
 Spezialfall Deuterium: z.B. *^D12
*/
 $atom='';
 $summe=0.0; $masse=0.0;
 $c=0; $k=0; $anzahl=0;
 if($formel[0]!='^') fehler1("sterndach-Syntaxfehler");//test
 if($formel[1]=='D' || $formel[1]=='T') //Spezialfall Deuterium u. Tritium
   {$atom=$formel[1];
    $masse=mol_wight($atom,$s,$actinium);
    $atom='H';
    $k=2;
   }
 else //Normalfall
   {for($masse=0.0,$k=1;($c=$formel[$k])!='' && isdigit($c);$k++)
          $masse=10*$masse+zahl($c);
    if($masse<=1 || !isupper($formel[$k])) fehler1("falsche Isotop-Syntax");
    $atom=$formel[$k++];
    $c=$formel[$k];
    if(islower($c)) {$k++; $atom="$atom$c";}
   }
 for($anzahl=0;($c=$formel[$k])!='' && isdigit($c);$k++)
   $anzahl=10*$anzahl+zahl($c);
 if($anzahl==0) $anzahl=1;
 while(ist_leer($formel[$k])) $k++;
 $zs=substr($formel,$k);
 $alt = ($isoflag==1) ? mol_wight_iso($atom,$s) : mol_wight($atom,$s,$actinium);
 if($alt==0 || $alt-$masse>5 || $masse-$alt>5) fehler1("Falsches-Isotop");
 if($isoflag==2)
   $summe = $masse * $anzahl;
 else
   $summe = ($masse - $alt) * $anzahl;
 return $summe;
}

/***************************** Hauptprogramm **************************/
// $formel=filtern($formel);
/*
 $alterlevel=error_reporting(0); //E_ALL sollte voreingestellt sein
 echo "alterlevel = ".$alterlevel."<br>";
 char *s,cstr[40];
 $nachkomma=3;
 sprintf(cstr,"Molgewicht = %%.%dlf\n",nachkomma);
*/
 $s='';
 echo    "eingegebene Formel: $formel<BR>";
 $formel2=formel_normieren($formel,0);
 if($formel2 != $formel)
   {echo " normierte  Formel: $formel2<BR>";}
 $actinium=0;
 if(($n=klammertest($formel2))!=0)
   {echo "fehlende Klammer "; if($n<0) echo "auf<br>"; else echo "zu<br>";}
 if($flags=="i" || $flags=="I")
  {$mg=mol_wight_iso($formel2,$s); echo "iso MG = $mg";}
 else if($flags=="p" || $flags=="P")
  {$mg=mol_wight($formel2,$s,$actinium);
   $formel2=formel_normieren($formel,1); $mg2=mol_wight($formel2,$s,$actinium);
   echo "MG = $mg  (Mit Seitenschutzgruppen: $mg2)";
  }
 else
  {$mg=mol_wight($formel2,$s,$actinium); $mgiso=mol_wight_iso($formel2,$s);
   echo "MG = $mg  (Isotopenrein: $mgiso)";
  }
 if($actinium>0) {echo "<br>Hinweis: Ac = Actinium, Ace = Acethyl";}
?>
</BODY>
</HTML>
