/* mgcheck3.c				letzte Aenderung: 6.12.2012 */
//#define CGIPROGRAMM
#define VERSION "2.0"
/*
Testprogramm zum mgkern.c zu ueberpruefen.

History:
Datum      Version  Kommentar
2.2.2012       Erstellung aus mgcheck.cc
6.12.          bei include direkt mgkern.c statt mgkern.h um "mgtabelle[134]" zu vermeiden

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
//#include "mgkern.h"
#include "mgkern.c"
#define MAXARG 2

/*************************** globale Parameter ************************/
char zeile[800];
char argflag['Z'+1];

void setflags(char *s)
{int c; while((c= *s++)!=0)  if((c=toupper(c))<='Z')  argflag[c]=1;}

/*************************** Vordeklarationen: ************************/
void formel_mit_allen_symbolen_erstellen(char *ziel,int max);

/***************************** Hauptprogramm **************************/
struct _Beisp {const char *formel,*summ; double mg,mgiso;};
typedef struct _Beisp Beisp;
static Beisp beispiele[]=
 {
  {"C", "C",   12.011,  12.000},
  {"Na", "Na", 22.9897, 22.9897},
  {"CH3-CH2-OH", "C2H6O", 46.06904, 46.04185},
  {"CH3-(CH2)2-OH", "C3H8O", 60.09592, 60.0575},
  {"Boc", "C5H9O2", 101.12526, 101.060225},
  {"Boc-Ala-Aib-OMe", "C13H24N2O5", 288.34396, 288.16844},
  {"Fmoc~ABCDEFGHIJKLMNPQRSTVWY~NH2", "C130H183N35O33S2", 2828.22972, 2826.315265},
  {"-p Fmoc~ABCDEFGHIJKLMNPQRSTVWY~NH2", "C130H183N35O33S2", 4530.61684, 4527.253235}, //mit Seitenketten-Flag
  {"RfDbSgBhHsMtDsRgCn", "BhCnDbDsHsMtRfRgSg", 2427.4636, 2427.4636},
  //hier koennen weitere Beispiele eingefuegt werden
  //{"all","C", 17644.377744, 17648.107796} //ohne kuenstliche Elemente
  {"all","AcAg...YbZnZr", 20325.183524, 20328.661191}, //mit kuenstliche Elemente
  {"NaHSO4*5H2O", "H11NaO9S", 210.13764, 210.002015}
 };

int main(int argc,char* argv[])
{
 double mg1,mg2;
 const char *sumf;
 int i,j,nachkomma;
 char errstring[80],warnstring[80];
 for(zeile[0]=0,i=j=1;i<argc;i++)
   if(*argv[i]=='-') setflags(argv[i]);
   else switch(j++)
        {case 1:strcpy(zeile,argv[i]); break;
         default:break;
        }
 if(j>MAXARG+1 || zeile[0]=='?' || argflag['?'])
	{printf("mgcheck Version %s\n",VERSION);
	 printf("Anwendung: mgcheck [-Flags]\n");
	 printf("   Flags: v=verbose = mit allen Kommentaren\n");
	 printf("          p=Peptide mit Seitenketten-Schutzgruppen\n");
	 exit(0);
	}
 nachkomma=6;
 if(argflag['P']) pflag=1;
 for(i=0;i<sizeof(beispiele)/sizeof(Beisp);i++)
  {
   strcpy(zeile,beispiele[i].formel);
   if(strcmp(zeile,"all")==0)
     formel_mit_allen_symbolen_erstellen(zeile,800);

   if(strncmp(zeile,"-p ",3)==0)
     {
      printf("Peptidkette mit Seitenketten-Schutzgruppen:\n");
      strcpy(zeile,&zeile[3]);
      pflag=1;
     }
   else if(!argflag['P']) pflag=0;

   error_reset(errstring,warnstring);
   if(argflag['V']) printf("--\nFormel = \"%s\"\n",zeile);
   mg1=calculate_mol_weight(zeile,0);
   mg2=calculate_mol_weight(zeile,ISO);

   if(argflag['V'] && *warnstring!=0) printf("Warnung: %s\n",warnstring);
   if(*errstring!=0)  printf("Error: %s\n",errstring);
   printf("Sollwerte: %f (%f)\n",beispiele[i].mg,beispiele[i].mgiso);
   printf("berechnet: %f (%f)\n",mg1,mg2);
#ifdef SUMMENFORMELN
   error_reset(errstring,warnstring);
   sumf=getsummenformel(zeile,NULL);
   strcpy(zeile,sumf); free((void*)sumf);
   mg1=calculate_mol_weight(zeile,0);
   mg2=calculate_mol_weight(zeile,ISO);
   if(argflag['V'] && *warnstring!=0) printf("Warnung: %s\n",warnstring);
   if(*errstring!=0)  printf("Error: %s\n",errstring);
   printf("berechne2: %f (%f)\n",mg1,mg2);
   printf(" Summenformel: \"%s\"\n",zeile);
   if(strcmp(zeile,beispiele[i].summ)!=0) printf("Summenformel2: \"%s\"\n",beispiele[i].summ);//test
#endif
  }
 return 0;
}/* ende von main */

/* nicht noetig mit obigem  include "mgkern.c"
struct _mgtab {const char *symbol; double wert;};
typedef struct _mgtab mgtab;
extern mgtab mgtabelle[134];
extern mgtab mgtabelle_iso[134];
*/

void formel_mit_allen_symbolen_erstellen(char *ziel,int max)
{
 int i,j,c;
 const char *s,*s2;
 for(j=0,c='B';c<='Z';c++)
  {
   if(c!='E' && c!='G' && c!='L' && c!='M' && c!='Q' && c!='R' && c!='X') //nur gueltige 1-Buchstaben-Abkuerzungen
    {
     ziel[j++]=c;
    }
  }
 ziel[j]=0;
 //if(argflag['V']) printf("Alle 1-Buchstaben-Abk.: \"%s\"\n",ziel);//test
 for(i=0;j<max-5 && i<sizeof(mgtabelle)/sizeof(mgtab);i++)
  {
   s=mgtabelle[i].symbol;
   s2=mgtabelle_iso[i].symbol;
   if(s==NULL || s2==NULL || strcmp(s,s2)!=0)
     printf("Fehler in mgtabelle[] oder mgtabelle_iso[]: i=%d \"%s\" \"%s\"\n",i,s,s2);
   strcpy(&ziel[j],s); j+=strlen(s);
  }
 ziel[j]=0;
 //if(argflag['V']) printf("Alle Symbole: \"%s\"\n",ziel);//
}
