/* mgtex.c				letzte Aenderung: 27.2.2004 */
#define VERSION "Version 1.6"
/*
Uebersetzen auf VMS:
;AVAX> CX mgtex
;AVAX> BLINK mgtex

Uebersetzen Unix (Linux):
make
make test
make install

Fuegt bei einer chemischen Gleichung (in LATEX) die Molekulargewichte ein.
Die entsprechenden Zeilen muessen mit %MGTEX markiert sein und mit \\ enden.
Beispiel:
%MGTEX
O$_2$ + 2 H$_2$ $\,\stackrel{\Delta}{\longrightarrow}\,$ H$_2$O
\\
Ende des Beispiels.

History:
11.3.1993 V1.2	Erstellung (Rolf Pfister)
		Atomgewichte vollstaendig bis Lawrencium
20.12.95	Anpassung ALPHA
6.10.2003 V1.3	Anpassung an Linux, Molekulargewichte fr Peptide
		automatische Ermittlung der Endungen verbessert
16.2.04	  1.6	Schutzgruppen von mg.cc Version 1.6 uebernommen
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#ifndef unix
#include <file.h>
#endif
#include <ctype.h>
#define MAXARG 3

#define index myindex

/*************************** Vordeklarationen *************************/
int isfirstformelzeichen(int c);
int isformelzeichen(int c);
int ist_leer(int c);
int getline(FILE *fp,char *s,int lim);
void ohnepunkt(char *name);
void stradd(char *s,char *t,char *z);
int index(char *s1,char *s2);
void systemf(char *str,char *p1,char *p2);
int formelzeile_lesen(FILE *fp,FILE *fp2);
void wandle(char *z1,char *z2);
char *klammerpaar_suchen(char *s,int auf,int zu);
void mgzeile_schreiben(FILE *fp2);
double mol_wight(char *formel,char **zs);
void putline(FILE *fp,char *s);

/*************************** globale Parameter ************************/
static char quelle[80],ziel[80];
#define MAX 200
#define M20 80
static char formelzeile[MAX],formzeile[MAX];

/***************************** Hauptprogramm **************************/
main(int argc,char *argv[])
{
 FILE *fp,*fp2;
 int n,zielistquelle;
 char *tmpname="mgtex.tmp";
 if(argc<2) {printf("Quelle:"); scanf("%s",quelle);}
 else	    {strcpy(quelle,argv[1]);}
 if(argc>MAXARG+1 || quelle[0]=='?' || quelle[0]=='-')
	{printf("MGTEX  %s\n",VERSION);
	 printf("Anwendung: MGTEX Name.mgtex [neuername.tex]\n");
	 printf("  in Name.tex:\n");
	 printf("       %MGTEX\n");
	 printf("       Formelgleichungen\n");
	 printf("       \\\\\n");
	 exit(0);
	}
 if(index(quelle,".")== -1) stradd(quelle,".mgtex",quelle);
 fp=fopen(quelle,"r");
 if(fp==NULL) {printf("'%s' nicht gefunden\n",quelle); exit(0);}
 if(argc==3) strcpy(ziel,argv[2]);
 else
   {strcpy(ziel,quelle);
    if(index(ziel,".mgtex")>0) ohnepunkt(ziel);
   }
 if(index(ziel,".")== -1)  stradd(ziel,".tex",ziel);
 if(strcmp(quelle,ziel)==0) {strcpy(ziel,tmpname); zielistquelle=1;}
 else zielistquelle=0;
 if((fp2=fopen(ziel,"w"))==NULL)
   {fclose(fp); printf("Fehler beim Oeffnen von '%s'\n",ziel); exit(0);}
// printf("quelle='%s' ziel='%s'\n",quelle,ziel);//test
 for(n=0;n>=0;)
  {if((n=formelzeile_lesen(fp,fp2))==1)
	{wandle(formelzeile,formzeile);
	 printf("%s\n",formzeile);/* test */
	 mgzeile_schreiben(fp2);
	}
   else if(n== -2)
	printf("Fehler: Zeile zu lang\n");
  }
 fclose(fp2); fclose(fp);
 if(n== -1 && zielistquelle) /* n== -1  ist normales Ende */
#ifdef unix
   {systemf("mv %s %s~",quelle,quelle);/* Alte Datei sichern, */
    systemf("cp %s %s",ziel,quelle); /* Ergebnis auf alten Name kopieren */
    systemf("rm %s;",ziel,NULL);     /* und Hilfsdatei loeschen. */
#else
   {systemf("COPY %s %s",ziel,quelle);/* Ergebnis auf alten Name kopieren */
    systemf("DEL %s;",ziel,NULL);   /* und Hilfsdatei loeschen */
#endif
	}
}/* ende von main */

void systemf(char *str,char *p1,char *p2)
{
 char s[160];
 sprintf(s,str,p1,p2); system(s);
}

int formelzeile_lesen(FILE *fp,FILE *fp2)
{
 int lim=MAX,c;
 char *s=formelzeile;
 if(getline(fp,s,lim)==EOF) return -1;
 if((c=strcmp(s,"%MGTEX"))==0)
   {while(lim>0)
	{lim=getline(fp,s,lim); putline(fp2,s);
	 if(lim==EOF) return 1;
	 s=formelzeile+MAX-3-lim;
	 if(s[0]=='\\' && s[1]=='\\') return 1;
	 s+=2; if(lim>0) *s++=' '; /* Nullbyte durch Leerstelle ersetzen */
	}
    return -2; /* Fehler */
   }
 putline(fp2,s);
 return 0;
}

void wandle(char *z1,char *z2)
{
/*  erster Durchgang:
	$_x$	ersetzen durch	_x
	\rm \,	entfernen
	\longrightarrow ersetzen --->
	\uparrow ersetzen ^
	\equiv ersetzen ==
	\stackrel{xx}{\longrightarrow} ersetzen ---->
	\end{large}	entfernen
	\cdot{} ersetzen *
	\cdot ersetzen *
    zweiter Durchgang:
	$ _ \	entfernen
	[ ]	ersetzen durch ( )
	mehrere Leerstellen kuerzen
*/
 char *s1,*s2,*s0;
 int c1,c2,j;
 for(s1=z1,s2=z2; c1= *s1++;)
  {if(c1=='$')
	{if(*s1=='_')
		while((c1= *s1) && c1!='$')  {*s2++=c1; s1++;}
	}
   else if(c1=='\\')
	{if(*s1==',')
		s1++;
	 else if(strncmp(s1,"rm ",3)==0)	/* entferne \rm */
		s1+=3;
	 else if(strncmp(s1,"cdot{}",6)==0)	/* \cdot{} ersetzen durch - */
		{*s2++='*'; s1+=6;}
	 else if(strncmp(s1,"cdot",4)==0)	/* \cdot ersetzen durch - */
		{*s2++='*'; s1+=4;}
	 else if(strncmp(s1,"longrightarrow",14)==0)
		{*s2++='-'; *s2++='-'; *s2++='-'; *s2++='>'; s1+=14;}
	 else if(strncmp(s1,"uparrow",7)==0)
		{*s2++='^'; s1+=7;}
	 else if(strncmp(s1,"equiv",5)==0)
		{*s2++='='; *s2++='='; s1+=5;}
	 else if(strncmp(s1,"end{large}",10)==0)
		{*s2++=' '; s1+=10;}
	 else if(strncmp(s1,"stackrel",8)==0)
		{s1=klammerpaar_suchen((s0=s1+8),'{','}');
		 j=(s1-s0)*2/3; if(j<3) j=3;
		 s1=klammerpaar_suchen(s1,'{','}');
		 while(j--) *s2++='-';
		 *s2++='>';
		}
	 else
		{*s2++=c1;}
	}
   else
	*s2++=c1;
  }
 *s2=0;
 for(s1=s2=z2,c2=0; c1= *s1++;) /* zweiter Durchgang */
  {if(c1!='$' && c1!='_' && c1!='\\' && (c1!=' ' || c2!=' '))
	{if(c1=='[') c1='('; else if(c1==']') c1=')';
	 *s2++ = c1;
	}
   c2=c1;
  }
 *s2=0;
}

char *klammerpaar_suchen(char *s,int auf,int zu)
{
 int i,c;
 while((c= *s++) && c!=auf)  ;
 if(c==0) return --s;
 for(i=1; c= *s; s++)
	{if(c==auf)  i++;
	 else if(c==zu) {if(--i==0) break;}
	}
 if(c!=0) s++;
 return s;
}

void mgzeile_schreiben(FILE *fp2)
{
 char *s,*s1,*s0;
 double mg[M20];
 int pos[M20],p0,i,j,n, c,p2,j2;
 for(s1=formzeile; (c= *s1) && c==' '; s1++)  ;
 s0=s1;
 for(n=0; *s1 && n<M20; s1=s)
	{while((c= *s1) && !isfirstformelzeichen(c)) s1++;
	 pos[n]=s1-s0;
	 mg[n]=mol_wight(s1,&s);
	 if(mg[n]>0.) n++;
	}
 fprintf(fp2,"M: \\ ");  printf("M: ");/* test */
 if(pos[0]>=4) p0=4; else p0=1; /* ?? */
 for(p2=3,i=0;i<n;i++)
	{for(j=pos[i]-p0; j>0; j--)  fprintf(fp2,"\\ \\ ");
	 for(j2=pos[i]-p2; j2>0; j2--)  printf(" ");
	 p0=pos[i]+3-j;
	 p2=pos[i]+4-j2; if(mg[i]>=100.) p2++;
	 fprintf(fp2,"\\=%.1lf\n",mg[i]); printf("%.1lf",mg[i]);
	}
 fprintf(fp2,"\\\\\n"); printf("\n");
}

#define bool int
/************************** aus MG.C *******************************/
#define DANN *256+

double mol_wight(char* formel,char** zs) /*  Berechne Molekulargewicht */
{
 int c,klamzu;
 char *s;
 double m, summe=0.;
 static double einzelzeichen['Z'-'A'+1]=
/* A */	{0., 10.811, 12.011, 2.014102, 0., 18.9984, 0., 1.00794, 126.9044,
/* J */	 126.9044, 39.0983, 0., 0., 14.0067, 15.9994, 30.9738, 0., 15.0348,
/* S */	 32.066, 0., 238.0289, 50.9415, 183.85, 0., 88.9059, 135.1424};
/* letzter Wert Z = Schutzgruppe C6H5-O-CO- */
/* printf("mol_wight('%s')\n",formel);/* test */
 while(isformelzeichen(c= *formel) && c!=')' && c!=']')
  {if(c=='(' || c=='[')
	{if(c=='[') klamzu=']'; else klamzu=')';
	 m=mol_wight(++formel,&s);
	 formel=s;
	 if(*formel++!=klamzu) {printf("fehlende Klammer\n"); break;}
	}
   else {if(!isupper(c))
	     {/* printf("ungueltige Formel:%s\n",formel); break; */
	      m=0.; formel++;
	     }
	 if(islower(formel[1]) || (formel[1]=='Z' && (c=='P' || c=='M')))
	    {switch (formel[0] DANN formel[1])
		{case 'A' DANN 'c': m=227.0278;	break;
		 case 'A' DANN 'g': m=107.8682;	break;
		 case 'A' DANN 'l': if(formel[2]=='a')
					{m=71.0788; formel++;} /*-Ala-*/
				    else m=26.9815; /*Aluminium*/	break;
		 case 'A' DANN 'i': if(formel[2]=='b')
					{m=85.1057; formel++;} /*-Aib-*/
				    else m=0; 	break;
		 case 'A' DANN 'r': if(formel[2]=='g') {m=156.1875; formel++;}
				    else m=39.948;	break;
		 case 'A' DANN 's': if(formel[2]=='n') {m=114.1038; formel++;}
				    else if(formel[2]=='p')
						       {m=115.0886; formel++;}
				    else  m=74.9216;	break;
		 case 'A' DANN 'm': m=243.0614;	break;
		 case 'A' DANN 't': m=209.9871;	break;
		 case 'A' DANN 'u': m=196.9665;	break;
		 case 'B' DANN 'a': m=137.327;	break;
		 case 'B' DANN 'e': m=9.01218;	break;
		 case 'B' DANN 'i': m=208.9804;	break;
		 case 'B' DANN 'k': m=247.0703;	break;
		 case 'B' DANN 'r': m=79.909;	break;
		 case 'B' DANN 'o': if(formel[2]=='c') {m=101.1253; formel++;} /*Boc-*/
				    else m=0; break;
		 case 'B' DANN 'z': if(formel[2]=='l') {m=91.1326; formel++;} /*Benzyl*/
				    else m=0; break;
		 case 'C' DANN 'a': m=40.078;	break;
		 case 'C' DANN 'd': m=112.411;	break;
		 case 'C' DANN 'e': m=140.115;	break;
		 case 'C' DANN 'f': m=251.0796;	break;
		 case 'C' DANN 'l': m=35.453;	break;
		 case 'C' DANN 'm': m=247.0703;	break;
		 case 'C' DANN 'p': m=65.0947;  break;
		 case 'C' DANN 'r': m=51.9961;	break;
		 case 'C' DANN 's': m=132.9051;	break;
		 case 'C' DANN 'o': m=58.9332;	break;
		 case 'C' DANN 'u': m=63.546;	break;
		 case 'C' DANN 'y': if(formel[2]=='s') {m=103.1448; formel++;}
				    else m=0;	break;
		 case 'D' DANN 'y': m=162.5;	break;
		 case 'E' DANN 'r': m=167.26;	break;
		 case 'E' DANN 's': m=252.0829;	break;
		 case 'E' DANN 't': m=29.0617;	break;
		 case 'E' DANN 'u': m=151.965;	break;
		 case 'F' DANN 'e': m=55.847;	break;
		 case 'F' DANN 'm': m=257.0951;	break;
		 case 'F' DANN 'r': m=223.0197;	break;
		 case 'G' DANN 'a': m=69.723;	break;
		 case 'G' DANN 'd': m=157.25;	break;
		 case 'G' DANN 'e': m=72.61;	break;
		 case 'G' DANN 'l': if(formel[2]=='y') {m=57.0519; formel++;} /*-Gly-*/
				    else if(formel[2]=='n') {m=128.1307; formel++;}
				    else if(formel[2]=='u') {m=129.1155; formel++;}
				    else m=0; break;
		 case 'H' DANN 'e': m=4.002602;	break;
		 case 'H' DANN 'f': m=178.49;	break;
		 case 'H' DANN 'g': m=200.59;	break;
		 case 'H' DANN 'o': m=164.9303;	break;
		 case 'H' DANN 'i': if(formel[2]=='s') {m=137.1411; formel++;}
				    else m=0;	break;
		 case 'I' DANN 'l': if(formel[2]=='e') {m=113.1594; formel++;}
				    else m=0;	break;
		 case 'I' DANN 'n': m=114.82;	break;
		 case 'I' DANN 'r': m=192.22;	break;
		 case 'K' DANN 'r': m=83.80;	break;
		 case 'L' DANN 'a': m=138.9055;	break;
		 case 'L' DANN 'e': if(formel[2]=='u') {m=113.1594; formel++;}
				    else m=0;	break;
		 case 'L' DANN 'y': if(formel[2]=='s') {m=128.1741; formel++;}
				    else m=0;	break;
		 case 'L' DANN 'i': m=6.941;	break;
		 case 'L' DANN 'r': m=260.1053;	break;
		 case 'L' DANN 'u': m=174.967;	break;
		 case 'M' DANN 'd': m=258.0986;	break;
		 case 'M' DANN 'e': if(formel[2]=='t') {m=131.1986; formel++;}
				    else m=15.0348;	break;
		 case 'M' DANN 'g': m=24.305;	break;
		 case 'M' DANN 'n': m=54.938;	break;
		 case 'M' DANN 'o': m=95.94;	break;
		 case 'M' DANN 'z': m=269.2798; break; /*Mz-Schutzgruppe*/
		 case 'M' DANN 'Z': m=269.2798; break; /*Mz-Schutzgruppe*/
		 case 'N' DANN 'a': m=22.9897;	break;
		 case 'N' DANN 'b': m=92.90638;	break;
		 case 'N' DANN 'd': m=144.24;	break;
		 case 'N' DANN 'e': m=20.1797;	break;
		 case 'N' DANN 'i': m=58.69;	break;
		 case 'N' DANN 'o': m=259.1009;	break;
		 case 'N' DANN 'p': m=237.0482;	break;
		 case 'O' DANN 's': m=190.2;	break;
		 case 'P' DANN 'a': m=231.0359;	break;
		 case 'P' DANN 'b': m=207.2;	break;
		 case 'P' DANN 'd': m=106.42;	break;
		 case 'P' DANN 'h': if(formel[2]=='e') {m=147.1766; formel++;}
				    else m=77.1057;	break;
		 case 'P' DANN 'm': m=146.9151;	break;
		 case 'P' DANN 'o': m=208.9824;	break;
		 case 'P' DANN 'r': if(formel[2]=='o') {m=97.1167; formel++;}
				    else m=140.9077;	break;
		 case 'P' DANN 't': m=195.08;	break;
		 case 'P' DANN 'u': m=244.0642;	break;
		 case 'P' DANN 'z': m=239.2535; break; /*Pz-Schutzgruppe*/
		 case 'P' DANN 'Z': m=239.2535; break; /*Pz-Schutzgruppe*/
		 case 'R' DANN 'a': m=226.0254;	break;
		 case 'R' DANN 'b': m=85.4678;	break;
		 case 'R' DANN 'e': m=186.207;	break;
		 case 'R' DANN 'h': m=102.9055;	break;
		 case 'R' DANN 'n': m=222.0176;	break;
		 case 'R' DANN 'u': m=101.07;	break;
		 case 'S' DANN 'b': m=121.75;	break;
		 case 'S' DANN 'c': m=44.95591;	break;
		 case 'S' DANN 'e': if(formel[2]=='r') {m=87.0782; formel++;}
				    else m=78.96;	break;
		 case 'S' DANN 'i': m=28.0855;	break;
		 case 'S' DANN 'm': m=150.36;	break;
		 case 'S' DANN 'n': m=118.710;	break;
		 case 'S' DANN 'r': m=87.62;	break;
		 case 'T' DANN 'a': m=180.9479;	break;
		 case 'T' DANN 'b': m=158.9253;	break;
		 case 'T' DANN 'c': m=98.9063;	break;
		 case 'T' DANN 'e': m=127.60;	break;
		 case 'T' DANN 'h': if(formel[2]=='r') {m=101.1051; formel++;}
				    else m=232.0381;	break;
		 case 'T' DANN 'i': m=47.88;	break;
		 case 'T' DANN 'l': m=204.3833;	break;
		 case 'T' DANN 'm': m=168.9342;	break;
		 case 'T' DANN 'r': if(formel[2]=='p') {m=186.2132; formel++;}
				    else m=0;	break;
		 case 'T' DANN 'y': if(formel[2]=='r') {m=163.1760; formel++;}
				    else m=0;	break;
		 case 'V' DANN 'a': if(formel[2]=='l') {m=99.1326; formel++;}
				    else m=0;	break;
		 case 'X' DANN 'e': m=131.29;	break;
		 case 'Y' DANN 'b': m=173.04;	break;
		 case 'Z' DANN 'n': m=65.39;	break;
		 case 'Z' DANN 'r': m=91.224;	break;
		 default :	    m=0.;	break;
		}
	     formel++;
	    }
	 else
 	    {m=einzelzeichen[c-'A'];}
	 formel++;
	}
   if(m==0.) {/*printf("Unbekannt:%s\n",formel);*/ summe=0.; break;}
   if(isdigit(*formel))
	{c = *formel++ - '0';
	 while(isdigit(*formel))
		{ c= 10*c + *formel++ - '0';}
	}
   else c=1;
   summe += c*m;
   while(ist_leer(*formel)) formel++;
  }
 if(c=='*')
  {formel++;
   if(isdigit(c= *formel))
	{c = *formel++ - '0';
	 while(isdigit(*formel))
		{ c= 10*c + *formel++ - '0';}
	}
   else	c=1;
   summe += c*mol_wight(formel,&s);
   formel=s;
  }
 *zs = formel;
/* printf("summe=%lf  *zs='%s'\n",summe,*zs);/* test */
 return summe;
}

bool isfirstformelzeichen(int c)
{
 return (isupper(c) || c=='(' || c=='[');
}

bool ist_leer(int c)
{
 return (c=='-' || c=='=' || c=='_');
}

bool isformelzeichen(int c)
{
 return (isfirstformelzeichen(c) || islower(c) || ist_leer(c)
	 || c==')' || c==']');
}

/*************************** kleinkram *****************************/
int getline(FILE *fp,char *s,int lim)
{			/* liest eine Textzeile oder maximal lim Zeichen */
 int c;			/* und ersetzt den Zeilentrenner durch 0         */
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 if(c==EOF) return EOF;
 return lim;
}

void ohnepunkt(char *name)	/* in Filename die Erweiterung .xxx loeschen */
{
 char c;
 while((c= *name)!='.' && c!=0) name++;
 if(c=='.') *name='\0';
}

void stradd(char *s,char *t,char *z)	/*  z = s + t  */
{char c;
 while (c = *s++) *z++ = c;
 while (*z++ = *t++)	;
}

index(char *s1,char *s2) /* Sucht den String s2 innerhalb von s1 und  */
			 /* gibt die Position zurueck (nicht gefunden = -1) */
{
 int i,c;
 char *p1,*p2;
 if(*s2==0) return 0;   /* leerer String ist immer enthalten */
 for(i=0;;i++)
	{if((c= *s1++)==0) return -1; /* nicht gefunden */
	 if(c== *s2)
		{for(p1=s1,p2=s2; c= *++p2;)
			if(*p1++!=c) break; /* noch nicht gefunden */
		 if(c==0) break; /* gefunden */
		}
	}
 return i;
}

void putline(FILE *fp,char *s)	/* wie fprintf(fp,"%s\n",s)		*/
				/* aber ohne ein Nullbyte zu schreiben	*/
{char c;
 while(c= *s++)  putc(c,fp);
 putc('\n',fp);
}
