/* molz3d.cc			letzte Aenderung: 11.4.2007 */
#define VERSION "Version 0.0"
/*
 Molekuele Zeichnen in 3D-Darstellung

History:
3.4.2007	Erstellung (RP)
*/

#include <iostream>
using namespace std;
#include <stdlib.h>
#include <xtekplot1.h>
//#include "matrixklasse.h"
#include <vektor3dklasse.cc>

#define XMAX 1280
#define YMAX 1024
#define TIEFE 24
const int WEISS=0xFFFFFF,SCHWARZ=0,GRAU=0x808080;

/************************* Vordeklarationen ***************************/
void dateiladen(char *name);
void mauspre();
void mausrel();
void mausmot();
void m_refresh();
Vektor3d projektion(Vektor3d p,double* f);
inline Vektor3d projektion(Vektor3d p) {double f; return projektion(p,&f);}

/**************************** kleinkram *******************************/
int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

int istendung(char *str,char *endung)
{
 int c,n=strlen(endung),c1= *endung++;
 for(;;)
 {while((c= *str++)!=c1) if(c==0) return 0;
  if(strcmp(str,endung)==0) return 1;
 }
 return 0;
}

/* int fscanfvekt(FILE *fp,Vektor3d* v)
{
 int c,n;
 while((c=getc(fp)) && c!='<' && c!='.' && !isdigit(c))
   if(c==EOF) return 0;
 if(c=='<')
   n=fscanf(fp,"%lf,%lf,%lf",&v->x,&v->y,&v->z);
 else
   {ungetc(c,fp);
    n=fscanf(fp,"%lf",&v->x);
    if(n==1) v->y=v->z=v->x;
   }
 printf("fscanfvekt() --> n=%d v=<%lg, %lg, %lg>\n",n,v->x,v->y,v->z);//test
 return n;
}*/

void vektoreinlesen(char *s,Vektor3d& v)
{
 int c;
 for(;(c= *s++)!='<' && c!=0;) ;
 sscanf(s,"%lf,%lf,%lf",&v.x,&v.y,&v.z);
}

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
static int test=0; //Testausdrucke (0=ohne 1=mit 2=noch mehr)
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
   if(c=='V') test++;
  }
}

/****************** Klassen und Globale Variablen *********************/
/** einfache globale Variablen: **/
static int gbreite,ghoehe,gtiefe;//Grafikfenster
static double gxmin= -13.3, gymin= -10.0, gxmax=13.3, gymax=10.0;
static int hintergrundfarbe;//Farbnummer fuer Hintergrund
static int vollmodus=1;//1=Atome ausgefuellt zeichnen, 0=nur Kreis zeichnen
static int higrund_r=128,higrund_g=128,higrund_b=255;//rgb-HintergrundFarbe
static int gatomradius=50,gbindradius=10;//Darstellung, Groessen in %
static int gedruecktemaustaste=0,shifttaste=0;

static Vektor3d kamera(0,0,-12), lookat(0,0,0), sky(0,1,0);
static double rotationswinkel=0, brennweite=20;
static int rotationsflag=0; //1=rotieren, 2=angehaltene Rotation

const int NELE=27*26;
typedef char STRING[80];

class Elemente
{
 double radius[NELE];
 STRING farbe[NELE];
 int ind(int c1,int c2=0)
  {if(c1<'A' || c1>'Z') return 0;
   if(c2==0) return 26*(c1-'A');
   if(c2<'a' || c2>'z') return 0;
   return 26*(c1-'A')+c2-'a'+1;
  }
public:
 Elemente()
  {int n;
   for(int i=0;i<27*26;i++) radius[i]=0;
   radius[n=ind('C')]=0.772; //Kohlenstoff Radius in Angstrom (0.1nm)
   strcpy(farbe[n],"Gray50"); //Farbe fuer Povray
   radius[n=ind('H')]=0.373; strcpy(farbe[n],"White"); //Wasserstoff
   radius[n=ind('B')]=0.795; strcpy(farbe[n],"Gray60"); //Bor
   radius[n=ind('N')]=0.549; strcpy(farbe[n],"Blue"); //Stickstoff
   radius[n=ind('O')]=0.604; strcpy(farbe[n],"Red"); //Sauerstoff
   radius[n=ind('F')]=0.709; strcpy(farbe[n],"rgb<0.8,1,0.5>"); //Fluor
   radius[n=ind('N','a')]=1.858; strcpy(farbe[n],"Gray40"); //Natrium
   radius[n=ind('C','l')]=0.994; strcpy(farbe[n],"Green"); //Chlor
   radius[n=ind('B','r')]=1.145; strcpy(farbe[n],"rgv<0.7,0.7,0>"); //Brom
   radius[n=ind('I')]=1.331; strcpy(farbe[n],"rgb<0.5,1,1>"); //Jod
   radius[n=ind('J')]=1.331; strcpy(farbe[n],"rgb<0.5,1,1>"); //Jod
   radius[n=ind('S')]=1.035; strcpy(farbe[n],"Yellow"); //Schwefel
   radius[n=ind('P')]=1.105; strcpy(farbe[n],"rgb<1,0,1>"); //Phosphor
  }
 double radi(int c1,int c2) {return radius[ind(c1,c2)];}
 char* farb(char *sym) {return farbe[ind(sym[0],sym[1])];}
};
static Elemente gelemente;

double atomradius(char *sym)
{
 return gelemente.radi(sym[0],sym[1]);
}

void povfarbe(char *farb,int* r,int* g,int* b)
{
 double xr,xg,xb;
 if(strncmp(farb,"rgb<",4)==0)
   {sscanf(&farb[4],"%lf,%lf,%lf",&xr,&xg,&xb);
    *r = int(xr*255+0.5);
    *g = int(xg*255+0.5);
    *b = int(xb*255+0.5);
    return;
   }
 char zeile[80],str[80],*name="colors.inc",*s;
 int c;
 if(strcmp(farb,"White")==0) {*r = *g = *b = 255; return;}
 if(strcmp(farb,"Black")==0) {*r = *g = *b = 0; return;}
 if(strcmp(farb,"Red")==0) {*r =255; *g = *b = 0; return;}
 if(strcmp(farb,"Green")==0) {*g =255; *r = *b = 0; return;}
 if(strcmp(farb,"Blue")==0) {*b =255; *g = *r = 0; return;}
 if(strcmp(farb,"Yellow")==0) {*r = *g = 255; *b = 0; return;}
 if(strcmp(farb,"Cyan")==0) {*r = 0; *g = *b = 255; return;}
 if(strcmp(farb,"Magenta")==0) {*g = 0; *r = *b = 255; return;}
 if(strcmp(farb,"Gray")==0) {*r = *g = *b = 192; return;}
 if(strncmp(farb,"Gray",4)==0)
   {sscanf(&farb[4],"%d",&c); c=256*c/100; if(c>255) c=255;
    *r = *g = *b = c; return;
   }
 FILE *fp=fopen(name,"r");
 if(fp==NULL)
   {printf("cant find '%s'\n",name);
    *r = *b = *g = 200;
   }
 while(getline(fp,zeile,80))
   if(strncmp(zeile,"#declare ",9)==0)
     {sscanf(&zeile[9],"%s",str);
      if(strcmp(str,farb)==0)
	{for(s=&zeile[9];(c= *s++) && c!='=';) ;
	 if(c!='=') {printf("syntaxerror in '%s'\n",name); continue;}
	 sscanf(s,"color red %lf green %lf blue %lf",&xr,&xg,&xb);
	 *r = int(xr*255+0.5);
	 *g = int(xg*255+0.5);
	 *b = int(xb*255+0.5);
	 fclose(fp);
	 return;
	}
     }
 fclose(fp);
}

class Atom
{
 int rr,gg,bb,rgbflag;
 void calcrgbfarbe()
  {if(rgbflag==0) {rgbflag=1; povfarbe(gelemente.farb(symbol),&rr,&gg,&bb);}}
public:
 Vektor3d pos;
 char symbol[4];
 double radius;
 int sel;
 Atom() {radius=0; symbol[0]=0; sel=0; rgbflag=0;}
 Atom(char *sym,double x,double y,double z)
  {strncpy(symbol,sym,3); symbol[3]=0; sel=0; rgbflag=0;
   pos=Vektor3d(x,y,z); radius=atomradius(symbol);}
 void zeichnen();
 void zeichnungloeschen(int farbe);
 void raytrace1(FILE *fp);
 void raytrace2(FILE *fp);
 void savexyz(FILE *fp);
 Atom& operator=(Atom z)
  {pos=z.pos; radius=z.radius; rgbflag=0;
   for(int i=0;i<4;i++) symbol[i]=z.symbol[i]; return *this;}
};

class Bindung
{
public:
 int a[2],n;
 //Bindung& operator=(Bindung& z) {a[0]=z.a[0]; a[1]=z.a[1]; n=z.n;}
};

class Molekuel
{
 int atomliste[120];
 Atom *atom;
 Bindung *bind;
 int na,maxa,nli,maxli,nb,maxb;
public:
 Molekuel() {atom=NULL; maxli=nli=maxa=na=maxb=nb=0;}
 ~Molekuel() {if(atom!=NULL) delete[] atom;}
 void put(char* sym,double x,double y,double z,int n= -1,int v=1);
 void putbindung(int a1,int a2,int v);
 void autoputbind();
 void zeichnen(int farbe=WEISS);
 void raytrace(char *dateiname);
 void savexyz(char *dateiname);
 void clear() {if(atom!=NULL) delete[] atom;
               atom=NULL; maxli=nli=maxa=na=maxb=nb=0;}
 Molekuel& operator=(Molekuel& z);
 void selectnext();
 void select(double x,double y);
 void selectall() {for(int i=0;i<na;i++) atom[i].sel=1;}
 void unselect() {for(int i=0;i<na;i++) atom[i].sel=0;}
 Atom getselectedatom(int* n);
 void replaceatom(int n,Atom a) {if(n>=0 && n<na) atom[n]=a;}
};
static Molekuel aktuellesmolekuel;

void Molekuel::autoputbind()
{
 const double min=1.5;
 for(int i=0;i<na-1;i++)
 for(int j=i+1;j<na;j++)
   {if(abs(atom[i].pos-atom[j].pos)<min) putbindung(i,j,1);
   }
}

Atom Molekuel::getselectedatom(int* n)
{
 int i= *n;
 if(i<0) i=0;
 for(;i<na;i++)
   if(atom[i].sel) {*n=i; return atom[i];}
 *n= -1;
 return atom[0];
}

void Molekuel::selectnext()
{
 int i;
 if(atom==NULL) return;
 if(shifttaste)
  {for(i=0;i<na && atom[i].sel==0;i++) ;
   if(i==na) {atom[0].sel=1; return;}
   for(;i<na && atom[i].sel==1;i++) ;
   if(i<na) atom[i].sel=1; else atom[0].sel=1;
  }
 else
  {for(i=0;i<na-1;i++)
     if(atom[i].sel) {atom[i].sel=0; atom[i+1].sel=1; return;}
   if(atom[na-1].sel) atom[na-1].sel=0;
   else atom[0].sel=1;
  }
}

void Molekuel::select(double x,double y)
{
 int i,ibest=0;
 double a,best;
 Vektor3d v(x,y,0);
 if(atom==NULL) return;
 if(!shifttaste) unselect();
 for(int i=0;i<na;i++)
   {a=abs(projektion(atom[i].pos)-v);
    if(i==0 || a<best) {best=a; ibest=i;}
   }
 atom[ibest].sel=1;
}

Molekuel& Molekuel::operator=(Molekuel& z)
{
 clear(); atom=new Atom[maxa=z.maxa]; na=z.na; for(int i=0;i<na;i++) atom[i]=z.atom[i];
 bind=new Bindung[maxb=z.maxb]; nb=z.nb; for(int i=0;i<nb;i++) bind[i]=z.bind[i];
 maxli=z.maxli; nli=z.nli; for(int i=0;i<nli;i++) atomliste[i]=z.atomliste[i];
 return *this;
}

void Molekuel::raytrace(char *dateiname) //erzeuge eine Datei fuer Povray
{
 int i;
 FILE *fp=fopen(dateiname,"w");
 if(fp==NULL) {printf("cant crate '%s'\n",dateiname); return;}
 fprintf(fp,"#include \"colors.inc\"\n");
 fprintf(fp,"camera {\n location <%lg, %lg, %lg>\n",kamera.x,kamera.y,kamera.z);
 //fprintf(fp," direction <0, 0, 2.3>\n"); //entweder direction oder look_at
 fprintf(fp," look_at <%lg, %lg, %lg>\n",lookat.x,lookat.y,lookat.z);
 if(sky.x!=0 || sky.z!=0 || sky.y<0)
   fprintf(fp," sky <%lg, %lg, %lg>\n",sky.x,sky.y,sky.z); //Oben fuer die Kamera
 fprintf(fp," angle %lg\n",2*atan2((gxmax-gxmin)/2,brennweite)/GRAD);
 fprintf(fp,"}\n\
light_source {<-10, 10, -5> color White}\n\
light_source {< 10, 5, -4> color Gray70}\n\
light_source {<0, 0, -10> color Gray50}\n");
//background {color rgb<0.5, 0.5, 1>}\n\n",higrund_r,higrund_g,higrund_b);
 fprintf(fp,"background {color rgb<%lg, %lg, %lg>}\n\n",
	 higrund_r/255.0,higrund_g/255.0,higrund_b/255.0);
 for(i=0;i<nli;i++) atom[atomliste[i]].raytrace1(fp);
 if(nb>0) fprintf(fp,"#declare bindradius=%lf;\n",1.0*gbindradius/100);
 for(i=0;i<nb;i++)
   {Vektor3d p1,p2;
    p1=atom[bind[i].a[0]].pos;
    p2=atom[bind[i].a[1]].pos;
    fprintf(fp,"//bond %d %d %d\n",bind[i].a[0],bind[i].a[1],bind[i].n);
    fprintf(fp,"cylinder {\n <%lg,%lg,%lg>,<%lg,%lg,%lg>, bindradius\n",
	    p1.x,p1.y,p1.z, p2.x,p2.y,p2.z);
    fprintf(fp," texture{pigment{color Plum} finish {phong 0.5}}\n}\n");//provi.
   }
 for(i=0;i<na;i++) atom[i].raytrace2(fp);
 fclose(fp);
}
void Atom::raytrace1(FILE *fp)
{
 fprintf(fp,"#declare %sradius=%lf;\n",symbol,radius*gatomradius/100);
}
void Atom::raytrace2(FILE *fp)
{
 fprintf(fp,"sphere {\n");
 fprintf(fp," <%lg, %lg, %lg>, %sradius\n",pos.x,pos.y,pos.z,symbol);
 fprintf(fp," pigment {%s}\n",gelemente.farb(symbol));
 fprintf(fp," finish {phong 0.5}\n");
 fprintf(fp,"}\n");
}

void Molekuel::savexyz(char *dateiname) //erzeuge eine xyz-Datei
{
 int i;
 FILE *fp=fopen(dateiname,"w");
 if(fp==NULL) {printf("cant crate '%s'\n",dateiname); return;}
 fprintf(fp,"%d  %d\n",na,nb);
 for(i=0;i<na;i++) atom[i].savexyz(fp);
 for(i=0;i<nb;i++) fprintf(fp,"%d %d\n",bind[i].a[0],bind[i].a[1]);
 fclose(fp);
}
void Atom::savexyz(FILE *fp)
{
 fprintf(fp," %-2s %12.6lf %12.6lf %12.6lf\n",symbol,pos.x,pos.y,pos.z);
}

void Molekuel::put(char* sym,double x,double y,double z,int a2,int v)
{
 if(na==maxa)
   {if(maxa==0) {atom=new Atom[maxa=20];}
    else
      {Atom *neu;
       neu=new Atom[maxa=2*maxa];
       for(int i=0;i<na;i++) neu[i]=atom[i];
       delete[] atom;
       atom=neu;
      }
   }
 atom[na]=Atom(sym,x,y,z);
 int i;
 for(i=0;i<nli;i++)
   {if(strcmp(atom[atomliste[i]].symbol,sym)==0) break;}
 if(i==nli) atomliste[nli++]=na;
 if(a2>=0) putbindung(na,a2,v);
 na++;
}
void Molekuel::putbindung(int a1,int a2,int v)
{
 if(nb==maxb)
   {if(maxb==0) {bind=new Bindung[maxb=20];}
    else
      {Bindung *neu;
       neu=new Bindung[maxb=2*maxb];
       for(int i=0;i<nb;i++) neu[i]=bind[i];
       delete[] bind;
       bind=neu;
      }
   }
 bind[nb].a[0]=a1; bind[nb].a[1]=a2; bind[nb].n=v;
 nb++;
}


/********************** weiterer Kleinkram ****************************/
void bildformat(int b,int h)
{
 double dx,dy=gymax-gymin,xmitte=(gxmin+gxmax)/2;
 dx=dy/h*b;
 gxmin=xmitte-dx/2; gxmax=gxmin+dx;
 term_refresh();
 inital_new(gxmin,gymin,gxmax,gymax);
 m_refresh();
}

/****************** Zeichnen in 3D-Darstellung ************************/
void rgbscreenclear(int r,int g,int b)
{
 hintergrundfarbe=(r<<16)+(g<<8)+b;
 screenclear(hintergrundfarbe);
}

Vektor3d projektion(Vektor3d p,double* f)
{
 /* Vektor auf Bildschirmebene Projezieren:
    Bildschirmebene ist x-y-System mit Nullpunkt in der Mitte,
    die z-Achse zeigt vom Betrachter weg.
    Fuer Punkte auf dem Bildschirm ist z also 0.
 */
 Vektor3d q,k,s;
 double alfa,beta,gamma,z;
 bool sflag=(sky.x!=0 || sky.z!=0 || sky.y<0);
 k=kamera-lookat; z=abs(k);
 if(sflag) s=k+sky;
 //Koordinatensystem in Lookat-Punkt Verschieben:
 q=p-lookat;
 //Drehung so dass Kamera auf y-z-Ebene zu liegen kommt:
 alfa=PI/2+atan2(k.z,k.x);
 if(rotationsflag) alfa+=rotationswinkel;
 q.drehenzx(alfa);
 //Drehung so dass Kamera auf negative z-Achse zu liegen kommt:
 beta=atan2(k.y,sqrt(z*z-k.y*k.y));
 q.drehenzy(beta);
 //Schieben so dass Koordinatenursprung auf Brennweite zu liegen kommt:
 q.z += z-brennweite;
 if(sflag)
   {s.drehenzx(alfa);
    s.drehenzy(beta);
    //Kamera kippen bis Sky-Vektor auf y-z-Ebene liegt:
    gamma=atan2(s.x,s.y); q.drehenxy(gamma);
   }
 //Strahlensatz um Punkt auf Bildschirm abzubilden:
 *f=brennweite/(q.z+brennweite);
 q.x *= *f;
 q.y *= *f;
 q.z=0;
 return q;
}

void liniezeichnen(Vektor3d v1,Vektor3d v2)
{
 Vektor3d p;
 p=projektion(v1); plot(p.x,p.y,PENUP);
 p=projektion(v2); plot(p.x,p.y,PENDOWN);
}

void Atom::zeichnen()
{
 double f;
 Vektor3d p=projektion(pos,&f);
 double r=radius*gatomradius/100*f,dr=(gymax-gymin)/400;
 calcrgbfarbe(); rgbcolor(rr,gg,bb);
 if(vollmodus)
   {fillcircle(p.x,p.y,r,r);
    if(sel)
      {r-=dr; color(SCHWARZ); drawcircle(p.x,p.y,r,r);
       r-=dr; color(WEISS); drawcircle(p.x,p.y,r,r);
      }
   }
 else
   {drawcircle(p.x,p.y,r,r);
    if(sel) {r-=dr; drawcircle(p.x,p.y,r,r);}
   }
}

void Atom::zeichnungloeschen(int farbe)
{
 double f;
 Vektor3d p=projektion(pos,&f);
 double r=radius*gatomradius/100*f;
 color(farbe);
 if(vollmodus) fillcircle(p.x,p.y,r,r);
 else
   {drawcircle(p.x,p.y,r,r);
    if(sel) {r-=(gymax-gymin)/400; drawcircle(p.x,p.y,r,r);}
   }
}

void Molekuel::zeichnen(int farbe)
{
 int i,j;
 color(farbe);
 for(i=0;i<nb;i++)
   {liniezeichnen(atom[bind[i].a[0]].pos,atom[bind[i].a[1]].pos);
    //provi. Doppel- und Dreifachbindung anders zeichnen
    //if(bind[i].n>1) ...
   }
 if(farbe==WEISS)
   for(i=0;i<na;i++) atom[i].zeichnen();
 else
   for(i=0;i<na;i++) atom[i].zeichnungloeschen(farbe);
}

/************************* Menu Behandlung ****************************/
static int exitflag=0;
void menu_exit() {exitflag=1;}
void m_hilfe()
{
 char text[]=
"  Hilfe zu Molz3D\n\
  ================\n\
\n\
Tastenbelegung:\n\
---------------\n\
Taste  Funktion\n\
n      Naechstes Atom selektieren (wie Menu Select-Next)\n\
N      Mehrere Atome selektieren\n\
Shift  (oder CapsLock) Mehrere Atome mit Maus selektieren\n\
q      Selektierung aufheben\n\
y      Bild neu zeichnen (wie Menu Refresh)\n\
r      Rotierende Darstellung stoppen/fortfahren\n\
\n";
 janeinrequester(text);
}
void m_beisp1()
{
 Molekuel methan;
 methan.put("C", 0, 0, 0);
 methan.put("H", 1.07, 0.0, 0.0, 0);
 methan.put("H",-0.34736, 0, -1.0117, 0);
 methan.put("H",-0.36082, 0.8711, 0.50585, 0);
 methan.put("H",-0.36082,-0.8711, 0.50585, 0);
 methan.zeichnen();
 aktuellesmolekuel=methan;
 m_refresh();
}
void m_beisp2()
{
 Molekuel ethan;
 ethan.put("C", 0, 0, 0);
 ethan.put("C", 1.07, 0.0, 0.0, 0);
 ethan.put("Cl",-0.34736, 0, -1.0117, 0);
 ethan.put("F",-0.36082, 0.8711, 0.50585, 0);
 ethan.put("I",-0.36082,-0.8711, 0.50585, 0);
 ethan.put("S", 1.41736, 0, -1.0117, 1);
 ethan.put("P", 1.43082, 0.8711, 0.50585, 1);
 ethan.put("O", 1.43082,-0.8711, 0.50585, 1);
 ethan.put("H", 2.50082,-0.8711, 0.50585, 7);
 aktuellesmolekuel=ethan;
 m_refresh();
}

//Menu File:
void m_load()
{
 int ok;
 static char name[200]="test1.pov",filter[80]="*.pov";
 ok=nachfilenamefragen("Lade Molekueldatei",name,200,0,filter);
 if(ok) dateiladen(name);
}
void m_save()
{
 int ok;
 static char name[200]="test.pov",filter[80]="*.pov";
 ok=nachfilenamefragen("Speichere Molekueldatei",name,200,0,filter);
 if(ok) aktuellesmolekuel.raytrace(name);
}
void m_loadxyz()
{
 int ok;
 static char name[200]="test1.xyz",filter[80]="*.xyz";
 ok=nachfilenamefragen("Lade Molekueldatei",name,200,0,filter);
 if(ok) dateiladen(name);
}
void m_savexyz()
{
 int ok;
 static char name[200]="test.xyz",filter[80]="*.xyz";
 ok=nachfilenamefragen("Speichere Molekueldatei",name,200,0,filter);
 if(ok) aktuellesmolekuel.savexyz(name);
}

//Menu Darstellung:
void m_param()
{
 int ok,n1,n2,m1,m2;
 char vollfarbig[80],format[80];
 strcpy(vollfarbig,(vollmodus)?"ja":"nein");
 n2=9; n1=int((gxmax-gxmin)/(gymax-gymin)*n2+0.5);
 if(n1%3==0) {n1/=3; n2=3;}
 sprintf(format,"%d:%d",n1,n2);
 ok=requester_input(5,"Hintergrundfarbe","%06X","%X",&hintergrundfarbe,
		    " Bildformat ","%s","%s\n",format,
		    "Atome Vollfarbig","%s","%s\n",vollfarbig,
		    "  Atomradius in %  ","%d","%d",&gatomradius,
		      "Bindungsradius in %","%d","%d\n",&gbindradius);
 if(ok)
   {vollmodus = (vollfarbig[0]=='n' || vollfarbig[0]=='N') ? 0 : 1;
    sscanf(format,"%d:%d",&m1,&m2);
    if(m1!=n1 || m2!=n2) bildformat(m1,m2);
   }
 m_refresh();
}
void m_kamera()
{
 int ok;
 ok=requester_input(10,"Kamera x","%lf","%lf",&kamera.x,
		    "Kamera y","%lf","%lf",&kamera.y,
		    "Kamera z","%lf","%lf\n",&kamera.z,
		    "Lookat x","%lf","%lf",&lookat.x,
		    "Lookat y","%lf","%lf",&lookat.y,
		    "Lookat z","%lf","%lf\n",&lookat.z,
		    " Oben x ","%lf","%lf",&sky.x,
		    " Oben y ","%lf","%lf",&sky.y,
		    " Oben z ","%lf","%lf\n",&sky.z,
		    "Brennweite","%lf","%lf",&brennweite);
 if(ok) m_refresh();
}
void m_rotieren()
{
 switch(rotationsflag)
   {case 1: rotationsflag=0; rotationswinkel=0; changebuffer(0,0); m_refresh();
    CASE 0: case 2: rotationsflag=1; changebuffer(0,1);
   }
}
void m_refresh()
{
 screenclear(hintergrundfarbe);
 aktuellesmolekuel.zeichnen();
}

//Menu Edit:
void m_selnext()
{
 aktuellesmolekuel.selectnext();
 m_refresh();
}
void m_selall()
{
 aktuellesmolekuel.selectall();
 m_refresh();
}
void m_edit()
{
 Atom atom;
 int i,na,nr,ok;
 char symbol[80];
 for(na=0;;na++)
   {atom=aktuellesmolekuel.getselectedatom(&na);
    if(na<0) break;
    nr=na; strcpy(symbol,atom.symbol);
    ok=requester_input(5,"  Atom  ","%s","%s",symbol,
		       " Nr (nicht aenderbar)","%d","%d\n",&nr,
		      " Position-x ","%lf","%lf",&atom.pos.x,
		      " Position-y ","%lf","%lf",&atom.pos.y,
		      " Position-z ","%lf","%lf",&atom.pos.z);
    if(ok)
      {symbol[2]=0; strcpy(atom.symbol,symbol);
       atom.radius=atomradius(atom.symbol);
       aktuellesmolekuel.replaceatom(na,atom);
      }
   }
}
void m_search()
{
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char quellname[80],zielname[80];
 quellname[0]=zielname[0]=0;
 FILE *fp1,*fp2;
 int i,j,c,visklasse;
 if(argc<=0)
   ;/* es wurde von WorkBench gestartet */
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
		 else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("molz3d  %s\n",VERSION);
	 printf("Anwendung: molz3d -flags [Quelle] [Ziel]\n");
	 printf("  Flags: v=verbose (Testausdrucke)\n");
	 exit(0);
	}
 //tek_setdebug(1);//test
 getmaxsize(&gbreite,&ghoehe,&gtiefe,&visklasse);
 if(gtiefe>TIEFE) gtiefe=TIEFE;
 setsize(gbreite,ghoehe,gtiefe);
 setmenu(4,"File",   "Edit",       "Darstellung", "Hilfe");
 setmenu(4,"Load...","%AN Select Next","Parameter...","Hilfe",
	 &m_load,&m_selnext,&m_param,&m_hilfe);
 setmenu(4,"Save...","Select All","Kamera...","Beispiel1",
	 &m_save,&m_selall,&m_kamera,&m_beisp1);
 setmenu(4,"Load xyz...","Edit Atom...","Rotieren ein/aus","Beispiel2",
	 &m_loadxyz,&m_edit,&m_rotieren,&m_beisp2);
 setmenu(3,"Save xyz...","Search...","%AY Refresh",
	 &m_savexyz,&m_search,&m_refresh);
 setmenu(1,"Exit",&menu_exit);
 set_funktions(mauspre,mausrel,NULL,mausmot);
 inital(gxmin,gymin,gxmax,gymax); /* Grafikfenster oeffnen */
 term_refresh();
 inital_new();
 waitBOF();//provi. (offenbar Fehler im xtekplot)
 rgbscreenclear(higrund_r,higrund_g,higrund_b);
 int taste,asci; ULONG rawcode;
 //Hauptschlaufe:
 while(exitflag==0 && waitmenu(0)==0)
  {waitBOF();		//auf Ende des Bildaufbaus warten
   if(keyget(&taste,&asci,&rawcode)!=0)
     {switch(rawcode)
	{case 0xFF51: case 0xFF52: case 0xFF53: case 0xFF54://Pfeiltasten
			;//Molekuel verschieben ??
	 //CASE 0xFF1B: case 0xFFE3: //Esc oder Ctrl
	 CASE 0xFFFF: case 0xFF60: case 0xFF08://Delete oder Backspace
			;//Atom loeschen ??
	 CASE 0xFFE1: case 0xFFE2://Shifttaste
			shifttaste ^= 1; //zum mehrere Atome selektieren
	 CASE 0xFFE5://CapsLock
			shifttaste = 1; //zum mehrere Atome selektieren
	 CASE 0xFF55: //Page Up
	 CASE 0xFF56: //Page Down
	 CASE 'y': shifttaste=0; case 'Y': m_refresh();
	 CASE 'n': shifttaste=0; m_selnext();
	 CASE 'N': shifttaste=1; m_selnext();
	 CASE 'q': shifttaste=0; case 'Q': aktuellesmolekuel.unselect(); m_refresh();
	 CASE 'r': shifttaste=0; case 'R':
	       switch(rotationsflag)
		 {case 0: case 2: rotationsflag=1; changebuffer(0,1);
		  CASE 1: rotationsflag=2; changebuffer(0,0); m_refresh();
		 } 
	 DEFAULT:
	   shifttaste=0; 
	   if(test) printf("taste=%d=%02X asci=0x%02X='%c' rawcode=0x%04X\n",
			    taste,taste,asci,asci,rawcode);
	}
     }
   else if(rotationsflag==1)
     {//Darstellung automatisch rotieren
      aktuellesmolekuel.zeichnen(hintergrundfarbe);
      rotationswinkel += 1*GRAD;
      if(rotationswinkel>=2*PI) rotationswinkel -= 2*PI;
      aktuellesmolekuel.zeichnen();
      changebuffer(0,1);
     }
  }
 term_exit();
 return 0;
}/* ende von main */

void dateiladen(char *name)
{
 char zeile[80],atomname[80],sym[4],*s;
 int c,c1,c2;
 double x,y,z;
 FILE *fp=fopen(name,"r");
 if(fp==NULL) {printf("Datei '%s' nicht gefunden.\n",name); return;}
 aktuellesmolekuel.clear();
 if(istendung(name,".pov"))
 {int nbindungen=0,n1,n2,nb;
  while(getline(fp,zeile,80))
   {if(strncmp(zeile,"sphere {",8)==0)
      {getline(fp,zeile,80);
       for(s=zeile;(c= *s++)!='<' && c!=0;) ;
       sscanf(s,"%lf,%lf,%lf>,%s",&x,&y,&z,atomname);
       c1=atomname[0]; c2=0;
       if(strcmp(&atomname[2],"radius")==0) c2=atomname[1];
       else if(strcmp(&atomname[1],"radius")==0)
	 {sym[0]=c1; sym[1]=c2; sym[2]=0;
	  aktuellesmolekuel.put(sym,x,y,z);
	 }
       else printf("Fehler: x=%lf y=%lf z=%lf zeile='%s' atomname='%s'\n",
		   x,y,z,zeile,atomname);//test
      }
    else if(strncmp(zeile,"//bond",6)==0)
      {//z.B. "//bond 0 1 2" waere eine Doppelbindung zw. Atom0 und Atom1
       sscanf(&zeile[6],"%d %d %d",&n1,&n2,&nb); if(nb==0) nb=1;
       aktuellesmolekuel.putbindung(n1,n2,nb);
      }
    else if(strncmp(zeile,"camera {",8)==0)
      {while(getline(fp,zeile,80) && *zeile!='}')
	{for(s=zeile;(c= *s)!=0 && isspace(c);s++) ;
	 if(strncmp(s,"location",8)==0) vektoreinlesen(&s[8],kamera);
	 else if(strncmp(s,"look_at",7)==0) vektoreinlesen(&s[7],lookat);
	 else if(strncmp(s,"sky",3)==0) vektoreinlesen(&s[3],sky);
	 else if(strncmp(s,"angle",5)==0)
	   {double angle; sscanf(&s[5],"%lf",&angle);
	    brennweite=(gxmax-gxmin)/2/tan(angle*GRAD/2);
	   }
	}
      }
   }
  if(nbindungen==0)
    aktuellesmolekuel.autoputbind();
 }
 else if(istendung(name,".xyz"))
 {int natome=0,nbindungen=0,n1,n2;
  fscanf(fp,"%d %d",&natome,&nbindungen);
  if(natome<1 || natome>10000)
    printf("Fehler: in xyz-Datei fehlende Anzahl Atome. (%d)\n",natome);
  else
   {for(int i=0;i<natome;i++)
      {fscanf(fp,"%s %lf %lf %lf",atomname,&x,&y,&z);
       c1=atomname[0]; c2=atomname[1];
       sym[0]=c1; sym[1]=c2; sym[2]=0;
       aktuellesmolekuel.put(sym,x,y,z);
      }
    if(nbindungen==0)
      aktuellesmolekuel.autoputbind();
    else
      for(int i=0;i<nbindungen;i++)
	{fscanf(fp,"%d %d",&n1,&n2);
	 if(n1<0 || n2<0 || n1>=natome || n2>=natome)
	   printf("Syntax-Fehler in '%s'\n",name);
	 else aktuellesmolekuel.putbindung(n1,n2,1);
	}
   }
 }
 else printf("Bisher nur .pov und .xyz Dateien lesbar.\n");
 fclose(fp);
 m_refresh();
}

void mausbewegung(int flag)
{
 double x,y;
 int ix,iy,tasten;
 tasten=mausposition(&x,&y);
 if(flag==1) //Maustaste gedrueckt
   {
    if(test) printf("Maustaste gedrueckt Position = %lf %lf\n",x,y);//test
    aktuellesmolekuel.select(x,y);
    gedruecktemaustaste=1;
    m_refresh();
   }
 else if(flag==2) //Maustaste losgelassen
   {
    if(test) printf("Maustaste losgelassen Position=%lf %lf\n",x,y);//test

    gedruecktemaustaste=0;
   }
 else if(flag==3) //Mausbewegung mit gedrueckter Maustaste
   {
   }
}

void mauspre() {mausbewegung(1);}
void mausrel() {mausbewegung(2);}
void mausmot() {if(gedruecktemaustaste) mausbewegung(3);}
