/* molz3d.cc			letzte Aenderung: 3.5.2007 */
#define VERSION "Version 0.9"
/*
 Molekuele Zeichnen in 3D-Darstellung

History:
3.4.2007	Erstellung (RP)
11.4.07   0.1	Korrekte Verdeckung: Sortieren nach Abstand
13.4.07   0.2   Diederwinkel-Drehungen
14.4.07   0.3   Farben auch bei kleinerer Farbtiefe
17.4.07   0.4   Methyl anfuegen
18.4.07   0.5   Mitdrehen des Rests bei Winkelaenderungen,
                automatische Bindungslaengen setzen
20.4.07   0.6   noch ein paar kleine Fehler behoben
23.4.07   0.7   Rotationsrichtung aenderbar
                Diederwinkel interaktiv verstellen
27.4.07   0.8   In Peptidkette alle Winkel simultan einstellen
3.5.07    0.9   Stereobilder
*/

//#define MACOSX

#include <iostream>
using namespace std;
#include <stdlib.h>
#include <xtekplot1.h>
//#include "matrixklasse.h"
#include "vektor3dklasse.cc"

#define XMAX 1280
#define YMAX 1024
#define TIEFE 24
static int WEISS=0xFFFFFF,FASTWEISS=0xFEFEFE,SCHWARZ=0,GRAU=0x808080;

/************************* Vordeklarationen ***************************/
void dateiladen(char *name,int anfuegflag=0);
void mauspre();
void mausrel();
void mausmot();
void m_refresh();
void m_refresh2() {waitBOF(); m_refresh();}
Vektor3d projektion(Vektor3d p,double* f);
inline Vektor3d projektion(Vektor3d p) {double f; return projektion(p,&f);}
void rgbcolor2(int r,int g,int b);
void elemente_init();
int pernr(char *sy);//Periodensystemnummer

/**************************** kleinkram *******************************/
inline bool istja(char *s) {return (*s!='n' && *s!='N');}
inline bool istnein(char *s) {return (*s=='n' || *s=='N');}

//Je nach Betriebssystem muss man folgende Zeilen auskommentieren oder nicht:
#ifdef MACOSX
inline double abs(double x) {return (x<0.) ? -x : x;}	/* Betrag */
#endif

int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

int istendung(char *str,char *endung)
{
 int c,n=strlen(endung),c1= *endung++;
 for(;;)
 {while((c= *str++)!=c1) if(c==0) return 0;
  if(strcmp(str,endung)==0) return 1;
 }
 return 0;
}

/* int fscanfvekt(FILE *fp,Vektor3d* v)
{
 int c,n;
 while((c=getc(fp)) && c!='<' && c!='.' && !isdigit(c))
   if(c==EOF) return 0;
 if(c=='<')
   n=fscanf(fp,"%lf,%lf,%lf",&v->x,&v->y,&v->z);
 else
   {ungetc(c,fp);
    n=fscanf(fp,"%lf",&v->x);
    if(n==1) v->y=v->z=v->x;
   }
 printf("fscanfvekt() --> n=%d v=<%lg, %lg, %lg>\n",n,v->x,v->y,v->z);//test
 return n;
}*/

void vektoreinlesen(char *s,Vektor3d& v)
{
 int c;
 for(;(c= *s++)!='<' && c!=0;) ;
 sscanf(s,"%lf,%lf,%lf",&v.x,&v.y,&v.z);
}

void linie(int r,int g,int b,double x0,double y0,double x1,double y1)
{
 double x[2],y[2];
 rgbcolor2(r,g,b);
 x[0]=x0; x[1]=x1; y[0]=y0; y[1]=y1;
 tek_line(2,x,y);
}

bool fastgleich(double d,double x1,double x2)
{
 double z=x1-x2;
 return (z<d  &&  z > -d);
}

int mysscanf(char *s,char *cstr,double *p1,double *p2,double *p3)
{
 //Beispiel: cstr="color red %lf green %lf blue %lf"
 int i,c,n=0;
 double x[3];
 while(*s!=0 && *cstr!=0 && n<3)
   {while(*cstr==' ') cstr++;
    while(*s==' ') s++;
    while((c= *cstr)!='%' && c!=0 && *s==c) {cstr++; s++;}
    if(strncmp(cstr,"%lf",3)==0)
      {sscanf(s,"%lf",&x[n++]);
       while((c= *s++)!=0 && (isdigit(c) || c=='.')) ;
       cstr+=3; c= *cstr;
      }
   }
 i=0;
 if(i<n) *p1=x[i++];
 if(i<n) *p2=x[i++];
 if(i<n) *p3=x[i++];
 return n;
}

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
static int test=0; //Testausdrucke (0=ohne 1=mit 2=noch mehr)
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
   if(c=='V') test++;
  }
}

/****************** Klassen und Globale Variablen *********************/
/** einfache globale Variablen: **/
static int gbreite,ghoehe,gtiefe;//Grafikfenster
static double gxmin= -13.3, gymin= -10.0, gxmax=13.3, gymax=10.0;
static double gdx=0;//Breite des Randbereichs
static int hintergrundfarbe;//24-Bit-Farbe fuer Hintergrund
static int hintergrundfarbnr;//Farbnummer fuer Hintergrund
static int higrund_r=0x80,higrund_g=0x80,higrund_b=0xFF;//rgb-HintergrundFarbe
static int vollmodus=1;//1=Atome ausgefuellt zeichnen, 0=nur Kreis zeichnen
static int gatomradius=50,gbindradius=10;//Darstellung, Groessen in %
static int gedruecktemaustaste=0,shifttaste=0;
static int winkelmessung=0;
static int diederinteraktiv=0;//1=Start, 2=erster Klick, 3=nach zweitem Klick
static Vektor3d kamera(0,0,-12), lookat(0,0,0), sky(0,1,0);
static double rotationswinkel=0, brennweite=20;
static int rotationsflag=0; //1=rotieren, 2=angehaltene Rotation
static int rotationsrichtung=0;
static int nochnichtgespeichert=0;
static double stereox0=20; //Abstand fuer Stereobilder
static int stereoflag=0; //Beleuchtung fuer Stereobilder anders

const int NELE=27*26;
typedef char STRING[80];

class Elemente
{
 double radius[NELE];
 STRING farbe[NELE];
 int ind(int c1,int c2=0)
  {if(c1<'A' || c1>'Z') return 0;
   if(c2==0) return 26*(c1-'A');
   if(c2<'a' || c2>'z') return 0;
   return 26*(c1-'A')+c2-'a'+1;
  }
public:
 Elemente()
  {int n;
   elemente_init();
   for(int i=0;i<NELE;i++) {radius[i]=1.0; strcpy(farbe[i],"Plum");}
   radius[n=ind('C')]=0.772; //Kohlenstoff Radius in Angstrom (0.1nm)
   strcpy(farbe[n],"Gray50"); //Farbe fuer Povray
   radius[n=ind('H')]=0.373; strcpy(farbe[n],"White"); //Wasserstoff
   radius[n=ind('B')]=0.795; strcpy(farbe[n],"Gray60"); //Bor
   radius[n=ind('N')]=0.549; strcpy(farbe[n],"Blue"); //Stickstoff
   radius[n=ind('O')]=0.604; strcpy(farbe[n],"Red"); //Sauerstoff
   radius[n=ind('F')]=0.709; strcpy(farbe[n],"rgb<0.8,1,0.5>"); //Fluor
   radius[n=ind('N','a')]=1.858; strcpy(farbe[n],"Gray40"); //Natrium
   radius[n=ind('C','l')]=0.994; strcpy(farbe[n],"Green"); //Chlor
   radius[n=ind('B','r')]=1.145; strcpy(farbe[n],"rgv<0.7,0.7,0>"); //Brom
   radius[n=ind('I')]=1.331; strcpy(farbe[n],"rgb<0.5,1,1>"); //Jod
   radius[n=ind('J')]=1.331; strcpy(farbe[n],"rgb<0.5,1,1>"); //Jod
   radius[n=ind('S')]=1.035; strcpy(farbe[n],"Yellow"); //Schwefel
   radius[n=ind('P')]=1.105; strcpy(farbe[n],"rgb<1,0,1>"); //Phosphor
  }
 double radi(int c1,int c2) {return radius[ind(c1,c2)];}
 char* farb(char *sym) {return farbe[ind(sym[0],sym[1])];}
};
static Elemente gelemente;

double atomradius(char *sym)
{
 return gelemente.radi(sym[0],sym[1]);
}

void povfarbe(char *farb,int* r,int* g,int* b)
{
 double xr,xg,xb;
 int c;
 if(strncmp(farb,"rgb<",4)==0)
   {sscanf(&farb[4],"%lf,%lf,%lf",&xr,&xg,&xb);
    *r = int(xr*255+0.5);
    *g = int(xg*255+0.5);
    *b = int(xb*255+0.5);
    return;
   }
 if(strcmp(farb,"White")==0) {*r = *g = *b = 255; return;}
 if(strcmp(farb,"Black")==0) {*r = *g = *b = 0; return;}
 if(strcmp(farb,"Red")==0) {*r =255; *g = *b = 0; return;}
 if(strcmp(farb,"Green")==0) {*g =255; *r = *b = 0; return;}
 if(strcmp(farb,"Blue")==0) {*b =255; *g = *r = 0; return;}
 if(strcmp(farb,"Yellow")==0) {*r = *g = 255; *b = 0; return;}
 if(strcmp(farb,"Cyan")==0) {*r = 0; *g = *b = 255; return;}
 if(strcmp(farb,"Magenta")==0) {*g = 0; *r = *b = 255; return;}
 if(strcmp(farb,"Gray")==0) {*r = *g = *b = 192; return;}
 if(strncmp(farb,"Gray",4)==0)
   {sscanf(&farb[4],"%d",&c); c=256*c/100; if(c>255) c=255;
    *r = *g = *b = c; return;
   }
 char zeile[80],str[80],*name="colors.inc",*s;
 FILE *fp=fopen(name,"r");
 if(fp==NULL)
  {sprintf(str,"%s/.molz3d/colors.inc",getenv("HOME"));
   if((fp=fopen(str,"r"))==NULL)
   {static int warnflag=1;
    if(warnflag)
      {printf("cant find '%s'. Using color Gray50\n",name); warnflag=0;}
    *r = *b = *g = 128;
   }}
 if(fp!=NULL)
 {while(getline(fp,zeile,80))
   if(strncmp(zeile,"#declare ",9)==0)
     {sscanf(&zeile[9],"%s",str);
      if(strcmp(str,farb)==0)
	{for(s=&zeile[9];(c= *s++) && c!='=';) ;
	 if(c!='=') {printf("syntaxerror in '%s'\n",name); continue;}
	 mysscanf(s,"color red %lf green %lf blue %lf",&xr,&xg,&xb);
	 if(test) printf("%s = <%lf, %lf, %lf>\n",farb,xr,xg,xb);//test
	 *r = int(xr*255+0.5);
	 *g = int(xg*255+0.5);
	 *b = int(xb*255+0.5);
	 fclose(fp);
	 return;
	}
     }
  fclose(fp);
 }
}

class Atom
{
 int rr,gg,bb,rgbflag,vorflag;
 Vektor3d pvor;//vorberechneter Punkt zum Zeichnen
 double fvor;//vorberechneter Faktor
 void calcrgbfarbe()
  {if(rgbflag==0) {rgbflag=1; povfarbe(gelemente.farb(symbol),&rr,&gg,&bb);}}
public:
 Vektor3d pos;
 char symbol[4];
 double radius;
 int sel;
 Atom() {radius=0; symbol[0]=0; sel=0; rgbflag=vorflag=0;}
 Atom(char *sym,double x,double y,double z)
  {strncpy(symbol,sym,3); symbol[3]=0; sel=0; rgbflag=vorflag=0;
   pos=Vektor3d(x,y,z); radius=atomradius(symbol);}
 bool istleer() {return radius==0;}
 double zeichnenvorberechnen();
 void zeichnen(int hell=100); //Default ist 100% Helligkeit
 void zeichnungloeschen(int farbe);
 void raytrace1(FILE *fp);
 void raytrace2(FILE *fp);
 void savexyz(FILE *fp);
 Atom& operator=(Atom z)
  {pos=z.pos; radius=z.radius; rgbflag=0;
   for(int i=0;i<4;i++) symbol[i]=z.symbol[i]; return *this;}
 bool operator==(char *s) {return strcmp(symbol,s)==0;}
};

class Bindung
{
public:
 int a[2],n;
 //Bindung& operator=(Bindung& z) {a[0]=z.a[0]; a[1]=z.a[1]; n=z.n;}
};

class Molekuel
{
 Atom *atom;
 Bindung *bind;
 int na,maxa,nb,maxb;
 int selliste[4];//Liste der ersten 4 selektierten Atome
 int nsel;//Anzahl selektierte Atome in der Liste
 int selpush(int i) {if(nsel<4) selliste[nsel++]=i; return i;}
 int selpop(int i) {if(nsel>0 && selliste[nsel-1]==i) --nsel; return i;}
public:
 Molekuel() {atom=NULL; maxa=na=maxb=nb=nsel=0;}
 ~Molekuel() {if(atom!=NULL) delete[] atom;}
 int put(char* sym,double x,double y,double z,int n= -1,int v=1);
 void putbindung(int a1,int a2,int v);
 void putbindung2(int a1,int a2);
 void replacebindung(int a1,int a2,int v);
 void autoputbind();
 void delbindung(int a1,int a2);
 int getbindung(int a1,int a2);
 Vektor3d getatompos(int i) {return atom[i].pos;}
 int bonds2atom(int a1);//Anzahl verbundene Atome zu diesem Atom
 void zeichnen(int farbe=WEISS);
 void raytrace(char *dateiname);
 void savexyz(char *dateiname);
 void clear() {if(atom!=NULL) delete[] atom;
               atom=NULL; maxa=na=maxb=nb=nsel=0;}
 bool istleer() {return na==0;}
 Molekuel& operator=(Molekuel& z);
 void selectnext();
 void select(double x,double y);
 void selectall() {nsel=0; for(int i=0;i<na;i++) atom[selpush(i)].sel=1;}
 void unselect() {nsel=0; for(int i=0;i<na;i++) atom[i].sel=0;}
 Atom getselectedatom(int* n);
 Atom getsel(int n) {Atom a; return (n>=nsel || n<0)?a:atom[selliste[n]];}
 Atom getsel(int n,int *j)
    {Atom a; return (n>=nsel || n<0)?a:atom[*j=selliste[n]];}
 int getnsel() {return nsel;}
 void replaceatom(int n,Atom a) {if(n>=0 && n<na) atom[n]=a;}
 void drehenyz(double w) //Drehen um x-Achse von y- Richtung z-Achse
    {for(int i=0;i<na;i++) atom[i].pos.drehenyz(w);}
 void drehenzy(double w)
    {for(int i=0;i<na;i++) atom[i].pos.drehenzy(w);}
 void drehenxz(double w) //Drehen um y-Achse von x- Richtung z-Achse
    {for(int i=0;i<na;i++) atom[i].pos.drehenxz(w);}
 void drehenzx(double w)
    {for(int i=0;i<na;i++) atom[i].pos.drehenzx(w);}
 void drehenyx(double w) //Drehen um z-Achse von y- Richtung x-Achse
    {for(int i=0;i<na;i++) atom[i].pos.drehenyx(w);}
 void drehenxy(double w)
    {for(int i=0;i<na;i++) atom[i].pos.drehenxy(w);}
 void drehenyzabnr(int n,int n0,double w);
 void rekursivdrehenyz(int n,int* schon,double w);
 void drehenzxabnr(int n,int n0,double w);
 void rekursivdrehenzx(int n,int* schon,double w);
 void schieben(Vektor3d p) {for(int i=0;i<na;i++) atom[i].pos+=p;}
 void schiebenabnr(int n,int n0,Vektor3d p);
 void rekursivschieben(int n,int* schon,Vektor3d p);
 void atomloeschen(int n);
 void zentrieren(Vektor3d p) {for(int i=0;i<na;i++) atom[i].pos-=p;}
 void drehenxachse(Vektor3d p);
 void drehenxyebene(Vektor3d p);
 void anfuegen(int a,Vektor3d p,Molekuel& molek);
 void anfuegen(double x0,Molekuel& molek);
 int checkpos(Vektor3d p); //pruefen ob schon ein Atom ungefaehr hier ist
 int getna() {return na;}
 int peptidkettesuchen(int n1,int n2,int n3,Atom* a,int* nr);
 bool istcarbonyl(int n) {return (bonds2atom(n)==3);}//provi.
};
static Molekuel aktuellesmolekuel,anfuegmolekuel;

bool fastgleich(Vektor3d p1,Vektor3d p2)
{
 const double d=0.2;
 return (abs(p1-p2)<d);
}

int Molekuel::peptidkettesuchen(int n1,int n2,int n3,Atom* a,int* nr)
{
 int i,ni,b,j;
 a[0]=atom[nr[0]=n1];
 for(i=1,ni=n2;ni!=n3;i++)
   {nr[i]=ni; if(i<6) a[i]=atom[ni];
    for(b=0;b<nb;b++)
     {if(bind[b].a[0]==ni) j=bind[b].a[1];
      else if(bind[b].a[1]==ni) j=bind[b].a[0];
      else continue;
      if(j!=ni && j!=n1)
	{if(atom[j]=="N") break;
	 if(atom[j]=="C" && (atom[ni]=="N" || istcarbonyl(j))) break;
	}
     }
    if(b==nb) return 0;
    n1=ni;
    ni=j;
   }
 nr[i]=n3; if(i<6) a[i]=atom[n3];
 return i+1;
}

int Molekuel::checkpos(Vektor3d p)
{//pruefen ob schon ein Atom ungefaehr hier ist
 for(int i=0;i<na;i++)
   if(fastgleich(atom[i].pos,p)) return i;
 return -1;
}

void Molekuel::drehenxachse(Vektor3d p) //p auf die x-Achse drehen
{
 double w1=atan2(p.z,p.y),w2=atan2(sqrt(p.y*p.y+p.z*p.z),p.x);
 for(int i=0;i<na;i++)
   {atom[i].pos.drehenzy(w1);
    atom[i].pos.drehenyx(w2);
   }
}
void Molekuel::drehenxyebene(Vektor3d p)//p um x-Achse auf die xy-Ebene drehen
{
 double w1=atan2(p.z,p.y);
 for(int i=0;i<na;i++)
   atom[i].pos.drehenzy(w1);
}

void Molekuel::autoputbind()
{
 const double min=1.5;
 for(int i=0;i<na-1;i++)
 for(int j=i+1;j<na;j++)
   {if(abs(atom[i].pos-atom[j].pos)<min) putbindung(i,j,1);
   }
}

Atom Molekuel::getselectedatom(int* n)
{
 int i= *n;
 if(i<0) i=0;
 for(;i<na;i++)
   if(atom[i].sel) {*n=i; return atom[i];}
 *n= -1;
 return atom[0];
}

void Molekuel::selectnext()
{
 int i;
 if(atom==NULL) return;
 if(shifttaste)
  {for(i=0;i<na && atom[i].sel==0;i++) ;
   if(i==na) {atom[selpush(0)].sel=1; return;}
   for(;i<na && atom[i].sel==1;i++) ;
   if(i<na) atom[selpush(i)].sel=1; else atom[selpush(0)].sel=1;
  }
 else
  {for(i=0;i<na-1;i++)
     if(atom[i].sel) {atom[selpop(i)].sel=0; atom[selpush(i+1)].sel=1; return;}
   if(atom[na-1].sel) atom[selpop(na-1)].sel=0;
   else atom[selpush(0)].sel=1;
  }
}

void Molekuel::select(double x,double y)
{
 int i,ibest=0;
 double a,best;
 Vektor3d v(x,y,0);
 if(atom==NULL) return;
 if(!shifttaste) unselect();
 for(int i=0;i<na;i++)
   {a=abs(projektion(atom[i].pos)-v);
    if(i==0 || a<best) {best=a; ibest=i;}
   }
 const double maxbest=2.0;
 if(best<maxbest) atom[selpush(ibest)].sel=1;
}

Molekuel& Molekuel::operator=(Molekuel& z)
{
 clear();
 atom=new Atom[maxa=z.maxa];  na=z.na; for(int i=0;i<na;i++) atom[i]=z.atom[i];
 bind=new Bindung[maxb=z.maxb];nb=z.nb;for(int i=0;i<nb;i++) bind[i]=z.bind[i];
 return *this;
}

void Molekuel::raytrace(char *dateiname) //erzeuge eine Datei fuer Povray
{
 int i;
 FILE *fp=fopen(dateiname,"w");
 if(fp==NULL) {printf("cant crate '%s'\n",dateiname); return;}
 fprintf(fp,"#include \"colors.inc\"\n");
 fprintf(fp,"camera {\n location <%lg, %lg, %lg>\n",kamera.x,kamera.y,kamera.z);
 //fprintf(fp," direction <0, 0, 2.3>\n"); //entweder direction oder look_at
 fprintf(fp," look_at <%lg, %lg, %lg>\n",lookat.x,lookat.y,lookat.z);
 if(sky.x!=0 || sky.z!=0 || sky.y<0)
   fprintf(fp," sky <%lg, %lg, %lg>\n",sky.x,sky.y,sky.z); //Oben fuer die Kamera
 fprintf(fp," angle %lg\n",2*atan2((gxmax-gxmin)/2,brennweite)/GRAD);
 fprintf(fp,"}\n");
 if(stereoflag)
   {for(i= -2;i<4;i++)
     fprintf(fp,"light_source {<%lg, 40, -100> color Gray50}\n",i*stereox0);
   }
 else
   fprintf(fp,"light_source {<-10, 10, -5> color White}\n\
light_source {< 10, 5, -4> color Gray70}\n\
light_source {<0, 0, -10> color Gray50}\n");
 fprintf(fp,"background {color rgb<%lg, %lg, %lg>}\n\n",
	 (higrund_r>=254)?1.0:higrund_r/256.0, //0.99 aufrunden auf 1.0
	 (higrund_g>=254)?1.0:higrund_g/256.0,
	 (higrund_b>=254)?1.0:higrund_b/256.0);
 char liste[120]; for(i=0;i<120;i++) liste[i]=0;
 for(i=0;i<na;i++)
   {int n=pernr(atom[i].symbol);
    if(n==0 || liste[n]==0) {atom[i].raytrace1(fp); liste[n]=1;}
   }
 fprintf(fp,"#declare glanz=0.5;\n");
 if(nb>0)
   {fprintf(fp,"#declare bindradius=%lf;\n",1.0*gbindradius/100);
    fprintf(fp,"#declare bindcol=Gray95;\n"); //Plum oder Gray90 oder ??
    fprintf(fp,"#declare bglanz=0.2;\n");
   }
 for(i=0;i<nb;i++)
   {Vektor3d p1,p2;
    p1=atom[bind[i].a[0]].pos;
    p2=atom[bind[i].a[1]].pos;
    fprintf(fp,"//bond %d %d %d\n",bind[i].a[0],bind[i].a[1],bind[i].n);
    fprintf(fp,"cylinder {\n <%lg,%lg,%lg>,<%lg,%lg,%lg>, bindradius\n",
	    p1.x,p1.y,p1.z, p2.x,p2.y,p2.z);
    fprintf(fp," texture{pigment{color bindcol} finish {phong bglanz}}\n}\n");
   }
 for(i=0;i<na;i++) atom[i].raytrace2(fp);
 fclose(fp);
}
void Atom::raytrace1(FILE *fp)
{
 fprintf(fp,"#declare %sradius=%lf;\n",symbol,radius*gatomradius/100);
}
void Atom::raytrace2(FILE *fp)
{
 fprintf(fp,"sphere {\n");
 fprintf(fp," <%lg, %lg, %lg>, %sradius\n",pos.x,pos.y,pos.z,symbol);
 fprintf(fp," pigment {%s}\n",gelemente.farb(symbol));
 fprintf(fp," finish {phong glanz}\n");
 fprintf(fp,"}\n");
}

void Molekuel::savexyz(char *dateiname) //erzeuge eine xyz-Datei
{
 int i,n;
 FILE *fp=fopen(dateiname,"w");
 if(fp==NULL) {printf("cant crate '%s'\n",dateiname); return;}
 fprintf(fp,"%d  %d\n",na,nb);
 for(i=0;i<na;i++) atom[i].savexyz(fp);
 for(i=0;i<nb;i++)
   if((n=bind[i].n)>1) fprintf(fp,"%d %d %d\n",bind[i].a[0],bind[i].a[1],n);
   else fprintf(fp,"%d %d\n",bind[i].a[0],bind[i].a[1]);
 fclose(fp);
}
void Atom::savexyz(FILE *fp)
{
 fprintf(fp," %-2s %12.6lf %12.6lf %12.6lf\n",symbol,pos.x,pos.y,pos.z);
}

int Molekuel::put(char* sym,double x,double y,double z,int a2,int v)
{
 if(na==maxa)
   {if(maxa==0) {atom=new Atom[maxa=20];}
    else
      {Atom *neu;
       neu=new Atom[maxa=2*maxa];
       for(int i=0;i<na;i++) neu[i]=atom[i];
       delete[] atom;
       atom=neu;
      }
   }
 atom[na]=Atom(sym,x,y,z);
 if(a2>=0) putbindung(na,a2,v);
 return na++;
}
void Molekuel::putbindung(int a1,int a2,int v)
{
 if(nb==maxb)
   {if(maxb==0) {bind=new Bindung[maxb=20];}
    else
      {Bindung *neu;
       neu=new Bindung[maxb=2*maxb];
       for(int i=0;i<nb;i++) neu[i]=bind[i];
       delete[] bind;
       bind=neu;
      }
   }
 bind[nb].a[0]=a1; bind[nb].a[1]=a2; bind[nb].n=v;
 nb++;
}
void Molekuel::putbindung2(int a1,int a2)
{
 for(int i=0;i<nb;i++)
   if((bind[i].a[0]==a1 && bind[i].a[1]==a2) ||
      (bind[i].a[0]==a2 && bind[i].a[1]==a1))
     {bind[i].n++; return;}
 putbindung(a1,a2,1);
}
int Molekuel::getbindung(int a1,int a2)
{
 for(int i=0;i<nb;i++)
   if((bind[i].a[0]==a1 && bind[i].a[1]==a2) ||
      (bind[i].a[0]==a2 && bind[i].a[1]==a1))
     {return bind[i].n;}
 return 0;
}
void Molekuel::replacebindung(int a1,int a2,int v)
{
 for(int i=0;i<nb;i++)
   if((bind[i].a[0]==a1 && bind[i].a[1]==a2) ||
      (bind[i].a[0]==a2 && bind[i].a[1]==a1))
     {bind[i].n=v; return;}
}
void Molekuel::delbindung(int a1,int a2)
{
 for(int i=0;i<nb;i++)
   if((bind[i].a[0]==a1 && bind[i].a[1]==a2) ||
      (bind[i].a[0]==a2 && bind[i].a[1]==a1))
     {for(;i<nb-1;i++) bind[i]=bind[i+1];
      nb--;
     }
}
int Molekuel::bonds2atom(int a1)
{
 int n=0;
 for(int i=0;i<nb;i++)
   if(bind[i].a[0]==a1 || bind[i].a[1]==a1) n++;
 return n;
}

void Molekuel::drehenyzabnr(int n,int n0,double w)
{
 //Molekuelteil ab atom[n] drehen: Nur den Teil der verbunden ist ohne n0
 int i,j,k,schon[na];
 for(i=0;i<na;i++) schon[i]=0;
 schon[n0]=1;
 rekursivdrehenyz(n,schon,w);
}
void Molekuel::rekursivdrehenyz(int n,int* schon,double w)
{
 int k;
 atom[n].pos.drehenyz(w); schon[n]=1;
 for(int j=0;j<nb;j++)
   if(bind[j].a[0]==n)
     {if(schon[k=bind[j].a[1]]==0) rekursivdrehenyz(k,schon,w);}
   else if(bind[j].a[1]==n)
     {if(schon[k=bind[j].a[0]]==0) rekursivdrehenyz(k,schon,w);}
}

void Molekuel::drehenzxabnr(int n,int n0,double w)
{
 //Molekuelteil ab atom[n] drehen: Nur den Teil der verbunden ist ohne n0
 int i,j,k,schon[na];
 for(i=0;i<na;i++) schon[i]=0;
 schon[n0]=1;
 rekursivdrehenzx(n,schon,w);
}
void Molekuel::rekursivdrehenzx(int n,int* schon,double w)
{
 int k;
 atom[n].pos.drehenzx(w); schon[n]=1;
 for(int j=0;j<nb;j++)
   if(bind[j].a[0]==n)
     {if(schon[k=bind[j].a[1]]==0) rekursivdrehenzx(k,schon,w);}
   else if(bind[j].a[1]==n)
     {if(schon[k=bind[j].a[0]]==0) rekursivdrehenzx(k,schon,w);}
}

void Molekuel::schiebenabnr(int n,int n0,Vektor3d p)
{
 //Molekuelteil ab atom[n] schieben: Nur den Teil der verbunden ist ohne n0
 int i,j,k,schon[na];
 for(i=0;i<na;i++) schon[i]=0;
 schon[n0]=1;
 rekursivschieben(n,schon,p);
}
void Molekuel::rekursivschieben(int n,int* schon,Vektor3d p)
{
 int k;
 atom[n].pos+=p; schon[n]=1;
 for(int j=0;j<nb;j++)
   if(bind[j].a[0]==n)
     {if(schon[k=bind[j].a[1]]==0) rekursivschieben(k,schon,p);}
   else if(bind[j].a[1]==n)
     {if(schon[k=bind[j].a[0]]==0) rekursivschieben(k,schon,p);}
}

void Molekuel::atomloeschen(int n)
{
 int i,j;
 if(n<0 || n>=na) return;
 for(j=0;j<nb;) //alle Bindungen zu Atom n loeschen
  {if(bind[j].a[0]==n || bind[j].a[1]==n)
     {for(i=j;i<nb-1;i++) bind[i]=bind[i+1];
      nb--;
     }
   else j++;
  }
 for(--na,i=n;i<na;i++) //Atom loeschen und andere nachschieben
          atom[i]=atom[i+1];
 for(int i=0;i<nb;i++) //Bindungen Nummerierungen korrigieren
   {if(bind[i].a[0]>n) --bind[i].a[0];
    if(bind[i].a[1]>n) --bind[i].a[1];
   }
}

class String80
{
 char str[80];
public:
 String80() {for(int i=0;i<80;i++) str[i]=0;}
 char& operator[](int i) {return str[i];}
};

const int MAXUNDO=10;
class Undostapel
{
 Molekuel stapel[MAXUNDO];
 String80 text[MAXUNDO];
 int nu;//Anzahl gueltige Eintraege
public:
 Undostapel() {nu=0;}
 void push(Molekuel& m,char *t);
 Molekuel& pop(char *t);
 bool check(char *t) {return (nu>0 && strcmp(t,&text[0][0])==0);}
};
static Undostapel undo;

void Undostapel::push(Molekuel& m,char *t)
{
 if(m.istleer()) return;
 if(nu<MAXUNDO) nu++;
 for(int i=nu;--i>0;)
   {stapel[i]=stapel[i-1];
    text[i]=text[i-1];
   }
 stapel[0]=m;
 strcpy(&text[0][0],t);
 nochnichtgespeichert=1;
}

Molekuel& Undostapel::pop(char *t)
{
 static Molekuel molekuel;
 if(nu>0)
   {molekuel=stapel[0];
    strcpy(t,&text[0][0]);
    --nu;
    for(int i=0;i<nu;i++)
      {stapel[i]=stapel[i+1];
       text[i]=text[i+1];
      }
   }
 else *t=0;
 return molekuel;
}

class Diederwinkel
{
public:
 Atom atom[4];
 int nr[4];
};
static Diederwinkel gdw;

/********************** weiterer Kleinkram ****************************/
int farbnummer(int r,int g,int b)
{
 if(gtiefe>=12) return ((r&0xF0)<<4)+(g&0xF0)+((b&0xF0)>>4);
 return (r&0xE0)+((g>>3)&0x1C)+((b>>6)&0x03);
}
void farben_init()
{
 int r,g,b;
 if(gtiefe>=12)
      for(r=0;r<=0xF0;r+=0x10)
      for(g=0;g<=0xF0;g+=0x10)
      for(b=0;b<=0xF0;b+=0x10) setcolor(farbnummer(r,g,b),r,g,b);
 else //if(gtiefe>=8)
      for(r=0;r<=0xE0;r+=0x20)
      for(g=0;g<=0xE0;g+=0x20)
      for(b=0;b<=0xC0;b+=0x40) setcolor(farbnummer(r,g,b),r,g,b);
}
void farbeneusetzen(int* farbe)
{
 int f1= *farbe,f2=0;
 int r=f1>>16,g=(f1>>8)&0xFF,b=f1&0xFF;;
 if(gtiefe>=8) f2=farbnummer(r,g,b);
 *farbe=f2;
}
void constfarbeneusetzen()
{
 printf("Farbtiefe=%d %s\n",
	gtiefe,(gtiefe<12)?"zu klein fuer korrekte Farbdarstellung":"");
 if(gtiefe>=8)
   {farbeneusetzen(&WEISS); farbeneusetzen(&FASTWEISS); farbeneusetzen(&GRAU);}
 else
   {WEISS=1; FASTWEISS=2; GRAU=3;
    printf("Fehler: Farbtiefe viel zu klein.\n");
   }
}
void rgbcolor2(int r,int g,int b)
{
 color((gtiefe<24) ? farbnummer(r,g,b) : (r<<16)+(g<<8)+b);
}
void rgbscreenclear(int r,int g,int b)
{
 hintergrundfarbe=(r<<16)+(g<<8)+b;
 hintergrundfarbnr=(gtiefe<24)?farbnummer(r,g,b):hintergrundfarbe;
 screenclear(hintergrundfarbnr);
}

void bildformat(int b,int h)
{
 double dx,dy=gymax-gymin,xmitte=(gxmin+gxmax)/2;
 dx=dy/h*b;
 gxmin=xmitte-dx/2; gxmax=gxmin+dx;
 term_refresh();
 inital_new(gxmin,gymin,gxmax,gymax);
 m_refresh();
}

/****************** Zeichnen in 3D-Darstellung ************************/
Vektor3d projektionvor(Vektor3d p) //Vorberechnung
{
 /* Vektor auf Bildschirmebene Projezieren:
    Bildschirmebene ist x-y-System mit Nullpunkt in der Mitte,
    die z-Achse zeigt vom Betrachter weg.
    Fuer Punkte auf dem Bildschirm ist z also 0.
 */
 Vektor3d q,k,s;
 double alfa,beta,gamma,z;
 bool sflag=(sky.x!=0 || sky.z!=0 || sky.y<0);
 k=kamera-lookat; z=abs(k);
 if(sflag) s=k+sky;
 //Koordinatensystem in Lookat-Punkt Verschieben:
 q=p-lookat;
 //Drehung so dass Kamera auf y-z-Ebene zu liegen kommt:
 alfa=PI/2+atan2(k.z,k.x);
 if(rotationsflag) alfa+=rotationswinkel;
 q.drehenzx(alfa);
 //Drehung so dass Kamera auf negative z-Achse zu liegen kommt:
 beta=atan2(k.y,sqrt(z*z-k.y*k.y));
 q.drehenzy(beta);
 //Schieben so dass Koordinatenursprung auf Brennweite zu liegen kommt:
 q.z += z-brennweite;
 if(sflag)
   {s.drehenzx(alfa);
    s.drehenzy(beta);
    //Kamera kippen bis Sky-Vektor auf y-z-Ebene liegt:
    gamma=atan2(s.x,s.y); q.drehenxy(gamma);
   }
 return q;
}
Vektor3d projektion(Vektor3d p,double* f)
{
 Vektor3d q=projektionvor(p);
 //Strahlensatz um Punkt auf Bildschirm abzubilden:
 *f=brennweite/(q.z+brennweite);
 q.x *= *f;
 q.y *= *f;
 q.z=0;
 return q;
}
Vektor3d rueckprojektionvor(Vektor3d q)
{
 //Umkehrung von projektionvor()
 Vektor3d k,s;
 double alfa,beta,gamma,z;
 bool sflag=(sky.x!=0 || sky.z!=0 || sky.y<0);
 k=kamera-lookat; z=abs(k);
 if(sflag) s=k+sky;
 alfa=PI/2+atan2(k.z,k.x); //fuer Drehung der Kamera auf y-z-Ebene
 if(rotationsflag) alfa+=rotationswinkel;
 beta=atan2(k.y,sqrt(z*z-k.y*k.y)); //fuer Drehung auf negative z-Achse
 if(sflag)
   {s.drehenzx(alfa);
    s.drehenzy(beta);
    //Umkehr: Kamera kippen bis Sky-Vektor auf y-z-Ebene liegt:
    gamma=atan2(s.x,s.y); q.drehenyx(gamma);
   }
 //Umkehr: Schieben so dass Koordinatenursprung auf Brennweite zu liegen kommt:
 q.z -= z-brennweite;
 //Umkehr: Drehung so dass Kamera auf negative z-Achse zu liegen kommt:
 q.drehenyz(beta);
 //Umkehr: Drehung so dass Kamera auf y-z-Ebene zu liegen kommt:
 q.drehenxz(alfa);
 //Umkehr: Koordinatensystem in Lookat-Punkt Verschieben:
 q+=lookat;
 return q;
}
Vektor3d rueckprojektion(Vektor3d p,double z)
{
 //Strahlensatz um Punkt vom Bildschirm auf z abzubilden:
 double z1=z-(kamera.z+brennweite);
 double f=(z1+brennweite)/brennweite;
 Vektor3d q(p.x*f,p.y*f,z1);
 q=rueckprojektionvor(q);
 return q;
}

void linie(double x1,double y1,double x2,double y2)
{
 if(x1>gxmax)
   {if(x2<gxmin || x2>gxmax || y2<gymin || y2>gymax) return;
    y1=y2+(y1-y2)/(x1-x2)*(gxmax-x2); x1=gxmax;
   }
 else if(x1<gxmin)
   {if(x2<gxmin || x2>gxmax || y2<gymin || y2>gymax) return;
    y1=y2+(y1-y2)/(x1-x2)*(gxmin-x2); x1=gxmin;
   }
 if(y1>gymax)
   {if(x2<gxmin || x2>gxmax || y2<gymin || y2>gymax) return;
    x1=x2+(x1-x2)/(y1-y2)*(gymax-y2); y1=gymax;
   }
 else if(y1<gymin) 
   {if(x2<gxmin || x2>gxmax || y2<gymin || y2>gymax) return;
    x1=x2+(x1-x2)/(y1-y2)*(gymin-y2); y1=gymin;
   }
 else
   {if(x2>gxmax) {y2=y1+(y2-y1)/(x2-x1)*(gxmax-x1); x2=gxmax;}
    else if(x2<gxmin) {y2=y1+(y2-y1)/(x2-x1)*(gxmin-x1); x2=gxmin;}
    if(y2>gymax) {x2=x1+(x2-x1)/(y2-y1)*(gymax-y1); y2=gymax;}
    else if(y2<gymin) {x2=x1+(x2-x1)/(y2-y1)*(gymin-y1); y2=gymin;}
   }
 plot(x1,y1,PENUP); plot(x2,y2,PENDOWN);
}

void liniezeichnen(Vektor3d v1,Vektor3d v2)
{
 Vektor3d p1,p2;
 p1=projektion(v1);
 p2=projektion(v2);
 linie(p1.x,p1.y,p2.x,p2.y);
}

void liniezeichnen2(Vektor3d v1,Vektor3d v2,int n)
{
 Vektor3d p1,p2,q1,q2;
 p1=projektion(v1); p2=projektion(v2);
 double b=(gymax-gymin)/((n==2)?400:200), alfa=atan2(p2.y-p1.y,p2.x-p1.x);
 double sina=sin(alfa),cosa=cos(alfa);
 if(n>=3) linie(p1.x,p1.y,p2.x,p2.y);
 q1.x=p1.x-b*sina; q1.y=p1.y+b*cosa;
 q2.x=p2.x-b*sina; q2.y=p2.y+b*cosa;
 linie(q1.x,q1.y,q2.x,q2.y);
 q1.x=p1.x+b*sina; q1.y=p1.y-b*cosa;
 q2.x=p2.x+b*sina; q2.y=p2.y-b*cosa;
 linie(q1.x,q1.y,q2.x,q2.y);
}

double Atom::zeichnenvorberechnen()
{
 pvor=projektionvor(pos);
 double z=pvor.z;
 //Strahlensatz um Punkt auf Bildschirm abzubilden:
 fvor=brennweite/(z+brennweite);
 pvor.x *= fvor;
 pvor.y *= fvor;
 pvor.z=0;
 vorflag=1;
 return z;
}

inline bool istsichtbar(double x,double y)
{
 return (x>=gxmin && x<=gxmax && y>=gymin && y<=gymax);
}

void Atom::zeichnen(int hell)
{
 if(!vorflag) zeichnenvorberechnen();
 if(istsichtbar(pvor.x,pvor.y))
 {double r=radius*gatomradius/100*fvor,dr=(gymax-gymin)/400;
  calcrgbfarbe(); rgbcolor2(rr*hell/100,gg*hell/100,bb*hell/100);
  if(vollmodus)
   {fillcircle(pvor.x,pvor.y,r,r);
    if(sel)
      {r-=dr; color(SCHWARZ); drawcircle(pvor.x,pvor.y,r,r);
       r-=dr; color(WEISS); drawcircle(pvor.x,pvor.y,r,r);
      }
   }
  else
   {drawcircle(pvor.x,pvor.y,r,r);
    if(sel) {r-=dr; drawcircle(pvor.x,pvor.y,r,r);}
   }
 }
}

void Atom::zeichnungloeschen(int farbe)
{
 double r=radius*gatomradius/100*fvor;
 if(istsichtbar(pvor.x,pvor.y))
 {color(farbe);
  if(vollmodus) fillcircle(pvor.x,pvor.y,r,r);
  else
   {drawcircle(pvor.x,pvor.y,r,r);
    if(sel) {r-=(gymax-gymin)/400; drawcircle(pvor.x,pvor.y,r,r);}
   }
 }
 vorflag=0;
}

void einsortieren(int na,int *sort,double *wert,int iz,double z)
{
 int i,j;
 for(i=0;i<na-1 && wert[i]>z;i++) ;
 for(j=na-1;j>i;--j) {wert[j]=wert[j-1]; sort[j]=sort[j-1];}
 wert[i]=z; sort[i]=iz;
}

void Molekuel::zeichnen(int farbe)
{
 int i,j,h;
 color(farbe);
 for(i=0;i<nb;i++)
   {if(bind[i].n>1)
      liniezeichnen2(atom[bind[i].a[0]].pos,atom[bind[i].a[1]].pos,bind[i].n);
    else liniezeichnen(atom[bind[i].a[0]].pos,atom[bind[i].a[1]].pos);
   }
 if(farbe==WEISS)
   {int sort[na]; double wert[na],w,wmax= -0.1,wmin=0.1;
    for(i=0;i<na;i++) wert[i]= -1e10;
    for(i=0;i<na;i++)
       {einsortieren(na,sort,wert,i,w=atom[i].zeichnenvorberechnen());
        if(w>wmax) wmax=w;
        else if(w<wmin) wmin=w;
       }
    w=20/(wmax-wmin);
    for(i=0;i<na;i++) atom[sort[i]].zeichnen(int(100-(wert[i]-wmin)*w));
   }
 else
   for(i=0;i<na;i++) atom[i].zeichnungloeschen(farbe);
}

/********************** Kamera-Verschiebungen *************************/
void kameraschwenken(int n,double f)
{
 double beta;
 Vektor3d p1;
 p1=lookat-kamera;
 if(n&1) //1 oder 3 heisst nach links oder rechts schwenken
   {beta=2*atan2((gxmax-gxmin)/2,brennweite)/f;
    if(n==1) p1.drehenxz(beta); else p1.drehenzx(beta);
   }
 else //2 oder 4 heisst noch oben oder unten schwenken
   {beta=2*atan2((gymax-gymin)/2,brennweite)/f;
    if(n==2) p1.drehenzy(beta); else p1.drehenyz(beta);
   }
 lookat=p1+kamera;
 m_refresh();
}
void kamerafahren(int n,double f)
{
 double dx;
 if(n&1) //1 oder 3 heisst nach links oder rechts fahren
   {if(n==1) f= -f;
    dx=(gxmax-gxmin)/f;
    kamera.x+=dx; lookat.x+=dx;
   }
 else //2 oder 4 heisst noch oben oder unten fahren
   {if(n==4) f= -f;
    dx=(gymax-gymin)/f;
    kamera.y+=dx; lookat.y+=dx;
   }
 m_refresh();
}

/************************* Menu Behandlung ****************************/
static int exitflag=0;
void menu_exit() {exitflag=1;}
void m_hilfe()
{
 char text[]=
"  Hilfe zu Molz3D\n\
  ================\n\
\n\
Tastenbelegung:\n\
---------------\n\
Taste  Funktion\n\
n      Naechstes Atom selektieren (wie Menu Select-Next)\n\
N      Mehrere Atome selektieren\n\
Shift  (oder CapsLock) Mehrere Atome mit Maus selektieren\n\
q      Selektierung aufheben\n\
Q      Selektierung aufheben, danach wieder mehrere Atome selektierbar\n\
Del    Selektiertes Atom loeschen\n\
y      Bild neu zeichnen (wie Menu Refresh)\n\
r      Rotierende Darstellung stoppen/fortfahren\n\
t      Rotierende Darstellung Richtung wechseln\n\
w      Winkel messen/aendern\n\
d      Dieder-Winkel messen/aendern\n\
i      Dieder-Winkel interaktiv aendern\n\
b      Bindungslaenge (oder Abstand) messen/aendern\n\
a      Bindungslaenge automatisch anpassen\n\
\nMausfunktionen:\n\
---------------\n\
Klicken auf Atom: Atom wird selektiert\n\
Ziehen an seitlichem Rand: drehen um die x-Achse\n\
Ziehen am unteren Rand: drehen um die y-Achse\n\
Ziehen am oberen Rand: drehen um die z-Achse\n\
\n";
 janeinrequester(text);
 m_refresh2();
}

//Menu File:
void m_load()
{
 int ok;
 static char name[200]="test1.pov",filter[80]="*.pov";
 ok=nachfilenamefragen("Lade Molekueldatei",name,200,0,filter);
 if(ok) dateiladen(name);
}
void dateispeichern(char *name)
{
 if(istendung(name,".pov")) aktuellesmolekuel.raytrace(name);
 else aktuellesmolekuel.savexyz(name);
 nochnichtgespeichert=0;
}
void m_save()
{
 int ok;
 static char name[200]="test.pov",filter[80]="*.pov";
 ok=nachfilenamefragen("Speichere Molekueldatei",name,200,0,filter);
 if(ok) dateispeichern(name);
}
void loadxyz(int flag)
{
 int ok;
 static char name[200]="test1.xyz",filter[80]="*.xyz";
 if(flag) ok=nachfilenamefragen("Molekuel zum Anfuegen",name,200,0,filter);
 else ok=nachfilenamefragen("Lade Molekueldatei",name,200,0,filter);
 if(ok) dateiladen(name,flag);
}
void m_loadxyz()
{
 loadxyz(0);
}
void m_savexyz()
{
 int ok;
 static char name[200]="test.xyz",filter[80]="*.xyz";
 ok=nachfilenamefragen("Speichere Molekueldatei",name,200,0,filter);
 if(ok) dateispeichern(name);
}

//Menu Darstellung:
void m_param()
{
 int ok,n1,n2,m1,m2;
 char vollfarbig[80],format[80];
 strcpy(vollfarbig,(vollmodus)?"ja":"nein");
 n2=9; n1=int((gxmax-gxmin)/(gymax-gymin)*n2+0.5);
 if(n1%3==0) {n1/=3; n2=3;}
 sprintf(format,"%d:%d",n1,n2);
 ok=requester_input(5,"Hintergrundfarbe","%06X","%X",&hintergrundfarbe,
		    " Bildformat ","%s","%s\n",format,
		    "Atome Vollfarbig","%s","%s\n",vollfarbig,
		    "  Atomradius in %  ","%d","%d",&gatomradius,
		      "Bindungsradius in %","%d","%d\n",&gbindradius);
 if(ok)
   {vollmodus = (vollfarbig[0]=='n' || vollfarbig[0]=='N') ? 0 : 1;
    higrund_r=hintergrundfarbe>>16;
    higrund_g=(hintergrundfarbe>>8)&0xFF;
    higrund_b=hintergrundfarbe&0xFF;
    rgbscreenclear(higrund_r,higrund_g,higrund_b);
    if(hintergrundfarbnr==WEISS) hintergrundfarbnr=FASTWEISS;
    sscanf(format,"%d:%d",&m1,&m2);
    if(m1!=n1 || m2!=n2) bildformat(m1,m2);
   }
 m_refresh2();
}
void m_kamera()
{
 int ok;
 ok=requester_input(10,"Kamera x","%lf","%lf",&kamera.x,
		    "Kamera y","%lf","%lf",&kamera.y,
		    "Kamera z","%lf","%lf\n",&kamera.z,
		    "Lookat x","%lf","%lf",&lookat.x,
		    "Lookat y","%lf","%lf",&lookat.y,
		    "Lookat z","%lf","%lf\n",&lookat.z,
		    " Oben x ","%lf","%lf",&sky.x,
		    " Oben y ","%lf","%lf",&sky.y,
		    " Oben z ","%lf","%lf\n",&sky.z,
		    "Brennweite","%lf","%lf",&brennweite);
 if(ok) m_refresh2();
}
void m_rotieren()
{
 if(rotationsflag)
   {rotationsflag=0; rotationswinkel=0; changebuffer(0,0); m_refresh();}
 else
   {rotationsflag=1; changebuffer(0,1);}
}
void m_refresh()
{
 screenclear(hintergrundfarbnr);
 aktuellesmolekuel.zeichnen();
}

//Menu Edit:

void m_undo()
{
 int ok;
 char text[80],str[160],alle[160],antw1[80]="nein",antw2[80]="ja";
 Molekuel molekuel;
 molekuel=undo.pop(text);
 if(*text==0)
   {janeinrequester("Undo-Stapel ist leer."); return;}
 if(undo.check(text))
   {sprintf(alle,"Alles %s zuruecknemen ?",text);
    sprintf(str,"Letztes %s zuruecknehmen ?",text);
    ok=requester_input(2,alle,"%s","%s\n",antw1,
		       str,"%s","%s",antw2);
    if(ok)
      {if(istja(antw1))
	{do molekuel=undo.pop(text); while(undo.check(text));}
       else if(!istja(antw2))
	 ok=0;
      }
   }
 else
   {sprintf(str,"%s zuruecknehmen ?",text);
    ok=janeinrequester(str," ja ","nein");
   }
 if(ok)
   {aktuellesmolekuel=molekuel; m_refresh();}
 else
   {undo.push(molekuel,text);}
}
void m_selnext()
{
 aktuellesmolekuel.selectnext();
 m_refresh();
}
void m_selall()
{
 aktuellesmolekuel.selectall();
 m_refresh();
}
void m_neuatom()
{
 char symbol[80]="C";
 double x=0.5,y=0.5,z=0;
 Atom atom;
 atom=aktuellesmolekuel.getsel(0);
 if(!atom.istleer())
   {strcpy(symbol,atom.symbol);
    x=0.01*int(100*atom.pos.x+70);
    y=0.01*int(100*atom.pos.y+70);
    z=0.01*int(100*atom.pos.z);
   }
 int ok=requester_input(4,"  Atom  ","%s","%s",symbol,
		      " Position-x ","%lf","%lf",&x,
		      " Position-y ","%lf","%lf",&y,
		      " Position-z ","%lf","%lf",&z);
 if(ok)
   {undo.push(aktuellesmolekuel,"Neues-Atom");
    aktuellesmolekuel.put(symbol,x,y,z);
   }
 m_refresh2();
}
void m_editatom()
{
 Atom atom;
 int i,na,nr,ok,flag=1;
 char symbol[80];
 for(na=0;;na++)
   {atom=aktuellesmolekuel.getselectedatom(&na);
    if(na<0) break;
    nr=na; strcpy(symbol,atom.symbol);
    flag=0;
    ok=requester_input(5,"  Atom  ","%s","%s",symbol,
		       " Nr (nicht aenderbar)","%d","%d\n",&nr,
		      " Position-x ","%lf","%lf",&atom.pos.x,
		      " Position-y ","%lf","%lf",&atom.pos.y,
		      " Position-z ","%lf","%lf",&atom.pos.z);
    if(ok)
      {symbol[2]=0; strcpy(atom.symbol,symbol);
       atom.radius=atomradius(atom.symbol);
       undo.push(aktuellesmolekuel,"Atom-aendern");
       aktuellesmolekuel.replaceatom(na,atom);
      }
   }
 if(flag) janeinrequester("Zuerst ein Atom selektieren.");
 m_refresh2();
}

static double covr[120];//Covalent-Radius
static double covr2[120];//fuer Doppelbindungen
static double covr3[120];//fuer Dreifachbindungen
static double vanr[120];//Vanderwaals Radius
int pernr(char *sy) //Periodensystemnummer
{
 static int tab1[]=
   {0,5,6,1,0,9,0,1,53,53,19,0,0,7,8,15,0,0,16,0,92,23,74,0,39,0};
 const int N=106;//alle Elemente bis zum Hafnium
 static char *element[N]=
   {0,"H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S",
    "Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga",
    "Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd",
    "Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm",
    "Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os",
    "Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa",
    "U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Ha"
   };
 int c=sy[0];
 if(c<'A' || c>'Z') return 0;
 if(sy[1]==0) return tab1[sy[0]-'A'];
 for(int i=2;i<N;i++) if(strcmp(sy,element[i])==0) return i;
 return 0;
}
void elemente_init()
{
 int i;
 for(i=0;i<120;i++) {covr[i]=covr2[i]=covr3[i]=0.75; vanr[i]=1.2;}
 covr[1]=0.30; vanr[1]=1.2;//H
 covr[6]=0.77; covr2[6]=0.67; covr3[6]=0.60; vanr[6]=covr[6]+0.8;//C
 covr[7]=0.74; covr2[7]=0.62; covr3[6]=0.55; vanr[6]=1.5;//N
 covr[8]=0.74; covr2[8]=0.62; covr3[6]=0.55; vanr[6]=1.4;//O
 covr[9]=0.64; vanr[9]=1.35;//F
 covr[14]=1.17; vanr[14]=covr[14]+0.8;//Si
 covr[15]=1.10; vanr[15]=1.9;//F
 covr[16]=1.04; vanr[16]=1.85;//S
 covr[17]=1.00; vanr[17]=1.80;//Cl
 covr[35]=1.14; vanr[35]=1.95;//Br
 covr[53]=1.33; vanr[53]=2.15;//Jod
}

double standardbindungslaenge(char *sy1,char *sy2,int bond)
{
 switch(bond)
   {case 1: return covr[pernr(sy1)] + covr[pernr(sy2)];
    case 2: return covr2[pernr(sy1)] + covr2[pernr(sy2)];
    case 3: return covr3[pernr(sy1)] + covr3[pernr(sy2)];
   }
 return vanr[pernr(sy1)] + vanr[pernr(sy2)];
}
void editbond(int autoflag)
{
 Atom atom[4];
 int bind,b0,nr[4],n1,n2,ok;
 for(int i=0;i<4;i++) atom[i]=aktuellesmolekuel.getsel(i,&nr[i]);
 if(!atom[2].istleer() || atom[1].istleer())
   {janeinrequester("Zuerst genau 2 Atome selektieren");
    m_refresh2();
    return;
   }
 double laenge,laenge0;
 char str[80],antw[80]="ja";
 sprintf(str,"Bindung %s---%s (%d---%d)",
	 atom[0].symbol,atom[1].symbol,nr[0],nr[1]);
 b0=bind=aktuellesmolekuel.getbindung(nr[0],nr[1]);
 laenge0=laenge=abs(atom[0].pos-atom[1].pos);
 n1=aktuellesmolekuel.bonds2atom(nr[0]);
 n2=aktuellesmolekuel.bonds2atom(nr[1]);
 if(autoflag)
   {ok=1; laenge=0;}
 else 
   ok=requester_input((n1<2 || n2<2)?2:3,str,"%d","%d\n",&bind,
		    "Bindungslaenge","%lf","%lf\n",&laenge,
		    "Alles nachfolgende auch schieben?","%s","%s",antw);
 if(ok)
   {if(bind!=b0)
	{if(bind==0)
	  {undo.push(aktuellesmolekuel,"Bindung-loeschen");
	   aktuellesmolekuel.delbindung(nr[0],nr[1]);
	  }
	 else if(b0!=0)
	  {undo.push(aktuellesmolekuel,"Bindung-aendern");
	   aktuellesmolekuel.replacebindung(nr[0],nr[1],bind);
	  }
	 else
	  {undo.push(aktuellesmolekuel,"Neue-Bindung");
	   aktuellesmolekuel.putbindung(nr[0],nr[1],bind);
	  }
	 if(fastgleich(0.001,laenge,laenge0)) laenge=laenge0;
	}
    if(laenge!=laenge0)
        {if(laenge==0) //Bindungslaenge automatisch setzen
	    {laenge=standardbindungslaenge(atom[0].symbol,atom[1].symbol,bind);
	     if(test)
	       printf("Automatisch gesetzte Bindungslaenge: %lf\n",laenge);
	    }
	 undo.push(aktuellesmolekuel,"Abstand-aendern");
	 if(n1<2 || n2<2 || istnein(antw))
	 {if(n1<n2 && n1<2)
	   {atom[0].pos=(atom[0].pos-atom[1].pos)*(laenge/laenge0)+atom[1].pos;
	    aktuellesmolekuel.replaceatom(nr[0],atom[0]);
	   }
	  else
	   {atom[1].pos=(atom[1].pos-atom[0].pos)*(laenge/laenge0)+atom[0].pos;
	    aktuellesmolekuel.replaceatom(nr[1],atom[1]);
	   }
	 }
	 else //alles ab Atom nr[1] schieben
	 {Vektor3d p;
	  p=(atom[1].pos-atom[0].pos)*(laenge/laenge0)+atom[0].pos-atom[1].pos;
	  aktuellesmolekuel.schiebenabnr(nr[1],nr[0],p);
	 }
	}
   }
 m_refresh2();
}
void m_editbond()
{
 editbond(0);
}
void m_editwinkel()
{
 Atom atom[4];
 int nr[4],ok;
 double winkel,alterwinkel;
 char str[80],antw[80]="ja";
 for(int i=0;i<4;i++) atom[i]=aktuellesmolekuel.getsel(i,&nr[i]);
 if(!atom[3].istleer() || atom[2].istleer())
   {janeinrequester("Genau 3 Atome selektieren\n(In richtiger Reihenfolge)");
    return;
   }
 sprintf(str,"Winkel %s---%s---%s (%d--%d--%d)",
	 atom[0].symbol,atom[1].symbol,atom[2].symbol,nr[0],nr[1],nr[2]);
 winkel=vektorwinkel2(atom[0].pos-atom[1].pos,atom[2].pos-atom[1].pos)/GRAD;
 alterwinkel=winkel;
 ok=requester_input(2,str,"%lf","%lf\n",&winkel,
		    "Alles nachfolgende mitdrehen?","%s","%s",antw);
 if(ok && winkel!=alterwinkel)
   {Vektor3d p1,p2,p3;
    double c,w,w1,w2,w3;
    undo.push(aktuellesmolekuel,"Winkel-aendern");
    if(istnein(antw))
      {p1=atom[0].pos; p2=atom[1].pos; p3=atom[2].pos;
       p2-=p1; p3-=p1;//Koordinatenursprung nach p1 schieben
       w1=atan2(p2.z,p2.x); p2.drehenzx(w1); p3.drehenzx(w1);
       w2=atan2(p2.y,p2.x); p2.drehenyx(w2); p3.drehenyx(w2);
       w3=atan2(p3.y,p3.z); p3.drehenyz(w3);
       //jetzt liegt p2 auf der x-Achse und p3 in der x-z-Ebene
       w=(winkel-90)*GRAD; c=abs(p3-p2);
       p3.x=p2.x+c*sin(w);
       p3.z=c*cos(w);
       if(p3.y>1e-6 || p3.y< -1e-6)
	 printf("Rundungsfehler? p3.y=%lg\n",p3.y);//test
       //zurueckdrehen:
       p3.drehenzy(w3); p3.drehenxy(w2); p3.drehenxz(w1);
       atom[2].pos=p1+p3;
       aktuellesmolekuel.replaceatom(nr[2],atom[2]);
      }
    else //ganzer Rest mitdrehen
      {p1=atom[0].pos; p2=atom[1].pos; p3=atom[2].pos;
       p2-=p1; p3-=p1;//Koordinatenursprung nach p1 schieben
       aktuellesmolekuel.schieben(-p1);
       w1=atan2(p2.z,p2.x); p2.drehenzx(w1); p3.drehenzx(w1);
       w2=atan2(p2.y,p2.x); p2.drehenyx(w2); p3.drehenyx(w2);
       w3=atan2(p3.y,p3.z); p3.drehenyz(w3);
       aktuellesmolekuel.drehenzx(w1);
       aktuellesmolekuel.drehenyx(w2);
       aktuellesmolekuel.drehenyz(w3);
       //jetzt liegt p2 auf der x-Achse und p3 in der x-z-Ebene
       aktuellesmolekuel.schieben(-p2);
       w=(winkel-alterwinkel)*GRAD;
       aktuellesmolekuel.drehenzxabnr(nr[2],nr[1],w);
       //zurueckdrehen:
       aktuellesmolekuel.schieben(p2);
       aktuellesmolekuel.drehenzy(w3);
       aktuellesmolekuel.drehenxy(w2);
       aktuellesmolekuel.drehenxz(w1);
       aktuellesmolekuel.schieben(p1);
      }
   }
 m_refresh2();
}
void m_diederwinkel()
{
 Atom atom[4];
 Vektor3d p1,p2,p3,p4;
 double winkel,w1,w2,w3,w4;
 int i,nr[4],abnr,ok;
 char str[80];
 for(i=0;i<4;i++) atom[i]=aktuellesmolekuel.getsel(i,&nr[i]);
 if(atom[3].istleer())
   {janeinrequester("Zuerst 4 Atome selektieren."); return;}
 sprintf(str,"Diederwinkel %s--%s---%s--%s (%d--%d--%d--%d)",
	 atom[0].symbol,atom[1].symbol,atom[2].symbol,atom[3].symbol,
	 nr[0],nr[1],nr[2],nr[3]);
 undo.push(aktuellesmolekuel,"Diederwinkel-aendern");
 p2=atom[1].pos;
 aktuellesmolekuel.zentrieren(p2); p3=atom[2].pos-p2;
 w1=atan2(p3.z,p3.y); w2=atan2(sqrt(p3.y*p3.y+p3.z*p3.z),p3.x);
 aktuellesmolekuel.drehenzy(w1);
 aktuellesmolekuel.drehenyx(w2);
 p1=aktuellesmolekuel.getatompos(nr[0]);
 w3=atan2(p1.z,p1.y);
 aktuellesmolekuel.drehenzy(w3);
 p4=aktuellesmolekuel.getatompos(nr[3]);
 w4=atan2(p4.z,p4.y);
 winkel=w4/GRAD;
 abnr=nr[2];
 ok=requester_input(2,str,"%lf","%lf\n",&winkel,
		    "alles mitdrehen ab AtomNr:","%d","%d",&abnr);
 if(ok)
   {double w5=winkel*GRAD-w4;
    //Teil des Molekuels drehen:
    int n0=(abnr==nr[2])?nr[1]:nr[2];
    if(w5!=0) aktuellesmolekuel.drehenyzabnr(abnr,n0,w5);
    //Gesamtmolekuel zurueckdrehen:
    aktuellesmolekuel.drehenyz(w3);
    aktuellesmolekuel.drehenxy(w2);
    aktuellesmolekuel.drehenyz(w1);
    aktuellesmolekuel.zentrieren(-p2);
   }
 else
   aktuellesmolekuel=undo.pop(str);
 m_refresh2();
}
void m_diederinteraktiv()
{
 for(int i=0;i<4;i++) gdw.atom[i]=aktuellesmolekuel.getsel(i,&gdw.nr[i]);
 if(gdw.atom[3].istleer())
   {janeinrequester("Zuerst 4 Atome selektieren."); return;}
 undo.push(aktuellesmolekuel,"Diederwinkel-aendern");
 diederinteraktiv=2;
 m_refresh();
}
void diederwinkelinteraktiv(double dw)
{
 Vektor3d p1,p2,p3,p4;
 double winkel,w1,w2,w3,w4;
 p2=gdw.atom[1].pos;
 aktuellesmolekuel.zentrieren(p2); p3=gdw.atom[2].pos-p2;
 w1=atan2(p3.z,p3.y); w2=atan2(sqrt(p3.y*p3.y+p3.z*p3.z),p3.x);
 aktuellesmolekuel.drehenzy(w1);
 aktuellesmolekuel.drehenyx(w2);
 p1=aktuellesmolekuel.getatompos(gdw.nr[0]);
 w3=atan2(p1.z,p1.y);
 aktuellesmolekuel.drehenzy(w3);
 p4=aktuellesmolekuel.getatompos(gdw.nr[3]);
 w4=atan2(p4.z,p4.y);
 winkel=w4+dw;
 //Teil des Molekuels drehen:
 aktuellesmolekuel.drehenyzabnr(gdw.nr[2],gdw.nr[1],dw);
 //Gesamtmolekuel zurueckdrehen:
 aktuellesmolekuel.drehenyz(w3);
 aktuellesmolekuel.drehenxy(w2);
 aktuellesmolekuel.drehenyz(w1);
 aktuellesmolekuel.zentrieren(-p2);
}
void diederbeenden(double x0,double y0,double x1,double y1)
{
 changebuffer(0,0); m_refresh();
}

void m_winkelkette()
{
 int na=aktuellesmolekuel.getna();
 int i,ok,nr[na],nn;
 char str1[80],str2[80],str3[80];
 Atom atom[6];
 for(i=0;i<4;i++) atom[i]=aktuellesmolekuel.getsel(i,&nr[i]);
 if(atom[2].istleer() || !atom[3].istleer())
   {janeinrequester("Zuerst genau 3 Atome selektieren: erste beide und letztes der Peptidkette.\n\
Also von der ersten Aminosaeure das N- und nachfolgende C-Atom\n\
und bei der letzten Aminosaeure das letzte C-Atom.");
    return;
   }
 nn=aktuellesmolekuel.peptidkettesuchen(nr[0],nr[1],nr[2],atom,nr);
 if(nn)
  {Vektor3d p1,p2,p3,p4;
   Molekuel molek;
   double winkel[3],w1,w2,w3,w4;
   sprintf(str1,"Diederwinkel %s--%s---%s--%s",
	   atom[0].symbol,atom[1].symbol,atom[2].symbol,atom[3].symbol);
   sprintf(str2,"Diederwinkel %s--%s---%s--%s",
	   atom[1].symbol,atom[2].symbol,atom[3].symbol,atom[4].symbol);
   sprintf(str3,"Diederwinkel %s--%s---%s--%s",
	   atom[2].symbol,atom[3].symbol,atom[4].symbol,atom[5].symbol);
   for(i=0;i<3;i++)
     {molek=aktuellesmolekuel;
      p2=atom[i+1].pos;
      molek.zentrieren(p2);
      p3=molek.getatompos(nr[i+2]);
      w1=atan2(p3.z,p3.y); w2=atan2(sqrt(p3.y*p3.y+p3.z*p3.z),p3.x);
      molek.drehenzy(w1);
      molek.drehenyx(w2);
      p1=molek.getatompos(nr[i]);
      w3=atan2(p1.z,p1.y);
      molek.drehenzy(w3);
      p4=molek.getatompos(nr[i+3]);
      w4=atan2(p4.z,p4.y);
      winkel[i]=w4/GRAD;
     }
   ok=requester_input(3,str1,"%lf","%lf\n",&winkel[0],
		      str2,"%lf","%lf\n",&winkel[1],
		      str3,"%lf","%lf\n",&winkel[2]);
   if(ok)
     {double w5;
      undo.push(aktuellesmolekuel,"Peptidwinkel-aendern");
      for(int j=0;j<nn-3;j++)
	{//Gesamtmolekuel drehen:
	 p2=aktuellesmolekuel.getatompos(nr[j+1]);
	 aktuellesmolekuel.zentrieren(p2);
	 p3=aktuellesmolekuel.getatompos(nr[j+2]);
	 w1=atan2(p3.z,p3.y); w2=atan2(sqrt(p3.y*p3.y+p3.z*p3.z),p3.x);
	 aktuellesmolekuel.drehenzy(w1);
	 aktuellesmolekuel.drehenyx(w2);
	 p1=aktuellesmolekuel.getatompos(nr[j]);
	 w3=atan2(p1.z,p1.y);
	 aktuellesmolekuel.drehenzy(w3);
	 p4=aktuellesmolekuel.getatompos(nr[j+3]);
	 w4=atan2(p4.z,p4.y);
	 //Teil des Molekuels drehen:
	 i=j%3;
	 w5=winkel[i]*GRAD-w4;
	 if(w5!=0) aktuellesmolekuel.drehenyzabnr(nr[j+2],nr[j+1],w5);
	 //Gesamtmolekuel zurueckdrehen:
	 aktuellesmolekuel.drehenyz(w3);
	 aktuellesmolekuel.drehenxy(w2);
	 aktuellesmolekuel.drehenyz(w1);
	 aktuellesmolekuel.zentrieren(-p2);
	}
     }
  }
 else janeinrequester("keine Peptidkette gefunden.");
 m_refresh2();
}

void m_zentrieren()
{
 Atom atom[4];
 int err=0,i;
 char str[200], *text="%s.\n\n\
1 Atom selektiert: auf Mitte zentrieren\n\
2 Atome selektiert: so drehen dass beide auf x-Achse zu liegen kommen\n\
3 Atome selektiert: so drehen dass alle 3 auf x-y-Ebene liegen\n";
 for(i=0;i<4;i++) atom[i]=aktuellesmolekuel.getsel(i);
 if(!atom[3].istleer())
   {err=1; sprintf(str,text,"Hoechstens 3 Atome selektieren");}
 else if(atom[0].istleer())
   {err=1; sprintf(str,text,"Zuerst 1 bis 3 Atome selektieren");}
 if(err) {janeinrequester(str); return;}
 undo.push(aktuellesmolekuel,"Zentrieren");
 aktuellesmolekuel.zentrieren(atom[0].pos);
 if(!atom[1].istleer())//2 Atome selektiert
   aktuellesmolekuel.drehenxachse(atom[1].pos-atom[0].pos);
 if(!atom[2].istleer())//3 Atome selektiert
   {atom[1]=aktuellesmolekuel.getsel(1);
    atom[2]=aktuellesmolekuel.getsel(2);
    aktuellesmolekuel.drehenxyebene(atom[2].pos-atom[1].pos);
   }
 m_refresh();
}
/* void m_search()
{
 janeinrequester("Noch keine Suchfunktion programmiert.");
} */

void atomoderbindungloeschen()
{
 Atom atom1,atom2,atom3;
 int i,na,nr1,nr2,bind,b0,ok,flag=1;
 char str[80];
 atom1=aktuellesmolekuel.getselectedatom(&na);
 if(na<0) return;//kein Atom selektiert
 nr1=na++;
 atom2=aktuellesmolekuel.getselectedatom(&na);
 if(na<0)
   {//einziges markiertes Atom loeschen
    undo.push(aktuellesmolekuel,"Atom-loeschen");
    aktuellesmolekuel.atomloeschen(nr1);
    m_refresh();
    return;
   }
 nr2=na++;
 atom3=aktuellesmolekuel.getselectedatom(&na);
 if(na>0) return;//wenn mehr als 2 Atome selektiert: nichts loeschen
 undo.push(aktuellesmolekuel,"Bindung-loeschen");
 aktuellesmolekuel.delbindung(nr1,nr2);
 m_refresh();
}

//Menu Zeichnen:
static long menu_ids[150]; /* Anzahl Menus * Maximale Anzahl Einträge */
const int NZEI=8;//Anzahl Submenus m_zei..
static int zeichnungsmodus=0;
static long zei_ids[NZEI];
static char txt_zeia[]="%R automatisch",
            txt_wass[]="%r Wasserstoff (H)",
            txt_kohl[]="%r Kohlenstoff (C)",
            txt_saue[]="%r Sauerstoff (O)",
            txt_stic[]="%r Stickstoff (N)",
            txt_ch3[]= "%r Methyl (CH3)",
            txt_cooh[]="%r Saeure (COOH)",
            txt_rueck[]="%r Jedesmal Rueckfrage";
static char *txt_zei[NZEI]=
  {txt_zeia,txt_wass,txt_kohl,txt_saue,txt_stic,
   txt_ch3,txt_cooh,
   txt_rueck};
void dings_umschalten(long id,long *idfeld,int n,int j,char **txt,int o,int O)
{
 int i;
 for(i=0;i<n;i++)  txt[i][1]=(i==j)?O:o;
 if(*idfeld==0) {if(id) getmenuids(id,idfeld); else return;}
 for(i=0;i<n;i++)  changemenu(idfeld[i],txt[i]);
}

void zei_umschalt(long id,int n)
{
 zeichnungsmodus=n;
 dings_umschalten(id,zei_ids,NZEI,n,txt_zei,'r','R'); m_refresh();
}
void m_zeia(long id) {zei_umschalt(id,0);}
void m_zeih(long id) {zei_umschalt(id,1);}
void m_zeic(long id) {zei_umschalt(id,2);}
void m_zeio(long id) {zei_umschalt(id,3);}
void m_zein(long id) {zei_umschalt(id,4);}
void m_zeich3(long id) {zei_umschalt(id,5);}
void m_zeicooh(long id) {zei_umschalt(id,6);}
//hier neue m_zei.. Submenus, NZEI erhoehen
void m_zeirueck(long id) {zei_umschalt(id,NZEI-1);}

void m_zeiload()
{
 loadxyz(1);
}

void m_stereo()
{
 int ok;
 if(stereoflag)
   {Molekuel molekuel;
    char text[80];
    stereoflag=0;
    molekuel=undo.pop(text);
    if(*text==0)
      {janeinrequester("Undo-Stapel ist leer."); ok=0;}
    else if(strcmp(text,"Stereobild")==0)
      {aktuellesmolekuel=molekuel; ok=1;}
    else
      {undo.push(molekuel,text); ok=0;}
    if(ok==0)
      {janeinrequester("kann Stereobildzeichnen nicht automatisch zuruecknehmen.");
       m_refresh2();
       return;
      }
   }
 ok=requester_input(3,"Abstand zwischen den Beiden Ansichten","%lg","%lf\n",
		    &stereox0,
		    "Kamera z (sollte etwa 80 sein)","%lf","%lf\n",
		    &kamera.z,
		    "Kamera Brennweite","%lf","%lf",&brennweite);
 if(ok)
   {undo.push(aktuellesmolekuel,"Stereobild"); 
    anfuegmolekuel=aktuellesmolekuel;
    aktuellesmolekuel.anfuegen(stereox0,anfuegmolekuel);
    anfuegmolekuel.clear();
    stereoflag=1;
   }
 m_refresh2();
}

/*********** Unterprogramme fuer Tasten-Kurzbefehle *******************/
void messungstart(int w)
{
 shifttaste=1; winkelmessung=w; aktuellesmolekuel.unselect(); m_refresh();
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char quellname[80],zielname[80];
 quellname[0]=zielname[0]=0;
 FILE *fp1,*fp2;
 int i,j,c,visklasse;
 if(argc<=0)
   ;/* es wurde von WorkBench gestartet */
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
		 else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("molz3d  %s\n",VERSION);
	 printf("Anwendung: molz3d -flags [Quelle] [Ziel]\n");
	 printf("  Flags: v=verbose (Testausdrucke)\n");
	 exit(0);
	}
 //tek_setdebug(1);//test
 getmaxsize(&gbreite,&ghoehe,&gtiefe,&visklasse);
 if(gtiefe<24) constfarbeneusetzen();
 if(gtiefe>TIEFE) gtiefe=TIEFE;
 setsize(gbreite,ghoehe,gtiefe);
 setmenu(5,"File",       "Edit",       "Darstellung",  "Zeichnen",  "Hilfe");
 setmenu(5,"Load...",    "undo...",    "Parameter...","Anfuegen  ->","Hilfe",
	 &m_load,&m_undo,&m_param,NULL,&m_hilfe);
 setsubmenu(4,NULL,NULL,NULL,txt_zeia,NULL,NULL,NULL,m_zeia);
 setsubmenu(4,NULL,NULL,NULL,txt_wass,NULL,NULL,NULL,m_zeih);
 setsubmenu(4,NULL,NULL,NULL,txt_kohl,NULL,NULL,NULL,m_zeic);
 setsubmenu(4,NULL,NULL,NULL,txt_saue,NULL,NULL,NULL,m_zeio);
 setsubmenu(4,NULL,NULL,NULL,txt_stic,NULL,NULL,NULL,m_zein);
 setsubmenu(4,NULL,NULL,NULL,txt_ch3,NULL,NULL,NULL,m_zeich3);
 setsubmenu(4,NULL,NULL,NULL,txt_cooh,NULL,NULL,NULL,m_zeicooh);
 setsubmenu(4,NULL,NULL,NULL,txt_rueck,NULL,NULL,NULL,m_zeirueck);
 setmenu(4,"Save...","%AN Select Next","Kamera...","Molekuel anfuegen...",
	 &m_save,&m_selnext,&m_kamera,&m_zeiload);
 setmenu(4,"Load xyz...","Select All", "Rotieren ein/aus","Stereobild...",
	 &m_loadxyz,&m_selall,&m_rotieren,&m_stereo);
 setmenu(3,"Save xyz...","Edit Atom...","%AY Refresh",
	 &m_savexyz,&m_editatom,&m_refresh);
 setmenu(3,"Exit","Edit Bond...","Zentrieren",
	 &menu_exit,&m_editbond,m_zentrieren);
 setmenu(2,NULL,  "Edit Winkel...",NULL,&m_editwinkel);
 setmenu(2,NULL,  "DiederWinkel...",NULL,&m_diederwinkel);
 setmenu(2,NULL,  "New Atom...",NULL,&m_neuatom);
 setmenu(2,NULL,  "DiederWinkel interaktiv aendern",NULL,&m_diederinteraktiv);
 setmenu(2,NULL,  "Alle Winkel in Peptidkette aendern...",NULL,&m_winkelkette);
 //setmenu(2,NULL,  "Search...",NULL,&m_search);
 set_funktions(mauspre,mausrel,NULL,mausmot);
 inital(gxmin,gymin,gxmax,gymax); /* Grafikfenster oeffnen */
 if(gtiefe<24) farben_init();
 term_refresh();
 inital_new();
 waitBOF();//provi. (offenbar Fehler im xtekplot)
 rgbscreenclear(higrund_r,higrund_g,higrund_b);
 if(*quellname!=0) dateiladen(quellname);
 int taste,asci; ULONG rawcode;
 //Hauptschlaufe:
 while(exitflag==0 && waitmenu(0)==0)
  {waitBOF();		//auf Ende des Bildaufbaus warten
   if(keyget(&taste,&asci,&rawcode)!=0)
     {if(rawcode>='a' && rawcode<='z') shifttaste=0;
      switch(rawcode)
	{case 0xFF51: case 0xFF52: case 0xFF53: case 0xFF54://Pfeiltasten
			kamerafahren(rawcode-0xFF50,8);
	 //CASE 0xFF1B: case 0xFFE3: //Esc oder Ctrl
	 CASE 0xFFFF: case 0xFF60: case 0xFF08://Delete oder Backspace
			shifttaste=0; atomoderbindungloeschen();
	 CASE 0xFFE1: case 0xFFE2://Shifttaste
			shifttaste ^= 1; //zum mehrere Atome selektieren
	 CASE 0xFFE5://CapsLock
			shifttaste = 1; //zum mehrere Atome selektieren
	 CASE 0xFF55: kamerafahren(2,2);//Page Up
	 CASE 0xFF56: kamerafahren(4,2);//Page Down
	 CASE 'y': case 'z': case 'Y': case 'Z': m_refresh();
	 CASE 'N': shifttaste=1; case 'n': m_selnext();
	 CASE 'Q': shifttaste=1; case 'q':
	       winkelmessung=0; aktuellesmolekuel.unselect(); m_refresh();
	 CASE 't': case 'T': rotationsrichtung^=1; if(rotationsflag==1) break;
	 case 'r': case 'R':
	       switch(rotationsflag)
		 {case 0: case 2: rotationsflag=1; changebuffer(0,1);
		  CASE 1: rotationsflag=2; changebuffer(0,0); m_refresh();
		 }
	 CASE 'a': case 'A': messungstart(1);
	 CASE 'b': case 'B': messungstart(2);
	 CASE 'w': case 'W': messungstart(3);
	 CASE 'd': case 'D': messungstart(4);
	 CASE 'i': case 'I': diederinteraktiv=1; messungstart(4);
	 DEFAULT:
	   shifttaste=0; 
	   if(test) printf("taste=%d=%02X asci=0x%02X='%c' rawcode=0x%04X\n",
			    taste,taste,asci,asci,rawcode);
	}
     }
   else if(rotationsflag==1)
     {//Darstellung automatisch rotieren
      aktuellesmolekuel.zeichnen(hintergrundfarbnr);
      if(rotationsrichtung==0)
	{rotationswinkel += 1*GRAD;
	 if(rotationswinkel>=2*PI) rotationswinkel -= 2*PI;
	}
      else
	{rotationswinkel -= 1*GRAD;
	 if(rotationswinkel<= -2*PI) rotationswinkel += 2*PI;
	}
      aktuellesmolekuel.zeichnen();
      changebuffer(0,1);
     }
  }
 if(nochnichtgespeichert)
   {if(janeinrequester("Aktuelles Molekuel speichern?"," ja ","nein"))
     m_savexyz();
   }
 term_exit();
 return 0;
}/* ende von main */

void dateiladen(char *name,int anfuegflag)
{
 char zeile[80],atomname[80],sym[4],*s;
 int c,c1,c2;
 double x,y,z;
 FILE *fp=fopen(name,"r");
 if(fp==NULL) {printf("Datei '%s' nicht gefunden.\n",name); return;}
 undo.push(aktuellesmolekuel,"Molekuel-laden");
 aktuellesmolekuel.clear();
 if(istendung(name,".pov"))
 {int nbindungen=0,n1,n2,nb;
  while(getline(fp,zeile,80))
   {if(strncmp(zeile,"sphere {",8)==0)
      {getline(fp,zeile,80);
       for(s=zeile;(c= *s++)!='<' && c!=0;) ;
       sscanf(s,"%lf,%lf,%lf>,%s",&x,&y,&z,atomname);
       c1=atomname[0]; c2= -1;
       if(strcmp(&atomname[2],"radius")==0) c2=atomname[1];
       else if(strcmp(&atomname[1],"radius")==0) c2=0;
       else printf("Fehler: x=%lf y=%lf z=%lf zeile='%s' atomname='%s'\n",
		   x,y,z,zeile,atomname);//test
       if(c2>=0)
	 {sym[0]=c1; sym[1]=c2; sym[2]=0;
	  aktuellesmolekuel.put(sym,x,y,z);
	 }
      }
    else if(strncmp(zeile,"//bond",6)==0)
      {//z.B. "//bond 0 1 2" waere eine Doppelbindung zw. Atom0 und Atom1
       sscanf(&zeile[6],"%d %d %d",&n1,&n2,&nb); if(nb==0) nb=1;
       aktuellesmolekuel.putbindung(n1,n2,nb);
       nbindungen++;
      }
    else if(strncmp(zeile,"camera {",8)==0)
      {while(getline(fp,zeile,80) && *zeile!='}')
	{for(s=zeile;(c= *s)!=0 && isspace(c);s++) ;
	 if(strncmp(s,"location",8)==0) vektoreinlesen(&s[8],kamera);
	 else if(strncmp(s,"look_at",7)==0) vektoreinlesen(&s[7],lookat);
	 else if(strncmp(s,"sky",3)==0) vektoreinlesen(&s[3],sky);
	 else if(strncmp(s,"angle",5)==0)
	   {double angle; sscanf(&s[5],"%lf",&angle);
	    brennweite=(gxmax-gxmin)/2/tan(angle*GRAD/2);
	   }
	}
      }
   }
  if(nbindungen==0)
    aktuellesmolekuel.autoputbind();
  if(anfuegflag==0) nochnichtgespeichert=0;
 }
 else if(istendung(name,".xyz"))
 {int natome=0,nbindungen=0,n1,n2,nb;
  fscanf(fp,"%d %d",&natome,&nbindungen);
  if(natome<1 || natome>10000)
    printf("Fehler: in xyz-Datei fehlende Anzahl Atome. (%d)\n",natome);
  else
   {for(int i=0;i<natome;i++)
      {fscanf(fp,"%s %lf %lf %lf",atomname,&x,&y,&z);
       c1=atomname[0]; c2=atomname[1];
       sym[0]=c1; sym[1]=c2; sym[2]=0;
       aktuellesmolekuel.put(sym,x,y,z);
      }
    if(nbindungen==0)
      aktuellesmolekuel.autoputbind();
    else
      for(int i=0;i<nbindungen;)
	if(getline(fp,zeile,80) && *zeile!=0)
	{nb=0; sscanf(zeile,"%d %d %d",&n1,&n2,&nb); if(nb==0) nb=1;
	 if(n1<0 || n2<0 || n1>=natome || n2>=natome || n1==n2)
	      printf("Syntax-Fehler in '%s'\n",name);
	 else aktuellesmolekuel.putbindung(n1,n2,nb);
	 i++;
	}
   }
  if(anfuegflag==0) nochnichtgespeichert=0;
 }
 else printf("Bisher nur .pov und .xyz Dateien lesbar.\n");
 fclose(fp);
 if(anfuegflag)
   {anfuegmolekuel=aktuellesmolekuel;
    aktuellesmolekuel=undo.pop(zeile);
   }
 m_refresh2();
}

/************************ Mausauswertungen ****************************/
bool imrandbereich(double x,double y,double x0,double y0)
{
 if(gdx==0) gdx=(gxmax-gxmin)/16;
 if(x>gxmin+gdx && x<gxmax-gdx &&
    y>gymin+gdx && y<gymax-gdx) return 0;
 if(x0>gxmin+gdx && x0<gxmax-gdx &&
    y0>gymin+gdx && y0<gymax-gdx) return 0;
 return true;
}

void methylanfuegen(int a,Vektor3d p1)
{
 Molekuel methyl;
 methyl.put("C", 0.0, 0.0, 0.0);
 methyl.put("H", 0.356667, 0.0,     -1.0088057, 0);
 methyl.put("H", 0.356667, 0.873651, 0.504403, 0);
 methyl.put("H", 0.356667,-0.873651, 0.504403, 0);
 aktuellesmolekuel.anfuegen(a,p1,methyl);
}
void coohanfuegen(int a,Vektor3d p1)
{
 Molekuel cooh;
 cooh.put("C", 0.0, 0.0, 0.0);
 cooh.put("O", 0.645, 1.117173, 0.0, 0, 2);
 cooh.put("O", 0.755,-1.307698, 0.0, 0);
 cooh.put("H", 1.795,-1.307698, 0.0, 2);
 aktuellesmolekuel.anfuegen(a,p1,cooh);
}
void molekuelanfuegen(int a,Vektor3d p1)
{
 aktuellesmolekuel.anfuegen(a,p1,anfuegmolekuel);
 anfuegmolekuel.clear();
}
void Molekuel::anfuegen(int nr1,Vektor3d p1,Molekuel& molek)
{
 Vektor3d p, p0=atom[nr1].pos, q0;
 int i,n,nr2;
 double alfa,beta;
 if(molek.na<2) {printf("Fehler: ungueltiges Molekuel.\n"); return;}//test
 //Atome kopieren:
 p=p1-p0;
 alfa=atan2(p.z,p.y);
 beta=atan2(sqrt(p.y*p.y+p.z*p.z),p.x);
 q0=molek.atom[0].pos;
 for(i=0;i<molek.na;i++)
   {p=molek.atom[i].pos-q0;
    p.drehenxy(beta); p.drehenyz(alfa);
    p+=p1;
    n=put(molek.atom[i].symbol, p.x, p.y, p.z);
    if(i==0) putbindung(nr1,nr2=n,1);
   }
 //Bindungen kopieren:
 int n1,n2;
 for(i=0;i<molek.nb;i++)
   {n1=molek.bind[i].a[0];
    n2=molek.bind[i].a[1];
    n=molek.bind[i].n;
    putbindung(n1+nr2,n2+nr2,n);
   }
}

void Molekuel::anfuegen(double x0,Molekuel& molek)
{
 Vektor3d p;
 int i,n,nr2;
 if(molek.na<2) {printf("Fehler: ungueltiges Molekuel.\n"); return;}//test
 //Atome kopieren:
 for(i=0;i<molek.na;i++)
   {p=molek.atom[i].pos;
    n=put(molek.atom[i].symbol, p.x+x0, p.y, p.z);
    if(i==0) nr2=n;
   }
 //Bindungen kopieren:
 int n1,n2;
 for(i=0;i<molek.nb;i++)
   {n1=molek.bind[i].a[0];
    n2=molek.bind[i].a[1];
    n=molek.bind[i].n;
    putbindung(n1+nr2,n2+nr2,n);
   }
}

void zeichnenbeenden(double x0,double y0,double x1,double y1)
{
 Vektor3d p0(x0,y0,0),p1(x1,y1,0);
 int nr1,nr2,ok=1;
 static char symbol[80]="H";
 undo.push(aktuellesmolekuel,"Zeichnen"); 
 Atom atom=aktuellesmolekuel.getsel(0,&nr1);
 if(atom.istleer())
   {printf("Fehler: fehlendes selektiertes Atom beim Zeichnen.\n"); return;}
 double z=atom.pos.z;
 //p0=rueckprojektion(projektion(atom.pos),z);//provi.
 p1=rueckprojektion(p1,z);
 atom.pos=p1;
 //atom.pos+=p1-p0;//provi.
 if((nr2=aktuellesmolekuel.checkpos(p1))>=0)//wenn schon ein Atom hier
   {aktuellesmolekuel.putbindung2(nr1,nr2);//dann zusaetzliche Bindung zeichnen
    m_refresh(); return;
   }
 if(!anfuegmolekuel.istleer())
   {molekuelanfuegen(nr1,atom.pos);
    m_refresh(); return;
   }
 switch(zeichnungsmodus)
   {case 0: strcpy(symbol,atom.symbol);
    CASE 1: strcpy(symbol,"H");
    CASE 2: strcpy(symbol,"C");
    CASE 3: strcpy(symbol,"O");
    CASE 4: strcpy(symbol,"N");
    CASE 5: strcpy(symbol,"CH3");
    CASE 6: strcpy(symbol,"COOH");
    DEFAULT:
       ok=requester_input(1,"Anzufuegendes Atom oder Molekuel","%s","%s",
			  symbol);
   }
 if(ok)
   {if(strlen(symbol)<3)
     {nr2=aktuellesmolekuel.put(symbol,atom.pos.x,atom.pos.y,atom.pos.z);
      aktuellesmolekuel.putbindung(nr1,nr2,1);
     }
    else
     {if(strcmp(symbol,"CH3")==0) methylanfuegen(nr1,atom.pos);
      else if(strcmp(symbol,"COOH")==0) coohanfuegen(nr1,atom.pos);
      else janeinrequester("Nicht im internen Speicher\n\
Vielleicht Menu <Molekuel anfuegen...> benutzen.");
     }
   }
 m_refresh();
}

void winkelmess()
{
 int w=winkelmessung,i;
 winkelmessung=0;
 if(w==1 && aktuellesmolekuel.getnsel()==2)
   {for(i=0;i<20;i++) waitBOF();//kurze Verzoegerung damit man
    editbond(1);                //den Unterschied sieht.
   }
 else if(w==2 && aktuellesmolekuel.getnsel()==2) m_editbond();
 else if(w==3 && aktuellesmolekuel.getnsel()==3) m_editwinkel();
 else if(w==4 && aktuellesmolekuel.getnsel()==4)
   {if(diederinteraktiv) m_diederinteraktiv();
    else m_diederwinkel();
   }
 else winkelmessung=w;
}

void mausbewegung(int flag)
{
 double x,y,winkel;
 static double x0,y0,x1,y1;
 int tasten;
 static int drehflag=0,zeichnenflag=0;
 tasten=mausposition(&x,&y);
 if(flag==1) //Maustaste gedrueckt
   {
    if(zeichnenflag || drehflag) //passieren wenn Mausrelease verpasst wurde
       {zeichnenflag=drehflag=0;}
    if(diederinteraktiv>=2) ;//kein weiteres Atom selektieren
    else aktuellesmolekuel.select(x,y);
    gedruecktemaustaste=1; x0=x; y0=y;
    m_refresh();
    if(winkelmessung) winkelmess();
   }
 else if(flag==2) //Maustaste losgelassen
   {
    //if(test) printf("Maustaste losgelassen Position=%lf %lf\n",x,y);//test
    if(drehflag) {changebuffer(0,0); m_refresh(); drehflag=0;}
    if(zeichnenflag) {zeichnenbeenden(x0,y0,x,y); zeichnenflag=0;}
    if(diederinteraktiv>=2)
      {if(diederinteraktiv==2) diederinteraktiv++;
       else {diederbeenden(x0,y0,x,y); diederinteraktiv=0;}
      }
    gedruecktemaustaste=0;
   }
 else if(flag==4) //verlorenes Mausrelease-Event korrigieren
   {
    if(drehflag) {changebuffer(0,0); m_refresh(); drehflag=0;}
    zeichnenflag=0;
    gedruecktemaustaste=0;
   }
 //Mausbewegung mit gedrueckter Maustaste:
 else if(diederinteraktiv) //Diederwinkel interaktiv aendern
   {if(diederinteraktiv<2 || y==y0) return;
    winkel=2*PI/(gymax-gymin)*(y-y0);
    diederwinkelinteraktiv(winkel);
    y0=y; x0=x;
    m_refresh(); changebuffer(0,1);
   }
 else if(imrandbereich(x,y,x0,y0)) //Mausbewegung im Randbereich
   {
    if(rotationsflag==1)
      {rotationsflag=2; changebuffer(0,0); m_refresh(); return;}
    if(drehflag==0)
      {undo.push(aktuellesmolekuel,"Drehen"); drehflag=1;}
    if((x<gxmin+gdx && x0<gxmin+gdx) || (x>gxmax-gdx && x0>gxmax-gdx))
      {//am linken oder rechten Rand --> Rotation um x-Achse
       winkel=PI/(gymax-gymin)*(y-y0);
       aktuellesmolekuel.drehenyz(winkel);
       y0=y; x0=x;
       m_refresh(); changebuffer(0,1);
      }
    else if(y<gymin+gdx && y0<gymin+gdx) //am unteren Rand
      {//Rotation um y-Achse
       winkel=PI/(gymax-gymin)*(x-x0);
       aktuellesmolekuel.drehenxz(winkel);
       y0=y; x0=x;
       m_refresh(); changebuffer(0,1);
      }
    else if(y>gymax-gdx && y0>gymax-gdx) //am oberen Rand
      {//Rotation um z-Achse
       winkel=PI/(gymax-gymin)*(x-x0);
       aktuellesmolekuel.drehenyx(winkel);
       y0=y; x0=x;
       m_refresh(); changebuffer(0,1);
      }
   }
 //Mausbewegung (mit gedrueckter Taste) im Mittelbereich:
 else if(aktuellesmolekuel.getnsel()==1)
   {
    if(rotationsflag>0) {m_rotieren(); return;}
    if(zeichnenflag==0)
      {double wenigepixel=(gxmax-gxmin)/100;
       if(abs(x-x0)<wenigepixel && abs(y-y0)<wenigepixel) return;
       zeichnenflag=1;
      }
    else linie(higrund_r,higrund_g,higrund_b,x0,y0,x1,y1);
    linie(255,0,0,x0,y0,x1=x,y1=y);
   }
}
void mauspre() {mausbewegung(1);}
void mausrel() {mausbewegung(2);}
void mausmot()
{
 if(gedruecktemaustaste)
   {if(winkelmessung)
      mausbewegung(4); //eventuell verlorener Mausrelease-Event korrigieren
    else
      mausbewegung(3);
   }
}
