/* xyz2pdb.cc			letzte Aenderung: 13.3.2009 */
#define VERSION "Version 0.0"
/*
 xyz-Datei nach pdb-Datei umwandeln (fuer export nach BallView)

History:
13.3.2009	Erstellung (RP)
17.6.2013       Anpassung an neue gcc-version
*/

#include <iostream>

//using namespace std;
#include <stdio.h>
#include <string.h>

#include <stdlib.h>

/************************* Vordeklarationen ***************************/
void printatom(FILE *fp2,char *atom,double x,double y,double z);
void printbindung(FILE *fp2,int n1,int n2,int n3);

/**************************** kleinkram *******************************/
char *ohneletztenpunkt(char *name)  /* die Endung .xxx loeschen */
{
 char c=0,*s; int i;
 for(i=0,s=name;*s!=0;s++,i++) ;
 while(i>0 && (c= *s)!='.')
        {--i; --s;}
 if(c=='.') *s='\0';
 return name;
}

char *anhaengen(char *s,const char *t)  /* s + t --> s */
{
 char *p;
 for(p=s;*p!=0;p++) ;
 for(;*p++ = *t++;) ;
 return s;
}

char *endungersetzen(char *neu,const char *name,const char *endung)
{
 strcpy(neu,name); ohneletztenpunkt(neu);
 return anhaengen(neu,endung);
}

int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
static int test=0; //Testausdrucke (0=ohne 1=mit 2=noch mehr)
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
   if(c=='V') test++;
  }
}

/****************** Klassen und Globale Variablen *********************/
/** einfache globale Variablen: **/

/********************** weiterer Kleinkram ****************************/

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char quellname[80],zielname[80],zeile[80],atom[80];
 quellname[0]=zielname[0]=0;
 FILE *fp,*fp2;
 int i,j,c,visklasse;
 if(argc<=0 || (argc==1 && *argv[0]=='/'))
   {j=0;/* es wurde von WorkBench (Amiga) oder von z.B. KDE (Linux) gestartet */
   }
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
		 else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("xyz2pdb  %s\n",VERSION);
	 printf("Anwendung: xyz2pdb Quelle.xyz [Ziel.pdb]\n");
	 printf("  Flags: v=verbose (Testausdrucke)\n");
	 exit(0);
	}
 if(*quellname==0) {printf("Quellname:"); scanf("%s",quellname);}
 if(*zielname==0)
  {endungersetzen(zielname,quellname,".pdb");
  }
 fp=fopen(quellname,"r");
 if(fp==NULL) {printf("Fehler: '%s' nicht gefunden.\n",quellname); exit(0);}
 fp2=fopen(zielname,"w");
 if(fp2==NULL) {printf("Fehler: kann '%s' nicht erstellen.\n",zielname);}
 else
  {int natome,nbindungen,n,n1,n2,n3;
   double x,y,z;
   getline(fp,zeile,80);
   sscanf(zeile,"%d %d",&natome,&nbindungen);
   for(i=0;i<natome;i++)
    {getline(fp,zeile,80);
     sscanf(zeile,"%s %lf %lf %lf",atom,&x,&y,&z);
     printatom(fp2,atom,x,y,z);
    }
   for(i=0;i<nbindungen;i++)
    {getline(fp,zeile,80);
     n=sscanf(zeile,"%d %d %d",&n1,&n2,&n3);
     if(n<3) n3=1;
     if(n>=2) printbindung(fp2,n1,n2,n3);
     else printf("Fehler: zeile='%s'\n",zeile);//test
    }
   fprintf(fp2,"ENDMDL\n");
   fclose(fp2);
  }
 fclose(fp);
 return 0;
}/* ende von main */

/*
Typische Zeilen in pdb-Datei:
RTyp  Num  Atm Res Ch  ResN X       Y       Z      Occ  Temp   PDB   Line
ATOM    1  N   ASP L   1    4.060   7.307   5.186  1.00 51.58  1FDL  93
ATOM      2  CA  ASP L   1       4.042   7.776   6.553  1.00 48.05      1FDL  94
ATOM      1  C   ACE     0      31.227  38.585  11.521  1.00 25.00      1AL1  50
HETATM    5 2H   ACE A 100       6.766  -5.398  17.355  1.00  6.83           H
HETATM 1094  HO2AMPD   513     -10.048   1.865  17.765  0.55 51.47           H  
CONECT    1    2    3    7
CONECT    2    1
END
*/
void printbindung(FILE *fp2,int n1,int n2,int n3)
{
 fprintf(fp2,"CONECT%5d%5d\n",n1+1,n2+1);
 //keine Ahnung wie man Doppelbindungen (n3=2) oder Dreifachbindungen (n3=3) definiert
}

void printatom(FILE *fp2,char *atom,double x,double y,double z)
{
 static int nr=1,resSeq=1;
 static char altLoc=' ',*resName="   ",chainID=' ',iCode=' ',*element="  ",*charge="  ";
 int c;
 double occupancy=1.0,tempFactor=25.0;
 fprintf(fp2,"ATOM  %5d  %-3s%c%3s %c%4d%c   %8.3lf%8.3lf%8.3lf%6.2lf%6.2lf           %2s%2s\n",
	 nr++,atom,altLoc,resName,chainID,resSeq,iCode,x,y,z,occupancy,tempFactor,element,charge);
}
/*
Atom:
COLUMNS      DATA TYPE        FIELD      DEFINITION
------------------------------------------------------
 1 -  6      Record name      "ATOM    "
 7 - 11      Integer          serial     Atom serial number.
13 - 16      Atom             name       Atom name.
17           Character        altLoc     Alternate location indicator.
18 - 20      Residue name     resName    Residue name.
22           Character        chainID    Chain identifier.
23 - 26      Integer          resSeq     Residue sequence number.
27           AChar            iCode      Code for insertion of residues.
31 - 38      Real(8.3)        x          Orthogonal coordinates for X in 
                                         Angstroms
39 - 46      Real(8.3)        y          Orthogonal coordinates for Y in 
                                         Angstroms
47 - 54      Real(8.3)        z          Orthogonal coordinates for Z in 
                                         Angstroms
55 - 60      Real(6.2)        occupancy  Occupancy.
61 - 66      Real(6.2)        tempFactor Temperature factor.
77 - 78      LString(2)       element    Element symbol, right-justified.
79 - 80      LString(2)       charge     Charge on the atom.
*/
