/* eed.cc			letzte nderung: 14.2.2006 */
#define VERSION "Version 0.0"
/*

 eed = Einfacher Editor
 Nicht wirklich nuetzlich zum Brauchen, sondern als Beispielprogramm
 gedacht, um die Funktionen von xtekplot1 auszuprobieren.

History:
31.1.2000	Erstellung (RPf)

*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <ctype.h>
#include <xtekplot1.h>

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/************************* Vordeklarationen ***************************/

/********************** Klassen-Deklarationen *************************/
class Cursor
{
 char *buffer; //Startposition des dargestellten Bereichs
 double bx,hy,za; //Buchstaben-breite, -hoehe, Zeilenabstand
 int ipos; //Position im Puffer
 double x0,y0,xpos,ypos; //Start-Position, Aktuelle-Position auf dem Fenster
 int zflag; //gesetzt wenn Cursor gezeichnet ist
public:
 Cursor() {zflag=0;}
 void setbuffer(char *b) {buffer=b; ipos=0;}
 void setxy(double x,double y,double b=0,double h=0);
 char& operator[](int i) {return buffer[ipos+i];}
 void zeichnen();
 void loeschen();
};

class Fenster
{
 int maxcol;
 int breite,hoehe,tiefe,visklasse; //Fenstergroesse
 double xmin,ymin,xmax,ymax; //Userkoordinaten
 int ibx,ihy; double bx,hy; //Schriftgroessen
 char *font;
 char *buffer; int buffersize,geaendertflag;
 char dateiname[200];
 Cursor cursor;
public:
 Fenster(char*,int b=1280,int h=1024,int t=8);
 ~Fenster();
 int run(char *text=NULL);
 void setfont(int b=9,int h=14,char *f="*courier*medium*-r-*normal*");
 void save();
};

/************************* Men Behandlung ****************************/
static int exitflag=0;
class Fenster *editorfenster;
void m_exit() {exitflag=1;}
void m_save() {editorfenster->save();}

/***************************** Klassen ********************************/
void Fenster::setfont(int b,int h,char *f)
{
 ibx=b; ihy=h; font=f;
 ihy=itextsize(ibx,ihy,font);
 deltakoordpix2user(ibx,ihy,&bx,&hy);
 buffer=NULL; buffersize=0; geaendertflag=0;
}
Fenster::Fenster(char *name,int br,int ho,int ti)
{
 xmin= -0.1; ymin=0.0; xmax=1.1; ymax=1.0;
 // bx=(xmax-xmin)/100; hy=(ymax-ymin)/40;
 //tek_setdebug(1);//test 1=wenige Testpunkte, 2=viele + Fontauswahl
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 hoehe -= 40; //wegen dem Menubalken des MacOSX noetig
 if(breite>br) breite=br;
 if(hoehe>ho) hoehe=ho;
 if(tiefe>ti) tiefe=ti;
 maxcol=(1<<tiefe);
 setsize(breite,hoehe,tiefe);
 setmenu(1,"File");
 setmenu(1,"Save ...",&m_save);
 setmenu(1,"Exit",&m_exit);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 set_tektitel(name);
 screenclear(1); color(0); setfont();
 term_refresh();
}
Fenster::~Fenster()
{
 if(geaendertflag) save();
 term_exit();
 if(buffer!=NULL) delete buffer;
}

void Cursor::zeichnen()
{
 if(zflag==0)
   {drawmode(COMPLEMENT);
    drawbox(xpos,ypos,xpos+bx,ypos+hy);
    drawmode(JAM1);
    zflag=1;
   }
}
void Cursor::loeschen()
{
 if(zflag==1)
   {drawmode(COMPLEMENT);
    drawbox(xpos,ypos,xpos+bx,ypos+hy);
    drawmode(JAM1);
    zflag=0;
   }
}
void Cursor::setxy(double x,double y,double b,double h)
{
 if(b!=0)
   {bx=b; hy=h; za=1.5*h;  xpos=x0=x; ypos=y0=y;}
 else
   {int i,c,ns,nz,nspalten=int((x-x0)/bx), nzeilen=int((y0-y)/za+0.9);
    for(i=0,nz=0,ns=0;(c=buffer[i])!=0 && (ns<nspalten || nz<nzeilen);i++)
      {if(c=='\n')
	{if(nz<nzeilen) {nz++; ns=0;}
	 else if(ns<nspalten) {nspalten=ns; --i;}
	}
       else ns++;
      }
    xpos=x0+ns*bx;
    ypos=y0-nz*za;
    ipos=i;
   }
}

/*************************** Filelaenge *******************************/
const int BLOCKS=0, BYTES=1;
int filelaenge(char *name,int flag=BYTES);

#undef FILELAENGE

#ifdef unix
#include <sys/types.h>
#include <sys/stat.h>
//#include <ourhdr.h>

int filelaenge(char *name,int flag)
{
 struct stat buf;
 int n;
 if(lstat(name,&buf)<0) return -1;
 if(!S_ISREG(buf.st_mode)) return -2;
//fuer Inhalt von buf siehe "man lstat"
 if(flag==BLOCKS) n=buf.st_blocks;
 else n=buf.st_size;
 return n;
}
#define FILELAENGE
#endif

#ifdef VAX
int filelaenge(char *name,int flag)
{
 char str[80];
 FILE *fp;
 int n;
 if(flag==BLOCKS)
  {sprintf(str,"DIR/SIZ/output=temp.dat %s;",name); system(str);
   fp=fopen("temp.dat","r");
   if(fp==NULL) return -3;
   if(fscanf(fp,"%*s %*s %*s %d",&n)!=1) n= -2;
   fclose(fp);
   system("DEL temp.dat;");
  }
 else
  {fp=fopen(name,"r");
   if(fp==NULL) return -1;
   for(n=0;getc(fp)!=EOF;n++)  ;
   fclose(fp);
  }
 return n;
}
#define FILELAENGE
#endif

#ifndef FILELAENGE
// auf unbekanntem System

int filelaenge(char *name,int flag)
{
 char str[80];
 FILE *fp;
 int n;
 const int blockgroesse=512;
 if(!(fp=fopen(name,"rb"))) return -1;
 for(n=0;(c=getc(fp))!=EOF;n++)  ;
 fclose(fp);
 if(flag==BLOCKS) n=(n+blockgroesse-1)/blockgroesse;
 printf("filelaenge('%s',%d) --> %d\n",name,flag,n);//test
 return n;
}
#endif

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 int c,j,i;
 char fenstername[80],filename[80];
 filename[0]=0;
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(filename,argv[i]);
		 //else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("eed  %s\n",VERSION);
	 printf("Anwendung: eed Dateiname\n");
	 exit(0);
	}
 sprintf(fenstername,"eed  %s",VERSION);
 if(filename[0]==0) {printf("Filename:"); scanf("%s",&filename);}
 Fenster meinfenster(fenstername,1024,768,8);
 editorfenster= &meinfenster;
 editorfenster->run(filename);
 return 0;
}/* ende von main */

char *nextzeile(char *s)
{
 int c;
 while((c= *s++) && c!='\n') ;
 return s;
}
int setnextlf(char *s,int neu)
{
 int c;
 while((c= *s) && c!='\n') s++;
 *s=neu;
 return c;
}

int Fenster::run(char *name)
{
 int n,c;
 FILE *fp=NULL;
 char *s;
 n=filelaenge(name,BYTES);
 if(n<0 || !(fp=fopen(name,"r")))
   {printf("'%s' not found\n",name); return -1;}
 strncpy(dateiname,name,200); dateiname[200-1]=0;
 buffer=new char[buffersize=n+1];
 for(s=buffer;(c=getc(fp))!=EOF;)  *s++ = c;
 *s=0;
 fclose(fp);
 inital_new();
 double x=xmin+bx/2, y=ymax-1.5*hy;
 for(s=buffer;*s;s=nextzeile(s))
   {c=setnextlf(s,0);
    schrift(x,y,s); y-=1.5*hy;
    setnextlf(s,c);
   }
 cursor.setbuffer(buffer);
 cursor.setxy(xmin+bx/2,ymax-1.5*hy,bx,hy);
 term_refresh();
 n=0; //cursor.zeichnen();
 while(exitflag==0 && waitmenu(0)==0)
	{waitTOF();// auf Benutzereingaben warten
	 if(mausposition(&x,&y) & LIMAUS)
	   {cursor.loeschen(); cursor.setxy(x,y); cursor.zeichnen();}
	 else if(++n>=50) {n=0; cursor.zeichnen();}
	 else if(n==25) cursor.loeschen();
	}
 return 0;
}

void Fenster::save()
{
 int ok;
 ok=nachfilenamefragen("save file",dateiname,200);
 if(ok)
   {FILE *fp;
    char *s;
    int c;
    if((fp=fopen(dateiname,"w"))==NULL)
      janeinrequester("konnte Datei nicht erstellen - nichts gespeichert");
    else
      {for(s=buffer;c= *s;s++) fputc(c,fp);
       fclose(fp);
      }
   }
}
