/* Filelaenge.cc */
/*
  Bestimmung der Lnge einer Datei

Auf VAX:
@LINK filelaenge,SYS$INPUT/OPT
SYS$SHARE:DECW$XLIBSHR/SHARE
*/

#include <stdio.h>
#include <ctype.h>

const int BLOCKS=0, BYTES=1, BSIZE=2;
int filelaenge(char *name,int flag=BYTES);

main(int argc,char *argv[])
{
 int nbytes,nblocks,blockgroesse;
 char filename[80];
 if(argc>=2) sscanf(argv[1],"%s",filename);
 else {printf("File:"); scanf("%s",filename);}
 nblocks=filelaenge(filename,BLOCKS);
 blockgroesse=filelaenge(filename,BSIZE);
 printf("Die Datei '%s' hat %d Blocks. (Blockgroesse=%d)\n",
	filename,nblocks,blockgroesse);
 nbytes=filelaenge(filename,BYTES);
 printf(" und ist %d Bytes lang.\n",nbytes);
 printf("System ist '%s'\n",
#ifdef unix
	"unix"
#elif VAX
	"VAX"
#else
	"unbekannt"
#endif
       );
}/* ende von main */

#undef FILELAENGE

#ifdef unix
#include <sys/types.h>
#include <sys/stat.h>
//#include <ourhdr.h>

int filelaenge(char *name,int flag)
{
 struct stat buf;
 int n;
 if(lstat(name,&buf)<0) return -1;
 if(!S_ISREG(buf.st_mode)) return -2;
//fuer Inhalt von buf siehe "man lstat"
 if(flag==BLOCKS) n=buf.st_blocks;
 else if(flag==BSIZE) n=buf.st_blksize;
 else n=buf.st_size;
 return n;
}
#define FILELAENGE
#endif

#ifdef VAX
int filelaenge(char *name,int flag)
{
 char str[80];
 FILE *fp;
 int n;
 if(flag==BLOCKS)
  {sprintf(str,"DIR/SIZ/output=temp.dat %s;",name); system(str);
   fp=fopen("temp.dat","r");
   if(fp==NULL) return -3;
   if(fscanf(fp,"%*s %*s %*s %d",&n)!=1) n= -2;
   fclose(fp);
   system("DEL temp.dat;");
  }
 else if(flag==BSIZE)
  {n=512;}
 else
  {fp=fopen(name,"r");
   if(fp==NULL) return -1;
   for(n=0;getc(fp)!=EOF;n++)  ;
   fclose(fp);
  }
 return n;
}
#define FILELAENGE
#endif

#ifndef FILELAENGE
// auf unbekanntem System

int filelaenge(char *name,int flag)
{
 char str[80];
 FILE *fp;
 int n;
 const int blockgroesse=512; //Vermutung
 if(flag==BSIZE) return blockgroesse;
 if(!(fp=fopen(name,"rb"))) return -1;
 for(n=0;(c=getc(fp))!=EOF;n++)  ;
 fclose(fp);
 if(flag==BLOCKS) n=(n+blockgroesse-1)/blockgroesse;
 return n;
}
#endif
