/* bitfeldklasse.cc
Verwendung von einzelnen Bits
Anwendung: einfuegen in C++ Programmen
*/
class Bitfeld
{
 char *feld;
 int jmax; //Maximale Anzahl Bits
public:
 Bitfeld() {feld=NULL;}
 Bitfeld(int j) {feld=NULL; init(j);}
 ~Bitfeld() {clear();}
 void clear() {if(feld!=NULL) {delete[] feld; feld=NULL;}}
 bool init(int j);
 void fill(int k) {int i,m=jmax/8,c=(k==0)?0:0xFF; for(i=0;i<m;i++) feld[i]=c;}
 int get(int j);
 int set(int j,int bit);
};
bool Bitfeld::init(int j)
{
 clear(); jmax=j; feld=new char[(j+7)/8];
 return feld!=NULL;
}
int Bitfeld::get(int j)
{
 if(j>=jmax || j<0) return -1;//Ausserhalb Bereich
 int k=j&0x07;
 return (feld[j/8]>>k)&0x01; //Resultat ist 0 oder 1
}
int Bitfeld::set(int j,int bit)
{
 if(j>=jmax || j<0) return -1;//Ausserhalb Bereich
 int k=j&0x07;
 char c=feld[j/=8];
 feld[j] = (bit==0) ? (c & ~(1<<k)) : (c | (1<<k));
 return bit;
}
