/* ringklasse.cc

 Ringspeicher (FIFO-Speicher)
Anwendung: einfgen in C++ Programmen
*/

class Ring
{
 char	*mem,	//Speicher
	*mend,	//Ende des Speichers
	*rp,	//Lesezeiger
	*wp;	//Schreibzeiger
 int	i;	//Anzahl gespeicherte Bytes
public:
 int	flags;	//Zustand
#define RINGFULL 1
 Ring(int n) {mem=new char[n]; mend = &mem[n];  rp=wp=mem; i=flags=0;}
 ~Ring() {delete mem;}
 int put(int c);
 int get();
 int check(int *f) {*f=flags; return i;}
 void clear() {rp=wp=mem; i=flags=0;}
};

int Ring::put(int c)
{
 char *wpneu=wp;
 if(++wpneu==mend) wpneu=mem;
 if(rp==wpneu) {flags |= RINGFULL; return 0;} //Speicher voll
 *wp = c;
 wp=wpneu; i++;
 return 1; //Erfolgreich
}

int Ring::get()
{
 if(rp==wp) return -1; //Speicher leer
 char *rpneu=rp;
 int c = *rpneu++;
 if(rpneu==mend) rpneu=mem;
 rp=rpneu; i--;
 return c&0xFF;
}
