/* spektrumklasse.cc

 Rechnen mit Spektren, wobei ein Spektrum als 2*n Matrix behandelt wird
Anwendung: einfgen in C++ Programmen
Voraussetzung: vektorklasse muss schon eingebunden sein
*/

class Spektrum
{
 int formatok(char*);
public:
 vektor *ve;		//Feld mit x-y-Wertepaaren
 unsigned long np;	//Anzahl Wertepaare
 Spektrum(long m=0,double x0=0.,double dx=0.,double y0=0.);
 Spektrum(char *name) {load(name);}
 Spektrum(Spektrum&);
 ~Spektrum() {del();}
 void del() {if(np) {np=0; delete ve;}}
 void load(char*);
 void save(char*);
 Spektrum& operator=(const Spektrum&);
 Spektrum& operator*=(vektor);
 Spektrum operator+=(Spektrum);
 friend Spektrum operator*(double,Spektrum);
 friend Spektrum operator*(Spektrum,double);
 friend Spektrum operator*(vektor,Spektrum);
 friend Spektrum operator*(Spektrum,vektor);
 friend Spektrum operator+(Spektrum,Spektrum);
 friend Spektrum operator+(double,Spektrum);
 friend Spektrum operator+(Spektrum,double);
};

inline Spektrum operator*(Spektrum a,double x) {return operator*(x,a);}
inline Spektrum operator*(Spektrum a,vektor v) {return operator*(v,a);}
inline Spektrum operator+(Spektrum a,double x) {return operator+(x,a);}

Spektrum::Spektrum(long m,double x0,double dx,double y0)
{
 long i;
 vektor *v;
 if(m>0) {np=m; ve=new vektor[np];}
 else np=0;
 if(x0!=0. || dx!=0.)
   for(i=0,v=ve;i<np;i++,v++)
     {v->x=x0; v->y=y0; x0+=dx;}
}
Spektrum::Spektrum(Spektrum& a)
{
 long i;
 vektor *v,*va;
 if(np=a.np) ve=new vektor[np];
 for(i=0,v=ve,va=a.ve;i<np;i++,v++,va++)
     {v->x=va->x; v->y=va->y;}
}

Spektrum& Spektrum::operator=(const Spektrum& b)
{
 long i; vektor *vz,*vb;
 del();
 if((np=b.np)==0) return *this;
 ve=new vektor[np];
 for(i=0,vz=ve,vb=b.ve;i<np;i++,vz++,vb++)
   {vz->x = vb->x;
    vz->y = vb->y;
   }
 return *this;
}

Spektrum& Spektrum::operator*=(vektor v)
{
 vektor *vz;
 long i;
 for(i=0,vz=ve;i<np;i++,vz++)
   {vz->x *= v.x;
    vz->y *= v.y;
   }
 return *this;
}

Spektrum operator*(double x,Spektrum b)
{
 Spektrum a=b;
 long i; vektor *va;
 for(i=0,va=a.ve;i<a.np;i++,va++)
    va->x *= x;
 return a;
}
Spektrum operator*(vektor v,Spektrum b)
{
 Spektrum a=b;
 long i; vektor *va;
 for(i=0,va=a.ve;i<a.np;i++,va++)
   {va->x *= v.x;
    va->y *= v.y;
   }
 return a;
}

/** alte Variante
Spektrum operator+(Spektrum a,Spektrum b)
{
 Spektrum z=a;
 if(b.np==0 || a.np==0)
   {printf("Error Spektrum operator+: deleted Spektrum\n"); return z;}
 vektor *vz,*vb;
 long i;
 double xi,xj,xj1,yj,yj1;
 double bxmin=b.ve[0].x, bxmax=b.ve[b.np-1].x;
 if(bxmin==bxmax) printf("Warning Spektrum operator+: empty Spektrum\n");
 for(i=0,vz=z.ve;i<z.np;i++,vz++)
   if((xi=vz->x) >= bxmin  &&  xi <= bxmax)
     {for(vb=b.ve; vb->x < xi; vb++)
		{xj=vb->x; yj=vb->y;}
      xj1=vb->x; yj1=vb->y;
      if(xj1==xi) vz->y += yj1;
      else        vz->y += (yj*(xi-xj)+yj1*(xj1-xi))/(xj1-xj);
     }
 return z;
}
**/

Spektrum operator+(Spektrum a,Spektrum b)
{
 Spektrum z;
 if(b.np==0 || a.np==0)
   {printf("Error Spektrum operator+: deleted Spektrum\n"); return z;}
 double axmin=a.ve[0].x,axmax=a.ve[a.np-1].x,
        bxmin=b.ve[0].x,bxmax=b.ve[b.np-1].x;
 double xmin=axmin,xmax=axmax;
 int flag=0;
 if(bxmin<xmin) {xmin=bxmin; flag++;}
 if(bxmax>xmax) {xmax=bxmax; flag++;}
 if(flag==1) //die beiden Spektren sind nur teilweise ueberlappend
    {double dx1=(axmax-axmin)/(a.np-1), dx2=(bxmax-bxmin)/(b.np-1);
     if(dx2<dx1) dx1=dx2;
     long npneu=long((xmax-xmin)/dx1+1.5);
     Spektrum z2(npneu,xmin,(xmax-xmin)/(npneu-1));
     z2+=a; z2+=b;
     return z2;
    }
 else if(flag==0) //Spektrum b ist innerhalb Spektrum a
    {z=a; z+=b;}
 else //(flag==2) Spektrum a ist innerhalb Spektrum b
    {z=b; z+=a;}
 return z;
}

Spektrum Spektrum::operator+=(Spektrum b)
{
 if(np==0 || b.np==0) return *this;
 vektor *vz,*vb;
 long i;
 double bxmin=b.ve[0].x, bxmax=b.ve[b.np-1].x;
 double xi,xj,xj1,yj,yj1;
 for(i=0,vz=ve;i<np;i++,vz++)
   if((xi=vz->x) >= bxmin  &&  xi <= bxmax)
     {for(vb=b.ve; vb->x < xi; vb++)
		{xj=vb->x; yj=vb->y;}
      xj1=vb->x; yj1=vb->y;
      if(xj1==xi) vz->y += yj1;
      else        vz->y += (yj*(xi-xj)+yj1*(xj1-xi))/(xj1-xj);
     }
 return *this;
}

Spektrum operator+(double x,Spektrum b)
{
 Spektrum a=b;
 long i; vektor *va;
 for(i=0,va=a.ve;i<a.np;i++,va++)
    va->x += x;
 return a;
}

int Spektrum::formatok(char *s)
{
 while(*s && *s!='.') s++;
 return strcmp(s,".xy")==0 || strcmp(s,".XY")==0; //provi.
}

void Spektrum::load(char *name)
{
 del();
 if(!formatok(name))
  {printf("Klasse Spektrum kann bisher nur 'name.xy' lesen\n");return;}//provi.
 FILE *fp=fopen(name,"r");
 double x,y;
 long i;
 vektor *pv;
 if(fp==NULL) {printf("'%s' not found\n",name); return;}
 for(np=0;fscanf(fp,"%lf%*c%lf",&x,&y)==2;np++)  ;
 fclose(fp); fp=fopen(name,"r");
 if(fp==NULL) {printf("cant reopen '%s'\n",name); np=0; return;}
 ve=new vektor[np];
 for(i=0,pv=ve;i<np;i++,pv++)
   {fscanf(fp,"%lf%*c%lf",&x,&y);
    pv->x=x; pv->y=y;
   }
 fclose(fp);
}

void Spektrum::save(char *name)
{
 if(!formatok(name)) //provi.
   {printf("Klasse Spektrum kann bisher nur 'name.xy' speichern\n"); return;}
 long i;
 vektor *pv;
 FILE *fp=fopen(name,"w");
 if(fp==NULL) {printf("cant create '%s'\n",name); return;}
 for(i=0,pv=ve;i<np;i++,pv++)
   fprintf(fp,"%lg\t%lg\n",pv->x,pv->y);
 fclose(fp);
}
