/* exact.cc	rechnen mit exakten Fliesszahlen
*/
char *version="1.0";
/*
;ALPHA> cx exact
;ALPHA> blink exact
;ALPHA> pur exact.exe
*/

#include <stdio.h>
#include <stdlib.h>
//#include "h:ulong.h"

/******************* Rechnen mit exakten Fliesszahlen **********************/
#define MIO 10000
#define TAUS 100
inline long idfix(double x) {return x<0.?long(x-0.5):long(x+0.5);}
inline int idfixi(double x) {return x<0.?int(x-0.5):int(x+0.5);}
inline long iabs(long x) {return x<0?-x:x;}

class exactfloat
{
 void normieren();
public:
 long ganze,mio;
 exactfloat() {ganze=mio=0;}
 exactfloat(long a,long b) {ganze=a; mio=b;}
 exactfloat(double x) {ganze=long(x); mio=idfix((x-ganze)*MIO); normieren();}
 ~exactfloat() {}
 exactfloat operator=(long n) {ganze=n; mio=0; return *this;}
 exactfloat operator=(int n) {ganze=n; mio=0; return *this;}
 exactfloat operator=(double);
 exactfloat operator=(exactfloat y) {ganze=y.ganze; mio=y.mio; return y;}
 exactfloat operator+=(exactfloat);
 long operator<=(exactfloat y);
 friend exactfloat operator+(exactfloat,exactfloat);
 friend exactfloat operator-(exactfloat,exactfloat);
 friend exactfloat operator*(exactfloat,exactfloat);
 friend exactfloat operator/(exactfloat,exactfloat);
 operator double() {return ganze+double(mio)/MIO;}
};
void exactfloat::normieren()
{
 if(mio>=MIO) {ganze++; mio-=MIO;}
 else if(mio<= -MIO) {ganze--; mio+=MIO;}
}
exactfloat operator+(exactfloat x,exactfloat y)
{
 exactfloat z;
 z.ganze=x.ganze+y.ganze; z.mio=x.mio+y.mio; z.normieren();
 return z;
}
exactfloat operator-(exactfloat x,exactfloat y)
{
 exactfloat z;
 z.ganze=x.ganze-y.ganze; z.mio=x.mio-y.mio; z.normieren();
 return z;
}
exactfloat exactfloat::operator=(double x)
{
 ganze=long(x); mio=idfix((x-ganze)*MIO); normieren();
 return *this;
}
exactfloat exactfloat::operator+=(exactfloat y)
{
 ganze+=y.ganze; mio+=y.mio; normieren();
 return *this;
}
long exactfloat::operator<=(exactfloat y)
{
 if(ganze!=y.ganze) return ganze<=y.ganze;
 return mio<=y.mio;
}

/** Provisorische Operatoren: * und / geht bisher nur mit MIO <= 10000 **/
exactfloat operator*(exactfloat x,exactfloat y)
{
 exactfloat z1,z2,z3;
 long ad,bc;
 z1.ganze=x.ganze*y.ganze;
 z1.mio=(x.mio/TAUS)*(y.mio/TAUS);
 ad=x.ganze*y.mio;
 bc=x.mio*y.ganze;
 z2.ganze=ad/MIO; z2.mio=ad%MIO;
 z3.ganze=bc/MIO; z3.mio=bc%MIO;
 return z1+z2+z3;
}

exactfloat operator/(exactfloat x,exactfloat y)
{
 exactfloat z1;
 long ab,cd;
 ab=x.ganze*MIO+x.mio; cd=y.ganze*MIO+y.mio;
 z1.ganze=ab/cd;
 z1.mio=(ab*MIO)/cd-z1.ganze*MIO;
 return z1;
}

/*************************/
main()
{
 double dx,dy,dz;
 exactfloat ex,ey,ez;
 printf("2 Zahlen:"); scanf("%lf %lf",&dx,&dy);
 ex=dx; ey=dy;
 ez=ex+ey; printf("%lf + %lf = %lf\n",dx,dy,double(ez));
 ez=ex-ey; printf("%lf - %lf = %lf\n",dx,dy,double(ez));
 ez=ex*ey; printf("%lf * %lf = %lf\n",dx,dy,double(ez));
 ez=ex/ey; printf("%lf / %lf = %lf\n",dx,dy,double(ez));
}
