/* Lint.cc */
/*
;AVAX> cx Lint
;AVAX> blink Lint
;AVAX> pur Lint.exe
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
//#include <ulong.h>

const int NBITS = (2*sizeof(long)*8),
          NEGBIT= (1<<(sizeof(long)*8-1));

class Lint
{
 long o,u;
 int divmod2()
	{int rest=u&1; u>>=1;
	 if(o&1) u|=NEGBIT;
	 o>>=1;
	 return rest;
	}
 int isneg() {return (o&NEGBIT);}
 void lshift() {o<<=1; if(u&NEGBIT) ++o;  u<<=1;}
public:
 Lint() {o=u=0;}
 Lint(long n) {o=0; u=n;}
 char *i2s();
 operator long() {return u;}
 Lint operator+(Lint);
 Lint operator-();     //unrer Operator
 Lint operator-(Lint); //binrer Operator
 int operator<(Lint);
 int operator<=(Lint);
 Lint operator+=(Lint);
 Lint operator-=(Lint);
 Lint operator*(Lint);
 Lint operator/(Lint);
 Lint operator%(Lint);
 Lint operator++() {if(++u==0) ++o;  return (*this);}
 Lint operator<<=(int);
 Lint operator>>=(int);
 friend Lint divmod(Lint*,Lint);
/*
 Lint operator*(long);  //gleich wie: friend Lint operator*(Lint,long);
 friend Lint operator*(long,Lint);
*/
};

Lint Lint::operator+(Lint b)
{
 Lint e;
 int va=u&NEGBIT,vb=b.u&NEGBIT;
 e.o=o+b.o; e.u=u+b.u;
 if((va && vb)
    || ((va || vb) && (e.u&NEGBIT)==0)
   )  e.o++;
 return e;
}
Lint Lint::operator+=(Lint b)
{
 int va=u&NEGBIT,vb=b.u&NEGBIT;
 o+=b.o; u+=b.u;
 if((va && vb)
    || ((va || vb) && (u&NEGBIT)==0)
   )  o++;
 return *this;
}
Lint Lint::operator-=(Lint b)
{
 b.o= ~b.o; b.u= ~b.u;
 if(++b.u==0) b.o++;
 int va=u&NEGBIT,vb=b.u&NEGBIT;
 o+=b.o; u+=b.u;
 if((va && vb)
    || ((va || vb) && (u&NEGBIT)==0)
   )  o++;
 return *this;
}

Lint Lint::operator-()
{
 Lint e;
 e.o= ~o; e.u= ~u;
 if(++e.u==0) e.o++;
 return e;
}
Lint Lint::operator-(Lint b)
{
 return (*this)+(-b);
}

Lint Lint::operator*(Lint b)
{
 Lint a=(*this),e;
 int neg=0;
 if(a.isneg()) {neg^=1; a= -a;}
 if(b.isneg()) {neg^=1; b= -b;}
 if(b<a) {e=a; a=b; b=e;}
 for(e=0; a.u!=0 || a.o!=0; b+=b)
   {if(a.divmod2()) e+=b;}
 if(neg) return -e;
 return e;
}

int Lint::operator<(Lint b)
{
 if(o<b.o) return 1;
 if(o>b.o) return 0;
 unsigned long ua,ub;
 if(o>=0) {ua=(unsigned long)u; ub=(unsigned long)b.u;}
 else     {ua=(unsigned long)b.u; ub=(unsigned long)u;}
 return (ua<ub);
}

int Lint::operator<=(Lint b)
{
 if(o<b.o) return 1;
 if(o>b.o) return 0;
 unsigned long ua,ub;
 if(o>=0) {ua=(unsigned long)u; ub=(unsigned long)b.u;}
 else     {ua=(unsigned long)b.u; ub=(unsigned long)u;}
 return (ua<=ub);
}

Lint Lint::operator/(Lint b)
{
 Lint a=(*this),e;
 int neg=0;
 if(a.isneg()) {neg^=1; a= -a;}
 if(b.isneg()) {neg^=1; b= -b;}
 e=divmod(&a,b);
 if(neg) return -e;
 return e;
}
Lint Lint::operator%(Lint b)
{
 Lint a=(*this);
 int neg;
 if(a.isneg()) {neg=1; a= -a;} else neg=0;
 if(b.isneg()) b= -b;
 divmod(&a,b);
 if(neg) return -a;
 return a;
}

Lint Lint::operator<<=(int n)
{
 if(n>=NBITS) o=u=0;
 else
   while(n-- > 0)
     {o<<=1; if(u&NEGBIT) ++o;  u<<=1;}
 return (*this);
}
Lint Lint::operator>>=(int n)
{
 if(n>NBITS) n=NBITS;
 while(n-- > 0)
      {u=(u>>1)&(~NEGBIT); if(o&1) u|=NEGBIT;  o>>=1;}
 return (*this);
}

Lint divmod(Lint *a,Lint b)
{
 Lint e=0,r=0;
 int i=0;
 if(b.u==0 && b.o==0) {e.o=(-1)&(~NEGBIT); e.u=(-1); return e;}
 if(a->o==0)
   {if(a->u==0) return e;
    a->o = a->u;  a->u = 0; i=(NBITS/2);
    while((a->o & NEGBIT)==0) {a->o <<= 1; i++;}
   }
 else
   while((a->o & NEGBIT)==0) {a->lshift(); i++;}
 for(;i<NBITS;i++)
   {r.lshift(); //etwas schneller als r<<=1;
    if(a->o & NEGBIT) ++r;
    a->lshift();
    e.lshift();
    if(b<=r) {++e; r-=b;}
   }
 *a = r;
 return e;
}

//Hilfsfunktionen zum Ausdrucken der grossen Zahlen:
char * Lint::i2s()
{
 Lint a=(*this);
 char *str=new char[22];
 char *s,*t;
 int c,negflag=0;
 s=str;
 if(a<0) {a= -a; negflag=1;}
 do {*s++ = long(a%10)+'0';  a=a/10;}
 while(a.u!=0 || a.o!=0);
 if(negflag) *s++ = '-';
 *s=0;
 for(t=str;*t;t++) ;
 for(--t; *t=='0' && t>str;) *t-- =0;
 for(s=str;t>s;t--,s++) {c= *t; *t= *s; *s=c;}
 return str;
}


main(int argc,char *argv[])
{
 Lint a=2874452364,b=123,c=25098,d=123,x,y,c1,c2,c3,c4;
// Lint a=2874,b=100,c=100,d=10,x,y,c1,c2,c3,c4;
 x=b*a;
 y=c*d;
 c1=x+y; printf("%s + %s = %s\n",x.i2s(),y.i2s(),c1.i2s());
 c2=x-y; printf("%s - %s = %s\n",x.i2s(),y.i2s(),c2.i2s());
 c3=x*y; printf("%s * %s = %s\n",x.i2s(),y.i2s(),c3.i2s());
 c4=x/y; b=x%y; printf("%s / %s = %s Rest %s\n",x.i2s(),y.i2s(),c4.i2s(),b.i2s());
 printf("zurckrechnen:\n");
 c1=c1-y; c=c1-x; printf("x = (x+y)-y = %s  Delta=%s\n",c1.i2s(),c.i2s());
 c2=c2+y; c=c2-x; printf("x = (x-y)+y = %s  Delta=%s\n",c2.i2s(),c.i2s());
 c3=c3/y; c=c3-x; printf("x = (x*y)/y = %s  Delta=%s\n",c3.i2s(),c.i2s());
 c4=c4*y+b; c=c4-x;
 printf("x = (x/y)*y+Rest = %s  Delta=%s\n",c4.i2s(),c.i2s());
}
