/* ulong64.cc */
/*
;ALPHA> cx ulong64
;ALPHA> blink ulong64
;ALPHA> pur ulong64.exe
;VAX> gx ulong64
;VAX> blink ulong64
;VAX> pur ulong64.exe
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "h:ulong.h"

class ULONG64
{
 ULONG H,L;
public:
 ULONG64(ULONG n) {L=n; H=0;}	//Konstruktoren
 ULONG64() {L=H=0;}
 ULONG64(ULONG h,ULONG l) {L=l; H=h;}
 ULONG64(char *s);
 char *i2s();			//allgemeine Funktionen
 int shiftleft(ULONG64 y);
 void test();
 friend ULONG64 operator+(ULONG64,ULONG64);	//Operatoren
 friend ULONG64 operator-(ULONG64,ULONG64);
 friend ULONG64 operator*(ULONG64,ULONG64);
 friend ULONG64 operator/(ULONG64,ULONG64);
 friend ULONG64 operator%(ULONG64,ULONG64);
 friend int operator<(ULONG64,ULONG64);
 friend int operator<(ULONG64,ULONG);
 friend int operator<=(ULONG64,ULONG64);
 friend int operator<=(ULONG64,ULONG);
 friend int operator==(ULONG64,ULONG64);
 friend int operator==(ULONG64,ULONG);
 friend int operator!=(ULONG64,ULONG64);
 friend int operator!=(ULONG64,ULONG);
 friend ULONG64 operator/(ULONG64,ULONG);
 friend ULONG operator%(ULONG64,ULONG);
// friend ULONG operator long(ULONG64);
 ULONG64 operator=(ULONG n) {ULONG64 z; z.L=L=n; z.H=H=0; return z;}
#ifndef __ALPHA
 ULONG64 operator=(ULONG64 x) {L=x.L; H=x.H; return x;}
#endif
};
ULONG64::ULONG64(char *s)
{
 ULONG64 x,h;
 x=0;
 int c;
 while((c= *s++) && isdigit(c))
	{h=x+x; h=h+h+x; x=h+h+(c-'0');}
 H=x.H; L=x.L;
}
char * ULONG64::i2s()
{
 ULONG64 a;
 char *str=new char[22];
 char *s,*t;
 int c;
 s=str; a.H=H; a.L=L;
 do	{*s++ = long(a%10)+'0';
	 a=a/10;
	}
 while(a.L!=0 || a.H!=0);
 *s=0;
 for(t=str;*t;t++) ;
 for(--t; *t=='0' && t>str;) *t-- =0;
 for(s=str;t>s;t--,s++) {c= *t; *t= *s; *s=c;}
 return str;
}
int ULONG64::shiftleft(ULONG64 y)
{
 int cy=(y.L&0x80000000)?1:0;
 int cy2=(y.H&0x80000000)?1:0;
 L=y.L+y.L; H=y.H+y.H+cy;
 return cy2;
}
void ULONG64::test()
{
 printf("ULONG64::test() H=%08X L=%08X\n",H,L);
}

ULONG64 operator+(ULONG64 x,ULONG64 y)
{
 ULONG64 z;
 ULONG a,b,c,d,h;
 a=x.L>>16; b=x.L&0xFFFF;
 c=y.L>>16; d=y.L&0xFFFF;
 z.L=b+d; h=a+c+(z.L>>16); z.L=(z.L&0xFFFF)+(h<<16);
 z.H=x.H+y.H+(h>>16);
 return z;
}
ULONG64 operator-(ULONG64 x,ULONG64 y)
{
 ULONG64 z;
 ULONG a,b,c,d,h;
 a=x.L>>16; b=x.L&0xFFFF;
 y.H ^= 0xFFFFFFFF; y.L ^= 0xFFFFFFFF; if((++y.L)==0) ++y.H;
 c=y.L>>16; d=y.L&0xFFFF;
 z.L=b+d; h=a+c+(z.L>>16); z.L=(z.L&0xFFFF)+(h<<16);
 z.H=x.H+y.H+(h>>16);
 return z;
}
ULONG64 operator/(ULONG64 x,ULONG y)
{
 ULONG64 z;
 ULONG a,b,h;
 a=x.L>>16; b=x.L&0xFFFF;
 z.H=x.H/y;
 h=a+((x.H%y)<<16); a=h/y;
 h=b+((h%y)<<16); b=h/y;
 z.L=(a<<16)+b;
 return z;
}
ULONG operator%(ULONG64 x,ULONG y)
{
 ULONG a,b,h;
 a=x.L>>16; b=x.L&0xFFFF;
 h=a+((x.H%y)<<16); a=h/y;
 h=b+((h%y)<<16);
 return h%y;
}
/*
ULONG operator long(ULONG64 x)
{
 return x.L;
}
*/

ULONG64 operator*(ULONG64 x,ULONG64 y)
{
 ULONG64 z;
 ULONG a[4],b[4],result[7],cy;
 int i,j,k0,k;
 a[0]=x.L&0xFFFF; b[0]=y.L&0xFFFF;
 a[1]=x.L>>16;    b[1]=y.L>>16;
 a[2]=x.H&0xFFFF; b[2]=y.H&0xFFFF;
 a[3]=x.H>>16;    b[3]=y.H>>16;
 for(i=0;i<7;i++) result[i]=0;
 for(i=k0=0;i<4;i++,k0++)
  for(j=cy=0,k=k0;j<4;j++,k++)
	{result[k] += a[i]*b[j]+cy;
	 cy=result[k]>>16; result[k] &= 0xFFFF;
	}
 z.L=result[0]+(result[1]<<16);
 z.H=result[2]+(result[3]<<16);
 if(result[4] || result[5] || result[6] || cy)
	printf("Warnung: Ueberlauf in 64-Bit-Multiplikation\n");
 return z;
}

ULONG64 operator/(ULONG64 x,ULONG64 y)
{
 ULONG64 z,z2,y2,h;
 if(y==0)
	{printf("Warnung: 64-Bit-Division durch Null\n");
	 x.H=x.L=0xFFFFFFFF; return x;
	}
 for(z=0;y<=x;)
	{for(y2=y,z2=1;;)
		{if(h.shiftleft(y2) || x<h) break;
		 y2=h; z2.shiftleft(z2);
		}
	 x=x-y2; z=z+z2;
	}
 return z;
}
ULONG64 operator%(ULONG64 x,ULONG64 y)
{
 ULONG64 z,z2,y2,h;
 if(y==0) return y;
 for(z=0;y<=x;)
	{for(y2=y,z2=1;;)
		{if(h.shiftleft(y2) || x<h) break;
		 y2=h; z2.shiftleft(z2);
		}
	 x=x-y2; z=z+z2;
	}
 return x;
}

/*** Vergleichsoperatoren: ***/
int operator==(ULONG64 x,ULONG64 y) {return (x.L==y.L && x.H==y.H);}
int operator==(ULONG64 x,ULONG y) {return (x.L==y && x.H==0);}
int operator!=(ULONG64 x,ULONG64 y) {return (x.L!=y.L || x.H!=y.H);}
int operator!=(ULONG64 x,ULONG y) {return (x.L!=y || x.H!=0);}
int operator<(ULONG64 x,ULONG64 y) {return (x.H<y.H ||(x.H==y.H && x.L<y.L));}
int operator<(ULONG64 x,ULONG y) {return (x.H==0 && x.L<y);}
int operator<=(ULONG64 x,ULONG64 y){return(x.H<y.H ||(x.H==y.H && x.L<=y.L));}
int operator<=(ULONG64 x,ULONG y){return (x.H==0 && x.L<=y);}

main(int argc,char *argv[])
{
 ULONG64 a(2874452364,3944680146),b=100,c,x,y,c1,c2,c3,c4;
 char s1[40],s2[40];
 c=b;
 b=1000;
 printf("Zuweisungstests:\n");
 printf(" ziffern=%s hundert=%s tausend=%s\n",a.i2s(),c.i2s(),b.i2s());
 printf("grosse Zahl:"); scanf("%s",&s1);
 printf("  noch eine:"); scanf("%s",&s2);
 x=s1; x.test();
 y=s2; y.test();
 c1=x+y; printf("%s + %s = %s\n",x.i2s(),y.i2s(),c1.i2s());
 c2=x-y; printf("%s - %s = %s\n",x.i2s(),y.i2s(),c2.i2s());
 c3=x*y; printf("%s * %s = %s\n",x.i2s(),y.i2s(),c3.i2s());
 c4=x/y; b=x%y; printf("%s / %s = %s Rest %s\n",x.i2s(),y.i2s(),c4.i2s(),b.i2s());
 printf("zurckrechnen:\n");
 c1=c1-y; c=c1-x; printf("x = (x+y)-y = %s  Delta=%s\n",c1.i2s(),c.i2s());
 c2=c2+y; c=c2-x; printf("x = (x-y)+y = %s  Delta=%s\n",c2.i2s(),c.i2s());
 c3=c3/y; c=c3-x; printf("x = (x*y)/y = %s  Delta=%s\n",c3.i2s(),c.i2s());
 c4=c4*y+b; c=c4-x;
 printf("x = (x/y)*y+Rest = %s  Delta=%s\n",c4.i2s(),c.i2s());
}
