/* zeitklasse.cc

 Lokalzeit und Weltzeit

Anwendung: Einfgen in C++ Programmen
*/

//#define unix //schon vom System gesetzt
//#define VAXORALPHA

//Zeit.flags
#define LOKALZEIT	1
#define WELTZEIT	2
#define SOMMERZEIT	4

#define ISTSCHALTJAHR(x) ((x%4)==0 && ((x%100)!=0 || (x%400)==0))

/****************** Maschinenabhaengige Funktionen ***********************/
#ifndef VTIMEB_H
#define VTIMEB_H

#ifdef VAXORALPHA
#include <file.h>
#ifndef __STDC__
#include <unixio.h>
#else
#include <timeb.h>
#endif
#include <time.h>
#define TIME_T
#define TM_T
#define TIMEB_T
#define FTIME_T
#endif /*VAXORALPHA*/

#ifdef unix
/** LINUX **/
#ifndef GCC_VERSION
#define GCC_VERSION (__GNUC__ * 1000 + __GNUC_MINOR__)
#endif /* GCC_VERSION */
#include <time.h>
#if GCC_VERSION>=3002
#define TIME_T
#define TM_T
#define GMTIME_C
#endif

/** IBM AIX UNIX **
#include <time.h>
#define TIME_T
#define TM_T
#endif

/** DEC Alpha UNIX **
#include <sys/time.h>
#define TIME_T
#define TM_T
#define GMTIME_C
/**/
#endif /*unix*/

#ifdef AMIGA
#include <sys/time.h>
#define TIME_T
#define TM_T
#define GMTIME_C
#endif /*AMIGA*/

#ifndef TIME_T /* ev. schon in <timeb.h> definiert */
typedef unsigned long time_t;
#endif

#ifndef TIMEB_T
struct timeb
        {time_t          time;
         unsigned short  millitm;
         short           timezone;
         short           dstflag;
        };
typedef struct timeb timeb_t;
#endif

#ifndef TM_T /* sollte schon in <time.h> definiert sein */
struct tm
        {int     tm_sec, tm_min, tm_hour;
         int     tm_mday, tm_mon, tm_year;
         int     tm_wday, tm_yday, tm_isdst;
        };
typedef struct tm tm_t;
#endif

#ifndef FTIME_T
int ftime(timeb_t*);
#endif

#endif /*VTIMEB_H*/

#ifndef GMTIME_C
#define GMTIME_C
/** schon in <timeb.h> definiert: **
typedef long time_t;
struct timeb
        {time_t          time;
         unsigned short  millitm;
         short           timezone;
         short           dstflag;
        };
typedef struct timeb timeb_t;
**/

struct tm *gmtime2(time_t *ptim)
{
 tm* p=new tm[1];
 int jahr,mon;
 time_t tim= *ptim;
 static int monat[12]={31,28,31,30,31,30,31,31,30,31,30,31};
 p->tm_wday=(tim/(3600*24)+4)%7;/* +4 fuer 1.Jan.1970==Donnerstag */
 p->tm_sec=tim%60; tim/=60;
 p->tm_min=tim%60; tim/=60;
 p->tm_hour=tim%24; tim/=24;
 for(jahr=1970;;jahr++)
   if(ISTSCHALTJAHR(jahr))
	{if(tim>=366) tim-=366; else break;}
   else {if(tim>=365) tim-=365; else break;}
 p->tm_year=jahr-1900;
 p->tm_yday=tim;
 if(ISTSCHALTJAHR(jahr)) monat[1]=29; else monat[1]=28;
 for(mon=0;tim>=monat[mon];mon++)
	tim -= monat[mon];
 p->tm_mon=mon;
 p->tm_mday=tim+1;
 p->tm_isdst=0;/* fuer Weltzeit immer 0 */
 return p;
}

inline struct tm *gmtime(time_t *ptim) {return gmtime2(ptim);}
inline struct tm *localtime2(time_t *ptim) {return gmtime2(ptim);}//provi.
#endif /*GMTIME_C*/

/***************** :Maschinenabhaengige Funktionen ***********************/

class Zeit
{
 int	flags;
 time_t aktzeit(); //aktuelle Zeit ermitteln
		//Anwenderprogramm: lokalzeit() oder weltzeit() benutzen!
 int setjd1(double jd1);
public:
 int	std,min,sec,jahr,mon,tag,wtag;
 int	jahrestag;			//Tag im Jahr, mit 0 beginnend
 char	*wochentag,*monat;
 int lokalzeit() {flags=LOKALZEIT; return aktzeit();}
 int weltzeit() {flags=WELTZEIT; return aktzeit();}
 Zeit() {flags=0;}
 Zeit(int f);
 Zeit(unsigned long sec);
 Zeit(double mjd) {flags=2; setmjd(mjd);}
 ~Zeit() {}
 int istsommer() {return flags & SOMMERZEIT;} //test auf Sommerzeit
 int set(int tg,int mo,int ja,int h,int m=0,int s=0);
 int set(char *s);
 int setjd(double jd)  {return setjd1(jd+0.5);}
 int setmjd(double mjd) {return setjd1(mjd+2400001.0);}
 double mjd();
 double jd() {return mjd()+2400000.5;}
 int addstd(int h) {return set(tag,mon,jahr,std+h,min,sec);}
 char *stri(char *str);  //Datum u. Zeit als String darstellen
 char *stri() {char *s=new char[32]; return stri(s);}
 Zeit operator+=(Zeit&);
 int operator>(Zeit& v);
 bool operator==(Zeit& v);
};

Zeit::Zeit(int f)
{
 switch(flags=f)
   {case LOKALZEIT: lokalzeit(); break;
    case WELTZEIT:  weltzeit(); break;
   }
}

static char *wochentag_name[7]=
   {"Sonntag","Montag","Dienstag","Mittwoch","Donnerstag","Freitag","Samstag"};
static char *monats_name[13]=
   {"NULL","Januar","Februar","Mrz","April","Mai","Juni",
    "Juli","August","September","Oktober","November","Dezember"};

time_t Zeit::aktzeit()
{
 time_t tim; //Sekunden seit 1.Jan.1970 0:00:00
 struct tm *z;
 time(&tim);
 if(flags & WELTZEIT) z=gmtime(&tim);
 else z=localtime(&tim);
// if(flags & WELTZEIT) z=gmtime2(&tim);//test
// else z=localtime2(&tim);//test
 sec=z->tm_sec;
 min=z->tm_min;
 std=z->tm_hour;
 tag=z->tm_mday;
 mon=z->tm_mon+1;
 jahr=z->tm_year+1900;
 wochentag=wochentag_name[wtag=z->tm_wday];
 monat=monats_name[mon];
 jahrestag=z->tm_yday;
 if(z->tm_isdst) flags |= SOMMERZEIT; else flags &= ~SOMMERZEIT;
 return tim;
}

int Zeit::set(int tg,int mo,int ja,int h,int m,int s)
{
 static int mona[12]={31,28,31,30,31,30,31,31,30,31,30,31};
 int tim,yday;
 if(--mo>=12) {++ja; mo-=12;}
 if(ISTSCHALTJAHR(ja)) mona[1]=29; else mona[1]=28;
 while(s>=60) {m++; s-=60;}
 while(m>=60) {h++; m-=60;}
 if(h<0) {tg--; h+=24;}
 else while(h>=24) {tg++; h-=24;}
 if(tg>mona[mo])
   {tg-=mona[mo];
    if(++mo>=12)
      {++ja; mo-=12; if(ISTSCHALTJAHR(ja)) mona[1]=29; else mona[1]=28;}
   }
 for(tim=0,jahr=1970;jahr<ja;jahr++)
   {if(ISTSCHALTJAHR(jahr)) tim+=366;
    else tim+=365;
   }
 for(yday=mon=0;mon<mo;mon++)
	yday += mona[mon];
 yday += tg-1;
 tim = (tim+yday)*(3600*24) + (h*60+m)*60+s;
 wtag=(tim/(3600*24)+4)%7;/* +4 fuer 1.Jan.1970==Donnerstag */
 sec=s; min=m; std=h;
 tag=tg; mon=mo+1; jahr=ja;
 wochentag=wochentag_name[wtag];
 monat=monats_name[mon];
 jahrestag=yday;
// if(z->tm_isdst) flags |= SOMMERZEIT; else flags &= ~SOMMERZEIT;
 return tim;
}

char *Zeit::stri(char *str)  //Datum u. Zeit als String darstellen
{
// Beispiele: " 1.1.1997   8:00:00"
//            "31.12.1997 23:59:59"
 sprintf(str,"%2d.%d.%d  ",tag,mon,jahr);
 sprintf(&str[11],"%2d:%02d:%02d",std,min,sec);
 return str;
}
int Zeit::set(char *str)
{
 int tg,mo,ja,h,m,s;
 sscanf(str,"%d%*c%d%*c%d %d%*c%d%*c%d",&tg,&mo,&ja, &h,&m,&s);
 return set(tg,mo,ja,h,m,s);
}

int Zeit::operator>(Zeit& v)
{
 if(jahr!=v.jahr) return (jahr>v.jahr);
 if(mon!=v.mon) return (mon>v.mon);
 if(tag!=v.tag) return (tag>v.tag);
 if(std!=v.std) return (std>v.std);
 if(min!=v.min) return (min>v.min);
 return (sec>v.sec);
}

Zeit Zeit::operator+=(Zeit& v)
{
 set(tag+v.tag,mon+v.mon,jahr+v.jahr,std+v.std,min+v.min,sec+v.sec);
 return *this;
}

bool Zeit::operator==(Zeit& v)
{
 return (sec==v.sec && min==v.min && std==v.std
	 && tag==v.tag && mon==v.mon && jahr==v.jahr);
}

//Meist ist es besser mit Zeiten in MJD oder JD zu rechnen, und nur
//bei Bedarf in Zeit-Klasse umzurechnen:

int Zeit::setjd1(double jd1) //jd1 = JD+0.5 = MJD+2400001.0
{
 long b,c,d,e,f,jd0=long(jd1);
 double hour;
 if(jd0<2299161)
   c=jd0+1524; //Julianischer Kalender
 else
   {b=long((jd0-1867216.25)/36524.25); //Gregoranischer Kalender
    c=jd0+b-b/4+1525;
   }
 d=long((c-122.1)/365.25); e=365*d+d/4; f=long((c-e)/30.6001);
 tag = c-e-long(30.6001*f);
 mon = f-1-12*long(f/14);
 jahr = d-4715-(7+mon)/10;
 hour = 24.0*(jd1-jd0);
 std=int(hour); hour=(hour-std)*60.;
 min=int(hour); hour=(hour-min)*60.;
 sec=int(hour+0.5);
 return set(tag,mon,jahr,std,min,sec);
}

double Zeit::mjd()  //Modifiziertes Julianisches Datum
{
 int b,day=tag,month=mon,year=jahr;
 double a;
 double hour=std+min/60.+sec/3600.;
 if(month<=2) {month += 12; year--;}
 if(year<1582 || (year==1582 && (100*month+day)<=1004))
	b = (year+4716)/4 - 1181;
 else	b = year/400 - year/100 + year/4;
 a = 365.0*year-679004.0;
 return a+b+long(30.6001*(month+1))+day+hour/24.0;
}

Zeit::Zeit(unsigned long s) //s=Sekunden seit 1970
{
 long tg,mo,ja,jh,j,ja1,h,m,k=0;
 long tg0;//Tage seit 1.Jan.1970
 int yday;//sovielter Tag im Jahr mit 0 beginnend
 static int mona[12]={31,28,31,30,31,30,31,31,30,31,30,31};
 m=s/60; s=s%60;
 h=m/60; m=m%60;
 tg0=h/24; h=h%24;
 do
  {if(k==0) ja=tg0*100/36525;
   else ja+=k;
   ja1=ja+1;
   tg=tg0-(ja*365+ja1/4-ja1/100+ja1/400);
   if(tg<0) k=tg/365-1;
   else if(tg>365) k=tg/365;
   else k=0;
  }
 while(k!=0);
 ja+=1970;
 if(ISTSCHALTJAHR(ja)) mona[1]=29; else mona[1]=28;
 mo=0;
 while(tg>mona[mo])
   {tg-=mona[mo];
    if(++mo>=12)
      {++ja; mo-=12; if(ISTSCHALTJAHR(ja)) mona[1]=29; else mona[1]=28;}
   }
 for(yday=mon=0;mon<mo;mon++)
	yday += mona[mon];
 yday += tg-1;
 wtag=(tg0+4)%7;/* +4 fuer 1.Jan.1970==Donnerstag */
 sec=s; min=m; std=h;
 tag=tg+1; mon=mo+1; jahr=ja;
 wochentag=wochentag_name[wtag];
 monat=monats_name[mon];
 jahrestag=yday;
}
