/* myls.cc			letzte Aenderung: 9.2.2009 */
#define VERSION "Version 0.0"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Kurzbeschreibung: Musterprogramm um Dateien zu listen

History:
5.1.2009	Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>

/************************* Vordeklarationen ***************************/
void myls(const char *ordner);
void mylsmitsortierung(const char *ordner);

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

//test:
void datumtest(char *name)
{
 char feld[1024+32];
 int i,i1=0,c,jahr,mon,tag,std,min,sec;
 FILE *fp=fopen(name,"r");
 if(fp==NULL) {printf("%s nicht gefunden.\n",name); return;}
 for(i=0;i<1024;i++)
   {feld[i]=c=getc(fp);
    if(i<16 && c=='E') i1=i;
   }
 fclose(fp);
 if(i1==0 || strcmp("Exif",&feld[i1])!=0) printf("kein Exif gefunden\n");
 else
   {if(strcmp(&feld[i1+6],"II*")==0) printf("Exif Little-Endian\n");
    else if(strcmp(&feld[i1+6],"MM")==0 && feld[i1+9]=='*')
       printf("Exif Big-Endian\n");
    else printf("Exif %c%c %02X%02X\n",
		feld[i1+6],feld[i1+7],feld[i1+8],feld[i1+9]);
   }
 for(i=0;i<1024-20;i++)
   {//teste auf Datumfeld der Form 2008:11:31 08:00:00
    if(feld[i+4]==':' && feld[i+7]==':' && feld[i+10]==' '
	&& feld[i+13]==':' && feld[i+16]==':' && feld[i+19]==0)
      {sscanf(&feld[i],"%d:%d:%d %d:%d:%d",&jahr,&mon,&tag,&std,&min,&sec);
       printf("%04d-%02d-%02d %02d:%02d:%02d\n",jahr,mon,tag,std,min,sec);
      }
   }
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char ordnername[80];
 FILE *fp1,*fp2;
 int i,j,c;
 ordnername[0]=0;
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(ordnername,argv[i]);
	         //else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("myls  %s\n",VERSION);
	 printf("Anwendung: myls [-flags] [Ordner]\n");
	 printf("  Flags:  r=Rekursiv\n");
	 printf("          f=ohne Sortierung\n");
	 printf("          l=mit zusaetzlichen Informationen pro Datei\n");
	 printf(" provisorisch:  t=teste Dateidatum\n");//test
	 exit(0);
	}
 if(argflag['T'] && *ordnername!=0) {datumtest(ordnername); exit(0);}//test
 if(argflag['F']) myls(ordnername);
 else mylsmitsortierung(ordnername);
 return 0;
}/* ende von main */

void myls(const char *ordner)
{
 char name[80]; //Einfachheitshalber Namenslaenge auf 80 beschraenkt
 char *pfadname=NULL,str[40];
 const char *styp;
 DIR *dp;
 struct dirent *dirp;
 struct stat statbuf;
 const int NORM=1,VERZ=2,SPEZ=3,LINK=4;
 int j,typ;
 if(ordner==NULL || *ordner==0) ordner=".";
 pfadname=new char[strlen(ordner)+80+2];
 dp=opendir(ordner);
 if(dp==NULL) {printf("kann Ordner '%s' nicht oeffnen.\n",ordner); return;}
 for(j=0;(dirp=readdir(dp))!=NULL;j++)
   {if(strcmp(dirp->d_name,".")==0 || strcmp(dirp->d_name,"..")==0) continue;
    sprintf(pfadname,"%s/%s",ordner,dirp->d_name);
    typ=NORM;
    if(lstat(pfadname,&statbuf) < 0) typ=SPEZ;
    else
      switch(statbuf.st_mode & S_IFMT)
	{case S_IFREG: typ=NORM; break;
	 case S_IFDIR: typ=VERZ; break;
	 case S_IFLNK: typ=LINK; break;
	 case S_IFBLK: case S_IFCHR: case S_IFIFO: case S_IFSOCK:
	 default: typ=SPEZ;
	}
    switch(typ)
      {case NORM: styp="     "; break;
       case VERZ: styp="(dir)"; break;
       case LINK: styp="(lnk)"; break;
       default: sprintf(str,"(%03lX)",typ); styp=str;
      }
    if(argflag['L'])
      {if(strcmp(ordner,".")==0) printf("%s \t mtime=%d \t %s\n",
					dirp->d_name,statbuf.st_mtime,styp);
       else printf("%s/%s \t mtime=%d \t %s\n",
		   ordner,dirp->d_name,statbuf.st_mtime,styp);
      }
    else
      {if(strcmp(ordner,".")==0) printf("%s \t %s\n",dirp->d_name,styp);
       else printf("%s/%s \t %s\n",ordner,dirp->d_name,styp);
       }
    if(argflag['R'] && typ==VERZ)
      {char *neupfad=new char[strlen(ordner)+strlen(dirp->d_name)+2];
       sprintf(neupfad,"%s/%s",ordner,dirp->d_name);
       myls(neupfad);
       delete[] neupfad;
      }
   }
 printf("%d Dateien.\n",j);
 closedir(dp);
 delete[] pfadname;
}

/* Mit alfabetischer Sortierung der Dateiname etwas aufwaendiger: */
const int N80=80;//maximale laenge von Dateinamen
const int NORM=1,VERZ=2,SPEZ=3,LINK=4;//Dateitypen

class Dateiliste
{
 char name[N80];
public:
 int typ;
 Dateiliste *next;
 Dateiliste() {name[0]=0; typ=0; next=NULL;}
 ~Dateiliste() {if(next!=NULL) delete[] next;}
 char& operator[](int i) {return name[i];}
 bool operator<=(Dateiliste& y);
 Dateiliste* einsortieren(const char *neuername,int t);
 Dateiliste* einsortieren(Dateiliste *neu);
};
bool Dateiliste::operator<=(Dateiliste& y)
{
 int i,c1,c2;
 for(i=0;(c1=name[i])!=0 && (c2=y[i])!=0;i++)
   {c1 &= 0xFF; c2 &= 0xFF;
    if(c1<c2) return true;
    else if(c1>c2) return false;
   }
 if(name[i]==0) return true;
 if(y[i]==0) return false;
 return true;
}
Dateiliste* Dateiliste::einsortieren(const char *neuername,int t)
{
 if(name[0]==0 && next==NULL)
   {//erster Eintrag in leere Liste
    strncpy(name,neuername,N80); name[79]=0;
    typ=t;
    return this;
   }
 Dateiliste *neu=new Dateiliste[1];
 if(neu==NULL) {printf("Fehler: new fehlgeschlagen.\n"); return this;}
 strncpy(neu->name,neuername,N80); neu->name[79]=0;
 neu->typ=t;
 return einsortieren(neu);
}
Dateiliste* Dateiliste::einsortieren(Dateiliste *neu)
{
 if((*neu) <= (*this)) {neu->next=this; return neu;}
 if(next==NULL) next=neu;
 else next=next->einsortieren(neu);
 return this;
}

const char *typ2str(int typ)
{
 const char *styp;
 char str[40];
 switch(typ)
      {case NORM: styp="     "; break;
       case VERZ: styp="(dir)"; break;
       case LINK: styp="(lnk)"; break;
       default: sprintf(str,"(%03lX)",typ); styp=str;
      }
 return styp;
}

void mylsmitsortierung(const char *ordner)
{
 char *pfadname=NULL;
 DIR *dp;
 struct dirent *dirp;
 struct stat statbuf;
 int j,typ;
 Dateiliste *liste=new Dateiliste[1];
 if(ordner==NULL || *ordner==0) ordner=".";
 pfadname=new char[strlen(ordner)+N80+2];
 dp=opendir(ordner);
 if(dp==NULL) {printf("kann Ordner '%s' nicht oeffnen.\n",ordner); return;}
 for(j=0;(dirp=readdir(dp))!=NULL;j++)
   {if(strcmp(dirp->d_name,".")==0 || strcmp(dirp->d_name,"..")==0) continue;
    sprintf(pfadname,"%s/%s",ordner,dirp->d_name);
    typ=NORM;
    if(lstat(pfadname,&statbuf) < 0) typ=SPEZ;
    else
      switch(statbuf.st_mode & S_IFMT)
	{case S_IFREG: typ=NORM; break;
	 case S_IFDIR: typ=VERZ; break;
	 case S_IFLNK: typ=LINK; break;
	 case S_IFBLK: case S_IFCHR: case S_IFIFO: case S_IFSOCK:
	 default: typ=SPEZ;
	}
    if(strcmp(ordner,".")==0) liste=liste->einsortieren(dirp->d_name,typ);
    else liste=liste->einsortieren(pfadname,typ);
    if(argflag['R'] && typ==VERZ)
      {char *neupfad=new char[strlen(ordner)+strlen(dirp->d_name)+2];
       sprintf(neupfad,"%s/%s",ordner,dirp->d_name);
       myls(neupfad);
       delete[] neupfad;
      }
   }
 closedir(dp);
 delete[] pfadname;
 Dateiliste *p;
 for(p=liste;p!=NULL;p=p->next)
   if(p->typ==NORM) printf("%s\n",&p[0]);
   else printf("%s  \t%s\n",&p[0],typ2str(p->typ));
 printf("%d Dateien.\n",j);
 delete[] liste;
}
