/* start_grafclass.cc			letzte nderung: 1.3.2000 */
#define VERSION "Version 0.0"
// start_grafclass berall durch Programmname ersetzen !!
/*
Uebersetzen:
;AVAX> cx start_grafclass
;AVAX> blink start_grafclass,[pfister.obj]xtekplot1
;AVAX> pur start_grafclass.exe

 Kurzbeschreibung: allgemeines Musterprogramm fr C++ mit XTekplot1-Grafik
                   mit Verwendung von Klassen

History:
0.3.2000	Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <xtekplot1.h>

/************************* Vordeklarationen ***************************/

/************************* Men Behandlung ****************************/
static int exitflag=0;
void m_exit() {exitflag=1;}

/***************************** Klassen ********************************/
class Fenster
{
 int maxcol;
 int breite,hoehe,tiefe,visklasse; //Fenstergroesse
 double xmin,ymin,xmax,ymax; //Userkoordinaten
 double bx,hy; //Schriftgroessen
public:
 Fenster(char*,int b=12500,int h=10000,int t=24);
 ~Fenster();
 int run(char *text=NULL);
};
Fenster::Fenster(char *name,int br,int ho,int ti)
{
 exitflag=0;
 xmin= -0.1; ymin=0.; xmax=1.1; ymax=1.;
 bx=(xmax-xmin)/100; hy=(ymax-ymin)/40;
 //tek_setdebug(1);//test
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(breite>br) breite=br;
 if(hoehe>ho) hoehe=ho;
 if(tiefe>ti) tiefe=ti;
 maxcol=(1<<tiefe);
 setsize(breite,hoehe,tiefe);
 setmenu(1,"File");
 setmenu(1,"Exit",&m_exit);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 set_tektitel(name);
 screenclear(1); color(0);
 term_refresh();
}
Fenster::~Fenster()
{
 term_exit();
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 int ok;
 char fenstername[80];
 if(argc>1 && *argv[1]=='?')
	{printf("start_grafclass  %s\n",VERSION);
	 exit(0);
	}
 sprintf(fenstername,"start_grafclass  %s",VERSION);
/*
 {
  Fenster klein("kleines Fenster",320,256);
  ok=klein.run("Hallo Welt"); if(!ok) exit(ok);
 }
*/
 {
  Fenster gross(fenstername,640,512,4);
  ok=gross.run();
 }
 return ok;
}/* ende von main */

int Fenster::run(char *text)
{
 int col=0,ok=1;
 inital_new();
 plot(0.,0.,PENUP); plot(1.,1.,PENDOWN); /* Hintergrundbild zeichnen */
/** Variante1 **/
 if(text!=NULL)
  {textsize(bx,hy);
   double x=xmin+(xmax-xmin)/10, y=(ymax+ymin)/2;
   schrift(x,y,text);
   term_refresh();
   while(exitflag==0 && waitmenu(1)==0)
	;// auf Benutzereingaben warten
  }
 else
/** Variante2 **/
  {inital_new();
   while(exitflag==0)
	{waitBOF();		//auf Ende des Bildaufbaus warten
	//oder waitTOF();	//auf Beginn des Bildaufbaus warten
	//oder waitmenu(0);	//nicht warten
	 if(++col==maxcol) col=0;
	 color(col); //nach jedem Bildaufbau mit anderer Farbe zeichnen
	 plot(1.,0.,PENUP); plot(0.,1.,PENDOWN);
	 plot(0.,0.,PENUP); plot(1.,1.,PENDOWN);
	}
/**/
  }
 return ok;
}
