/* expnmr.cc			letzte Aenderung: 20.1.2009 */
#define VERSION "Version 0.0"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Kurzbeschreibung: Experimentelle NMR-Daten vergleichen

History:
20.1.2009	Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <xtekplot1.h>

#define XMAX 1280
#define YMAX 1024
#define TIEFE 24

/************************ Globale Variablen ***************************/
static int gbreite,ghoehe,gtiefe;
static int test=0;//fuer Testausdrucke

/************************* Vordeklarationen ***************************/

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
   if(c=='V') test++;
  }
}

/************************* Menu Behandlung ****************************/
static int exitflag=0;
void menu_exit() {exitflag=1;}

/************************* Hauptprogramm ******************************/
void grafikfenster_oeffnen()
{
 double xmin=0,ymin=0,xmax=XMAX,ymax=YMAX;
 setmenu(1,"File");
 setmenu(1,"Exit",&menu_exit);
 //set_funktions(mauspre,mausrel,NULL,mausmot);
 inital(xmin,ymin,xmax,ymax);
 char titel[80];
 sprintf(titel,"expnmr %s",VERSION);
 set_tektitel(titel);
 //if(gtiefe<24) farben_init();
 //hintergrundgrau=farbnummer(128,128,128);
 term_refresh();
 waitTOF();
 //startflag=0;
}

main(int argc,char *argv[])
{
 char quellname[80],zielname[80];
 quellname[0]=zielname[0]=0;
 FILE *fp1,*fp2;
 int c,i,j,visklasse;
 if(argc<=0)
   ;/* es wurde von WorkBench gestartet */
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
		 else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("expnmr  %s\n",VERSION);
	 printf("Anwendung: expnmr [-Optionen] [Quelle] [Ziel]\n");
	 printf(" Optionen: v=mit Testausdrucken\n");
	 exit(0);
	}
 //tek_setdebug(1);//test
 getmaxsize(&gbreite,&ghoehe,&gtiefe,&visklasse);
 if(argflag['V']) printf("gbreite=%d ghoehe=%d gtiefe=%d visklasse=%d\n",
			 gbreite,ghoehe,gtiefe,visklasse);
 if(gtiefe>TIEFE) gtiefe=TIEFE;
 else if(gtiefe<TIEFE)
   {printf("Warnung: Farbtiefe kleiner als %d: gtiefe=%d\n",TIEFE,gtiefe);}
 if(gbreite>XMAX) gbreite=XMAX;
 if(ghoehe>YMAX) ghoehe=YMAX;
 setsize(gbreite,ghoehe,gtiefe);
 if(gtiefe<24) setmaxfarben(1<<gtiefe);
 grafikfenster_oeffnen();
 int taste,asci,vorher= -1; ULONG rawcode;
 while(exitflag==0 && waitmenu(0)==0)
  {waitTOF(); //auf Beginn des Bildaufbaus warten
   if(keyget(&taste,&asci,&rawcode)!=0)
     {switch(rawcode)
	{case 0xFF51: case 0xFF52: case 0xFF53: case 0xFF54://Pfeiltasten
	    printf("Pfeiltaste gedrueckt n=%d\n",rawcode-0xFF50);//test
	 CASE 'a': case 'A': //m_auswahl2(0);
	 DEFAULT:
	   if(test) printf("taste=%d=%02X asci=0x%02X='%c' rawcode=0x%04lX\n",
			    taste,taste,asci,asci,rawcode);
	}
     }
  }
 term_exit();
 return 0;
}/* ende von main */
