/* o18austausch.c			letzte Aenderung: 31.10.2007 */
#define VERSION "Version 0.1"
/*
 Austausch von Isotopen berechnen
 Beispiel:
 Ala-1-^13C + H2^18O ---> Ala-1-^13C-^18O2

 Allgemeiner:
 X-^16O_n + H2^18O ---> X-^18O_n

History:
21.1.2005	Erstellung von aust.cc (RP)
2.11.05		Anpassung fuer diesen Spezialfall (Ala-13C-18O)
31.10.07	Namensaenderung von c13o18ala nach o18austausch
                Anpassung fuer andere Molekuele
*/

#include <stdio.h>
//#include <iostream>
#include <stdlib.h>

/************************* Vordeklarationen ***************************/


/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 4
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 int i,j,c,n,noxygens=2;
 double a,b1,c1,markiert,mgew=90.1;
 char molekname[200]="Ala-^13C"; //Name des Molekuels (bei Option i)
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) sscanf(argv[i],"%lf",&a);
		 else if(j==2) sscanf(argv[i],"%lf",&b1);
		 else if(j==3) sscanf(argv[i],"%lf",&c1);
		 else if(j==4) sscanf(argv[i],"%d",&n);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("o18austausch  %s\n",VERSION);
	 printf("Anwendung: o18austausch [A B C N] [-Flags]\n");
	 printf(" A = Menge Ala-^13C mit noch nicht markiertem O\n");
	 printf(" B = Erste Menge H2^18O mit C %% markiertem Anteil\n");
	 printf(" N = Anzahl Austausche\n");
	 printf(" alle Mengen in Gramm.\n");
	 printf("  Flags: i = Interaktive Eingabe von andern Molekuelen\n");
	 exit(0);
	}
 if(argflag['I'])
   {printf("Welches Molekuel soll verwendet werden:"); scanf("%s",molekname);
    printf("Molekulargewicht:"); scanf("%lf",&mgew);
    printf("Anzahl austauschbar O-Atome:"); scanf("%d",&noxygens);
   }
 //if(j<1) {printf("Menge Ala-^13C in Gramm:"); scanf("%lf",&a);}
 if(j<1) {printf("Menge %s in Gramm:",molekname); scanf("%lf",&a);}
 if(j<2) {printf("Erste Menge ^18O-Wasser:"); scanf("%lf",&b1);}
 if(j<3) {printf("Markierter Anteil in %%:"); scanf("%lf",&c1);}
 if(j<4) {printf("Anzahl Austausche:"); scanf("%d",&n);}
 double b2[n],c2[n];
 //a = 2*a/90.1; //2 Sauerstoffatome pro Molekuel
 a = noxygens*a/mgew;
 b2[0]=b1/20.0; c2[0]=c1*0.01;
 for(j=2;j<=n;j++)
   {printf("Menge ^18O-Wasser beim %d. Austausch:",j); scanf("%lf",&b2[j-1]);
    printf("Anteil ^18O beim %d.Austausch (in %%):",j); scanf("%lf",&c2[j-1]);
    b2[j-1] /= 20.0;
    c2[j-1] *= 0.01;
   }
 //printf("Austausch von %.2lfg Ala-^13C entsprechend %.1lf mmol O\n",
 //	a*90.1/2,a*1000);
 printf("Austausch von %.2lfg %s entsprechend %.1lf mmol O\n",
	a*mgew/noxygens, molekname, a*1000);
 for(i=0,c1=0;i<n;i++)
   {markiert=a*c1+b2[i]*c2[i];
    c1=markiert/(a+b2[i]);
    printf("%d. Austausch: %.2lfg = %.1lf mmol %.1lf%%iges H2^18O ---> %.2lf\%\n",
	   i+1,b2[i]*20,b2[i]*1000,c2[i]*100,c1*100);
   }
 return 0;
}/* ende von main */
