#ifndef LABJACKCLASS_H
#define LABJACKCLASS_H

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>
#include <string.h>
#include <ulong.h>
/* if you dont like ulong.h use this and adapt it to your compiler:
// (UBYTE is 8 Bit, UWORD is 16 Bit, ULONG is 32 Bit)
#define UBYTE unsigned char
#define UWORD unsigned short
#define ULONG unsigned int
*/

class Labjack
{
 UBYTE buf[8],pwmbuf[8],IOout,gain[4];
 int fd;
 double caliba[8],calibb[8]; //Achsenabschnitt und Steigung fr ain()
 double caldia[4],caldib[4],caldic[4],caldid[4]; //fr aindiff()
 UWORD aoutdigits(double);
 double digitsain(UWORD bits,int g=0);
 int ljopen();
 void ljclose();
public:
 Labjack();
 ~Labjack();
 int labjopen();
 void labjclose();
 int printfirmware();
 void bufdump(); //only for debugging
 int dio(UWORD Dtris, UBYTE IOtris,
	 UWORD& Dstate,UBYTE& IOstate,int update,UWORD* Dlatch=NULL);
 int aout(double a0,double a1);
 int ain(double*); //Analog In, Read all 8 Single-Ended Inputs
 int setgain(int g[4]); //allowed values: 1,2,4,5,8,10,16,20
 int setgain(int g);
 int code2gain(int);
 int gain2code(int);
 int aindiff(double*); //Analog In, Read 4 Differential Inputs
 int ainput(int modus,int n,double* gains,int* channels,double* a);
 void calib(int i,double a,double b);
 void calibdiff(int i,double a,double b,double c,double d);
};
#endif
