/* oszi.cc			letzte nderung: 23.11.2003 */
#define VERSION "Version 0.1"
/*

  Oszillograph

History:
2.11.2003	Erstellung (RP)
*/

//#define TESTMODUS 1

#include <stdio.h>
#ifndef GCC_VERSION
#define GCC_VERSION (__GNUC__ * 1000 + __GNUC_MINOR__)
#endif
#if GCC_VERSION>=3000
#include <iostream>
using namespace std;
#else
#include <stream.h>
#endif
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <sys/io.h>
#include <ulong.h>
#include <xtekplot1.h>
#include <vektorklasse.cc>
#define XMAX 1280
#define YMAX 1024
#define TIEFE 8
static double xmin=0,xmax=33.6,ymin=0,ymax=26.0; //Bildschirmkoord in cm
static double schirm_x1=xmin,schirm_x2=30,schirm_y1=2,schirm_y2=ymax;
const int SCHWARZ=0,WEISS=1,ROT=2,GRUEN=3,BLAU=4,VIOLET=5,GELB=6,GRAU=7,
  RAST1=8,RAST2=9,HELLGRAU=10;
const int TRIG_OFF=0,TRIG_MANUAL=1,TRIG_AUTO=2,
	  TRIG_KAN1=3,TRIG_KAN2=4,TRIG_KAN3=5,TRIG_KAN4=6;

/*************************** kleinkram ***************************/
inline long idfix(double x) {return long((x>=0.) ? x+0.5 : x-0.5);}
void udelay(long usec)
{
 long sum;
 for(long j=0;j<36;j++)
  for(long i=0;i<usec;i++)
    sum += i+j;
}
void warten(long usec)
{
 while(usec>1000) {usec-=1000; udelay(1000);}
 if(usec>0) udelay(usec);
}

double aktuellezeit()  //Sekunden seit Rechnerstart
{
 double zeit;
 FILE *fp=fopen("/proc/uptime","r");
 fscanf(fp,"%lf",&zeit);
 fclose(fp);
 return zeit;
}

void linie(double x1,double y1,double x2,double y2)
{
 plot(x1,y1,PENUP); plot(x2,y2,PENDOWN);
}

void aktivbox(int akt,double x1,double y1,double x2,double y2)
{ //Box zeichnen, akt=1: selektiert, akt=0: deselektiert
 if(akt==1) color(SCHWARZ); else color(HELLGRAU);
 linie(x1,y1,x1,y2); linie(x1,y2,x2,y2);
 if(akt==1) color(HELLGRAU); else color(SCHWARZ);
 linie(x1,y1,x2,y1); linie(x2,y1,x2,y2);
}

void pfeil(double x1,double y1,double y2,double xspitz)
{
 double y=(y1+y2)/2;
 linie(x1,y1,x1,y2);
 linie(x1,y1,xspitz,y);
 linie(x1,y2,xspitz,y);
}

/************************* Vordeklarationen ***************************/
void allesneuzeichnen();
void redrawschirm();
inline void redrawschirm2() {allesneuzeichnen();} //test
void mauspre(),mausrel(),mausmot();

/************************* A/D-Wandler ***************************/
#include "labjackclass.h"

static int ad_gain[4]={1,1,1,1};

double adwandlung(int kanal,int* gain)
{
 static Labjack lab;
 static int start=1;
 if(start)
   {if(lab.printfirmware()<0) exit(0);
    //lab.calib(0,-0.0296,1.0049);
    start=0;
   }
 static double volt[8];
 if(kanal==0)
   {int g; int j,flag;
    if(gain!=NULL) lab.setgain(gain);
    lab.aindiff(volt);
   }
 return volt[kanal];
}

/***************************** Grafik *********************************/
//Globale Variablen:
static int exitflag=0;
static char dateiname[200]="oszisave.tmp";
static double bx=0.20,hy=0.35, //kleine Schrift
	      bx1=0.40,hy1=0.50, //mittlere Schrift
	      bx2=0.50,hy2=0.70, //grosse Schrift
	      hy0=0.0; //wirkliche Hhe der kleinen Schrift

const int TYP_UNI=0,TYP_FLIP=1,TYP_REGLER=2,TYP_KNOPF=3;

class Hgadget
{
 char text[80]; //beschreibender Text
 int nwert,maxn; //aktueller Wert, maximaler Wert
 bool aktivflag; //gesetzt wenn Mauszeiger im Gadget
 double textbreite,texth; //Abstand des Text links oben von Angelpunkt
 vektor box[2]; //Angelpunkt und rechts oben
 char **wtext; //Tabelle der Wert-Texte (z.B. "10mV")
 int bgcol,fgcol; //Hintergrund- und Vordergrund-Farbe
 int htyp; //TYP_UNI:normalfall, TYP_FLIP:Ein/Aus , TYP_REGLER:Schieberegler
           //TYP_KNOPF: nwert wechseln zwischen 0 und 1
 double xr0,xr1,xr2,mausx; //Reglerposition
 char *wstr; double wstart,wstep; //Alternative zu wtext
 funkzeig unterprog;
public:
 void init(char* s,double b,double h,int n,int max,char** wt,
	   double x1,double y1,double x2,double y2,int typ=0,
	   char* cstr=NULL,double xwstart=0,double xwstep=0,funkzeig u=NULL);
 void settext(char* s) {strcpy(text,s);}
 void neupos(double x,double y);
 void zeichnen();
 int getn() {return nwert;}
 double getw();
 void setn(int n) {if(n>=0 && n<=maxn) nwert=n;}
 bool istinbox(double x,double y)
	{return x>=box[0].x && x<=box[1].x && y>=box[0].y && y<=box[1].y;}
 void klick(double x,double y);
 bool mausmove(double x,double y);
 void release(double x,double y);
 bool istaktiv() {return aktivflag;}
 void aktiv(bool b);
};
void Hgadget::init(char* s,double b,double h,int n,int max,char** wt,
		   double x1,double y1,double dx,double dy,int typ,
		   char* cstr,double xwstart,double xwstep,funkzeig u)
{
 if(s==NULL) text[0]=0; else strcpy(text,s);
 textbreite=b; texth=h;
 nwert=n; maxn=max;
 wtext=wt;
 box[0]=vektor(x1,y1); box[1]=vektor(x1+dx,y1+dy);
 bgcol=GRAU; fgcol=SCHWARZ;
 htyp=typ;
 xr0=xr1=xr2=mausx=0;
 wstr=cstr; wstart=xwstart; wstep=xwstep;
 unterprog=u;
}
void Hgadget::neupos(double x,double y)
{
 box[0].x += x; box[0].y += y;
 box[1].x += x; box[1].y += y;
}
void Hgadget::aktiv(bool b)
{
 if(aktivflag==b) return;
 aktivflag=b;
 mausx=0;
 zeichnen();
}
void Hgadget::klick(double x,double y)
{
 double xmitte,ymitte, dx=(htyp==TYP_FLIP)?0:(box[1].x-box[0].x)/8;
 xmitte=(box[0].x+box[1].x)/2.0;
 if(htyp==TYP_REGLER)
   {int dn=maxn/10; if(dn==0) dn=1;
    mausx=0;
    if(x>box[1].x-dx && nwert<maxn) nwert++;
    else if(x<box[0].x+dx && nwert>0) nwert--;
    else if(x>xr2) {nwert+=dn; if(nwert>maxn) nwert=maxn;}
    else if(x<xr1) {nwert-=dn; if(nwert<0) nwert=0;}
    else {mausx=x;}
   }
 else if(htyp==TYP_KNOPF)
   {nwert=1; zeichnen();
    if(unterprog!=NULL) {(*unterprog)(); nwert=0;}
   }
 else if(x>=xmitte+dx || x<=xmitte-dx)
   {if(x>xmitte && nwert<maxn) nwert++;
    if(x<xmitte && nwert>0) nwert--;
   }
 else
   {ymitte=(box[0].y+box[1].y)/2.0;
    if(y>ymitte && nwert<maxn) nwert++;
    if(y<ymitte && nwert>0) nwert--;
   }
 zeichnen();
}
bool Hgadget::mausmove(double x,double y)
{
 bool update=false;
 if(mausx!=0)
   {nwert += idfix((x-mausx)*maxn/xr0); mausx=x;
    if(nwert<0) nwert=0; else if(nwert>maxn) nwert=maxn;
    zeichnen(); update=true;
   }
 return update;
}
void Hgadget::release(double x,double y)
{
 mausx=0;
 zeichnen();
}
void Hgadget::zeichnen()
{
 char str[40],*s;
 if(hy0==0.0) hy0=textsize(bx,hy);
 color(bgcol); fillbox(box[0].x,box[0].y,box[1].x,box[1].y); color(fgcol);
 if(text[0]!=0 && htyp!=TYP_KNOPF)
   schrift(box[0].x-textbreite,box[0].y+texth,text);
 if(htyp==TYP_UNI)
  {if(wtext==NULL)
     {if(wstr!=NULL) sprintf(str,wstr,wstart+nwert*wstep);
      else sprintf(str,"%d",nwert);
      s=str;
     }
   else {s=wtext[nwert];}
   schrift((box[0].x+box[1].x-bx*strlen(s))/2.0,(box[0].y+box[1].y-hy0)/2.0,s);
  }
 else if(htyp==TYP_KNOPF)
  {s=text; if(nwert==1) color(ROT);
   schrift((box[0].x+box[1].x-bx*strlen(s))/2.0,(box[0].y+box[1].y-hy0)/2.0,s);
   if(!aktivflag) color(SCHWARZ);
  }
 else if(htyp==TYP_FLIP)
  {if(wtext==NULL) {strcpy(str,"OFF   ON"); s=str;}
   else {sprintf(str,"%.18s   %.18s",wtext[0],wtext[1]); s=str;}
   schrift((box[0].x+box[1].x-bx*strlen(s))/2.0,(box[0].y+box[1].y-hy0)/2.0,s);
   double xm=(box[0].x+box[1].x)/2, dy=(ymax-ymin)/YMAX;
   aktivbox(1-nwert,box[0].x+dy,box[0].y+dy,xm,box[1].y-dy);
   aktivbox(nwert,xm,box[0].y+dy,box[1].x-dy,box[1].y-dy);
   color(bgcol);
  }
 else if(htyp==TYP_REGLER)
  {double dy=(ymax-ymin)/YMAX, dx, y1=box[0].y+dy, y2=box[1].y-dy;
   xr0=box[1].x-box[0].x; dx=xr0/8;
   xr0 -= 3*dx+2*dy;
   xr1=box[0].x+dx+dy+xr0/maxn*nwert; xr2=xr1+dx;
   if(aktivflag) {color(ROT); drawbox(xr1,y1,xr2,y2); color(fgcol);}
   if(wtext==NULL)
     {if(wstr!=NULL) sprintf(str,wstr,wstart+nwert*wstep);
      else sprintf(str,"%d",nwert);
      s=str;
     }
   else {s=wtext[nwert];}
   schrift((box[0].x+box[1].x-bx*strlen(s))/2.0,(box[0].y+box[1].y-hy0)/2.0,s);
   linie(box[0].x+dx,box[0].y,box[0].x+dx,box[1].y);
   linie(box[1].x-dx,box[0].y,box[1].x-dx,box[1].y);
   double dx4=dx/4;
   dy=(box[1].y-box[0].y)/4;
   pfeil(box[0].x+dx-dx4,box[0].y+dy,box[1].y-dy,box[0].x+dx4);
   pfeil(box[1].x-dx+dx4,box[0].y+dy,box[1].y-dy,box[1].x-dx4);
  }
 if(aktivflag) color(ROT);
 drawbox(box[0].x,box[0].y,box[1].x,box[1].y);
 if(aktivflag) color(SCHWARZ);
}
double Hgadget::getw()
{
 double wert; char c;
 int n=getn();
 if(wtext!=NULL) {sscanf(wtext[n],"%lf%c",&wert,&c); if(c=='m') wert*=0.001;}
 else if(wstr!=NULL) {wert=wstart+n*wstep;}
 else {wert=n;}
 return wert;
}

/************************ Kurve-Speicherung ***************************/
const int MAXPUNKTE=4000;
class Kurven
{
 int npu,aktiv[4];
 double xp[MAXPUNKTE];
 double yp[MAXPUNKTE][4];
public:
 Kurven() {npu=0; for(int i=0;i<4;i++) aktiv[i]=1;}
 bool put(double x,double y1,double y2,double y3,double y4);
 void clear() {npu=0;}
 int npunkte() {return npu;}
 double getx(int i);
 bool gety(int i,int j,double& y);
 void zeichnen();
};
static Kurven kurven;

bool Kurven::put(double x,double y1,double y2,double y3,double y4)
{
 if(npu==MAXPUNKTE) return false;
 xp[npu]=x; yp[npu][0]=y1; yp[npu][1]=y2; yp[npu][2]=y3; yp[npu][3]=y4;
 npu++;
 return true;
}
double Kurven::getx(int i)
{
 if(i>=npu) return 0;
 return xp[i];
}
bool Kurven::gety(int i,int j,double& y)
{
 if(i>=npu || aktiv[j]==0) return false;
 y=yp[i][j];
 return true;
}

/************************* Men Behandlung ****************************/
void menu_exit() {exitflag=1;}
void m_refresh();
void m_save1()
{
 double x,y;
 int i,j;
 FILE *fp;
 fp=fopen(dateiname,"w");
 if(fp==NULL) {printf("kann '%s' nicht erstellen\n",dateiname); return;}
 for(i=0;i<kurven.npunkte();i++)
   {fprintf(fp,"%lg",kurven.getx(i));
    for(j=0;j<4;j++)
      {if(kurven.gety(i,j,y)) fprintf(fp," %lg",y);}
    fprintf(fp,"\n");
   }
 fclose(fp);
}
void m_save2()
{
 m_save1();
 Delay(13);
}
void m_save()
{
 int ok=nachfilenamefragen("Save File",dateiname,200);
 if(ok) m_save1();
}
void m_zoom()
{
 int ok;
/*
 ok=requester_input(4,"xmin","%lf","%lf",&xmin,
		    "xmax","%lf","%lf\n",&xmax,
		    "ymin","%lf","%lf",&ymin,
		    "ymax","%lf","%lf\n",&ymax);
*/
 m_refresh();
}
void m_zoomin()
{
 m_refresh();
}
void m_zoomout()
{
 m_refresh();
}

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 1
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/************************* Hauptprogramm ******************************/
const int KAN_NGAD=5;
class Kanal
{
 double uquer; //Durchschnittliche Spannung zwischen Trigger und rechter Rand
 double uabsquer; //Durchschnittliche Wechsel-Spannung
 double u0,frequenz,t0,tf,freqsum;
 double yposition; //in Volt
 double yoffset;
 double mvprodiv; //in MilliVolt
 double x0,y0; //Position der Grafiken
 int col1,aktgain;
 double usumme,uabsum,umin,umax;
public:
 Hgadget gadget[KAN_NGAD];
 Kanal();
  // void set(double yp,double yo,double mv)
  //	{yposition=yp; yoffset=yo; mvprodiv=mv;}
 double yscal(double u);
 void setpos(double x,double y);
 void zeichnen(int neucol= -1);
 void calcuquer(double t)
	{uquer=usumme/t; uabsquer=uabsum/t; frequenz=freqsum/(tf-t0);}
 void usummereset() {usumme=uabsum=0; freqsum=0; t0=0; tf=1e-6;}
 void usummieren(double u,double t2,double t1);
 int getgain();
 void minmaxreset() {umin= -0.1; umax=0.1;}
};
static Kanal kanal[4];

static char *wtmvdiv[12]={"1mV","2mV","5mV","10mV","20mV","50mV",
			  "100mV","200mV","500mV","1V","2V","5V"};
static char *wtgain[9]={"auto","1","2","4","5","8","10","16","20"};
static char *wtacdc[2]={"DC","AC"};
static char *wtonoff[2]={"ON","OFF"};

Kanal::Kanal()
{
 yposition=yoffset=0; col1=1;
 mvprodiv=1000; uquer=uabsquer=0; frequenz=0; u0=0;
 usummereset(); minmaxreset(); aktgain=1;
 //             Text       b   h   n nmax wt     x1  y1   dx  dy
 gadget[3].init(" mV/Div ",1.8,0,  9,11,wtmvdiv,4.0,1.45, 2.5, 0.4);
 gadget[2].init("  Gain  ",1.8,0,  0, 8,wtgain, 4.0,1.0,  2.5, 0.4);
 gadget[1].init("Position",1.8,0,1000,2000,NULL,4.0,0.55, 2.5, 0.4,TYP_REGLER,
		"%.2lfV",-10.00,0.01);
 gadget[0].init(" ",       0,  0,  0, 1,wtacdc, 3.0,0,    2.0,0.45,TYP_FLIP);
 gadget[4].init(NULL,      0,  0,  0, 1,wtonoff,0.5,0,    2.0,0.45,TYP_FLIP);
}
int Kanal::getgain()
{
 double gain=gadget[2].getw();
 if(gain<0.99) //autogain
   {int x,erlaubtewerte[]={1,2,4,5,8,10,16,20,0};
    gain= -10.0/umin;
    if(umax*gain>10.0) gain=10.0/umax;
    for(int i=1;(x=erlaubtewerte[i])>0;i++)
      if(gain<x) {return aktgain=erlaubtewerte[i-1];}
    return aktgain=20;
   }
 return aktgain=idfix(gain);
}
void Kanal::usummieren(double u,double t2,double t1)
{
 double t=t2-t1;
 if(u<umin) umin=u; else if(u>umax) umax=u;
 usumme += u*t;
 uabsum += abs(u-uquer)*t;
 if(gadget[0].getn()==1) //AC
   {if(u>uquer && u0<=uquer)
      {if(t0==0) {freqsum=0; t0=t2; tf=t0+1e-6;} else {freqsum++; tf=t2;}}
    u0=u;
   }
}
void Kanal::setpos(double x,double y)
{
 x0=x; y0=y;
 for(int i=0;i<KAN_NGAD;i++) gadget[i].neupos(x,y);
}
double Kanal::yscal(double u)
{
 const double cmprodiv=2.0;
 yposition=gadget[1].getw();
 mvprodiv=idfix(gadget[3].getw()*1000);
 yoffset=(gadget[0].getn()==1)?uquer:0;
 return (u+yposition-yoffset)*1000/mvprodiv*cmprodiv+(schirm_y1+schirm_y2)/2;
}
void Kanal::zeichnen(int neucol)
{
 char text[40];
 for(int i=0;i<KAN_NGAD;i++) gadget[i].zeichnen();
 bool ac=(gadget[0].getn()==1);
 if(!ac) //DC
   {if(uquer>=1.0 || uquer<= -1.0) sprintf(text,"%.3lf V  ",uquer);
    else sprintf(text,"%3.1lf mV  ",uquer*1000);
   }
 else //AC
   {if(uabsquer>=1.0) sprintf(text,"%.3lf V~ ",uabsquer);
    else sprintf(text,"%3.1lf mV~ ",uabsquer*1000);
   }
 if(neucol>=0) col1=neucol;
 color(col1);
 schrift(x0+0.2,y0+1.0,text);
 if(ac)
   {if(frequenz>=1.0) sprintf(text,"%.3lf Hz ",frequenz);
    else sprintf(text,"%3.1lf mHz ",frequenz*1000);
    schrift(x0+0.2,y0+0.5,text);
   }
 if(gadget[2].getn()==0) //autogain
   {sprintf(text,"%d",aktgain);
    color(SCHWARZ); schrift(x0+6.7,y0+1.1,text);
   }
}

double tscal(double t,int msdiv)
{
 return t*1000/msdiv*2;
}

class Spielfeld
{
 Hgadget *gadget[100];
 int ngadgets;
public:
 Hgadget zeitdiv,graster,trigquell,triglevel,trigflank,saveknopf;
 Spielfeld();
 void zeichnen();
 bool mausklick(double x,double y);
 bool mausrelease(double x,double y);
 bool mausmove(double x,double y);
 int msecprodiv() {return idfix(zeitdiv.getw()*1000);}
 int trigger(double *lev,int *fla)
  {*lev=triglevel.getw(); *fla=trigflank.getn(); return trigquell.getn();}
};
static Spielfeld spielfeld;

static char *wtsecdiv[10]={"50ms","100ms","200ms","500ms","1Sec","2Sec","5Sec",
			   "10Sec","30Sec","60Sec"};
static char *wtraster[3]={"off","light","strong"};
static char *wtsource[7]={"Manual","Manual","Auto","Kanal1","Kanal2","Kanal3","Kanal4"};
static char *wtflank[2]={"UP","DWN"};

Spielfeld::Spielfeld()
{
 //             Text       b   h   n nmax  wt     x1   y1    dx   dy
 zeitdiv.init(  "Sec/Div", 1.4,0,  1,9, wtsecdiv, 31.5,24.0, 2.0, 0.5);
 graster.init(  " Raster", 1.4,0,  1,2, wtraster, 31.5,23.0, 2.0, 0.5);
//trigquell.init("Source ",-0.2,0.7,2,6,wtsource, 31.5,11.0, 2.0, 0.5);
 trigquell.init("Source ", 1.4,0,  2,6, wtsource, 31.5,11.0, 2.0, 0.5);
 triglevel.init(" Level ", 1.4,0,1000,2000,NULL, 31.5,10, 2.0,0.5,TYP_REGLER,
		"%.2lfV",-10.00,0.01);
 trigflank.init("Flanke", 1.1,0,  0,1, wtflank, 31.3, 9,  2.2,0.5,TYP_FLIP);
 saveknopf.init("Save",   1.1,0,  0,1, NULL,    31.1, 5,  2.0,0.5,TYP_KNOPF,
		NULL,0,0,m_save2);
 ngadgets=0;
 gadget[ngadgets++] = &zeitdiv;
 gadget[ngadgets++] = &graster;
 gadget[ngadgets++] = &trigquell;
 gadget[ngadgets++] = &triglevel;
 gadget[ngadgets++] = &trigflank;
 gadget[ngadgets++] = &saveknopf;
 for(int j=0;j<4;j++)
  for(int i=0;i<KAN_NGAD;i++)
    gadget[ngadgets++] = &(kanal[j].gadget[i]);
}
void Spielfeld::zeichnen()
{
 for(int i=0;i<ngadgets;i++)
   gadget[i]->zeichnen();
}
bool Spielfeld::mausklick(double x,double y)
{
 for(int i=0;i<ngadgets;i++)
     if(gadget[i]->istinbox(x,y))
      {gadget[i]->klick(x,y); return true;}
 return false;
}
bool Spielfeld::mausrelease(double x,double y)
{
 for(int i=0;i<ngadgets;i++)
     if(gadget[i]->istinbox(x,y))
      {gadget[i]->release(x,y); return true;}
 return false;
}
bool Spielfeld::mausmove(double x,double y)
{
 bool update=false;
 for(int i=0;i<ngadgets;i++)
    if(gadget[i]->istinbox(x,y))
      {if(gadget[i]->istaktiv()) {if(gadget[i]->mausmove(x,y)) update=true;}
       else {gadget[i]->aktiv(true); update=true;}
      }
    else
      {if(gadget[i]->istaktiv()) {gadget[i]->aktiv(false); update=true;}
      }
 return update;
}

main(int argc,char *argv[])
{
 int maxcol,breite,hoehe,tiefe,visklasse,k;
 double u1[4],u0[4],tmax;
 char titel[80];
 //tek_setdebug(1);//test
 // printf("udelay justieren: 10 Sekunden Warteschlaufe. weiter mit RETURN");
 // getc(stdin); warten(10000000); printf("fertig.\n"); sleep(1);
 int i,j,c,msdiv=1000;
 for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	}
 if(argflag['?'] || j>MAXARG)
	{printf("oszi  %s\n",VERSION);
	 printf("Anwendung: oszi\n");
	 exit(0);
	}
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 printf("breite=%d hoehe=%d tiefe=%d visklasse=%d\n",breite,hoehe,tiefe,visklasse);//test
 if(tiefe>TIEFE) tiefe=TIEFE;
 maxcol=(1<<TIEFE);
 setsize(XMAX,YMAX,tiefe);
 setmenu(2,"File","Einstellungen");
 setmenu(2,"Save ...","Refresh", m_save,m_refresh);
 setmenu(1,"Exit",&menu_exit);
 /*
 setmenu(2,"Exit","Zoom ...",&menu_exit,m_zoom);
 setmenu(2,NULL,  "Zoom in", NUll,m_zoomin);
 setmenu(2,NULL,  "Zoom out",NULL,m_zoomout);
 */
 set_funktions(mauspre,mausrel,NULL,mausmot);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 sprintf(titel,"Oszillograph   %s",VERSION);
 set_tektitel(titel);
 setcolor(RAST1,0,120,80);
 setcolor(RAST2,0,180,100);
 setcolor(HELLGRAU,180,180,180);
 setcolor(ROT,255,100,60);
 setcolor(BLAU,60,100,255);
 double t0=aktuellezeit(), t1,t2;
 //printf("t0=%lf\n",t0);//test
 for(k=0;k<4;k++)
   {u0[k]=u1[k]=0; kanal[k].usummereset();
    kanal[k].setpos(7.5*k,0.0);
   }
 allesneuzeichnen();
 term_refresh();
 inital_new(xmin,ymin,xmax,ymax);
 allesneuzeichnen();
 //mainloop
 bool summestart=true,trigflag=true;
 for(t1=t0;exitflag==0 && waitmenu(0)==0;t1=t2)
   {if(msdiv!=spielfeld.msecprodiv())
     {double x=(t1-t0)/msdiv;
      msdiv=spielfeld.msecprodiv(); tmax=15*msdiv*0.001;
      t0=t1-x*msdiv;
     }
    if(msdiv>=10000) Delay(int(15*msdiv/MAXPUNKTE/20+0.5));
    t2=aktuellezeit();
    if(trigflag) t0=t1=t2;
    else if(t2==t1) continue;
    //inital_new(xmin,ymin,xmax,ymax);
    for(k=0;k<4;k++) //Spannungen messen
      {u0[k]=u1[k]; u1[k]=adwandlung(k,trigflag?ad_gain:NULL);}
    if(t2-t0>tmax)
      {int trig,flanke; double level;
       if(summestart==false)
	 {for(k=0;k<4;k++)
	   {kanal[k].calcuquer(t1-t0); ad_gain[k]=kanal[k].getgain();
	    kanal[k].minmaxreset();
	   }
	  summestart=true;
	 }
       trig=spielfeld.trigger(&level,&flanke);
       if(trig==TRIG_AUTO) {trigflag=true; redrawschirm2();}
       else if(trig==TRIG_OFF)
	 {spielfeld.trigquell.setn(TRIG_MANUAL);
	  trigflag=true; redrawschirm2();
	 }
       else if(trig>=TRIG_KAN1 && trig<=TRIG_KAN4)
	 {k=trig-TRIG_KAN1;
	  if((flanke==0 && u0[k]<level && u1[k]>=level)
	     || (flanke==1 && u0[k]>level && u1[k]<=level))
	    {trigflag=true; redrawschirm2();}
	 }
       continue;
      }
    //term_refresh();
    if(trigflag) kurven.clear();
    kurven.put(t2-t0,u1[0],u1[1],u1[2],u1[3]);
    if(trigflag)
      {trigflag=false;
       for(k=0;k<4;k++) kanal[k].usummereset();
       summestart=false;
      }
    else
      {for(k=0;k<4;k++)
	if(kanal[k].gadget[4].getn()==0) //ON
	  {color(k+1);
	   plot(tscal(t1-t0,msdiv),kanal[k].yscal(u0[k]),PENUP);
	   plot(tscal(t2-t0,msdiv),kanal[k].yscal(u1[k]),PENDOWN);
	   kanal[k].usummieren((u1[k]+u0[k])/2,t2,t1);
	  }
      }
   } //Ende des mainloops
 term_exit();
 return 0;
}/* ende von main */

#define X1 schirm_x1
#define Y1 schirm_y1
#define X2 schirm_x2
#define Y2 schirm_y2

void redraw1() //Beschriftungen und Gadgets neu zeichnen
{
 char text[80];
 for(int k=0;k<4;k++)
   {color(k+1); sprintf(text,"Kanal %d",k+1); schrift(7.5*k+0.2,1.5,text);
    color(SCHWARZ); kanal[k].zeichnen(k+1);
   }
 color(1); schrift(31,ymax-1,"Zeit");
 schrift(31,ymax/2-1,"Trigger");
 color(SCHWARZ); spielfeld.zeichnen();
}
void redrawschirm()
{
 color(SCHWARZ); fillbox(X1,Y1,X2,Y2);
 color(1);
 linie(X1,Y1, X2,Y1); linie(X2,Y1, X2,Y2); //Rahmen um Grafikbereich
 int raster=spielfeld.graster.getn();
 if(raster>0)
   {double x,y,x0=(X1+X2)/2,y0=(Y1+Y2)/2,d=0.1;
    if(raster==1) color(RAST1); else color(RAST2);
    for(x=X1+1;x<X2;x+=2.0) linie(x,Y1+d,x,Y2);
    for(y=Y1+2;y<Y2;y+=2.0)  linie(X1,y,X2-d,y);
    for(x=X1;(x+=0.4)<X2-d;) linie(x,y0-0.1,x,y0+0.1);
    for(y=Y1;(y+=0.4)<Y2;)  linie(x0-0.1,y,x0+0.1,y);
   }
}
void allesneuzeichnen()
{
 color(GRAU);
 fillbox(xmin,ymin,xmax,Y1);
 fillbox(X2,Y1,xmax,ymax);
 color(1);
 linie(X1,Y1, X2,Y1); linie(X2,Y1, X2,Y2); //Rahmen um Grafikbereich
 double br=(X2-X1)/4;
 for(int k=1;k<=4;k++) linie(br*k,ymin,br*k,Y1); //Unterteilungen Kanle
 linie(X2,ymax/2,xmax,ymax/2); //Unterteilung Zeit/Trigger
 redraw1();
 redrawschirm();
}

void Kurven::zeichnen()
{
 int i,k,pen,msdiv=spielfeld.msecprodiv(); 
 for(k=0;k<4;k++)
   {color(k+1);
    for(i=0,pen=PENUP;i<npu;i++,pen=PENDOWN)
      plot(tscal(xp[i],msdiv),kanal[k].yscal(yp[i][k]),pen);
   }
}
void m_refresh()
{
 //inital_new();
 allesneuzeichnen();
 kurven.zeichnen();
 //term_refresh();
}

void mausbewegung(int flag)
{
 static double x1,y1,x2,y2;
 double x,y,xm,ym,f1,f2;
 int tasten;
 bool update=false;
 tasten=mausposition(&x,&y);
 if(flag==2 && (tasten&LIMAUS)==0) //Linke Maustaste losgelassen
   update=spielfeld.mausrelease(x,y);
 else if(flag==1 && (tasten&LIMAUS)!=0) //Linke Maustaste gedrueckt
   update=spielfeld.mausklick(x,y);
 else if(flag==0) //Maus bewegt
     {//wenn Position auf einem Gadget dann dieses markieren
      update=spielfeld.mausmove(x,y);
     }
 //if(update) redraw1();
}
void mauspre() {mausbewegung(1);}
void mausrel() {mausbewegung(2);}
void mausmot() {mausbewegung(0);}
