/* pwrtmngr.cc			letzte Aenderung: 20.11.2009 */
#define VERSION "Version 0.1"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Kurzbeschreibung: PasswortManager

History:
18.11.2009	Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>

/************************* Vordeklarationen ***************************/
void unverschluesselt_speichern(const char *inhaltname);

/*************************** kleinkram ***************************/
int index(const char *s1,const char *s2)
{	             /* Sucht den String s2 innerhalb von s1           */
 int i,c;	     /* und gibt Position zurueck (nicht gefunden: -1) */
 const char *p1,*p2;
 if(*s2==0) return 0;   /* leerer String ist immer enthalten */
 for(i=0;;i++)
	{if((c= *s1++)==0) return -1; /* nicht gefunden */
	 if(c== *s2)
		{for(p1=s1,p2=s2; c= *++p2;)
			if(*p1++!=c) break; /* noch nicht gefunden */
		 if(c==0) break; /* gefunden */
		}
	}
 return i;
}

double zufall4()	/* Zufallszahl zwischen 0.0 und 1.0 */
{			/* bisher bester Zufallsgenerator   */
 static double x=581;
 double y;
 if(x==0.) x=581;
 x/=1.163;
 x-=(long)(x);
 y=10.*x;
 x*=1000.;
 return (y-(long)(y));
}

int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

char *ohneletztenpunkt(char *name)  /* die Endung .xxx loeschen */
{
 char c=0,*s; int i;
 for(i=0,s=name;*s!=0;s++,i++) ;
 while(i>0 && (c= *s)!='.')
        {--i; --s;}
 if(c=='.') *s='\0';
 return name;
}
char *anhaengen(char *s,const char *t)  /* s + t --> s */
{
 char *p;
 for(p=s;*p!=0;p++) ;
 for(;*p++ = *t++;) ;
 return s;
}
char *endungersetzen(char *neu,const char *name,const char *endung)
{
 strcpy(neu,name); ohneletztenpunkt(neu);
 return anhaengen(neu,endung);
}

/*********************** Serielle Schnittstelle ***********************/
//#include <stdio.h>
//#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <termios.h>
#include <unistd.h>
static char sername[80]="/dev/ttyS0";
static int baudrate=0;
static int fdr,fdw;

static int baudcodliste[]={50,B50, 75,B75, 110,B110, 134,B134, 150,B150,
   300,B300, 600,B600, 1200,B1200, 1800,B1800, 2400,B2400, 4800,B4800,
   9600,B9600, 19200,B19200, 38400,B38400,
   57600,B57600, 115200,B115200,
   230400,B230400, 460800,B460800, 500000,B500000, 576000,B576000,
   921600,B921600, 1000000,B1000000, 1152000,B1152000, 1500000,B1500000,
   2000000,B2000000, 2500000,B2500000, 3000000,B3000000, 3500000,B3500000,
   4000000,B4000000, 0,0};

int ibaud(int x) //Baudcode in Baudrate umrechnen
{
 int *co,a;
 for(co=baudcodliste;(a= *co++)!=0;co++)
    if(x== *co) return a;
 printf("Fehler: unbekannter Baudratecode %d\n",x);
 return 0;
}
int baudi(int x) //Baudrate in Baudcode umrechnen
{
 int *co,b,min=0;
 for(co=baudcodliste;(b= *co++)>0;co++)
     if(x==b) return *co;
     else if(x>b) {min= *co;}
 printf("Warnung: unbekannte Baudrate %d, auf %d abgerundet\n",x,min);
 return min;
}

void noecho(int fd)
{
 struct termios buf;
 if(tcgetattr(fd,&buf)<0)
   {printf("tcgetattr() Error\n"); return;}
 buf.c_lflag &= ~ECHO;
 if(baudrate!=0)
     {cfsetispeed(&buf,baudi(baudrate));
      cfsetospeed(&buf,baudi(baudrate));
     }
 if(tcsetattr(fd,TCSAFLUSH,&buf)<0)
   {printf("tcsetattr() Error\n"); return;}
 int a=cfgetispeed(&buf),b=cfgetospeed(&buf);
 printf("Baudraten: %d %d\n",ibaud(a),ibaud(b));
}
void seriell_open()
{
 int mode=0;
 fdr=open(sername,O_RDWR|mode);
 if(fdr<0) {printf("Fehler in seriell_open(): fdr = %d\n",fdr); return;}
	   //wenn dieser Fehler kommt sollte /dev/ttyS0 ueberprueft werden
	   //Zugriffsberechtigung freigeben: chmod a+rw /dev/ttyS0
	   //oder vielleicht /dev/ttyS1
 noecho(fdr);
 fdw=fdr;
}
void seriell_close()
{
 if(fdr>=0) close(fdr);
}
void seriell_readline(char *str,int max)
{
 int i;
 char *s,c;
 for(i=1,s=str;i<max;)
   {read(fdr,&c,1);
    if(c=='\n') break;
    if(c==0) printf("Null-Zeichen empfangen\n");//test
    else
      {*s++ = c; i++;}
   }
 if(s!=str && s[-1] == '\r') {--s; printf("CR empfangen\n");}
 *s=0;
}
void seriell_writeline(char *str)
{
 int n=strlen(str);
 char *wbuf=new char[n+3];
 //if(argflag['C']) sprintf(wbuf,"%s\r\n",str);
 //else
 sprintf(wbuf,"%s\n",str);
 write(fdw,wbuf,n+1);
 delete wbuf;
}

double zufall_hardware() //Zufallszahl zwischen 0.0 und 1.0 auf nstellen genau
{
 int c=0,c2,i;
 const int nstellen=4;
 const int imax=(nstellen*10+17)/18; // n/log(64) aufgerundet
 double z=0,fak=1.0/64;

 for(i=0;i<imax;i++,fak/=64)
   {do
     {read(fdr,&c,1);  c2=c-0x21;
     }
    while(c2<0 || c2>63);
    z += c2*fak;
   }
 //printf("zufall_hardware() --> %lf\n",z);//test

 if(z>=1.0) fprintf(stderr,"Zufallszahl zu gross: z=%lf\n",z);//test
 return z;
}

/**************** Verschluessen und Entschluesseln ********************/
int zufallszahl() //provisorisch
{
 static int startflag=1;
 int z;
 if(fdr<0)
  {if(startflag)
    {printf("keine Serielle Schnittstelle - Schluessel wird mit Pseudozufallszahlen generiert.\n");
     printf("mind. 4-stellige Startzahl fuer Zufallsgenerator:");
     scanf("%d",&z);
     while(--z>0) zufall4();
     startflag=0;
    }
   z=int(zufall4()*256.0) & 0xFF; //Variante mit Pseudozufallszahlen
  }
else
 {if(startflag)
   {printf("Schluessel wird mit Zufallszahlen von Serieller Schnittstelle generiert.\n");
    printf("Das gibt nur ein guter Schluessel wenn ein Hardware-Zufallsgenerator angeschlossen ist!\n");
    startflag=0;
   }
  z=int(zufall_hardware()*256.0) & 0xFF; //Variante mit Hardware-Zufallszahlen
 }
 return z;
}

void schluessel_generieren(const char *schluesselname)
{
 FILE *fp;
 char antw[40];
 int c,i;
 if((fp=fopen(schluesselname,"r"))!=NULL)
  {fclose(fp);
   printf("Datei '%s' ueberschreiben?",schluesselname); scanf("%s",antw);
   if((c=antw[0])=='j' || c=='J' || c=='y' || c=='Y')
    ;
   else {printf("nichts veraendert.\n"); exit(0);}
  }
 if((fp=fopen(schluesselname,"w"))==NULL)
  {printf("kann Datei '%s' nicht erstellen.\n",schluesselname); exit(0);}
 seriell_open();
 for(i=0;i<200;i++)
  {c=zufallszahl();
   putc(c,fp);
  }
 seriell_close();
 fclose(fp);
}

const int C2START=0x12AB;

int verschluesseln(int c,int c1,int& c2)
{
 int cy=0;
 c2=c2+c2+c1;
 if(c2&0x8000) cy=1;
 c2=(c2<<1)+cy;
 return (c2^c)&0xFF;
}
int entschluesseln(int c,int c1,int& c2)
{
 int cy=0;
 c2=c2+c2+c1;
 if(c2&0x8000) cy=1;
 c2=(c2<<1)+cy;
 return (c2^c)&0xFF;
}

/************************ Haupt-Routinen ******************************/
static char pass[40],schluessel[200],inhalt[4000], *gefunden=NULL;
static int inhfrei=0;

void schluessel_einlesen(FILE *fp)
{
 int c,i;
 for(i=0;(c=getc(fp))!=EOF && i<200;i++)
  schluessel[i]=c;
}

void inhalt_einlesen(FILE *fp)
{
 int c=0,c2=C2START,i,j,np;
 np=strlen(pass); if(np==0) np=1;
 for(i=0;i<np;i++) verschluesseln(c,pass[i],c2);
 for(i=j=0;(c=getc(fp))!=EOF && i<4000-1;i++)
  {c=entschluesseln(c,schluessel[j]+pass[i%np],c2);
   inhalt[i]=c;
   if(++j==200) j=0;
  }
 inhalt[i++]=0;
 if(i==4000) fprintf(stderr,"Fehler: Puffer voll\n");
 inhfrei=4000-i;
}
void inhalt_speichern(FILE *fp,int un)
{
 int c=0,c2=C2START,i,j,np;
 np=strlen(pass); if(np==0) np=1;
 for(i=0;i<np;i++) verschluesseln(c,pass[i],c2);
 for(i=j=0;(c=inhalt[i])!=0 && i<4000;i++)
  {
   if(un==0) c=verschluesseln(c,schluessel[j]+pass[i%np],c2);
   putc(c,fp);
   if(++j==200) j=0;
  }
}

void inhalt_unverschluesselt_einlesen(FILE *fp)
{
 int c,i,j;
 for(i=0;(c=getc(fp))!=EOF && i<4000-1;i++)
  {inhalt[i]=c;
  }
 inhalt[i++]=0;
 if(i==4000) fprintf(stderr,"Fehler: Puffer voll\n");
 inhfrei=4000-i;
}
void auflisten()
{
 printf("%s\n",inhalt);
}
void suchen(const char *text)
{
 int i,j,n,c;
 n=strlen(text);
 gefunden=NULL;
 for(i=0;(c=inhalt[i])!=0 && i<4000;i++)
  {if(strncmp(&inhalt[i],text,n)==0)
    {for(j=i;j>0 && inhalt[j-1]>=' ';--j) ;
     gefunden = &inhalt[j];
     for(;(c=inhalt[j])>=' ';j++)
      putc(c,stdout);
     putc('\n',stdout);
     return;
    }
  }
 printf("nicht gefunden\n");
}
int eintraglaenge(const char *str)
{
 int n=1,max;
 max=4000-(str-inhalt);
 while(*str++ >= ' ' && n<max) n++;
 return n;
}
int eintrag_anfuegen(int n,char *str)
{
 char *s1;
 int i;
 if(n>inhfrei) return 0;
 for(s1= &inhalt[4000-inhfrei-1],i=0;i<n;i++) *s1++ = *str++;
 *s1=0;
 inhfrei-=n;
}
int schiebe_nachhinten(int n,char *str)
{
 char *s1,*s2;
 if(n>inhfrei) return 0;
 for(s1= &inhalt[4000-inhfrei],s2=s1+n;s1>str;)
   *--s2 = *--s1;
 inhfrei-=n;
 return 1;
}
int schiebe_nachvorne(int n,char *str)
{
 char *s1,*s2;
 for(s1=str,s2=s1+n;s2 < &inhalt[4000-inhfrei];)
   *s1++ = *s2++;
 inhfrei+=n;
 return 1;
}

void eintrag_aendern(int neu)
{
 char zeile[160], *s;
 int i,n1,n2,c,ok;
 if(neu)
  {n1=0;
   printf("Neuer Eintrag: ");
  }
 else
  {if(gefunden==NULL) {printf("kein aktuell gefundener Eintrag\n"); return;}
   n1=eintraglaenge(gefunden);
   printf("Eintrag aendern\nalt: ");
   for(s=gefunden,i=0;i<n1;i++) putc(*s++,stdout);
   printf("neu: ");
  }
 for(i=0,zeile[0]=0;i<2 && zeile[0]==0;i++)
  {getline(stdin,zeile,160);}
 n2=strlen(zeile);
 zeile[n2++]='\n'; zeile[n2]=0;
 if(n1==0)
  {if(n2>1)
    {ok=eintrag_anfuegen(n2,zeile);
     if(!ok) printf("Puffer voll - Eintrag nicht gemacht\n");
    }
  }
 else
  {if(n1<n2)
    ok=schiebe_nachhinten(n2-n1,gefunden);
   else if(n1>n2)
    {if(n2==1) --n2;
     ok=schiebe_nachvorne(n1-n2,gefunden);
    }
   else ok=1;
   if(ok) {if(n2>0) strncpy(gefunden,zeile,n2);}
   else printf("Puffer voll - Eintrag nicht veraendert\n");
  }
}

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char schluesselname[80],inhaltname[80];
 FILE *fp1,*fp2;
 int i,j,c,ok=1,saveflag=0;
 schluesselname[0]=inhaltname[0]=0;
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(inhaltname,argv[i]);
		 else if(j==2) strcpy(schluesselname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("pwrtmngr  %s\n",VERSION);
	 printf("Anwendung: pwrtmngr [-Optionen] [inhalt] [schluessel]\n");
	 printf(" Optionen: G=Generiere Schluessel\n");
	 exit(0);
	}
 if(*schluesselname==0) strcpy(schluesselname,"schluessel.bin");
 if(argflag['G']) schluessel_generieren(schluesselname);
 if(*inhaltname==0) strcpy(inhaltname,"inhalt.bin");
 if(fp1=fopen(schluesselname,"r"))  {schluessel_einlesen(fp1); fclose(fp1);}
 else {printf("Datei '%s' nicht gefunden.\n",schluesselname); exit(0);}
 printf("Passwort:");
 for(i=0,pass[0]=0;i<2 && pass[0]==0;i++)
  {getline(stdin,pass,40);}
 if(fp2=fopen(inhaltname,"r"))
  {if(index(inhaltname,".txt")>0) inhalt_unverschluesselt_einlesen(fp2);
   else inhalt_einlesen(fp2);
   fclose(fp2);
  }
 else {printf("Datei '%s' nicht gefunden.\n",inhaltname); ok=0;}
 if(ok)
  {int modus;
   char suchtext[80],antw[40];
   for(modus=1;modus!=0;)
    {if(modus==1)
      {printf("Suchtext eingeben oder eine Nummer:\n");
       printf("  1=Hilfe, 2=Auflisten, 3=Eintrag aendern, 4=neuer Eintrag,\n");
       printf("  5=als Klartext speichern, 0=Ende\n");
      }
     printf("Suche:"); scanf("%s",suchtext);
     if((c=suchtext[0])>='0' && c<='9') modus=atoi(suchtext);
     else modus=10;
     switch(modus)
       {case 0: break;
        case 2: auflisten(); break;
        case 3: eintrag_aendern(0); saveflag=1; break;
        case 4: eintrag_aendern(1); saveflag=1; break;
        case 5: unverschluesselt_speichern(inhaltname); break;
        case 10: suchen(suchtext); break;
        default: modus=1;
       }
    }
  }
 if(saveflag)
  {char inhaltbin[80];
   endungersetzen(inhaltbin,inhaltname,".bin");
   fp2=fopen(inhaltbin,"w");
   if(fp2==NULL) printf("kann '%s' nicht speichern\n",inhaltbin);
   else {inhalt_speichern(fp2,0); fclose(fp2);}
  }
 return 0;
}/* ende von main */

void unverschluesselt_speichern(const char *inhaltname)
{
 char inhalttxt[80],antw[40];
 int c;
 FILE *fp2;
 endungersetzen(inhalttxt,inhaltname,".txt");
 printf("Allfaelliges '%s' ueberschreiben?",inhalttxt);
 scanf("%s",antw);
 if((c=antw[0])=='j' || c=='J' || c=='y' || c=='Y')
  {fp2=fopen(inhalttxt,"w");
   if(fp2==NULL) printf("kann '%s' nicht speichern\n",inhalttxt);
   else {inhalt_speichern(fp2,1); fclose(fp2);}
   printf("%s gespeichert.\n",inhalttxt);
  }
}
