/* pngklasse.cc

   Dateiformat PNG (Portable Network Grafik)
Anwendung: einfgen in C++ Programmen
*/

#include <stdio.h>
#include <ulong.h>
#include <zlib.h>

//struct RGB {UBYTE r,g,b;};

const int bit_ancillary=(0x20<<24); //Verzichtbarkeits-Bit
const int bit_private = (0x20<<16);
const int bit_reserved= (0x20<<8);
const int bit_safetocopy=0x20;

/************************** CRC ***********************/
#define CRCSTARTWERT 0xffffffff

class CRC32
{
 /* Table of CRCs of all 8-bit messages. */
 ULONG crc_table[256];
 void make_crc_table();
 ULONG update_crc(ULONG crc, unsigned char *buf,int len);
 ULONG crc(unsigned char *buf, int len);
public:
 CRC32() {make_crc_table();}
 ULONG update_crc(ULONG crc,int c);
 ULONG update_crc(ULONG crc,char *buf,int len)
    {return update_crc(crc,(unsigned char*)buf,len);}
};

   /* Make the table for a fast CRC. */
void CRC32::make_crc_table()
{
 ULONG c;
 int n, k;
 for(n=0;n<256;n++)
   {c=(ULONG)n;
    for(k=0; k<8; k++)
      {if(c & 1)
	 c = 0xedb88320L ^ (c >> 1);
       else
	 c = c >> 1;
      }
    crc_table[n] = c;
   }
}

   /* Update a running CRC with the bytes buf[0..len-1]--the CRC
      should be initialized to all 1's, and the transmitted value
      is the 1's complement of the final running CRC (see the
      crc() routine below)). */

ULONG CRC32::update_crc(ULONG crc, unsigned char *buf,int len)
{
 ULONG c = crc;
 for(int n=0; n<len; n++)
   {c = crc_table[(c ^ buf[n]) & 0xff] ^ (c >> 8);}
 return c;
}

ULONG CRC32::update_crc(ULONG crc, int buf)
{
 return crc_table[(crc ^ buf) & 0xff] ^ (crc >> 8);
}

   /* Return the CRC of the bytes buf[0..len-1]. */
ULONG CRC32::crc(unsigned char *buf, int len)
{
 return update_crc(0xffffffffL, buf, len) ^ 0xffffffffL;
}

static CRC32 crc_32;

/************************** Kleinkram ***********************/
char *put(char *p,ULONG x)
{
 *p++ = (x>>24)&0xFF; *p++ = (x>>16)&0xFF; *p++ = (x>>8)&0xFF; *p++ = x&0xFF;
 return p;
}
void put(FILE *fp,ULONG x)
{
 putc((x>>24)&0xFF,fp); putc((x>>16)&0xFF,fp);
 putc((x>>8)&0xFF,fp); putc(x&0xFF,fp);
}
/*void put(FILE *fp,char *s)
{
 int c;
 while(c= *s++) putc(c,fp);
}*/

void nkopie(int n,char *s,char *t)
{
 while(n-- > 0)
   *t++ = *s++;
}

/************************** Klassen ***********************/
class Chunk
{
 void settyp(char*s) {typ=(s[0]<<24)+(s[1]<<16)+(s[2]<<8)+s[3];}
public:
 ULONG laenge,typ;
 char *data;
 ULONG crc;
 Chunk() {laenge=0; data=NULL; crc=0;}
 ~Chunk() {if(data!=NULL) delete data;}
 void set(char *t,ULONG n=0,char *s=" ")
    {settyp(t); laenge=n; crc=crc_32.update_crc(CRCSTARTWERT,t,4);
     if(n>0)
       {data=new char[n+1]; nkopie(n,s,data);
        crc=crc_32.update_crc(crc,data,n);
       }
    }
 void write(FILE *fp);
};
void Chunk::write(FILE *fp)
{
 ULONG i;
 char *p;
 put(fp,laenge);
 put(fp,typ);
 for(p=data,i=0;i<laenge;i++) putc(*p++,fp);
 put(fp,crc ^ CRCSTARTWERT);
}

class Png
{
 FILE *fp;
 int status,tiefe;
 void writesignatur() {fprintf(fp,"\211PNG\r\n\032\n");}
 void setihdr(ULONG b,ULONG h,int t=8,int f=3,int ko=0,int fi=0,int in=0);
 char *buf,*pbuf,*destbuf,*pdestbuf;
 ULONG buflen;
 int breite,ibuf;
 char* compr(char* p);//compressing scanline
public:
 Chunk ihdr,plte,idat,iend;
 Png() {status=0; buf=destbuf=NULL;}
 ~Png() {if(buf!=NULL) delete buf;  if(destbuf!=NULL) delete destbuf;}
 bool open(char*,char*rw="rb");
 void writestart(ULONG br,ULONG ho,int ti=8);
 void writedata(int farbnr);
 bool close();
 void setcolor(int nr,int r,int g,int b);
};
void Png::setihdr(ULONG b,ULONG h,int t,int f,int ko,int fi,int in)
{
 char data[13],*p;
 p=put(data,b); p=put(p,h);
 *p++ = tiefe = t; *p++ = f; *p++ = ko; *p++ = fi; *p++ = in;
 ihdr.set("IHDR",13,data);
}

bool Png::open(char *name,char *rw)
{
 fp=fopen(name,rw);
 if(!fp) return false;
 if(*rw=='w') writesignatur();
 return true;
}
void Png::writestart(ULONG br,ULONG ho,int ti)
{
 idat.laenge=br*ho*((ti+7)/8); //lnge fr ungepackte daten
 breite=br;
 buflen=breite+1;
 if(buf!=NULL) delete buf;
 pbuf=buf=new char[buflen];
 if(destbuf!=NULL) delete destbuf;
 pdestbuf=destbuf=new char[(ho+1)*buflen];
 ibuf=0;
 setihdr(br,ho,ti);
 ihdr.write(fp);
 plte.write(fp);
}
void Png::writedata(int farbnr)
{
 // if(tiefe>8) ;//provi. bisher nur 8 bit tiefe untersttzt
 if(--idat.laenge<0) return;
 if(ibuf==0)
   {ibuf=breite;
    pdestbuf=compr(pdestbuf);
    pbuf=buf; *pbuf++ = 0; //FilterAlgorithms: None
   }
 *pbuf++ = farbnr; --ibuf;
}
char* Png::compr(char* p)
{
 uLong destlen=buflen*2;
 int ok=compress((Bytef*)p,&destlen,(Bytef*)buf,(uLong)buflen);
 if(ok!=Z_OK) printf("error in compress() %d\n",ok);
 return &p[destlen];
}
bool Png::close()
{
 if(!fp) return false;
 if(idat.laenge!=0)
   {printf("Png::close() Falsche Datenmenge idat.laenge=%ld (sollte 0 sein)\n",
	   idat.laenge);
   //return false;
   }
 pdestbuf=compr(pdestbuf);
 ULONG destlen=pdestbuf-destbuf;
 idat.set("IDAT",destlen,destbuf); idat.write(fp);
 iend.set("IEND"); iend.write(fp);
 fclose(fp);
 return true;
}

void makegifanim(char *quelle,char *ziel)
{
 char *str=new char[strlen(quelle)+strlen(ziel)+20];
 sprintf(str,"convert %s.png %s.gif",quelle,ziel);
 system(str);
 delete str;
}
