/*  psi.cc			letzte nderung: 7.6.2000 */
#define VERSION "Version 1.1"
/*
 einfaches Programm zum Zeichnen von Wellenfunktionen

History:
27.4.2000	Erstellung (RP)
15.5.   1.1	mit Raytracing-Teil

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <xtekplot1.h>
#include <ulong.h>
#include <math3.cc>
#include "vektorklasse.cc"
#include "vektor3dklasse.cc"
//#include "pngklasse.cc"
#include "saveiff.h"

const int TIEFE=8;
static int tiefe=8;

const int F_ACHSEN=1, F_POLAR=2, F_HYBRID=4, F_BINDUNG=8, F_CLEAR=0x10,
	  F_STOP=0x20;
const int FU_PSI=0, FU_PSIQUADRAT=2, FU_ABSPSI=3, FU_Y=4, FU_Y2=5;

/************************* Globale Variablen **************************/
//static Png pngbild;
//static char pngcolors[3*256];
static char animbildname[80]="anim001", bildformat[40]="ilbm";
static int rip=0;//Abkrzung fr bildformat[0]
char puffer[640*512];//bildspeicher

/************************* Vordeklarationen ***************************/
inline double sq(double x) {return x*x;}
//inline double abs(double x) {return x>=0?x:-x;}
void mysetcolor(int nr,int r,int g,int b);
void animation_fertigstellen(char*);

/************************* Men Behandlung ****************************/
static int exitflag=0;
void m_exit() {exitflag=1;}
void m_calc(),m_scale(),m_scalexyz(),m_options(),m_hybrid();
void m_mpos(),m_morb(),m_ray(),m_rayk(),m_rayk2(),m_raystop(),m_rayanim();

/***************************** Klassen ********************************/
class Fenster
{
 int maxcol;
 int breite,hoehe,visklasse; //Fenstergroesse
 double xmin,ymin,xmax,ymax; //Userkoordinaten
 double bx,hy; //Schriftgroessen
public:
 Fenster(char*,int b=12500,int h=10000,int t=24);
 ~Fenster();
 int run(char *text=NULL);
};
Fenster::Fenster(char *name,int br,int ho,int ti)
{
 exitflag=0;
 xmin= -0.15; ymin= -0.12; xmax=0.2; ymax=0.16;
 bx=(xmax-xmin)/100; hy=(ymax-ymin)/40;
 //tek_setdebug(1);//test
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(breite>br) breite=br;
 if(hoehe>ho) hoehe=ho;
 if(tiefe>ti) tiefe=ti;
 maxcol=(1<<tiefe);
 setsize(breite,hoehe,tiefe);
 setmenu(4,"File","Settings","Molekuele","Raytracer");
 setmenu(4,"run ...","scaling ...","Positionen ...","run ...",
	 m_calc,m_scale,m_mpos,m_ray);
 setmenu(4,"Exit","xyz-scaling ...","Orbitale ...","stop",
	 m_exit,m_scalexyz,m_morb,m_raystop);
 setmenu(4,NULL,  "options ...",    NULL,          "kamera ...",
	 NULL,m_options,NULL,m_rayk);
 setmenu(4,NULL,  "hybridization ...",NULL,        "kamerafahrt ...",
	 NULL,m_hybrid,NULL,m_rayk2);
 setmenu(4,NULL,  NULL,  NULL,			   "animation ...",
	 NULL, NULL, NULL, m_rayanim);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 set_tektitel(name);
 screenclear(1); color(0);
 term_refresh();
}
Fenster::~Fenster()
{
 term_exit();
}

/*********************** Koordinaten umrechnen ****************************/
void xyz2w(double x,double y,double z,double *theta,double *phi,double *r)
{
 double wu;
 *theta=atan2(y,x);
 *phi=atan2(z,sqrt(wu=x*x+y*y));
 *r=sqrt(wu+z*z);
}
void w2xyz(double theta,double phi,double r,double *x,double *y,double *z)
{
 double wu;
 *z=r*sin(phi);
 wu=r*cos(phi);
 *x=wu*cos(theta);
 *y=wu*sin(theta);
}

/************************* Hauptprogramm ******************************/
const double a=0.593, zweia=2*a, a3=a*a*a, a7=a3*a3*a, a9=a7*a*a;
const int MAXP=640; //Maximale anzahl Pixel in x-Richtung

class Ray
{
public:
 Vektor3d k; //Kamera
 double f; //Brennweite der Kamera (in m)
// double wneig; //Neigungswinkel der Kamera
 double horizw; //Winkel zum zustzlichen Drehen um den Blickpunkt (z-Achse)
 double vertiw; //Winkel zum Drehen ber den Blickpunkt (Elevation)
 double blickw; //Blickwinkel
// Vektor3d l[8]; //Lichtquellen
 Vektor3d b; //Blickpunkt, auf diesen Punkt ist die Kamera gerichtet
 Vektor3d oben; //nach oben zeigender Vektor
 double smax;//Maximale Blickdistanz
 double ds1; //Schrittweite des Sehstrahls
 double soll;
 int quick;//schnelle Vorschau
 Ray() {k=Vektor3d(40,0,10); f=0.5; blickw=60*GRAD; b=Vektor3d(0,0,0);
	smax=80; ds1=smax/1e4; soll=0; quick=0; horizw=vertiw=0;
	oben=Vektor3d(0,0,1);}
 Vektor3d getk();
};
Vektor3d Ray::getk()
{
 Vektor3d k2;
 double theta0,phi0,r;
 xyz2w(k.x,k.y,k.z,&theta0,&phi0,&r);
 w2xyz(theta0+horizw,phi0+vertiw,r,&k2.x,&k2.y,&k2.z);
 return k2;
}

class Anim
{
 int nb;
 char bildname[200];
 void setaktualray();
 void bild_speichern();
public:
 int nbilder;
 Ray startpunkt,endpunkt;
 Anim() {nbilder=3; nb=0; startpunkt.f=endpunkt.f=0;}
 void start(int n=0);
 bool next();
 void stop();
};
static Anim anim;

class Psi
{
 double xmi,ymi,xma,yma;//Grenzen fuer Grafik
 int comp(int l,int m)
	{int lm=10*l+abs(m); if(m<0) lm= -lm; return lm;}
 int compnlm(int n,int l,int m)
	{int nlm=100*n+10*l+abs(m); if(m<0) nlm= -nlm; return nlm;}
 double olapi;//Overlap-Integral bei Bindungen
public:
 int anzatome;//Anzahl zusaetzliche Atome
 Psi *psiatom;//zusaetzliche Atome
 double xatom[4],yatom[4],zatom[4];//Positionen der zusaetzliche Atome
 double xmin,ymin,xmax,ymax,zmin,zmax,AMAX;
 double eps; //Vergleichsgenauigkeit
 int nlm, raster,praster;
 int hyb[4]; double anteil[4];
 int flags,funkt,higrund;
 double soll;
 Ray ray;
 Psi()	{//nlm=210; anzatome=0;
	 nlm=420; anzatome=0;
	 soll=0.008; eps=soll*0.1; raster=100; praster=MAXP/4;
	 flags=F_CLEAR; funkt=FU_PSI;
	 AMAX=16; xmin=ymin=zmin= -AMAX; xmax=ymax=zmax=AMAX;
	 anteil[0]=anteil[1]=anteil[2]=anteil[3]=1;
	 hyb[0]=200; hyb[1]=210; hyb[2]=211; hyb[3]= -211;
	 higrund=1;
	}
 double calc1(double x,double y,double z);
 double hybrid(double x,double y,double z);
 double bindung(double x,double y,double z);
 double calc(double x,double y,double z)
	{return (flags&F_BINDUNG) ? bindung(x,y,z) : 
	         ((flags&F_HYBRID) ? hybrid(x,y,z) : calc1(x,y,z));}
 void neuzeichnen();
 void raytrace();
 bool fastgleich(double,double);
 void sethyb(int k,int*p,double*pa)
	{int i; for(i=0;i<k;i++,p+=3)
	  {hyb[i]=compnlm(*p,p[1],p[2]); anteil[i]=pa[i];}
	 for(;i<4;i++) {hyb[i]=0; anteil[i]=0.0;}
	}
 void gethyb(int k,int*p,double*pa)
	{for(int i=0;i<k;i++,p+=3)
	  {int k=abs(hyb[i]);
	   *p=k/100; k-= *p*100; p[1]=k/10; k-=p[1]*10;
	   p[2] = hyb[i]<0 ? -k : k;
	   *pa++ = anteil[i];
	  }
	}
 void setnlm(int n,int l,int m)
	{nlm=100*n+10*l+abs(m); if(m<0) nlm= -nlm;}
 void getnlm(int& n,int& l,int& m)
   {int a=abs(nlm); n=a/100;  l=(a-100*n)/10;
    m=a-100*n-10*l; if(nlm<0) m= -m;
   }
};
static Psi psi;

double Psi::calc1(double x,double y,double z) //berechnet PSI
{
 double a1,a2;
 double r=sqrt(x*x+y*y+z*z);
 // sintheta=sqrt(x*x+y*y)/r;
 if(funkt>=FU_Y)
   {//Kugelfunktionen:
    double Y;
    switch(nlm%100)
      {case  00: a1=1/(4*PI); a2=1;
       CASE  10: a1=3/(8*PI); a2=z/r; //cos(theta);
       CASE  11: a1=3/(8*PI); a2=x/r; //sin(theta)*cos(phi);
       CASE -11: a1=3/(8*PI); a2=y/r; //sin(theta)*sin(phi);
       CASE  20: a1=5/(16*PI); a2=3*sq(z/r)-1;
       CASE  21: a1=15/(8*PI); a2=z/r*x/r;
       CASE -21: a1=15/(8*PI); a2=z/r*y/r;
       CASE  22: a1=15/(32*PI)*(x*x+y*y); a2=x/(r*r);
       CASE -22: a1=15/(32*PI)*(x*x+y*y); a2=y/(r*r);
       CASE  30: a1=7/(16*PI); a2=(5*sq(z/r)-3)*z/r;
       DEFAULT:
        printf("unbekannte Kugelfunktion fuer nlm = %d\n",nlm);//test
      }
    if(funkt==FU_Y2)
      {int vorzeichen=(nlm>0)?1 : -1;
       Y=vorzeichen*a1*abs(a2)*a2; //Quadrierte Y-Funkt.
      }
    else Y=sqrt(a1)*a2; //Y-Funktion
    return Y*soll/r;
   }
 //else //sonst Wellenfunktionen:
 int n=abs(nlm)/100;
 double theta,phi,ra;
 phi=atan2(y,x);
 theta=acos(z/r);
 ra=r/a;
 switch(nlm)
   {case  100: a1=PI*a3; a2=1;
    CASE  200: a1=32*PI*a3; a2=2-ra;
    CASE  210: a1=32*PI*a3; a2=ra*cos(theta);
    CASE  211: a1=32*PI*a3; a2=ra*sin(theta)*cos(phi);
    CASE -211: a1=32*PI*a3; a2=ra*sin(theta)*sin(phi);
    CASE  300: a1=81*81*3*PI*a3; a2=27-18*ra+2*ra*ra;
    CASE  310: a1=81*81*PI/2*a3; a2=ra*(6-ra)*cos(theta);
    CASE  311: a1=81*81*PI/2*a3; a2=ra*(6-ra)*sin(theta)*cos(phi);
    CASE -311: a1=81*81*PI/2*a3; a2=ra*(6-ra)*sin(theta)*sin(phi);
    CASE  320: a1=81*81*6*PI*a3; a2=ra*ra*(3*sq(cos(theta))-1);
    CASE  321: a1=81*81*PI/2*a3; a2=ra*ra*sin(theta)*cos(theta)*cos(phi);
    CASE -321: a1=81*81*PI/2*a3; a2=ra*ra*sin(theta)*cos(theta)*sin(phi);
    CASE  322: a1=81*81*2*PI*a3; a2=ra*ra*sq(sin(theta))*cos(2*phi);
    CASE -322: a1=81*81*2*PI*a3; a2=ra*ra*sq(sin(theta))*sin(2*phi);
    CASE  400: a1=81*81*PI*a3; a2=1-ra*(3/4+ra/8-ra*ra/192);
    CASE  410: a1=32*32*PI*a3; a2=ra*(1-ra/4+ra*ra/80)*cos(theta);
    CASE  411: a1=32*32*PI*a3; a2=ra*(1-ra/4+ra*ra/80)*sin(theta)*cos(phi);
    CASE -411: a1=32*32*PI*a3; a2=ra*(1-ra/4+ra*ra/80)*sin(theta)*sin(phi);
    CASE  420: a1=256*256*PI*a7; a2=(1-ra/12)*(3*z*z-r*r);
    CASE  421: a1=128*128*PI/3*a7; a2=(1-ra/12)*x*z;
    CASE -421: a1=128*128*PI/3*a7; a2=(1-ra/12)*y*z;
    CASE  422: a1=128*128*PI/3*a7; a2=(1-ra/12)*x*y;
    CASE -422: a1=128*128*PI/3*a7; a2=(1-ra/12)*(x*x-y*y);
    CASE  430: a1=3072*3072*5*PI*a9; a2=(5*z*z-3*r*r)*z;
    CASE  431: a1=1024*1024*30*PI*a9; a2=(5*z*z-r*r)*x;
    CASE -431: a1=1024*1024*30*PI*a9; a2=(5*z*z-r*r)*y;
    CASE  432: a1=512*512*3*PI*a9; a2=x*y*z;
    CASE -432: a1=1024*1024*3*PI*a9; a2=z*(x*x-y*y);
    CASE  433: a1=3072*3072*2*PI*a9; a2=x*(x*x-3*y*y);
    CASE -433: a1=3072*3072*2*PI*a9; a2=y*(3*x*x-y*y);
    DEFAULT: a1=a2=1; //printf("unbekannte nlm-Kombination %d\n",nlm);
   }
 if(funkt==FU_PSI) return sqrt(1/a1)*a2*exp(-ra/n);
 else if(funkt==FU_ABSPSI) return abs(sqrt(1/a1)*a2*exp(-ra/n));
//else if(funkt==FU_PSIQUADRAT)
 return a2*a2/a1*exp(-2*ra/n);
}
double Psi::hybrid(double x,double y,double z) //Hybridisierung
{
 double result=0,an=0;
 for(int i=0;hyb[i]!=0;i++)
   {nlm=hyb[i]; an+=abs(anteil[i]); result += anteil[i]*calc1(x,y,z);}
 return result/an;
}
double Psi::bindung(double x,double y,double z) //Bindungen
{
 double p,olap,result;
 olap=result=(flags&F_HYBRID)?hybrid(x,y,z):calc1(x,y,z);
 for(int i=0;i<anzatome;i++)
   {result += p=psiatom[i].calc(x-xatom[i],y-yatom[i],z-zatom[i]);
    olap *= p;
   }
 olapi+=olap;
 return result;
}

bool Psi::fastgleich(double x,double y)
{
 if(x<0) return (y < -x+eps && y > -x-eps);
 return (y<x+eps && y>x-eps);
}

const double f=0.7, ALFA=45*PI/180, sinaf=sin(ALFA)*f, cosaf=cos(ALFA)*f;

//void punktzeichnen(double x,double y,double z)
void punktzeichnen(double x,double y,double z,int farbe)
{
  // int farbe=(z>0)?0:2;
 tek_punkt(x+y*cosaf,z+y*sinaf,farbe);
}
void achsezeichnen(double x1,double y1,double z1,double x2,double y2,double z2)
{
 plot(x1+y1*cosaf,z1+y1*sinaf,PENUP);
 plot(x2+y2*cosaf,z2+y2*sinaf,PENDOWN);
}

void Psi::neuzeichnen()
{
 double dx,dy,dz; dx=dy=dz=2*AMAX/raster;
 double x,y,z,result;
 char text[80];
 xmi=(xmin+ymin*cosaf)*1.25; xma=(xmax+ymax*cosaf)*1.25;
 ymi=zmin+ymin*sinaf; yma=zmax+ymax*sinaf;
 inital_new(xmi,ymi,xma,yma);
 if(flags&F_CLEAR) screenclear(1);
 color(0);
 if(flags&F_ACHSEN)
   {achsezeichnen(0,0,zmin, 0,0,zmax);
    achsezeichnen(xmin,0,0, xmax,0,0);
    achsezeichnen(0,ymin,0, 0,ymax,0);
   }
 double altsoll=soll, alteps=eps;
 if(funkt==FU_Y2 || funkt==FU_PSIQUADRAT) {soll*=soll; eps*=altsoll;}
 if(flags&F_BINDUNG) olapi=0;
 for(y=ymax;y>=ymin;y-=dy)
   for(x=xmin;x<=xmax;x+=dx)
     for(z=zmin;z<=zmax;z+=dx)
       {if(fastgleich(result=calc(x,y,z),soll))
	 punktzeichnen(x,y,z,result>0?4:2); //Blau positiv, Rot negativ
       }
 soll=altsoll; eps=alteps;
 color(0);
 if(flags&F_BINDUNG)
   sprintf(text,"Overlap-Integral: %lf",olapi*(dx*dy*dz));
 else if(flags&F_HYBRID)
   sprintf(text,"Hybridization: %d %d %d %d",hyb[0],hyb[1],hyb[2],hyb[3]);
 else sprintf(text,"nlm = %d",nlm);
 if(abs(nlm)>=500) sprintf(text,"Sorry, yet only working with n<=4");
 schrift(xmi,ymi,text);
 term_refresh();
}

void m_scale()
{
 int ok;
 ok=requester_input(2," xmin ","%lf","%lf",&psi.xmin,
		      " xmax ","%lf","%lf\n",&psi.xmax);
 if(ok)
   {psi.AMAX=psi.xmax;
    psi.zmin=psi.ymin=psi.xmin;
    psi.zmax=psi.ymax=psi.xmax;
    psi.neuzeichnen();
   }
}
void m_scalexyz()
{
 int ok;
 ok=requester_input(6," xmin ","%lf","%lf",&psi.xmin,
		      " xmax ","%lf","%lf\n",&psi.xmax,
		      " ymin ","%lf","%lf",&psi.ymin,
		      " ymax ","%lf","%lf\n",&psi.ymax,
		      " zmin ","%lf","%lf",&psi.zmin,
		      " zmax ","%lf","%lf\n",&psi.zmax);
 if(ok)
   {psi.AMAX=(psi.ymax>psi.xmax)?psi.ymax:psi.xmax;
    psi.neuzeichnen();
   }
}
void m_options()
{
 int ok;
 char koord[40],achse[40],funkt[40],clear[40];
 strcpy(koord,psi.flags&F_POLAR?"polar":"xyz");
 strcpy(achse,psi.flags&F_ACHSEN?"ja":"nein");
 switch(psi.funkt)
   {case FU_ABSPSI: strcpy(funkt,"abs(psi)");
    CASE FU_PSIQUADRAT: strcpy(funkt,"psi^2");
    CASE FU_Y: strcpy(funkt,"Y");
    CASE FU_Y2: strcpy(funkt,"Y^2");
    CASE FU_PSI: default: strcpy(funkt,"psi");
   }
 strcpy(clear,psi.flags&F_CLEAR?"on":"off");
 ok=requester_input(4," Koordinaten (xyz oder polar) ","%s","%s\n",koord,
		      " Achsen einzeichnen (j/n) ","%s","%s\n",achse,
		      "Funktion (psi psi^2 abs(psi) Y Y^2)","%s","%s\n",funkt,
		      " Screenclear (on off) ","%s","%s\n",clear);
 if(ok)
   {psi.flags &= ~(F_POLAR+F_ACHSEN+F_CLEAR);
    if(strncmp(koord,"pol",3)==0) psi.flags |= F_POLAR;
    if(*achse!='n' && *achse!='N') psi.flags |= F_ACHSEN;
    if(strncmp(funkt,"psi^2",5)==0) psi.funkt=FU_PSIQUADRAT;
    else if(strncmp(funkt,"abs",3)==0) psi.funkt=FU_ABSPSI;
    else if(strncmp(funkt,"Y^2",3)==0) psi.funkt=FU_Y2;
    else if(strncmp(funkt,"Y",1)==0) psi.funkt=FU_Y;
    else psi.funkt=FU_PSI;
    if(strncmp(clear,"on",2)==0) psi.flags |= F_CLEAR;
   }
}
void m_hybrid()
{
 int ok;
 char txt1[40],txt2[40],txt3[40],txt4[40];
 int n,l,m,feld[4*3],*p;
 double an,afeld[4],*pa;
 psi.gethyb(4,feld,afeld);
 p=feld; pa=afeld;
 sprintf(txt1," %d %2d %2d  %.3lf",*p,p[1],p[2],*pa++); p+=3;
 sprintf(txt2," %d %2d %2d  %.3lf",*p,p[1],p[2],*pa++); p+=3;
 sprintf(txt3," %d %2d %2d  %.3lf",*p,p[1],p[2],*pa++); p+=3;
 sprintf(txt4," %d %2d %2d  %.3lf",*p,p[1],p[2],*pa++); p+=3;
 ok=requester_input(4," n  l  m  Anteil","%s","%s\n",txt1,
		      " n  l  m  Anteil","%s","%s\n",txt2,
		      " n  l  m  Anteil","%s","%s\n",txt3,
		      " n  l  m  Anteil","%s","%s\n",txt4);
 if(ok)
   {p=feld; pa=afeld;
    sscanf(txt1,"%d %d %d %lf",&n,&l,&m,&an);
    *p++ =n; *p++ =l; *p++ =m; *pa++ =an;
    if(n==0) psi.flags &= ~F_HYBRID;
    else     psi.flags |= F_HYBRID;
    sscanf(txt2,"%d %d %d %lf",&n,&l,&m,&an);
    *p++ =n; *p++ =l; *p++ =m; *pa++ =an;
    if(n==0) psi.flags &= ~F_HYBRID;
    sscanf(txt3,"%d %d %d %lf",&n,&l,&m,&an); if(n==0 || an==0) n=l=m=0;
    *p++ =n; *p++ =l; *p++ =m; *pa++ =an;
    sscanf(txt4,"%d %d %d %lf",&n,&l,&m,&an); if(n==0 || an==0) n=l=m=0;
    *p++ =n; *p++ =l; *p++ =m; *pa++ =an;
    psi.sethyb(4,feld,afeld);
   }
}

void m_calc()
{
 int ok,n,l,m;
 if(psi.flags&F_HYBRID)
 ok=requester_input(7," nlm1 ","%d","%d",&psi.hyb[0],
		      " nlm2 ","%d","%d",&psi.hyb[1],
		      " nlm3 ","%d","%d",&psi.hyb[2],
		      " nlm4 ","%d","%d\n",&psi.hyb[3],
		      "  Psi-Sollwert  ","%lf","%lf",&psi.soll,
		      "     epsilon    ","%lf","%lf\n",&psi.eps,
		      " Anzahl Schritte ","%d","%d\n",&psi.raster);
 else
  {psi.getnlm(n,l,m);
   ok=requester_input(6,"  n  ","%d","%d",&n,
		      "  l  ","%d","%d",&l,
		      "  m  ","%d","%d\n",&m,
		      "  Psi-Sollwert  ","%lf","%lf",&psi.soll,
		      "     epsilon    ","%lf","%lf\n",&psi.eps,
		      " Anzahl Schritte ","%d","%d\n",&psi.raster);
   if(ok) psi.setnlm(n,l,m);
  }
 if(ok) psi.neuzeichnen();
}

typedef char string[80];

void m_mpos()
{
 int ok,i;
 static double f=1;
 string txt[4];
 for(i=0;i<4;i++)
   sprintf(txt[i],"%8.4lf %7.4lf %7.4lf",
	   psi.xatom[i]/f,psi.yatom[i]/f,psi.zatom[i]/f);
 ok=requester_input(6,"Anzahl Atome","%d","%d\n",&psi.anzatome,
		      " 1: x       y       z  ","%s","%s\n",txt[0],
		      " 2: x       y       z  ","%s","%s\n",txt[1],
		      " 3: x       y       z  ","%s","%s\n",txt[2],
		      " 4: x       y       z  ","%s","%s\n",txt[3],
		      " Skalierfaktor ","%lf","%lf",&f);
 if(ok)
   {if(psi.anzatome>4) printf("Auf %d Atome beschraenkt\n",psi.anzatome=4);
    if(strncmp(txt[0],"CH4",3)==0)
      {psi.xatom[0]=0; psi.yatom[0]=0; psi.zatom[0]=f;
       psi.xatom[1]=0.9455*f; psi.yatom[1]=0; psi.zatom[1]= -0.3256*f;
       psi.xatom[2]= -0.4728*f; psi.yatom[2]=0.8188*f; psi.zatom[2]= -0.3256*f;
       psi.xatom[3]= -0.4728*f; psi.yatom[3]= -0.8188*f; psi.zatom[3]= -0.3256*f;
      }
    else
      for(i=0;i<psi.anzatome;i++)
	{double x,y,z;
	 sscanf(txt[i],"%lf %lf %lf",&x,&y,&z);
	 psi.xatom[i]=x*f; psi.yatom[i]=y*f; psi.zatom[i]=z*f;
	}
    if(psi.anzatome>0) psi.flags |= F_BINDUNG; else psi.flags &= ~F_BINDUNG;
   }
}

void m_morb()
{
 int ok,i,n,l,m;
 string txt[4];
 for(i=0;i<4;i++)
  {psi.psiatom[i].getnlm(n,l,m);
   //             "Atom 1: n  l  m  "
   sprintf(txt[i],"%5d %2d %2d",n,l,m);
  }
 ok=requester_input(5,"Anzahl Atome","%d","%d\n",&psi.anzatome,
		      " 1: n  l  m  ","%s","%s\n",txt[0],
		      " 2: n  l  m  ","%s","%s\n",txt[1],
		      " 3: n  l  m  ","%s","%s\n",txt[2],
		      " 4: n  l  m  ","%s","%s\n",txt[3]);
 if(ok)
   {if(psi.anzatome>4) printf("Auf %d Atome beschraenkt\n",psi.anzatome=4);
    for(i=0;i<psi.anzatome;i++)
     {sscanf(txt[i],"%d %d %d",&n,&l,&m);
      psi.psiatom[i].setnlm(n,l,m);
     }
    if(psi.anzatome>0) psi.flags |= F_BINDUNG; else psi.flags &= ~F_BINDUNG;
   }
}

void sprivekt(char *s,Vektor3d v)
{
 sprintf(s,"%lf %lf %lf",v.x,v.y,v.z);
}
void sprivektg(char *s,Vektor3d v)
{
 sprintf(s,"%lg %lg %lg",v.x,v.y,v.z);
}
Vektor3d scavekt(char *s)
{
 Vektor3d v;
 sscanf(s,"%lf %lf %lf",&v.x,&v.y,&v.z);
 return v;
}

void m_raystop()
{
 psi.flags |= F_STOP;
}
void m_rayk() //Kamera-Einstellungen
{
 int ok;
 double w;
 char txt1[80]; sprivekt(txt1,psi.ray.k);
 char txt2[80]; sprivekt(txt2,psi.ray.b);
 // char txt3[80]; sprintf(txt3,"%lf %lf %lf",
 //			psi.ray.ds1,psi.ray.ds4,psi.ray.ds8);
 w=psi.ray.blickw/GRAD;
 ok=requester_input(6,"   Kamera-Position  ( x  y  z )   ","%s","%s\n",txt1,
		      " Brennweite ","%lf","%lf",&psi.ray.f,
		      "Blickwinkel Grad","%.1lf","%lf\n",&w,
		      "   Blickpunkt ( x  y  z )         ","%s","%s\n",txt2,
		      " Sichtweite ","%lf","%lf\n",&psi.ray.smax,
		      " Rumliche Auflsung ","%lf","%lf",&psi.ray.ds1
		    );
 if(ok)
   {psi.ray.k=scavekt(txt1);
    psi.ray.b=scavekt(txt2);
    psi.ray.blickw=w*GRAD;
    //sscanf(txt3,"%lf %lf %lf",
    //	   &psi.ray.ds1,&psi.ray.ds4,&psi.ray.ds8);
   }
}
void m_rayk2() //Kamera-Fahrt
{
 int ok;
 double theta,phi;
 char txt1[80]; sprivektg(txt1,psi.ray.oben);
 int fahrt=0;//provi.
 theta=psi.ray.horizw/GRAD;
 phi=psi.ray.vertiw/GRAD;
 ok=requester_input(4,"Art der Kamera-Fahrt (0=normal)","%d","%d\n",&fahrt,
		      "Horizontaler Drehwinkel (Grad) ","%lf","%lf\n",&theta,
		      "  Vertikaler Drehwinkel (Grad) ","%lf","%lf\n",&phi,
		      "      Oben  (x y z)            ","%s","%s\n",&txt1
		    );
 if(ok)
   {psi.ray.horizw=theta*GRAD;
    psi.ray.vertiw=phi*GRAD;
    psi.ray.oben=scavekt(txt1);
    if(fahrt!=0) printf("Typ der Kamerafahrt noch nicht waehlbar.\n");
   }
}

void m_rayanim()
{
 int ok;
 char txt1[40],txt2[40];
 strcpy(txt1,"n"); strcpy(txt2,"n");
 ok=requester_input(5,"aktuelle Werte --> Startpunkt","%s","%s\n",txt1,
		      "aktuelle Werte --> Endpunkt  ","%s","%s\n",txt2,
		      "Anzahl Bilder","%d","%d\n",&anim.nbilder,
		      " Bildname (1.Bild) ","%s","%s",animbildname,
		      "Bildformat (raw/ilbm/png)","%s","%s\n",bildformat
		    );
 if(ok)
   {if(tolower(*txt1)!='n' || anim.startpunkt.f==0) anim.startpunkt=psi.ray;
    if(tolower(*txt2)!='n' || anim.endpunkt.f==0) anim.endpunkt=psi.ray;
    rip=bildformat[0];
   }
}
void m_ray()
{
 static int running=0;
 int ok;
 char txt[40],txt2[40];
 if(running)
   {ok=janeinrequester("Stop the running raytracer ?","yes","no");
    if(ok) m_raystop();
    return;
   }
 running=1;
 strcpy(txt,psi.higrund>0?"ja":"nein");
 strcpy(txt2,"n");
 if(psi.ray.soll==0) psi.ray.soll=psi.soll;
 ok=requester_input(5,"  Psi-Sollwert  ","%lf","%lf",&psi.ray.soll,
		      " Anzahl x-Pixel ","%d","%d\n",&psi.praster,
		"Quickflag (1=schnell 0=korrekt)","%d","%d\n",&psi.ray.quick,
		"Hintergrund (ja/nein)","%s","%s\n",txt,
		"Animations-Sequenz (ja/nein)","%s","%s\n",txt2);
 if(ok)
   {if(*txt!='n' && *txt!='N') psi.higrund=1; else psi.higrund=0;
    if(*txt2!='n' && *txt2!='N') 
      {anim.start();
       do {psi.raytrace();} while(anim.next());
       anim.stop();
      }
    else
      {anim.start(1);
       psi.raytrace();
       anim.stop();
      }
   }
 running=0;
}

/*
Vektor3d drehenxy(Vektor3d v,double w)	//Vektor in xy-Ebene um Winkel w
{					//im gegenuhrzeigersinn drehen
 v.drehenxy(w);
 return v;
}
*/
Vektor3d drehenyx(Vektor3d v,double sina,double cosa)
{
 v.drehenyx(sina,cosa);
 return v;
}
Vektor3d drehenzx(Vektor3d v,double sina,double cosa)
{
 v.drehenzx(sina,cosa);
 return v;
}

/*
void setpngcolor(int nr,int r,int g,int b)
{
 int i=3*nr;
 pngcolors[i++]=r; pngcolors[i++]=g; pngcolors[i]=b;
}
*/

void Psi::raytrace()
{
 double f=ray.f;
 Vektor3d kamera;
 double xma=f*tan(ray.blickw/2), yma=xma/1.25, xmi= -xma, ymi= -yma;
 double dx=(xma-xmi)/praster, dy=dx;
 double ds,ds1,ds4,ds8,ds11,dsmax,sollhalbe;
 double x,y,wu,s,h,result,absr,oldabsr;
 double beta,sinbeta,cosbeta,singamma;
 double y1,sina,cosa,sinb,cosb;
 ds1=(ray.ds1==0)?dx:ray.ds1;
 if(ray.soll!=0) soll=ray.soll;
 if(ray.quick) {ds4=100*ds1; ds8=400*ds1; sollhalbe=soll*0.9; ds11=ds4;}
 else {ds4=16*dx; ds8=100*dx; sollhalbe=soll*0.25; ds11=ds1*1.1;}
 // double sinepsilon;
 int i,j,imax=praster*4/5;
 Vektor3d ve,vp,vp0,vpj1[MAXP],vpj,vpi;
 int farbe, ngrau=((1<<tiefe)-8)/2, dg=(255-50)/ngrau;
 inital_new(xmi,ymi,xma,yma);
 screenclear(0);
 mysetcolor(0,0,0,0);//schwarz
 mysetcolor(1,255,255,255);//weiss
 for(i=0,j=255-(ngrau-1)*dg;i<ngrau;i++,j+=dg)
   {setcolor(2*i+8,j/4,j/4,j);//Blauwerte
    setcolor(2*i+9,j,j/4,j/4);//Rotwerte
    mysetcolor(2*i+8,j/4,j/4,j);//Blauwerte
    mysetcolor(2*i+9,j,j/4,j/4);//Rotwerte
    //printf("setcolor(%d,%d,%d,%d) setcolor(%d,%d,%d,%d)\n",
    //   2*i+8,255,j,j, 2*i+9,j,j,255);//test
   }
 // pngbild.plte.set("PLTE",3*256,pngcolors);
 // pngbild.writestart(praster,praster*4/5,tiefe);
 /*test:*
 for(i=8,x=xmi;i<(1<<tiefe);i+=2,x+=(xma-xmi)/ngrau/2)//test
   {color(i); fillbox(x,0.95*yma,x+(xma-xmi)/ngrau,yma);}
 for(i=9;i<(1<<tiefe);i+=2,x+=(xma-xmi)/ngrau/2)//test
   {color(i); fillbox(x,0.95*yma,x+(xma-xmi)/ngrau,yma);}
 *:test*/
 kamera=ray.getk();
 //Voraus-Berechnungen fr die Hilfsdrehungen von vp0:
 ve=ray.b-kamera; ve.einheitsvektor();
 if(ve.x==0 && ve.y==0) {sina=0; cosa=1;}
 else
   {sina= -ve.y/(wu=sqrt(ve.x*ve.x+ve.y*ve.y));
    if(ray.oben.z<0) {cosa=ve.x/wu;}//provi.
    else {cosa= -ve.x/wu;}
   }
 // printf("sina=%lf cosa=%lf\n",sina,cosa);//test
 ve.drehenyx(sina,cosa);
 sinb= -ve.z; cosb= -ve.x;
 // printf("sinb=%lf cosb=%lf\n",sinb,cosb);//test
 //:Voraus-Berechnungen fr die Hilfsdrehungen von vp0 fertig.
 for(i=0;i<imax;i++)
  {y=ymi+i*dy; sinbeta=y/(wu=sqrt(y*y+f*f)); cosbeta=f/wu;
   for(j=0;j<praster;j++)
    {if(higrund>0)
        {waitmenu(0);
	 if(flags&F_STOP) {i=imax; flags &= ~F_STOP; break;}
	}
     x=xmi+j*dx;
     //neue Berechnungsmethode von vp0:
     // Hilfsdrehungen so dass der Einheitsvektor 
     // auf x-Achse zu liegen kommt.
     // Danach ist vp0==[-1 0 0] (Einheitsvektor der auf Bildmitte zeigt)
     vp0.x= -f; vp0.y=x; vp0.z=y; //Vektor von K auf den aktuellen Pixel
     vp0.einheitsvektor();
     vp0.drehenxz(sinb,cosb); //Obige Hilfsdrehungen wieder
     vp0.drehenxy(sina,cosa); //rckgngig machen.
     //:Ende neue Berechnungsmethode von vp0
     for(s=f,ds=ds1,absr=result=0;s<ray.smax;s+=ds)
       {vp=vp0*s+kamera; oldabsr=absr;
	absr=abs(result=calc(vp.x,vp.y,vp.z));
	if(absr>=soll) break;
	else
	  {if(absr<sollhalbe) dsmax=ds8; else dsmax=ds4;
	   if(absr<=oldabsr) ds=dsmax;
	   else
	     {ds=(soll-absr)/(absr-oldabsr)*0.25;
	      if(ds<ds1) ds=ds1; else if(ds>dsmax) ds=dsmax;
	     }
	   //if(i==imax/2 && j==praster/2 && absr<soll*1.1)//test
	   //  printf("absr=%lf s=%lf ds=%lf (ds1=%lf)\n",absr,s,ds,ds1);//test
	  }
       }
     if(ds>=ds11 && ray.quick==0)
       for(s-=ds;s<ray.smax;s+=ds1) //Korrektur wenn Schrittweite zu gross war
	 {vp=vp0*s+kamera;
	  absr=abs(result=calc(vp.x,vp.y,vp.z));
	  if(absr>=soll) break;
	 }
     if(s>=ray.smax)
       {h=0;
       }
     else
       {vpj = (j==0)? vp0*ray.smax+kamera : vpj1[j-1];
        vpi = (i==0)? vp0*ray.smax+kamera : vpj1[j];
	singamma=sinwinkel_zwischen_vektor_und_flaeche(kamera-vp,vpi-vp,vpj-vp);
        /* Lampe:
	sinepsilon=sinwinkel_zwischen_vektor_und_flaeche(vl-vp,vpi-vp,vpj-vp);
        h=singamma*sinepsilon;
	/* :vorlufig ohne Lampe */
        h=singamma; //provi. vorlufig ohne Lampe
       }
     if(h>0)
       {farbe=8+2*int(ngrau*h-0.499); if(result<0) farbe++;//rot fr neg. Psi
        //if(farbe>=(1<<tiefe)) farbe=(1<<tiefe)-1;
	tek_punkt(x,y,farbe);
       }
     else farbe=0;
     puffer[(imax-1-i)*praster+j] = farbe;
     vpj1[j]=vp;
    }
  }
 term_refresh();
}

int main(int argc,char *argv[])
{
 int ok;
 char fenstername[80];
 if(argc>1 && *argv[1]=='?')
	{printf("psi  %s\n",VERSION);
	 exit(0);
	}
 sprintf(fenstername,"psi  %s",VERSION);
 {
  Fenster gross(fenstername,640,512,TIEFE);
  psi.psiatom=new Psi[4];
  ok=gross.run();
 }
 return ok;
}/* ende von main */

int Fenster::run(char *text)
{
 int ok=1;
 psi.neuzeichnen();
 while(exitflag==0)
   {waitTOF();	//auf Beginn des Bildaufbaus warten
    //waitmenu(1);	//auf Eingaben warten
    waitmenu(0);	//nicht warten
   }
 return ok;
}

/******************* Animation erstellen *********************/
void neuebildnummer(char *s)
{
 char *t1,*t2,cstr[8];
 int n,nr;
 for(t1=s;!isdigit(*t1);t1++) ;
 for(t2=t1;isdigit(*++t2);) ;
 n=t2-t1;
 sscanf(t1,"%d",&nr);
 sprintf(cstr,"%%0%dd.%%s",n); //erzeugt z.B. "%03d.%s"
 sprintf(t1,cstr,nr+1,bildformat);
}
char *ohnebildnummer(char *s)
{
 char *t,*t0;
 int c;
 t=t0=new char[strlen(s)+1];
 while((c= *s++) && !isdigit(c)) *t++ = c;
 *t=0;
 return t0;
}

void Anim::start(int n)
{
 nb=0;
 if(n==0) setaktualray();
 sprintf(bildname,"%s.%s",animbildname,bildformat);
 // pngbild.open(bildname,"wb");//provi.
}
void Anim::stop()
{
 bild_speichern();
 animation_fertigstellen(bildname);
}
bool Anim::next()
{
 if(++nb >= nbilder) return false;
 bild_speichern();
 setaktualray();
 neuebildnummer(bildname);
 // pngbild.open(bildname,"wb");//provi.
 return true;
}
void Anim::setaktualray()
{
 int m=nbilder-1,na=m-nb;
 psi.ray.k = (startpunkt.k*na + endpunkt.k*nb)/m;
 psi.ray.horizw = (startpunkt.horizw*na + endpunkt.horizw*nb)/m;
 psi.ray.vertiw = (startpunkt.vertiw*na + endpunkt.vertiw*nb)/m;
 psi.ray.f = (startpunkt.f*na + endpunkt.f*nb)/m;
 psi.ray.blickw = (startpunkt.blickw*na + endpunkt.blickw*nb)/m;
 psi.ray.b = (startpunkt.b*na + endpunkt.b*nb)/m;
 psi.ray.smax = (startpunkt.smax*na + endpunkt.smax*nb)/m;
 psi.ray.ds1 = (startpunkt.ds1*na + endpunkt.ds1*nb)/m;
 psi.ray.soll = (startpunkt.soll*na + endpunkt.soll*nb)/m;
}

/********************* Bildspeicherung **********************/
static UBYTE redcol[256],greencol[256],bluecol[256];

void mysetcolor(int nr,int r,int g,int b)
{
 redcol[nr]=r; greencol[nr]=g; bluecol[nr]=b;
}

/**
Vorhandene Daten:
  fr jedes Pixel 1 Byte

Erwartete Daten in saveiff():
  jedes Bit entspricht einem Pixel
  die Zeilenlnge wird auf eine gerade Anzahl Bytes aufgerundet
  Fr jede Zeile werden 8 Bildebenen gespeichert (bei ti==8)
**/

void Anim::bild_speichern()
{
 // pngbild.close();//provi.
 int br=psi.praster,ho=br*4/5;
 LONG nb=(br+15)/16*2; //bytesprozeile
 const int compr=0;
 int i,j,k,m1,i1,m2,b;
 char *puffer2,*p2,*p1,*p10;
 p2=puffer2=new char[ho*nb*tiefe];
 if(puffer2==NULL) {printf("zu wenig Speicher\n"); return;}
 if(tiefe!=8) printf("unerwartete Tiefe: tiefe=%d\n",tiefe);//test
 for(p10=puffer,i=0; i<ho; i++,p10+=br)
  for(m1=0x01,i1=0; i1<tiefe; i1++,m1<<=1)
   for(p1=p10,k=j=0;j<nb;j++)
    {for(b=0,m2=0x80; m2>0 && k<br; m2>>=1,k++)
       if(*p1++ & m1) b+=m2;
     *p2++ = b;
    }
 saveiff(bildname,br,ho,tiefe,puffer2,compr,nb, redcol,greencol,bluecol);
 delete puffer2;
}

void animation_fertigstellen(char *bildname)
{
 char *str,*nam=ohnebildnummer(bildname);
 str=new char[2*strlen(nam)+20];
 sprintf(str,"convert %s*.%s %s.gif",nam,bildformat,nam);
 system(str);
 delete nam;
 delete str;
}
