/* psi.cc			letzte nderung: 2.5.2000 */
#define VERSION "Version 1.0"
/*
 einfaches Programm zum Zeichnen von Wellenfunktionen

History:
27.4.2000	Erstellung (RP)
*/

#include <stdio.h>
#include <stream.h>
#include <stdlib.h>
#include <xtekplot1.h>
#include <atan2.cc>
#include <string.h>

const int F_ACHSEN=1, F_POLAR=2, F_HYBRID=4, F_CLEAR=8;
const int FU_PSI=0, FU_PSIQUADRAT=2, FU_ABSPSI=3;

/************************* Vordeklarationen ***************************/
inline double sq(double x) {return x*x;}
inline double abs(double x) {return x>=0?x:-x;}

/************************* Men Behandlung ****************************/
static int exitflag=0;
void m_exit() {exitflag=1;}
void m_calc(),m_scale(),m_scalexyz(),m_options(),m_hybrid();

/***************************** Klassen ********************************/
class Fenster
{
 int maxcol;
 int breite,hoehe,tiefe,visklasse; //Fenstergroesse
 double xmin,ymin,xmax,ymax; //Userkoordinaten
 double bx,hy; //Schriftgroessen
public:
 Fenster(char*,int b=12500,int h=10000,int t=24);
 ~Fenster();
 int run(char *text=NULL);
};
Fenster::Fenster(char *name,int br,int ho,int ti)
{
 exitflag=0;
 xmin= -0.15; ymin= -0.12; xmax=0.2; ymax=0.16;
 bx=(xmax-xmin)/100; hy=(ymax-ymin)/40;
 //tek_setdebug(1);//test
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(breite>br) breite=br;
 if(hoehe>ho) hoehe=ho;
 if(tiefe>ti) tiefe=ti;
 maxcol=(1<<tiefe);
 setsize(breite,hoehe,tiefe);
 setmenu(2,"File","Settings");
 setmenu(2,"run ...","scaling ...",&m_calc,&m_scale);
 setmenu(2,"Exit","xyz-scaling ...",&m_exit,&m_scalexyz);
 setmenu(2,NULL,  "options ...",&m_exit,&m_options);
 setmenu(2,NULL,  "hybridization ...",&m_exit,&m_hybrid);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 set_tektitel(name);
 screenclear(1); color(0);
 term_refresh();
}
Fenster::~Fenster()
{
 term_exit();
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 int ok;
 char fenstername[80];
 if(argc>1 && *argv[1]=='?')
	{printf("psi  %s\n",VERSION);
	 exit(0);
	}
 sprintf(fenstername,"psi  %s",VERSION);
 {
  Fenster gross(fenstername,640,512,4);
  ok=gross.run();
 }
 return ok;
}/* ende von main */

class Psi
{
 double a,zweia,a3;
 double xmi,ymi,xma,yma;//Grenzen fuer Grafik
 int comp(int n,int l,int m)
	{int nlm=100*n+10*l+abs(m); if(m<0) nlm= -nlm; return nlm;}
public:
 double xmin,ymin,xmax,ymax,zmin,zmax,AMAX;
 double eps; //Vergleichsgenauigkeit
 int n,l,m,nlm, raster;
 int hyb[4]; double anteil[4];
 int flags,funkt;
 double soll;
 Psi()	{n=2; l=1; m=0; a=0.593; zweia=2*a; a3=a*a*a;
	 soll=0.01; eps=1e-3; raster=100; flags=F_CLEAR; funkt=FU_PSI;
	 AMAX=8; xmin=ymin=zmin= -AMAX; xmax=ymax=zmax=AMAX;
	 anteil[0]=anteil[1]=anteil[2]=anteil[3]=1;
	 hyb[0]=200; hyb[1]=210; hyb[2]=211; hyb[3]= -211;
	}
 double calc1(double x,double y,double z);
 double hybrid(double x,double y,double z);
 double calc(double x,double y,double z)
	{return (flags&F_HYBRID) ? hybrid(x,y,z) : calc1(x,y,z);}
 void neuzeichnen();
 bool fastgleich(double,double);
 void sethyb(int k,int*p,double*pa)
	{int i; for(i=0;i<k;i++,p+=3)
	  {hyb[i]=comp(*p,p[1],p[2]); anteil[i]=pa[i];}
	 for(;i<4;i++) {hyb[i]=0; anteil[i]=0.0;}
	}
 void gethyb(int k,int*p,double*pa)
	{for(int i=0;i<k;i++,p+=3)
	  {int k=abs(hyb[i]);
	   *p=k/100; k-= *p*100; p[1]=k/10; k-=p[1]*10;
	   p[2] = hyb[i]<0 ? -k : k;
	   *pa++ = anteil[i];
	  }
	}
};
static Psi psi;

double Psi::calc1(double x,double y,double z) //berechnet PSI
{
 double a1,a2,r,ra,theta,phi,xy2=x*x+y*y;
 r=sqrt(xy2+z*z); ra=r/a;
 phi=atan2(y,x);
 theta=acos(z/r);
 switch(nlm)
   {case  100: a1=PI*a3; a2=1; ra*=2;
    CASE  200: a1=32*PI*a3; a2=2-ra;
    CASE  210: a1=32*PI*a3; a2=ra*cos(theta);
    CASE  211: a1=32*PI*a3; a2=ra*sin(theta)*cos(phi);
    CASE -211: a1=32*PI*a3; a2=ra*sin(theta)*sin(phi);
    CASE  300: a1=81*81*3*PI*a3; a2=27-18*ra+2*ra*ra;
    CASE  310: a1=81*81*PI/2*a3; a2=ra*(6-ra)*cos(theta);
    CASE  311: a1=81*81*PI/2*a3; a2=ra*(6-ra)*sin(theta)*cos(phi);
    CASE -311: a1=81*81*PI/2*a3; a2=ra*(6-ra)*sin(theta)*sin(phi);
    CASE  320: a1=81*81*6*PI*a3; a2=ra*ra*(3*sq(cos(theta))-1);
    CASE  321: a1=81*81*PI/2*a3; a2=ra*ra*sin(theta)*cos(theta)*cos(phi);
    CASE -321: a1=81*81*PI/2*a3; a2=ra*ra*sin(theta)*cos(theta)*sin(phi);
    CASE  322: a1=81*81*2*PI*a3; a2=ra*ra*sq(sin(theta))*cos(2*phi);
    CASE -322: a1=81*81*2*PI*a3; a2=ra*ra*sq(sin(theta))*sin(2*phi);
   DEFAULT: a1=a2=1; //printf("unbekannte nlm-Kombination %d %d %d\n",n,l,m);
   }
 if(funkt==FU_PSI) return sqrt(1/a1)*a2*exp(-ra*0.5);
 else if(funkt==FU_ABSPSI) return abs(sqrt(1/a1)*a2*exp(-ra*0.5));
//else if(funkt==FU_PSIQUADRAT)
 return 1/a1*a2*a2*exp(-ra);
}
double Psi::hybrid(double x,double y,double z) //Hybridisierung
{
 double result=0,an=0;
 int n;
 for(n=0;hyb[n]!=0;n++)
   {nlm=hyb[n]; an+=abs(anteil[n]); result += anteil[n]*calc1(x,y,z);}
 return result/an; //geht (noch) nicht richtig
}

bool Psi::fastgleich(double x,double y)
{
 if(x<0) return (y < -x+eps && y > -x-eps);
 return (y<x+eps && y>x-eps);
}

const double f=0.7, alfa=45*PI/180, sinaf=sin(alfa)*f, cosaf=cos(alfa)*f;

//void punktzeichnen(double x,double y,double z)
void punktzeichnen(double x,double y,double z,int farbe)
{
  // int farbe=(z>0)?0:2;
 tek_punkt(x+y*cosaf,z+y*sinaf,farbe);
}
void achsezeichnen(double x1,double y1,double z1,double x2,double y2,double z2)
{
 plot(x1+y1*cosaf,z1+y1*sinaf,PENUP);
 plot(x2+y2*cosaf,z2+y2*sinaf,PENDOWN);
}

void Psi::neuzeichnen()
{
 double p,dx,dy,dz; dx=dy=dz=2*AMAX/raster;
 double x,y,z,result;
 char text[80];
 nlm=100*n+10*l+abs(m);
 if(m<0) nlm= -nlm;
 xmi=(xmin+ymin*cosaf)*1.25; xma=(xmax+ymax*cosaf)*1.25;
 ymi=zmin+ymin*sinaf; yma=zmax+ymax*sinaf;
 inital_new(xmi,ymi,xma,yma);
 if(flags&F_CLEAR) screenclear(1);
 color(0);
 if(flags&F_ACHSEN)
   {achsezeichnen(0,0,zmin, 0,0,zmax);
    achsezeichnen(xmin,0,0, xmax,0,0);
    achsezeichnen(0,ymin,0, 0,ymax,0);
   }
 for(y=ymax;y>=ymin;y-=dy)
   for(x=xmin;x<=xmax;x+=dx)
     for(z=zmin;z<=zmax;z+=dx)
       {if(fastgleich(result=calc(x,y,z),soll))
	    punktzeichnen(x,y,z,result>0?4:2);
       }
 color(0);
 if(flags&F_HYBRID)
   sprintf(text,"Hybridization: %d %d %d %d",hyb[0],hyb[1],hyb[2],hyb[3]);
 else sprintf(text,"n = %d   l = %d   m = %d",n,l,m);
 if(n>3) sprintf(text,"Sorry, yet only working with n<=3");
 schrift(xmi,ymi,text);
 term_refresh();
}

void m_scale()
{
 int ok;
 ok=requester_input(2," xmin ","%lf","%lf",&psi.xmin,
		      " xmax ","%lf","%lf\n",&psi.xmax);
 if(ok)
   {psi.AMAX=psi.xmax;
    psi.zmin=psi.ymin=psi.xmin;
    psi.zmax=psi.ymax=psi.xmax;
    psi.neuzeichnen();
   }
}
void m_scalexyz()
{
 int ok;
 ok=requester_input(6," xmin ","%lf","%lf",&psi.xmin,
		      " xmax ","%lf","%lf\n",&psi.xmax,
		      " ymin ","%lf","%lf",&psi.ymin,
		      " ymax ","%lf","%lf\n",&psi.ymax,
		      " zmin ","%lf","%lf",&psi.zmin,
		      " zmax ","%lf","%lf\n",&psi.zmax);
 if(ok)
   {psi.AMAX=(psi.ymax>psi.xmax)?psi.ymax:psi.xmax;
    psi.neuzeichnen();
   }
}
void m_options()
{
 int ok;
 char koord[40],achse[40],funkt[40],clear[40];
 strcpy(koord,psi.flags&F_POLAR?"polar":"xyz");
 strcpy(achse,psi.flags&F_ACHSEN?"ja":"nein");
 switch(psi.funkt)
   {case FU_ABSPSI: strcpy(funkt,"abs(psi)");
    CASE FU_PSIQUADRAT: strcpy(funkt,"psi^2");
    CASE FU_PSI: default: strcpy(funkt,"psi");
   }
 strcpy(clear,psi.flags&F_CLEAR?"on":"off");
 ok=requester_input(4," Koordinaten (xyz oder polar) ","%s","%s\n",koord,
		      " Achsen einzeichnen (j/n) ","%s","%s\n",achse,
		      " Funktion (psi psi^2 abs(psi) ","%s","%s\n",funkt,
		      " Screenclear (on off","%s","%s\n",clear);
 if(ok)
   {psi.flags=0;
    if(strncmp(koord,"pol",3)==0) psi.flags |= F_POLAR;
    if(*achse!='n' && *achse!='N') psi.flags |= F_ACHSEN;
    if(strcmp(funkt,"psi^2")==0) psi.funkt=FU_PSIQUADRAT;
    else if(strncmp(funkt,"abs",3)==0) psi.funkt=FU_ABSPSI;
    else psi.funkt=FU_PSI;
    if(strncmp(clear,"on",2)==0) psi.flags |= F_CLEAR;
   }
}
void m_hybrid()
{
 int ok;
 char txt1[40],txt2[40],txt3[40],txt4[40];
 int n,l,m,feld[4*3],*p;
 double an,afeld[4],*pa;
 psi.gethyb(4,feld,afeld);
 p=feld; pa=afeld;
 sprintf(txt1," %d %2d %2d  %.3lf",*p,p[1],p[2],*pa++); p+=3;
 sprintf(txt2," %d %2d %2d  %.3lf",*p,p[1],p[2],*pa++); p+=3;
 sprintf(txt3," %d %2d %2d  %.3lf",*p,p[1],p[2],*pa++); p+=3;
 sprintf(txt4," %d %2d %2d  %.3lf",*p,p[1],p[2],*pa++); p+=3;
 ok=requester_input(4," n  l  m  Anteil","%s","%s\n",txt1,
		      " n  l  m  Anteil","%s","%s\n",txt2,
		      " n  l  m  Anteil","%s","%s\n",txt3,
		      " n  l  m  Anteil","%s","%s\n",txt4);
 if(ok)
   {p=feld; pa=afeld;
    sscanf(txt1,"%d %d %d %lf",&n,&l,&m,&an);
    *p++ =n; *p++ =l; *p++ =m; *pa++ =an;
    if(n==0) psi.flags &= ~F_HYBRID;
    else     psi.flags |= F_HYBRID;
    sscanf(txt2,"%d %d %d %lf",&n,&l,&m,&an);
    *p++ =n; *p++ =l; *p++ =m; *pa++ =an;
    if(n==0) psi.flags &= ~F_HYBRID;
    sscanf(txt3,"%d %d %d %lf",&n,&l,&m,&an); if(n==0 || an==0) n=l=m=0;
    *p++ =n; *p++ =l; *p++ =m; *pa++ =an;
    sscanf(txt4,"%d %d %d %lf",&n,&l,&m,&an); if(n==0 || an==0) n=l=m=0;
    *p++ =n; *p++ =l; *p++ =m; *pa++ =an;
    psi.sethyb(4,feld,afeld);
   }
}

void m_calc()
{
 int ok;
 if(psi.flags&F_HYBRID)
 ok=requester_input(7," nlm1 ","%d","%d",&psi.hyb[0],
		      " nlm2 ","%d","%d",&psi.hyb[1],
		      " nlm3 ","%d","%d",&psi.hyb[2],
		      " nlm4 ","%d","%d\n",&psi.hyb[3],
		      "  Psi-Sollwert  ","%lf","%lf",&psi.soll,
		      "     epsilon    ","%lf","%lf\n",&psi.eps,
		      " Anzahl Schritte ","%d","%d\n",&psi.raster);
 else
 ok=requester_input(6,"  n  ","%d","%d",&psi.n,
		      "  l  ","%d","%d",&psi.l,
		      "  m  ","%d","%d\n",&psi.m,
		      "  Psi-Sollwert  ","%lf","%lf",&psi.soll,
		      "     epsilon    ","%lf","%lf\n",&psi.eps,
		      " Anzahl Schritte ","%d","%d\n",&psi.raster);
 if(ok) psi.neuzeichnen();
}

int Fenster::run(char *text)
{
 int ok=1;
 psi.neuzeichnen();
 while(exitflag==0)
   {//waitTOF();	//auf Beginn des Bildaufbaus warten
    waitmenu(1);	//auf Eingaben warten
    //oder waitmenu(0);	//nicht warten
   }
 return ok;
}
