/* saveiff.cc		IFF-Saver */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <ulong.h>
#ifndef BOOL
#define BOOL int
#endif

// Vordeklarationen von C2CPP erzeugt:
//void saveiff(char* name,UWORD br,UWORD ho,UBYTE ti,char* p,UBYTE compr);
LONG packe(char* quelle,char* ziel,LONG zeilenlaenge,int nzeilen);
int getline(FILE* fp,char* s,int lim);
int ascitodigit(int c);
BYTE *PutDump(BYTE* dest,int nn);
BYTE *PutRun(BYTE* dest,int nn,int cc);
LONG PackRow(BYTE** pSource,BYTE** pDest,LONG rowSize);
// Ende der Vordeklarationen von C2CPP

/***************** maschinenabhaengiger Teil *********************/
static void ffwrite(char* adr,int size,int n,FILE* fp)
{		/* korrigiert fehlerhaftes fwrite */
 char h;
 int i,j,k;
 for(k=0;k<n;k++)
   {i=k*size;
    for(j=i+size-1;i<j;i++,j--)
        {h= adr[i]; adr[i]=adr[j]; adr[j]=h;}
   }
 fwrite(adr,1,size*n,fp);
 for(k=0;k<n;k++)
   {i=k*size;
    for(j=i+size-1;i<j;i++,j--)
        {h= adr[i]; adr[i]=adr[j]; adr[j]=h;}
   }
}

/************************ portabler Teil **************************/
struct bmhd
	{UWORD breite,hoehe;
	 WORD x,y;
	 UBYTE nplanes,mask,compr,pad;
	 UWORD transcolor;
	 UBYTE xaspect,yaspect;
	 WORD scrbreite,scrhoehe;
	};

void saveiff(char* name,UWORD br,UWORD ho,UBYTE ti,char* p,UBYTE compr,
	LONG bytesprozeile,UBYTE *redcol,UBYTE *greencol,UBYTE *bluecol)
{
 FILE *fp; char *p2=NULL;
 LONG i,null=0,weiss=0xFFFFFFFF,nb;
 UBYTE eins=1;
 BYTE noop= -128, evenflag=0;
 LONG laenge,bmhd_laenge,cmap_laenge,body_laenge,evenbody_laenge;
 int ncolors=(1<<ti);
 fp=fopen(name,"w");
 if(fp==NULL) {printf("Fehler beim Oeffnen von '%s'\n",name); return;}
 nb=bytesprozeile;
 if(nb!=((br+15)/16)*2)
	printf("Fehler: Bytesprozeile nicht auf Words gerundet\n");
 body_laenge=nb*ho*ti;
 if(compr)
	{p2=(char*)calloc(body_laenge,1);
	 if(p2) {body_laenge=packe(p,p2,nb,ho); p=p2;}
	}
 bmhd_laenge=sizeof(bmhd);
 cmap_laenge=(((1<<ti)*3+1)/2)*2;
 fwrite("FORM",1,4,fp);
 evenbody_laenge=body_laenge;
 if(evenbody_laenge & 1) {evenflag=1; evenbody_laenge++;}
 laenge=evenbody_laenge+cmap_laenge+bmhd_laenge+3*8+4;
 ffwrite((char*)&laenge,4,1,fp);
 fwrite("ILBMBMHD",1,8,fp);
 ffwrite((char*)&bmhd_laenge,4,1,fp);
 ffwrite((char*)&br,2,1,fp); ffwrite((char*)&ho,2,1,fp);   /* breite,hoehe */
 fwrite(&null,4,1,fp);			     /* x,y */
 fwrite(&ti,1,1,fp); fwrite(&null,1,1,fp);   /* nplanes,mask */
 fwrite(&compr,1,1,fp); fwrite(&null,1,1,fp);/* compr,pad */
 fwrite(&null,2,1,fp);			     /* transcolor */
 fwrite(&eins,1,1,fp); fwrite(&eins,1,1,fp); /* xaspect,yaspect */
 ffwrite((char*)&br,2,1,fp); ffwrite((char*)&ho,2,1,fp);/* scrbreite,scrhoehe */
 fwrite("CMAP",1,4,fp);
 ffwrite((char*)&cmap_laenge,4,1,fp);
/* fwrite(&null,1,3,fp); /* schwarz */
/* fwrite(&weiss,1,3,fp); /* weiss */
 for(i=0;i<ncolors;i++)
	{fwrite(&redcol[i],1,1,fp);
	 fwrite(&greencol[i],1,1,fp);
	 fwrite(&bluecol[i],1,1,fp);
	}
 fwrite("BODY",1,4,fp);
 ffwrite((char*)&evenbody_laenge,4,1,fp);
 for(i=0;i<body_laenge;i++)
	fwrite(p++,1,1,fp);
 if(evenflag) fwrite(&noop,1,1,fp);
 if(p2) cfree(p2);
 fclose(fp);
 return;
}

LONG packe(char* quelle,char* ziel,LONG zeilenlaenge,int nzeilen)
{
 char *z0=ziel;
 int n;
 while(nzeilen--)
	 PackRow(&quelle,&ziel,zeilenlaenge);
 return (ziel-z0);
}

/************************* Kleinkram *************************/
getline(FILE* fp,char* s,int lim) ///* liest eine Textzeile oder maximal lim Zeichen */
//FILE *fp; char *s; int lim; /* und ersetzt den Zeilentrenner durch 0         */
{int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
        *s++ = c;
 *s='\0';
 return (c!=EOF);       /* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

ascitodigit(int c) ///* wandelt ein ASCI-Zeichen in eine 1-stellige Hex-Zahl */
//int c;
{
 if(c<0) return c;
 if(!isxdigit(c)) return -2;
 c=toupper(c)-'0';
 if(c>9) c += '0'-'A'+10;
 return c;
}

/*----------------------------------------------------------------------*
 * packer.c Convert data to "cmpByteRun1" run compression.     11/15/85
 *
 * By Jerry Morrison and Steve Shaw, Electronic Arts.
 * This software is in the public domain.
 *
 *      control bytes:
 *       [0..127]   : followed by n+1 bytes of data.
 *       [-1..-127] : followed by byte to be repeated (-n)+1 times.
 *       -128       : NOOP.
 *
 * This version for the Commodore-Amiga computer.
 *----------------------------------------------------------------------*/
/* #include "iff/packer.h" */

#define DUMP    0
#define RUN     1

#define MinRun 3
#define MaxRun 128
#define MaxDat 128
LONG putSize;
#define GetByte()       (*source++)
#define PutByte(c)      { *dest++ = (c);   ++putSize; }

char buf[256];  /* [TBD] should be 128?  on stack?*/

BYTE *PutDump(BYTE* dest,int nn)
//BYTE *dest;  int nn;
{
        int i;

        PutByte(nn-1);
        for(i = 0;  i < nn;  i++)   PutByte(buf[i]);
        return(dest);
}

BYTE *PutRun(BYTE* dest,int nn,int cc)
//BYTE *dest;
//int nn, cc;
{
        PutByte(-(nn-1));
        PutByte(cc);
        return(dest);
}

#define OutDump(nn)   dest = PutDump(dest, nn)
#define OutRun(nn,cc) dest = PutRun(dest, nn, cc)

/*----------- PackRow --------------------------------------------------*/
/* Given POINTERS TO POINTERS, packs one row, updating the source and
   destination pointers.  RETURNs count of packed bytes.*/
LONG PackRow(BYTE** pSource,BYTE** pDest,LONG rowSize)
//BYTE **pSource, **pDest;
//LONG rowSize;
{
    BYTE *source, *dest;
    char c,lastc = '\0';
    BOOL mode = DUMP;
    short nbuf = 0;             /* number of chars in buffer */
    short rstart = 0;           /* buffer index current run starts */

    source = *pSource;
    dest = *pDest;
    putSize = 0;
    buf[0] = lastc = c = GetByte();  /* so have valid lastc */
    nbuf = 1;   rowSize--;      /* since one byte eaten.*/

    for (;  rowSize;  --rowSize) {
        buf[nbuf++] = c = GetByte();
        switch (mode) {
                case DUMP:
                        /* If the buffer is full, write the length byte,
                           then the data */
                        if (nbuf>MaxDat) {
                                OutDump(nbuf-1);
                                buf[0] = c;
                                nbuf = 1;   rstart = 0;
                                break;
                                }

                        if (c == lastc) {
                            if (nbuf-rstart >= MinRun) {
                                if (rstart > 0) OutDump(rstart);
                                mode = RUN;
                                }
                            else if (rstart == 0)
                                mode = RUN;     /* no dump in progress,
                                so can't lose by making these 2 a run.*/
                            }
                        else  rstart = nbuf-1;          /* first of run */
                        break;

                case RUN: if ( (c != lastc)|| ( nbuf-rstart > MaxRun)) {
                        /* output run */
                        OutRun(nbuf-1-rstart,lastc);
                        buf[0] = c;
                        nbuf = 1; rstart = 0;
                        mode = DUMP;
                        }
                        break;
                }

        lastc = c;
        }

    switch (mode) {
        case DUMP: OutDump(nbuf); break;
        case RUN: OutRun(nbuf-rstart,lastc); break;
        }
    *pSource = source;
    *pDest = dest;
    return(putSize);
}
