// Einstieg in die Informatik mit C++, Gerd Bohlender, Uni Karlsruhe, 25.5.97

// Loesung eines linearen Gleichungssystems mit Gauss-Elimination

#include <iostream.h>

int main ()
{
const int n=4;          // Dimension des LGS
double a[n][n];         // n*n Matrix
double b[n],x[n];       // Vektor der rechten Seite und Loesungsvektor
int i,j,k;              // Zaehlvariablen
double f;               // Faktor zur Zeilenaddition

// lies Matrix
cout << "Bitte " << n << '*' << n << "-Matrix zeilenweise eingeben" << endl;
for (i=0; i<n; i++)
  for (j=0; j<n; j++)
    cin >> a[i][j];

// lies Vektor der rechten Seite
cout << "Bitte rechte Seite eingeben" << endl;
for (i=0; i<n; i++)
  cin >> b[i];

// Gauss Elimination
// Transformation auf Dreiecksmatrix
for (i=0; i<n-1; i++)                      // n-1 Eliminationsschritte
  for (j=i+1; j<n; j++)                    // jeweils alle folgenden Zeilen bearbeiten
  {
    f = - a[j][i] / a[i][i];               // Faktor bestimmen
    a[j][i] = 0.0;                         // dieses Element wird zu 0 gemacht
    for (k=i+1; k<n; k++)                  // zum Rest der j-ten Zeile das ...
      a[j][k] = a[j][k] + f * a[i][k];     // ... f-fache der i-ten Zeile addieren
    b[j] = b[j] + f * b[i];                // ebenso auf der rechten Seite
  }
// x[i] aus Dreiecksmatrix bestimmen
for (i=n-1; i>=0; i--)
{
  x[i] = b[i];                             // rechte Seite
  for (j=n-1; j>i; j--)
    x[i] = x[i] - a[i][j] * x[j];          // alle bekannten x[j] einsetzen
  x[i] = x[i] / a[i][i];                   // durch Diagonalelement dividieren
}

// drucke Ergebnisvektor
cout << "Ergebnis: " << endl;
for (i=0; i<n; i++)
  cout << x[i] << endl;
return 0;
}

