// Loesung eines linearen Gleichungssystems mit Gauss-Elimination

double* lgs_gauss(int n,double a[][NGAU],double *b)
{
 double* x=new double[n];
 int i,j,k;
 double f;               // Faktor zur Zeilenaddition

// Gauss Elimination
// Transformation auf Dreiecksmatrix
for (i=0; i<n-1; i++)                      // n-1 Eliminationsschritte
  for (j=i+1; j<n; j++)                    // jeweils alle folgenden Zeilen bearbeiten
  {
    f = - a[j][i] / a[i][i];               // Faktor bestimmen
    a[j][i] = 0.0;                         // dieses Element wird zu 0 gemacht
    for (k=i+1; k<n; k++)                  // zum Rest der j-ten Zeile das ...
      a[j][k] = a[j][k] + f * a[i][k];     // ... f-fache der i-ten Zeile addieren
    b[j] = b[j] + f * b[i];                // ebenso auf der rechten Seite
  }
// x[i] aus Dreiecksmatrix bestimmen
for (i=n-1; i>=0; i--)
{
  x[i] = b[i];                             // rechte Seite
  for (j=n-1; j>i; j--)
    x[i] = x[i] - a[i][j] * x[j];          // alle bekannten x[j] einsetzen
  x[i] = x[i] / a[i][i];                   // durch Diagonalelement dividieren
}

 return x;
}
