/* potflaeche.cc			letzte nderung: 7.8.2001 */
#define VERSION "Version 0.1"
/*

 Kurzbeschreibung: einfache Darstellung einer Potentialflche

History:
2.8.2001	Erstellung (RP)
*/

#include <stdio.h>
#include <stream.h>
#include <stdlib.h>
#include <xtekplot1.h>
#include <math3.h>

#define XMAX 640
#define YMAX 512
#define TIEFE 4

/************************* Vordeklarationen ***************************/
void zeichnen(char *name,int methode);

/************************* Men Behandlung ****************************/
static int exitflag=0;
void menu_exit() {exitflag=1;}
void menu_draw(),menu_opti();

/************************* Globale Variablen ****************************/
static double g_xmin,g_xmax,g_ymin,g_ymax;
static double g_alfa=45,g_f=0.7,g_zoom=1.0;
static int g_methode=4,g_argc;
static char* g_name[200];

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 int col=0,maxcol;
 int breite,hoehe,tiefe,visklasse,i;
 double xmin=1.725,ymin=2.2,xmax=6.675,ymax=6.2;
 //tek_setdebug(1);//test
 if(argc<2 || (argc>1 && *argv[1]=='?'))
	{printf("potflaeche  %s\n",VERSION);
	 printf("Anwendung: potflaeche name.data\n",VERSION);
	 exit(0);
	}
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(tiefe>TIEFE) tiefe=TIEFE;
 maxcol=(1<<TIEFE);
 setsize(XMAX,YMAX,tiefe);
 setmenu(1,"File");
 setmenu(1,"Optionen ...",&menu_opti);
 setmenu(1,"Zeichnen ...",&menu_draw);
 setmenu(1,"Exit",&menu_exit);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 g_xmin=xmin; g_xmax=xmax; g_ymin=ymin; g_ymax=ymax;
 if(g_methode>=3) {term_refresh(); inital_new(-0.1875,0.0,1.6875,1.5);}
 g_argc=argc;
 color(0);
 for(i=1;i<argc;i++) {screenclear(1); zeichnen(g_name[i]=argv[i],g_methode);}
 term_refresh();
 while(exitflag==0 && waitmenu(1)==0)
	;// auf Benutzereingaben warten
 inital_new();
 term_exit();
 return 0;
}/* ende von main */

/*************************** kleinkram: ***************************/
int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}
/*************************** :kleinkram ***************************/

void getzminmax(char *name,double& zmin,double& zmax)
{
 double x,y,z;
 char zeile[80];
 FILE *fp;
 if((fp=fopen(name,"r"))==NULL) {printf("%s nicht gefunden\n",name); return;}
 getline(fp,zeile,80); //kommentar berlesen
 getline(fp,zeile,80); //xstep berlesen
 getline(fp,zeile,80); //ystep berlesen
 zmin=1e20; zmax= -zmin;
 while(getline(fp,zeile,80))
  {sscanf(zeile,"%lf %lf %lf",&x,&y,&z); z= -z;
   if(z>zmax) zmax=z;
   if(z<zmin) zmin=z;
  }
 fclose(fp);
 // printf("zmin=%lf  zmax=%lf\n",zmin,zmax); //test
}

void zeichnen(char *name,int methode)
{
 double x,y,z;
 static double zmin,zmax,xfeld[20][20],yfeld[20][20],zfeld[20][20];
 int i,imax=100,imax2=imax/2,j,r,g,b,farbnr,fmin=0,fmax=255,nx,ny;
 char zeile[80];
 static char kommentar[80],filename[80];
 FILE *fp;
 if(name!=NULL) strcpy(filename,name);
 if(methode==1)
  {for(i=0;i<=imax;i++)
    {g=(fmax-fmin)*i/imax+fmin; setcolor(2+i,g,g,g);}
  }
 else
  {for(i=0;i<=imax;i++)
    {if(i<imax2) {b=fmax-(fmax-fmin)*i/imax2; g=255-b; r=0;}
     else {b=0; r=fmax-(fmax-fmin)*(imax-i)/imax2; g=255-r;}
     setcolor(2+i,r,g,b);
    }
  }
 getzminmax(filename,zmin,zmax);
 if((fp=fopen(filename,"r"))==NULL)
   {printf("%s nicht gefunden\n",filename); return;}
 getline(fp,kommentar,80);
 getline(fp,zeile,80); sscanf(zeile,"%d",&nx);
 getline(fp,zeile,80); sscanf(zeile,"%d",&ny);
 if(methode>=3)
 {double alfa=g_alfa,f=g_f; //Winkel und Verkrzung der 3D-Darstellung
  double cosaf=cos(alfa*GRAD)*f,sinaf=sin(alfa*GRAD)*f;
  double zf=1.0/(zmax-zmin);
  double yf=g_zoom/(g_ymax-g_ymin);
  double xf=g_zoom/(g_xmax-g_xmin);
  for(j=0;j<ny;j++)
   for(i=0;i<nx;i++)
     {getline(fp,zeile,80);
      sscanf(zeile,"%lf %lf %lf",&x,&y,&z); z= -z;
      xfeld[j][i]=x; yfeld[j][i]=y; zfeld[j][i]=z;
     }
  color(0);
  for(j=0;j<ny;j++)
   for(i=0;i<nx;i++)
     {y=xfeld[j][i]; x=yfeld[j][i]; z=zfeld[j][i];
      plot((x-g_xmin)*xf+cosaf*(y-g_ymin)*yf,
	   (zmax-z)*zf+sinaf*(y-g_ymin)*yf,
	   i==0?PENUP:PENDOWN);
     }
  if(methode==4)
  {for(j=0;j<ny;j++)
    for(i=0;i<nx;i++)
     {x=xfeld[j][i]; y=yfeld[j][i]; z=zfeld[j][i];
      plot((x-g_xmin)*xf+cosaf*(y-g_ymin)*yf,
	   (zmax-z)*zf+sinaf*(y-g_ymin)*yf,
	   i==0?PENUP:PENDOWN);
     }
  }
 }
 else
 {while(getline(fp,zeile,80))
  {sscanf(zeile,"%lf %lf %lf",&x,&y,&z); z= -z;
   farbnr=2+int(imax/(zmax-zmin)*(z-zmin)+0.5);
   color(farbnr);
   fillbox(x,y,x+0.2,y+0.2);
  }
 }
 fclose(fp);
}

void menu_draw()
{
 int ok,i;
 ok=requester_input(1,"Methode (1=Grau 2=Falschfarben 3=Scheiben 4=Netz)",
		    "%d","%d\n",&g_methode);
 if(ok)
   {if(g_methode>=3) inital_new(-0.1875,0.0,1.6875,1.5);
    else inital_new(g_xmin,g_ymin,g_xmax,g_ymax);
    for(i=1;i<g_argc;)
      {screenclear(1); zeichnen(g_name[i],g_methode);
       if(++i<g_argc) {term_refresh(); inital_new();}
      }
    term_refresh();
   }
}

void menu_opti()
{
 requester_input(3,"Winkel in Grad","%lf","%lf",&g_alfa,
		   "Verkuerzungsfaktor","%lf","%lf\n",&g_f,
		   "Zoomfaktor","%lf","%lf\n",&g_zoom);
}
