/* qpot.cc			letzte nderung: 8.8.2001 */
#define VERSION "Version 0.0"
/*

 Kurzbeschreibung: Darstellung einer Potentialflche mit QT

History:
7.8.2001	Erstellung (RP)
*/

#include <stdio.h>
#include <stream.h>
#include <stdlib.h>
#include <vektorklasse.cc>
#include "vektor3dklasse.cc"
long idfix(double x) {return x<0?int(x-0.5):int(x+0.5);}

#include <qapplication.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qpixmap.h>

/*************************** kleinkram: ***************************/
int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}
/*************************** :kleinkram ***************************/
class Dreidplot
{
 int xmax,ymax; //Breite und Hhe des Pixelbereichs fr Ausgabe
 double pixbreite,pixhoehe; //Breite und Hhe eines Pixels (z.B. in mm)
 Vektor3d streck,offset; //Streckfaktoren und Offset fr wirkliche Koordinaten
                         //zuerst wird Offset gemacht, dann gestreckt
 double dreh1,dreh2,dreh3; //Drehungen des Objekts
    //(zuerst um z-Achse, dann um x-Achse und nochmals um z-Achse)
 double sindreh1,cosdreh1,sindreh2,cosdreh2,sindreh3,cosdreh3;
 double kameraabstand; //Kameraposition
  //(Kamera liegt immer auf z-Achse und auf Koordinatenursprung ausgerichtet)
 double brenn; //Brennweite
public:
 Dreidplot(int xm,int ym,double b,double k,Vektor3d o,Vektor3d s,
	   double d1,double d2,double d3)
  {xmax=xm; ymax=ym; brenn=b; kameraabstand=k; offset=o; streck=s;
   pixbreite=pixhoehe=0.28; //Pixelgrsse des Monitors
   drehen(d1,d2,d3);
  }
 void drehen(double d1,double d2,double d3,bool relativ=false); //Objekt drehen
 QPoint getpixcoord(Vektor3d p);
 QPoint getpixcoord(double x,double y,double z)
  {return getpixcoord(Vektor3d(x,y,z));}
};
void Dreidplot::drehen(double d1,double d2,double d3,bool relativ)
{
 if(relativ)
   {dreh1+=d1; dreh2+=d2; dreh3+=d3;}
 else
   {dreh1=d1; dreh2=d2; dreh3=d3;}
 sindreh1=sin(dreh1*GRAD); cosdreh1=cos(dreh1*GRAD);
 sindreh2=sin(dreh2*GRAD); cosdreh2=cos(dreh2*GRAD);
 sindreh3=sin(dreh3*GRAD); cosdreh3=cos(dreh3*GRAD);
}
QPoint Dreidplot::getpixcoord(Vektor3d p)
{
 double bx,by,af;
 // printf("Dreidplot::getpixcoord(%lf %lf %lf)\n",p.x,p.y,p.z);//test
 p -= offset;
 // printf(" Offset subtrahiert: %lf %lf %lf\n",p.x,p.y,p.z);//test
 p = p*streck;
 // printf(" gestreckt: %lf %lf %lf\n",p.x,p.y,p.z);//test
 p.drehenyx(sindreh1,cosdreh1);
 // printf(" 1.Drehung: %lf %lf %lf\n",p.x,p.y,p.z);//test
 p.drehenyz(sindreh2,cosdreh2);
 // printf(" 2.Drehung: %lf %lf %lf\n",p.x,p.y,p.z);//test
 p.drehenyx(sindreh3,cosdreh3);
 // printf(" 3.Drehung: %lf %lf %lf\n",p.x,p.y,p.z);//test
 af=kameraabstand+brenn-p.z;
 if(af==0)
   {bx = p.x>0 ? 32000 : -32000; //Bei Division durch Null liegt
    by = p.y>0 ? 32000 : -32000; //der Punkt weit ausserhalb.
   }
 else
   {bx=brenn*p.x/af;
    by=brenn*p.y/af;
   }
 // printf("bx=%lf by=%lf\n",bx,by);//test
 // printf("%ld %ld\n",
 //	idfix(bx/pixbreite)+xmax/2,idfix(by/pixhoehe)+ymax/2);//test
 return QPoint(idfix(bx/pixbreite)+xmax/2,idfix(by/pixhoehe)+ymax/2);
}

class Potentialflaeche
{
 double *xfeld,*yfeld,*zfeld;
 int n;//Anzahl definierte Punkte
 char kommentar[160];
 Dreidplot* dplot;
public:
 int nx,ny;
 Potentialflaeche(char* name,Dreidplot* d);
 QPoint getqpoint(int i,int j);
};

QPoint Potentialflaeche::getqpoint(int i,int j)
{
 int n=nx*j+i;
 return dplot->getpixcoord(xfeld[n],yfeld[n],zfeld[n]);
}

Potentialflaeche::Potentialflaeche(char* name,Dreidplot* d)
{
 // double xmin=1.725,ymin=2.2,xmax=6.675,ymax=6.2;
 dplot=d;
 int i,nn;
 char zeile[80];
 FILE *fp;
 if((fp=fopen(name,"r"))==NULL)
   {printf("%s nicht gefunden\n",name); return;}
 getline(fp,kommentar,160);
 getline(fp,zeile,80); sscanf(zeile,"%d",&nx);
 getline(fp,zeile,80); sscanf(zeile,"%d",&ny);
 xfeld=new double[nn=nx*ny];
 yfeld=new double[nn];
 zfeld=new double[nn];
 for(i=0;getline(fp,zeile,80) && i<nn;i++)
  {sscanf(zeile,"%lf %lf %lf",&xfeld[i],&yfeld[i],&zfeld[i]);
  }
 fclose(fp);
}

/************************* Hauptprogramm ******************************/
class MalFenster:public QWidget
{
 Potentialflaeche* potf;
public:
 MalFenster(Potentialflaeche* p)
  {potf=p; setBackgroundMode(NoBackground);}
protected:
 virtual void mousePressEvent(QMouseEvent* event)
  {letztepos=event->pos();}
 virtual void mouseMoveEvent(QMouseEvent* event)
  {QPainter wMaler;
   QPainter pMaler;
   wMaler.begin(this);
   pMaler.begin(&puffer);
   wMaler.drawLine(letztepos,event->pos());
   pMaler.drawLine(letztepos,event->pos());
   wMaler.end();
   pMaler.end();
   letztepos=event->pos();
  }
 virtual void paintEvent(QPaintEvent*)
  {bitBlt(this,0,0,&puffer);
   QPainter wMaler;
   QPainter pMaler;
   wMaler.begin(this);
   pMaler.begin(&puffer);
   for(j=0;j<potf->ny;j++)
    for(i=0;i<potf->nx;i++)
     {if(i==0)
       {pos2=potf->getqpoint(i,j);}
      else
	{pos1=pos2; pos2=potf->getqpoint(i,j);
	 wMaler.drawLine(pos1,pos2);
	 pMaler.drawLine(pos1,pos2);
	}
     }
   for(i=0;i<potf->nx;i++)
    for(j=0;j<potf->ny;j++)
     {if(j==0)
       {pos2=potf->getqpoint(i,j);}
      else
	{pos1=pos2; pos2=potf->getqpoint(i,j);
	 wMaler.drawLine(pos1,pos2);
	 pMaler.drawLine(pos1,pos2);
	}
     }
   wMaler.end();
   pMaler.end();
  }
 virtual void resizeEvent(QResizeEvent* event)
  {QPixmap save(puffer);
   puffer.resize(event->size());
   puffer.fill(white);
   bitBlt(&puffer,0,0,&save);
  }
private:
 int i,j;
 QPoint letztepos,pos1,pos2;
 QPixmap puffer;
};

main(int argc,char *argv[])
{
 QApplication myapp(argc,argv);
 Dreidplot* dplot=new Dreidplot(512,512,
				200, //Brennweite
				700, //Kameraabstand
				Vektor3d(4,4,-609.2), //Offset
				Vektor3d(100,100,500), //Skalierung
				45,60,0 //Drehungen in Grad
			       );
 Potentialflaeche* potf=new Potentialflaeche(argv[1],dplot);
 MalFenster* mywidget=new MalFenster(potf);
 mywidget->setGeometry(50,50,512,512);
 myapp.setMainWidget(mywidget);
 mywidget->show();
 return myapp.exec();
}
