/* qpot.cc			letzte nderung: 15.8.2001 */
#define VERSION "0.2"
/*

 Kurzbeschreibung: Darstellung einer Potentialflche mit QT

History:
7.8.2001	Erstellung (RP)
8.8.		0.1 erste funktionierende Version
13.8.		0.2 mit Strecken in z-Richtung (rechte Maustaste)
                und Verschieben (mittlere Maustaste)
14.8.		vertauschte x/y-Achsen korrigiert
		versuche Splines einzubauen
*/

#include <stdio.h>
#include <stream.h>
#include <stdlib.h>
#include <vektor3dklasse.cc>

#include <qapplication.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qprinter.h>
#include <qpixmap.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qmessagebox.h>
#include <qfiledialog.h>

/*************************** kleinkram: ***************************/
long idfix(double x) {return x<0?int(x-0.5):int(x+0.5);}

int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}
/*************************** :kleinkram ***************************/

class Dreidplot
{
 int xmax,ymax; //Breite und Hhe des Pixelbereichs fr Ausgabe
 double pixbreite,pixhoehe; //Breite und Hhe eines Pixels (z.B. in mm)
 Vektor3d streck,offset; //Streckfaktoren und Offset fr wirkliche Koordinaten
                         //zuerst wird Offset gemacht, dann gestreckt
 double dreh1,dreh2,dreh3; //Drehungen des Objekts
    //(zuerst um z-Achse, dann um x-Achse und nochmals um z-Achse)
 double sindreh1,cosdreh1,sindreh2,cosdreh2,sindreh3,cosdreh3;
 double kameraabstand; //Kameraposition
  //(Kamera liegt immer auf z-Achse und auf Koordinatenursprung ausgerichtet)
 double brenn; //Brennweite
public:
 Dreidplot(int xm,int ym,double b,double k,Vektor3d o,Vektor3d s,
	   double d1,double d2,double d3)
  {xmax=xm; ymax=ym; brenn=b; kameraabstand=k; offset=o; streck=s;
   pixbreite=pixhoehe=0.28; //Pixelgrsse des Monitors
   drehen(d1,d2,d3);
  }
 void drehen(double d1,double d2,double d3,bool relativ=false); //Objekt drehen
 void strecken(Vektor3d p,bool relativ=true); //Objekt strecken
 void schieben(Vektor3d p,bool relativ=true); //Objekt verschieben
 QPoint getpixcoord(Vektor3d p);
 QPoint getpixcoord(double x,double y,double z)
  {return getpixcoord(Vektor3d(x,y,z));}
};
void Dreidplot::drehen(double d1,double d2,double d3,bool relativ)
{
 if(relativ)
   {dreh1+=d1; dreh2+=d2; dreh3+=d3;}
 else
   {dreh1=d1; dreh2=d2; dreh3=d3;}
 sindreh1=sin(dreh1*GRAD); cosdreh1=cos(dreh1*GRAD);
 sindreh2=sin(dreh2*GRAD); cosdreh2=cos(dreh2*GRAD);
 sindreh3=sin(dreh3*GRAD); cosdreh3=cos(dreh3*GRAD);
}
void Dreidplot::strecken(Vektor3d p,bool relativ)
{
 if(relativ) {streck=streck*p;}
 else {streck=p;}
}
void Dreidplot::schieben(Vektor3d p,bool relativ)
{
 if(relativ) {offset+=p/streck;}
 else {offset=p/streck;}
}
QPoint Dreidplot::getpixcoord(Vektor3d p)
{
 double bx,by,af;
 p -= offset;
 p = p*streck;
 p.drehenxy(sindreh1,cosdreh1); //Drehung um z-Achse
 p.drehenzy(sindreh2,cosdreh2); //Drehung um x-Achse
 p.drehenxy(sindreh3,cosdreh3); //wieder um z-Achse drehen
 af=kameraabstand+brenn-p.z;
 if(af==0)
   {bx = p.x>0 ? 8000 : -8000; //Bei Division durch Null liegt
    by = p.y>0 ? 8000 : -8000; //der Punkt weit ausserhalb.
   }
 else
   {bx=brenn*p.x/af;
    by=brenn*p.y/af;
   }
 // return QPoint(idfix(bx/pixbreite)+xmax/2,
 //	       ymax-(idfix(by/pixhoehe)+ymax/2) //warum, ...
 //	      );
 int x=idfix(bx/pixbreite)+xmax/2, y=ymax-(idfix(by/pixhoehe)+ymax/2);
/* if(x<0 || x>1024 || y<0 || y>768) //test
   {printf("ausserhalb des sichtbaren Bereichs x=%d y=%d\n",x,y);//test
    x=y=0;//test
   }
*/
 return QPoint(x,y);
 //... weil Pixel-y-Koordinate von oben nach unten zeigt
}

class Potentialflaeche
{
 double *xfeld,*yfeld,*zfeld;
 char kommentar[160];
 Dreidplot* dplot;
 int i1,j1,k1,k1max;//Parameter fr Splines
 double x1,y1;//Parameter fr Splines
 vektor p0,p1,p2,p3;//aktuelle Sttzpunkte fr Splines
public:
 int nx,ny; //jeweils nx*ny Punkte in xfeld yfeld und zfeld gespeichert
 Potentialflaeche(char* name,Dreidplot* d);
 QPoint getqpoint(int i,int j);
 QPoint getqpoint(double x,double y,double z)
  {return dplot->getpixcoord(x,y,z);}
 void drehen(double d1,double d2,double d3,bool relativ=false)
  {dplot->drehen(d1,d2,d3,relativ);}
 void streckenz(double z) {dplot->strecken(Vektor3d(1.0,1.0,z));}
 void schieben(double x,double y,double z) {dplot->schieben(Vektor3d(x,y,z));}
 QPoint xsplinebegin(int j,int kmax);
 QPoint ysplinebegin(int i,int kmax);
 bool xsplinenext(QPoint* p);
 bool ysplinenext(QPoint* p);
};

/** Splinemethode 1
 Die folgende Spline-Methode trifft die vorgegebenen Punkte genau.
 Es werden dabei jeweils nur 3 Punkte betrachtet.
 geht offenbar noch nicht
**
QPoint Potentialflaeche::xsplinebegin(int j,int kmax)
{
 j1=j; i1=0;
 k1max=kmax+1;  k1 = -k1max;
 int n=ny*i1+j1;
 p1=vektor(xfeld[n],zfeld[n]);
 p2=vektor(xfeld[n+nx],zfeld[n+nx]);
 p3=vektor(xfeld[n+2*nx],zfeld[n+2*nx]);
 return dplot->getpixcoord(xfeld[n],y1=yfeld[n],zfeld[n]);
}
QPoint Potentialflaeche::ysplinebegin(int i,int kmax)
{
 j1=0; i1=i;
 k1max=kmax+1;  k1 = -k1max;
 int n=ny*i1+j1;
 p1=vektor(yfeld[n],zfeld[n]);
 p2=vektor(yfeld[n+1],zfeld[n+1]);
 p3=vektor(yfeld[n+2],zfeld[n+2]);
 return dplot->getpixcoord(x1=xfeld[n],yfeld[n],zfeld[n]);
}
bool Potentialflaeche::xsplinenext(QPoint* p)
{
 int max=(i1==nx-3)?k1max+1:k1max/2;
 if(++k1==max)
   {if(++i1==nx-2) return false;
    int n=ny*(i1+2)+j1;
    p1=p2; p2=p3; p3=vektor(xfeld[n],zfeld[n]);
    k1= -k1max/2;
   }
 double x,z,dx,sa,sb, dx2=p2.x-p1.x, dx3=p3.x-p2.x;
 dx = (k1<=0) ? dx2/k1max : dx3/k1max;
 x=p2.x+k1*dx;
 sa=(p2.y-p1.y)/dx2;//Steigung der Geraden zwischen p1 und p2
 sb=(p3.y-p2.y)/dx3;//Steigung der Geraden zwischen p2 und p3
 z = (p1.y+(x-p1.x)*sa)*(p3.x-x)/(dx2+dx3)
   + (p3.y+(x-p3.x)*sb)*(x-p1.x)/(dx2+dx3);
 // z=p2.y;//test
 *p = dplot->getpixcoord(x,y1,z);
 return true;
}
bool Potentialflaeche::ysplinenext(QPoint* p)
{
 int max=(j1==ny-3)?k1max+1:k1max/2;
 if(++k1==max)
   {if(++j1==ny-2) return false;
    int n=ny*i1+(j1+2);
    p1=p2; p2=p3; p3=vektor(yfeld[n],zfeld[n]);
    k1= -k1max/2;
   }
 double x,z,dx,sa,sb, dx2=p2.x-p1.x, dx3=p3.x-p2.x;
 dx = (k1<=0) ? dx2/k1max : dx3/k1max;
 x=p2.x+k1*dx;
 sa=(p2.y-p1.y)/dx2;//Steigung der Geraden zwischen p1 und p2
 sb=(p3.y-p2.y)/dx3;//Steigung der Geraden zwischen p2 und p3
 z = (p1.y+(x-p1.x)*sa)*(p3.x-x)/(dx2+dx3)
   + (p3.y+(x-p3.x)*sb)*(x-p1.x)/(dx2+dx3);
// z=p2.y;//test
 *p = dplot->getpixcoord(x1,x,z);
 return true;
}
/** Ende Splinemethode 1 **/

/** Splinemethode 2
 Diese Splinemethode glttet ber 3 Punkte wobei die Gewichtung der
 4 bercksichtigten Punkte von 1 2 1 0 nach 0 1 2 1 verschoben wird.
**/
QPoint Potentialflaeche::xsplinebegin(int j,int kmax)
{
 j1=j; i1=0; //y bleibt konstant, x ndert
 k1max=kmax+1;  k1=0;
 int n=ny*i1+j1;
 y1=yfeld[n];
 p1=vektor(xfeld[n],zfeld[n]);
 n+=ny; p2=vektor(xfeld[n],zfeld[n]);
 n+=ny; p3=vektor(xfeld[n],zfeld[n]);
 p0=2*p1-p2;
 return dplot->getpixcoord(p1.x,y1,p1.y);
}
QPoint Potentialflaeche::ysplinebegin(int i,int kmax)
{
 j1=0; i1=i; //y ndert, x bleibt konstant
 k1max=kmax+1;  k1=0;
 int n=ny*i1+j1;
 x1=xfeld[n];
 p1=vektor(yfeld[n],zfeld[n]);
 n++; p2=vektor(yfeld[n],zfeld[n]);
 n++; p3=vektor(yfeld[n],zfeld[n]);
 p0=2*p1-p2;
 return dplot->getpixcoord(x1,p1.x,p1.y);
}
bool Potentialflaeche::xsplinenext(QPoint* p)
{
 if(k1>=k1max)
   {if(++i1>nx) return false;
    else if(i1<nx)
      {p0=p1; p1=p2; p2=p3;
       if(i1+2<nx)
	 {int n=ny*(i1+2)+j1;
	  p3=vektor(xfeld[n],zfeld[n]);
	 }
       k1=0;
      }
    //else (i1==nx): der letzte Punkt mit k1==k1max auch zeichnen
   }
 // printf("xsplinenext() k1=%d k1max=%d\n",k1,k1max);//test
 double x,z, g=double(k1)/k1max;
 const int M=2,M1=M-1; //Mittengewichtung
 x=p1.x+(p2.x-p1.x)*g;
 z=(p0.y*(1-g)+p1.y*(M-M1*g)+p2.y*(1+M1*g)+p3.y*g)/(2+M);
 // printf(" g=%lf x=%lf y1=%lf z=%lf\n",g,x,y1,z);//test
 k1++;
 *p = dplot->getpixcoord(x,y1,z);
 return true;
}
bool Potentialflaeche::ysplinenext(QPoint* p)
{
 if(k1>=k1max)
   {if(++j1>ny) return false;
    else if(j1<ny)
      {p0=p1; p1=p2; p2=p3;
       if(j1+2<ny)
	 {int n=ny*i1+(j1+2);
	  p3=vektor(yfeld[n],zfeld[n]);
	 }
       k1=0;
      }
    //else (j1==ny): der letzte Punkt mit k1==k1max auch zeichnen
   }
 // printf("ysplinenext() k1=%d k1max=%d\n",k1,k1max);//test
 double x,z, g=double(k1)/k1max;
 const int M=2,M1=M-1; //Mittengewichtung
 x=p1.x+(p2.x-p1.x)*g;
 z=(p0.y*(1-g)+p1.y*(M-M1*g)+p2.y*(1+M1*g)+p3.y*g)/(2+M);
 // printf(" g=%lf x1=%lf x=%lf z=%lf\n",g,x1,x,z);//test
 k1++;
 *p = dplot->getpixcoord(x1,x,z);
 return true;
}
/** Ende Splinemethode 2 **/

QPoint Potentialflaeche::getqpoint(int i,int j)
{
 int n=ny*i+j;
 return dplot->getpixcoord(xfeld[n],yfeld[n],zfeld[n]);
}

Potentialflaeche::Potentialflaeche(char* name,Dreidplot* d)
{
 // double xmin=1.725,ymin=2.2,xmax=6.675,ymax=6.2;
 dplot=d;
 int i,nn;
 char zeile[80];
 FILE *fp;
 if((fp=fopen(name,"r"))==NULL)
   {printf("%s nicht gefunden\n",name); return;}
 getline(fp,kommentar,160);
 getline(fp,zeile,80); sscanf(zeile,"%d",&nx);
 getline(fp,zeile,80); sscanf(zeile,"%d",&ny);
 xfeld=new double[nn=nx*ny];
 yfeld=new double[nn];
 zfeld=new double[nn];
 for(i=0;getline(fp,zeile,80) && i<nn;i++)
  {sscanf(zeile,"%lf %lf %lf",&xfeld[i],&yfeld[i],&zfeld[i]);
  }
 fclose(fp);
}

class EpsPainter
{
 FILE *fp;
 int lastx,lasty,lastflag;
 void lastpoint()
  {if(lastflag>0) {print("s\n"); lastflag=0;}
  }
public:
 EpsPainter() {fp=NULL; lastflag=0;}
 ~EpsPainter() {if(fp) end();}
 void print(char *s) {if(fp) fprintf(fp,s);}
 void print(char *s,char *p) {if(fp) fprintf(fp,s,p);}
 void print(char *s,int x,int y) {if(fp) fprintf(fp,s,x,y);}
 void print(char *s,double r,double g,double b) {if(fp) fprintf(fp,s,r,g,b);}
 void begin(const char *name)
  {fp=fopen(name,"w");
   if(fp==NULL) {printf("Error: cant open %s\n",name); return;}
   print("%%!PS-Adobe-2.0 EPSF-1.2\n");
   print("%%%%Creator: EpsPainter %s\n",VERSION);
   print("%%%%BoundingBox: 0 0 596 843\n");
   print("%%%%BeginProlog\n");
   print("/m /moveto load def /d /lineto load def /s /stroke load def\n");
   print("%%%%EndProlog\n");
   print("save\n1 -1 scale\n0 -800 translate\n");
   print("gsave\n");
  }
 void end()
  {lastpoint();
   if(fp!=NULL)
    {print("grestore\nrestore\n"); fclose(fp); fp=NULL;}
  }
 void drawLine(QPoint p1,QPoint p2)
  {if(lastflag!=0) {if(lastx!=p1.x() || lasty!=p1.y()) lastpoint();}
   if(lastflag==0)
     {print("%d %d m ",p1.x(),p1.y()); ++lastflag;}
   if(++lastflag>100)
     {print("%d %d d s\n",p2.x(),p2.y()); lastflag=0;}
   else 
     {if(lastflag%4==0) print("%d %d d\n",lastx=p2.x(),lasty=p2.y());
      else              print("%d %d d ",lastx=p2.x(),lasty=p2.y());
     }
  }
 void setPen(QPen stift)
  {//provi. nur Farbe gesetzt
   lastpoint();
   QColor c=stift.color(); const double f=1.0/255;
   print("%lg %lg %lg setrgbcolor\n",c.red()*f,c.green()*f,c.blue()*f);
  }
};

/************************* Hauptprogramm ******************************/
enum {GITTER, FLAECHEN, SPLINE}; //mgliche Werte fr darstellung

class MalFenster:public QWidget
{
 Q_OBJECT
public:
 MalFenster(Potentialflaeche* p)
  {potf=p;
   darstellung=GITTER;
   setBackgroundMode(NoBackground);
   dateimenu=new QPopupMenu;
   dateimenu->insertItem("&Save PostScript ...",this,SLOT(SavepsSlot()));
   dateimenu->insertItem("&Quit",qApp,SLOT(quit()));
   optmenu=new QPopupMenu;
   optmenu->insertItem("&Gitter",GITTER);
   optmenu->insertItem("&Flaechen",FLAECHEN);
   optmenu->insertItem("&Spline",SPLINE);
   QObject::connect(optmenu, SIGNAL(activated(int)),
		    this, SLOT(optMenuSlot(int)));
   hilfemenu=new QPopupMenu;
   hilfemenu->insertItem("&About this Program",this,SLOT(AboutSlot()));
   hilfemenu->insertItem("A&bout Qt",this,SLOT(AboutQtSlot()));
   menubalken=new QMenuBar(this);
   menubalken->insertItem("&Datei",dateimenu);
   menubalken->insertItem("&Optionen",optmenu);
   menubalken->insertSeparator();
   menubalken->insertItem("&Hilfe",hilfemenu);
   meinDrucker=new QPrinter;
   meinDrucker->setPrintProgram("lpr");
  }
 ~MalFenster() {}
protected:
 virtual void mousePressEvent(QMouseEvent* event)
  {letztepos=event->pos();}
 virtual void mouseMoveEvent(QMouseEvent* event)
  {
   QPoint p=event->pos();
   if(event->state()&MidButton) //bei mittlerer Maustaste: verschieben
     {double x=letztepos.x()-p.x(), y=p.y()-letztepos.y();
      if(event->state()&ShiftButton)
	potf->schieben(x,0.0,y);
      else if(event->state()&ControlButton)
	potf->schieben(0.0,x,y);
      else if(event->state()&AltButton) //geht auf Mac mit Exodus nicht!
	potf->schieben(0.0,x,y);
      else
	potf->schieben(x,y,0.0);
     }
   else if(event->state()&RightButton) //rechte Maustaste: Strecken in z-Richt.
     {double z=(letztepos.y()+512)/(p.y()+512.0);
      potf->streckenz(z);
     }
   else
     {int dx=p.x()-letztepos.x(), dy=p.y()-letztepos.y();
      potf->drehen(dx*360.0/512, -dy*360.0/512, 0.0, true);
     }
   zeichnen();
   letztepos=event->pos();
  }
 virtual void paintEvent(QPaintEvent*)
  {zeichnen();
  }
 virtual void resizeEvent(QResizeEvent* event)
  {QPixmap save(puffer);
   puffer.resize(event->size());
   puffer.fill(white);
   bitBlt(&puffer,0,0,&save);
  }
 virtual void mouseDoubleClickEvent(QMouseEvent*)
  {int ok=meinDrucker->setup(this);
   if(ok)
    {QPainter p(meinDrucker);
     p.drawPixmap(0,0,puffer);
     p.drawRect(puffer.rect());
    }
  }
private slots:
 void SavepsSlot()
  {QString dateiname=QFileDialog::getSaveFileName(".","*.eps\n*",this);
   if(!dateiname.isEmpty())
     eps_zeichnen(dateiname.latin1());
  }
 void AboutSlot()
  {QMessageBox::information(this,"qpot","Potentialkurven darstellen\n");}
 void AboutQtSlot() {QMessageBox::aboutQt(this,"About Qt");}
 void optMenuSlot(int id) {darstellung=id; zeichnen();}
private:
 int i,j,darstellung;
 QPoint letztepos,pos1,pos2;
 QPixmap puffer;
 QMenuBar* menubalken;
 QPopupMenu* dateimenu; QPopupMenu* optmenu; QPopupMenu* hilfemenu;
 QPrinter *meinDrucker;

 Potentialflaeche* potf;
 void zeichnen()
  {
   puffer.fill(white);
   QPainter pMaler;
   pMaler.begin(&puffer);
   //Achsen zeichnen
   QPen stift,rotstift; rotstift.setColor(red); pMaler.setPen(rotstift);
   pos1=potf->getqpoint(2.2,2.2,-609.45);
   pMaler.drawLine(pos1,potf->getqpoint(6.5,2.2,-609.45));
   stift.setColor(blue); pMaler.setPen(stift); //y-Achse blau
   pMaler.drawLine(pos1,potf->getqpoint(2.2,6.5,-609.45));
   stift.setColor(green); pMaler.setPen(stift); //z-Achse gruen
   pMaler.drawLine(pos1,potf->getqpoint(2.2,2.2,-608.45));
   stift.setColor(black); pMaler.setPen(stift);
   //Potentialflaeche zeichnen
   if(darstellung==SPLINE)
     {const int kmax=20; //Anzahl Zwischenpunkte
      for(j=0;j<potf->ny;j++)
       {pos1=potf->xsplinebegin(j,kmax);
        while(potf->xsplinenext(&pos2))
	  {pMaler.drawLine(pos1,pos2);
	   pos1=pos2;
	  }
       }
      for(i=0;i<potf->nx;i++)
       {pos1=potf->ysplinebegin(i,kmax);
        while(potf->ysplinenext(&pos2))
	  {pMaler.drawLine(pos1,pos2);
	   pos1=pos2;
	  }
       }
     }
   else
     {for(j=0;j<potf->ny;j++)
       for(i=0;i<potf->nx;i++)
	 {if(i==0)
	   {pos2=potf->getqpoint(i,j);}
	  else
	    {pos1=pos2; pos2=potf->getqpoint(i,j);
	     pMaler.drawLine(pos1,pos2);
	    }
	 }
      for(i=0;i<potf->nx;i++)
	for(j=0;j<potf->ny;j++)
	  {if(j==0)
	    {pos2=potf->getqpoint(i,j);}
	   else
	     {pos1=pos2; pos2=potf->getqpoint(i,j);
	      pMaler.drawLine(pos1,pos2);
	     }
	  }
     }
   pMaler.end();
   bitBlt(this,0,0,&puffer);
  }
 void eps_zeichnen(const char *dateiname)
  {
   EpsPainter pMaler;
   pMaler.begin(dateiname);
   //Achsen zeichnen
   QPen stift; stift.setColor(red); pMaler.setPen(stift);
   //pMaler.print("1 0 0 setrgbcolor\n");//provi.
   pos1=potf->getqpoint(2.2,2.2,-609.45);
   pMaler.drawLine(pos1,potf->getqpoint(6.5,2.2,-609.45));
   pMaler.drawLine(pos1,potf->getqpoint(2.2,6.5,-609.45));
   pMaler.drawLine(pos1,potf->getqpoint(2.2,2.2,-608.45));
   stift.setColor(black); pMaler.setPen(stift);
   //pMaler.print("0 0 0 setrgbcolor\n");//provi.
   //Potentialflaeche zeichnen
   if(darstellung==SPLINE)
     {const int kmax=20; //Anzahl Zwischenpunkte
      for(j=0;j<potf->ny;j++)
       {pos1=potf->xsplinebegin(j,kmax);
        while(potf->xsplinenext(&pos2))
	  {pMaler.drawLine(pos1,pos2);
	   pos1=pos2;
	  }
       }
      for(i=0;i<potf->nx;i++)
       {pos1=potf->ysplinebegin(i,kmax);
        while(potf->ysplinenext(&pos2))
	  {pMaler.drawLine(pos1,pos2);
	   pos1=pos2;
	  }
       }
     }
   else
     {for(j=0;j<potf->ny;j++)
       for(i=0;i<potf->nx;i++)
	 {if(i==0)
	   {pos2=potf->getqpoint(i,j);}
	  else
	    {pos1=pos2; pos2=potf->getqpoint(i,j);
	     pMaler.drawLine(pos1,pos2);
	    }
	 }
      for(i=0;i<potf->nx;i++)
	for(j=0;j<potf->ny;j++)
	  {if(j==0)
	    {pos2=potf->getqpoint(i,j);}
	   else
	     {pos1=pos2; pos2=potf->getqpoint(i,j);
	      pMaler.drawLine(pos1,pos2);
	     }
	  }
     }
   pMaler.end();
  }
};

#include "qpot.moc"

main(int argc,char *argv[])
{
 QApplication myapp(argc,argv);
 Dreidplot* dplot=new Dreidplot(512,512,
				200, //Brennweite
				700, //Kameraabstand
				Vektor3d(4,4,-609.2), //Offset
				Vektor3d(100,100,500), //Skalierung
				-45,60,0 //Drehungen in Grad
			       );
 Potentialflaeche* potf=new Potentialflaeche(argv[1],dplot);
 MalFenster* mywidget=new MalFenster(potf);
 mywidget->setGeometry(20,20,640,512);
 myapp.setMainWidget(mywidget);
 mywidget->show();
 return myapp.exec();
}
