/* qpot.cc			letzte nderung: 13.8.2001 */
#define VERSION "Version 0.2"
/*

 Kurzbeschreibung: Darstellung einer Potentialflche mit QT

History:
7.8.2001	Erstellung (RP)
8.8.		0.1 erste funktionierende Version
13.8.		0.2 mit Strecken in z-Richtung (rechte Maustaste)
                und Verschieben (mittlere Maustaste)
*/

#include <stdio.h>
#include <stream.h>
#include <stdlib.h>
#include <vektor3dklasse.cc>

#include <qapplication.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qprinter.h>
#include <qpixmap.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qmessagebox.h>

/*************************** kleinkram: ***************************/
long idfix(double x) {return x<0?int(x-0.5):int(x+0.5);}

int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}
/*************************** :kleinkram ***************************/

class Dreidplot
{
 int xmax,ymax; //Breite und Hhe des Pixelbereichs fr Ausgabe
 double pixbreite,pixhoehe; //Breite und Hhe eines Pixels (z.B. in mm)
 Vektor3d streck,offset; //Streckfaktoren und Offset fr wirkliche Koordinaten
                         //zuerst wird Offset gemacht, dann gestreckt
 double dreh1,dreh2,dreh3; //Drehungen des Objekts
    //(zuerst um z-Achse, dann um x-Achse und nochmals um z-Achse)
 double sindreh1,cosdreh1,sindreh2,cosdreh2,sindreh3,cosdreh3;
 double kameraabstand; //Kameraposition
  //(Kamera liegt immer auf z-Achse und auf Koordinatenursprung ausgerichtet)
 double brenn; //Brennweite
public:
 Dreidplot(int xm,int ym,double b,double k,Vektor3d o,Vektor3d s,
	   double d1,double d2,double d3)
  {xmax=xm; ymax=ym; brenn=b; kameraabstand=k; offset=o; streck=s;
   pixbreite=pixhoehe=0.28; //Pixelgrsse des Monitors
   drehen(d1,d2,d3);
  }
 void drehen(double d1,double d2,double d3,bool relativ=false); //Objekt drehen
 void strecken(Vektor3d p,bool relativ=true); //Objekt strecken
 void schieben(Vektor3d p,bool relativ=true); //Objekt verschieben
 QPoint getpixcoord(Vektor3d p);
 QPoint getpixcoord(double x,double y,double z)
  {return getpixcoord(Vektor3d(x,y,z));}
};
void Dreidplot::drehen(double d1,double d2,double d3,bool relativ)
{
 if(relativ)
   {dreh1+=d1; dreh2+=d2; dreh3+=d3;}
 else
   {dreh1=d1; dreh2=d2; dreh3=d3;}
 sindreh1=sin(dreh1*GRAD); cosdreh1=cos(dreh1*GRAD);
 sindreh2=sin(dreh2*GRAD); cosdreh2=cos(dreh2*GRAD);
 sindreh3=sin(dreh3*GRAD); cosdreh3=cos(dreh3*GRAD);
}
void Dreidplot::strecken(Vektor3d p,bool relativ)
{
 if(relativ) {streck=streck*p;}
 else {streck=p;}
}
void Dreidplot::schieben(Vektor3d p,bool relativ)
{
 if(relativ) {offset+=p/streck;}
 else {offset=p/streck;}
}
QPoint Dreidplot::getpixcoord(Vektor3d p)
{
 double bx,by,af;
 p -= offset;
 p = p*streck;
 p.drehenyx(sindreh1,cosdreh1);
 p.drehenyz(sindreh2,cosdreh2);
 p.drehenyx(sindreh3,cosdreh3);
 af=kameraabstand+brenn-p.z;
 if(af==0)
   {bx = p.x>0 ? 32000 : -32000; //Bei Division durch Null liegt
    by = p.y>0 ? 32000 : -32000; //der Punkt weit ausserhalb.
   }
 else
   {bx=brenn*p.x/af;
    by=brenn*p.y/af;
   }
 return QPoint(idfix(bx/pixbreite)+xmax/2,idfix(by/pixhoehe)+ymax/2);
}

class Potentialflaeche
{
 double *xfeld,*yfeld,*zfeld;
 int n;//Anzahl definierte Punkte
 char kommentar[160];
 Dreidplot* dplot;
public:
 int nx,ny;
 Potentialflaeche(char* name,Dreidplot* d);
 QPoint getqpoint(int i,int j);
 QPoint getqpoint(double x,double y,double z)
  {return dplot->getpixcoord(x,y,z);}
 void drehen(double d1,double d2,double d3,bool relativ=false)
  {dplot->drehen(d1,d2,d3,relativ);}
 void streckenz(double z) {dplot->strecken(Vektor3d(1.0,1.0,z));}
 void schieben(double x,double y,double z) {dplot->schieben(Vektor3d(x,y,z));}
};

QPoint Potentialflaeche::getqpoint(int i,int j)
{
 int n=nx*j+i;
 return dplot->getpixcoord(xfeld[n],yfeld[n],zfeld[n]);
}

Potentialflaeche::Potentialflaeche(char* name,Dreidplot* d)
{
 // double xmin=1.725,ymin=2.2,xmax=6.675,ymax=6.2;
 dplot=d;
 int i,nn;
 char zeile[80];
 FILE *fp;
 if((fp=fopen(name,"r"))==NULL)
   {printf("%s nicht gefunden\n",name); return;}
 getline(fp,kommentar,160);
 getline(fp,zeile,80); sscanf(zeile,"%d",&nx);
 getline(fp,zeile,80); sscanf(zeile,"%d",&ny);
 xfeld=new double[nn=nx*ny];
 yfeld=new double[nn];
 zfeld=new double[nn];
 for(i=0;getline(fp,zeile,80) && i<nn;i++)
  {sscanf(zeile,"%lf %lf %lf",&xfeld[i],&yfeld[i],&zfeld[i]);
  }
 fclose(fp);
}

/************************* Hauptprogramm ******************************/
enum {GITTER, FLAECHEN, SCHATTEN};

class MalFenster:public QWidget
{
 Q_OBJECT
public:
 MalFenster(Potentialflaeche* p)
  {potf=p;
   darstellung=GITTER;
   setBackgroundMode(NoBackground);
   dateimenu=new QPopupMenu;
   dateimenu->insertItem("&Quit",qApp,SLOT(quit()));
   optmenu=new QPopupMenu;
   optmenu->insertItem("&Gitter",GITTER);
   optmenu->insertItem("&Flaechen",FLAECHEN);
   optmenu->insertItem("&Schatten",SCHATTEN);
   QObject::connect(optmenu, SIGNAL(activated(int)),
		    this, SLOT(optMenuSlot(int)));
   hilfemenu=new QPopupMenu;
   hilfemenu->insertItem("&About this Program",this,SLOT(AboutSlot()));
   hilfemenu->insertItem("A&bout Qt",this,SLOT(AboutQtSlot()));
   menubalken=new QMenuBar(this);
   menubalken->insertItem("&Datei",dateimenu);
   menubalken->insertItem("&Optionen",optmenu);
   menubalken->insertSeparator();
   menubalken->insertItem("&Hilfe",hilfemenu);
   meinDrucker=new QPrinter;
   meinDrucker->setPrintProgram("lpr");
  }
 ~MalFenster() {}
protected:
 virtual void mousePressEvent(QMouseEvent* event)
  {letztepos=event->pos();}
 virtual void mouseMoveEvent(QMouseEvent* event)
  {
   QPoint p=event->pos();
   if(event->state()&MidButton) //bei mittlerer Maustaste: verschieben
     {double x=letztepos.x()-p.x(), y=p.y()-letztepos.y();
      if(event->state()&ShiftButton)
	potf->schieben(x,0.0,y);
      else if(event->state()&ControlButton)
	potf->schieben(0.0,x,y);
      else if(event->state()&AltButton) //geht auf Mac mit Exodus nicht!
	potf->schieben(x,0.0,y);
      else
	potf->schieben(y,x,0.0);
     }
   else if(event->state()&RightButton) //rechte Maustaste: Strecken in z-Richt.
     {double z=(letztepos.y()+512)/(p.y()+512.0);
      potf->streckenz(z);
     }
   else
     {int dx=p.x()-letztepos.x(), dy=p.y()-letztepos.y();
      potf->drehen(dx*360.0/512, -dy*360.0/512, 0.0, true);
     }
   zeichnen();
   letztepos=event->pos();
  }
 virtual void paintEvent(QPaintEvent*)
  {zeichnen();
  }
 virtual void resizeEvent(QResizeEvent* event)
  {QPixmap save(puffer);
   puffer.resize(event->size());
   puffer.fill(white);
   bitBlt(&puffer,0,0,&save);
  }
 virtual void mouseDoubleClickEvent(QMouseEvent*)
  {int ok=meinDrucker->setup(this);
   if(ok)
    {QPainter p(meinDrucker);
     p.drawPixmap(0,0,puffer);
     p.drawRect(puffer.rect());
    }
  }
private slots:
 void AboutSlot()
  {QMessageBox::information(this,"qpot","Potentialkurven darstellen\n");}
 void AboutQtSlot() {QMessageBox::aboutQt(this,"About Qt");}
 void optMenuSlot(int id) {darstellung=id;}
private:
 int i,j,darstellung;
 QPoint letztepos,pos1,pos2;
 QPixmap puffer;
 QMenuBar* menubalken;
 QPopupMenu* dateimenu; QPopupMenu* optmenu; QPopupMenu* hilfemenu;
 QPrinter *meinDrucker;

 Potentialflaeche* potf;
 void zeichnen()
  {
   puffer.fill(white);
   QPainter pMaler;
   pMaler.begin(&puffer);
   //Achsen zeichnen
   QPen stift; stift.setColor(red); pMaler.setPen(stift);
   pos1=potf->getqpoint(2.2,2.2,-609.45);
   pMaler.drawLine(pos1,potf->getqpoint(6.5,2.2,-609.45));
   pMaler.drawLine(pos1,potf->getqpoint(2.2,6.5,-609.45));
   pMaler.drawLine(pos1,potf->getqpoint(2.2,2.2,-608.45));
   stift.setColor(black); pMaler.setPen(stift);
   //Potentialflaeche zeichnen
   for(j=0;j<potf->ny;j++)
    for(i=0;i<potf->nx;i++)
     {if(i==0)
       {pos2=potf->getqpoint(i,j);}
      else
	{pos1=pos2; pos2=potf->getqpoint(i,j);
	 pMaler.drawLine(pos1,pos2);
	}
     }
   for(i=0;i<potf->nx;i++)
    for(j=0;j<potf->ny;j++)
     {if(j==0)
       {pos2=potf->getqpoint(i,j);}
      else
	{pos1=pos2; pos2=potf->getqpoint(i,j);
	 pMaler.drawLine(pos1,pos2);
	}
     }
   pMaler.end();
   bitBlt(this,0,0,&puffer);
  }
};

#include "qpot.moc"

main(int argc,char *argv[])
{
 QApplication myapp(argc,argv);
 Dreidplot* dplot=new Dreidplot(512,512,
				200, //Brennweite
				700, //Kameraabstand
				Vektor3d(4,4,-609.2), //Offset
				Vektor3d(100,100,500), //Skalierung
				45,60,0 //Drehungen in Grad
			       );
 Potentialflaeche* potf=new Potentialflaeche(argv[1],dplot);
 MalFenster* mywidget=new MalFenster(potf);
 mywidget->setGeometry(20,20,640,512);
 myapp.setMainWidget(mywidget);
 mywidget->show();
 return myapp.exec();
}
