/* qpot.cc			letzte nderung: 21.8.2001 */
#define VERSION "0.4"
/*

 Kurzbeschreibung: Darstellung einer Potentialflche mit QT

History:
7.8.2001	Erstellung (RP)
8.8.	0.1	erste funktionierende Version
13.8.	0.2	mit Strecken in z-Richtung (rechte Maustaste)
                und Verschieben (mittlere Maustaste)
14.8.		vertauschte x/y-Achsen korrigiert
16.8.	0.3	Splines eingebaut
21.8.	0.4	Flchenangleich
*/

#include <stdio.h>
#include <stream.h>
#include <stdlib.h>
#include <vektor3dklasse.cc>

//test:
#include <unistd.h>

#include <qapplication.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qprinter.h>
#include <qpixmap.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qmessagebox.h>
#include <qfiledialog.h>
#include <qinputdialog.h>

const int MAXNPOLY=200;
const int N21=MAXNPOLY*2+1, NGAU=N21;
#include "gauss.cc"

/*************************** Tests ***************************/
void test_lgs(int n,double ga[][N21],double *gb)
{
 int i,j;
 printf("Matrix des Gleichungssystems:\n");
 for(i=0;i<n;i++)
   {for(j=0;j<n;j++) printf("%lg ",ga[i][j]);
    printf("\n");
   }
 printf("Ergebnisspalte: ");
 for(i=0;i<n;i++) printf("%lg ",gb[i]);
 printf("\n");
}
/*************************** kleinkram: ***************************/
//long idfix(double x) {return x<0?long(x-0.5):long(x+0.5);}

int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

/**
double hoch(double x,int n)
{
 double z=1.0;
 while(n>0)
        {if(n&1) {z*=x; n--;}
         else    {x*=x; n=(n>>1);}
        }
 return z;
} **/
/*************************** :kleinkram ***************************/

enum {GITTER, FLAECHEN}; //mgliche Werte fr darstellung
enum {GERADEN, SPLINE, FLAECHENANGLEICH, POLYNOMGRAD}; //mgliche Werte fr angleich

class Dreidplot
{
 int xmax,ymax; //Breite und Hhe des Pixelbereichs fr Ausgabe
 double pixbreite,pixhoehe; //Breite und Hhe eines Pixels (z.B. in mm)
 Vektor3d streck,offset; //Streckfaktoren und Offset fr wirkliche Koordinaten
                         //zuerst wird Offset gemacht, dann gestreckt
 double dreh1,dreh2,dreh3; //Drehungen des Objekts
    //(zuerst um z-Achse, dann um x-Achse und nochmals um z-Achse)
 double sindreh1,cosdreh1,sindreh2,cosdreh2,sindreh3,cosdreh3;
 double kameraabstand; //Kameraposition
  //(Kamera liegt immer auf z-Achse und auf Koordinatenursprung ausgerichtet)
 double brenn; //Brennweite
public:
 Dreidplot(int xm,int ym,double b,double k,Vektor3d o,Vektor3d s,
	   double d1,double d2,double d3)
  {xmax=xm; ymax=ym; brenn=b; kameraabstand=k; offset=o; streck=s;
   pixbreite=pixhoehe=0.28; //Pixelgrsse des Monitors
   drehen(d1,d2,d3);
  }
 void drehen(double d1,double d2,double d3,bool relativ=false); //Objekt drehen
 void strecken(Vektor3d p,bool relativ=true); //Objekt strecken
 void schieben(Vektor3d p,bool relativ=true); //Objekt verschieben
 vektor getpixcoord(Vektor3d p);
 vektor getpixcoord(double x,double y,double z)
  {return getpixcoord(Vektor3d(x,y,z));}
};
void Dreidplot::drehen(double d1,double d2,double d3,bool relativ)
{
 if(relativ)
   {dreh1+=d1; dreh2+=d2; dreh3+=d3;}
 else
   {dreh1=d1; dreh2=d2; dreh3=d3;}
 sindreh1=sin(dreh1*GRAD); cosdreh1=cos(dreh1*GRAD);
 sindreh2=sin(dreh2*GRAD); cosdreh2=cos(dreh2*GRAD);
 sindreh3=sin(dreh3*GRAD); cosdreh3=cos(dreh3*GRAD);
}
void Dreidplot::strecken(Vektor3d p,bool relativ)
{
 if(relativ) {streck=streck*p;}
 else {streck=p;}
}
void Dreidplot::schieben(Vektor3d p,bool relativ)
{
 if(relativ) {offset+=p/streck;}
 else {offset=p/streck;}
}
vektor Dreidplot::getpixcoord(Vektor3d p)
{
 double bx,by,af;
 p -= offset;
 p = p*streck;
 p.drehenxy(sindreh1,cosdreh1); //Drehung um z-Achse
 p.drehenzy(sindreh2,cosdreh2); //Drehung um x-Achse
 p.drehenxy(sindreh3,cosdreh3); //wieder um z-Achse drehen
 af=kameraabstand+brenn-p.z;
 if(af==0)
   {bx = p.x>0 ? 1e5 : -1e5; //Bei Division durch Null liegt
    by = p.y>0 ? 1e5 : -1e5; //der Punkt weit ausserhalb.
   }
 else
   {bx=brenn*p.x/af;
    by=brenn*p.y/af;
   }
 vektor r(bx/pixbreite+xmax/2.0, ymax-(by/pixhoehe+ymax/2.0));
 //y-Umrechnung ist anders als x-Umrechnung
 //weil Pixel-y-Koordinate von oben nach unten zeigt
 const double MIN= -1024.0, MAX=2048.0; //provi.
 if(r.x>MAX) r.x=MAX; else if(r.x<MIN) r.x=MIN;
 if(r.y>MAX) r.y=MAX; else if(r.y<MIN) r.y=MIN;
 return r;
}

class myQPainter:public QPainter
{
 int idfix(double x) {return x<0?int(x-0.5):int(x+0.5);}
 QPoint qpoint(vektor p) {return QPoint(idfix(p.x),idfix(p.y));}
public:
 myQPainter():QPainter() {}
 ~myQPainter() {}
 void drawLine(vektor p1,vektor p2)
  {return QPainter::drawLine(qpoint(p1),qpoint(p2));}
};

class Potentialflaeche
{
 double *xfeld,*yfeld,*zfeld; //vorgegebene Sttzpunkte
 double *aa,*bb,cc; //Polynomfaktoren fuer Flaechenangleich
 int npoly; //Polynomgrad fuer Flaechenangleich
 char kommentar[160];
 Dreidplot* dplot;
 int i1,j1,k1,k1max;//Parameter fr Splines
 double x1,y1,delta,a0,a1,a2,b0,b1,b2;//Parameter fr Splines
 vektor p0,p1,p2,p3;//aktuelle Sttzpunkte fr Splines
 double parabel1(double x) {return a0+a1*x+a2*x*x;}
 double parabel2(double x) {return b0+b1*x+b2*x*x;}
 double zberechnen_aus_polynom(double x,double y)
  {double z1=0,z2=0; int i;
   for(i=npoly;--i>=0;)
     {z1=(z1+aa[i])*x;
      z2=(z2+bb[i])*y;
     }
   static int test=10;
   if(test>0)
     {for(i=0;i<npoly;i++) printf("A%d=%lg ",i+1,aa[i]);
      for(i=0;i<npoly;i++) printf("B%d=%lg ",i+1,bb[i]);
      printf("C=%lg\n",cc);
      printf("zberechnen() --> z=%lf\n",z1+z2+cc);//test
      --test;
     }
   return z1+z2+cc;
  }
public:
 int nx,ny; //jeweils nx*ny Punkte in xfeld yfeld und zfeld gespeichert
 int NPOLY; //Polynomgrad fuer naechsten Flaechenangleich
 Potentialflaeche(char* name,Dreidplot* d);
 vektor getpoint(int i,int j);
 vektor getpoint(double x,double y,double z)
  {return dplot->getpixcoord(x,y,z);}
 void drehen(double d1,double d2,double d3,bool relativ=false)
  {dplot->drehen(d1,d2,d3,relativ);}
 void streckenz(double z) {dplot->strecken(Vektor3d(1.0,1.0,z));}
 void schieben(double x,double y,double z) {dplot->schieben(Vektor3d(x,y,z));}
 vektor xsplinebegin(int j,int kmax);
 vektor ysplinebegin(int i,int kmax);
 bool xsplinenext(vektor* p);
 bool ysplinenext(vektor* p);
 void angleichung_berechnen(int id); //Flaechenangleich machen
 vektor xflaechenpunkt(int j,int kmax);
 vektor yflaechenpunkt(int i,int kmax);
 bool xflaechenpunkt(vektor* p);
 bool yflaechenpunkt(vektor* p);
};

/** Splinemethode 3
 Es werden 4 Sttzpunkte verwendet. Es wird eine Parabel durch die ersten
 3 Punkte gelegt, dann eine Parabel durch die letzten 3 Punkte.
 Fr die Verbindung vom 2. zum 3. Punkt wird der (gewichtete) Durchschnitt
 aus den beiden Parabeln genommen.
 Fr Anfang und Ende wird je noch ein Hilfspunkt angefgt.
**/
void parabel(vektor& a,vektor& b,vektor& c,double* a0,double* a1,double *a2)
{
 //Berechnet die Parabel y(x)=a2*x^2+a1*x+a0 durch die Punkte a b c
 double bax=b.x-a.x, cax=c.x-a.x, bay=b.y-a.y,
        ax2=a.x*a.x, bx2=b.x*b.x, cx2=c.x*c.x;
 *a2 = (c.y-a.y-cax*bay/bax) / (cax*(ax2-bx2)/bax+(cx2-ax2));
 *a1 = (bay+(*a2)*(ax2-bx2))/bax;
 *a0 = a.y-(*a2)*ax2-(*a1)*a.x;
}
vektor Potentialflaeche::xsplinebegin(int j,int kmax)
{
 j1=j; i1=0; //y bleibt konstant, x ndert
 k1max=kmax+1;  k1=0;
 int n=ny*i1+j1;
 y1=yfeld[n];
 p1=vektor(xfeld[n],zfeld[n]);
 n+=ny; p2=vektor(xfeld[n],zfeld[n]);
 n+=ny; p3=vektor(xfeld[n],zfeld[n]);
 p0=2*p1-p2; //Hilfspunkt fr Anfangsstrecke
 parabel(p0,p1,p2,&a0,&a1,&a2); parabel(p1,p2,p3,&b0,&b1,&b2);
 return dplot->getpixcoord(p1.x,y1,p1.y);
}
vektor Potentialflaeche::ysplinebegin(int i,int kmax)
{
 j1=0; i1=i; //y ndert, x bleibt konstant
 k1max=kmax+1;  k1=0;
 int n=ny*i1+j1;
 x1=xfeld[n];
 p1=vektor(yfeld[n],zfeld[n]);
 n++; p2=vektor(yfeld[n],zfeld[n]);
 n++; p3=vektor(yfeld[n],zfeld[n]);
 p0=2*p1-p2;
 parabel(p0,p1,p2,&a0,&a1,&a2); parabel(p1,p2,p3,&b0,&b1,&b2);
 return dplot->getpixcoord(x1,p1.x,p1.y);
}
bool Potentialflaeche::xsplinenext(vektor* p)
{
 if(k1>=k1max)
   {if(++i1>=nx) return false;
    else if(i1<nx-1)
      {p0=p1; p1=p2; p2=p3;
       if(i1+2<nx)
	 {int n=ny*(i1+2)+j1;
	  p3=vektor(xfeld[n],zfeld[n]);
	 }
       else
	 {p3=2*p2-p1;} //Hilfspunkt fr letzte Strecke
       parabel(p0,p1,p2,&a0,&a1,&a2); parabel(p1,p2,p3,&b0,&b1,&b2);
       k1=0;
      }
    //else (i1==nx-1): der letzte Punkt mit k1==k1max auch zeichnen
   }
 double x,z, g=double(k1)/k1max;
 x=p1.x+(p2.x-p1.x)*g;
 z=(1-g)*parabel1(x)+g*parabel2(x);
 // printf(" g=%lf x=%lf y1=%lf z=%lf\n",g,x,y1,z);//test
 k1++;
 *p = dplot->getpixcoord(x,y1,z);
 return true;
}
bool Potentialflaeche::ysplinenext(vektor* p)
{
 if(k1>=k1max)
   {if(++j1>=ny) return false;
    else if(j1<ny-1)
      {p0=p1; p1=p2; p2=p3;
       if(j1+2<ny)
	 {int n=ny*i1+(j1+2);
	  p3=vektor(yfeld[n],zfeld[n]);
	 }
       else
	 {p3=2*p2-p1;} //Hilfspunkt fr letzte Strecke
       parabel(p0,p1,p2,&a0,&a1,&a2); parabel(p1,p2,p3,&b0,&b1,&b2);
       k1=0;
      }
    //else (j1==ny-1): der letzte Punkt mit k1==k1max auch zeichnen
   }
 double x,z, g=double(k1)/k1max;
 x=p1.x+(p2.x-p1.x)*g;
 z=(1-g)*parabel1(x)+g*parabel2(x);
 // printf(" g=%lf x1=%lf x=%lf z=%lf\n",g,x1,x,z);//test
 k1++;
 *p = dplot->getpixcoord(x1,x,z);
 return true;
}
/** Ende Splinemethode 3 **/

vektor Potentialflaeche::getpoint(int i,int j)
{
 int n=ny*i+j;
 return dplot->getpixcoord(xfeld[n],yfeld[n],zfeld[n]);
}

Potentialflaeche::Potentialflaeche(char* name,Dreidplot* d)
{
 // double xmin=1.725,ymin=2.2,xmax=6.675,ymax=6.2;
 dplot=d;
 npoly= -1; //noch kein Flaechenangleich gemacht
 NPOLY=5; //Voreinstellung fuer Polynomgrad
 int i,nn;
 char zeile[80];
 FILE *fp;
 if((fp=fopen(name,"r"))==NULL)
   {printf("%s nicht gefunden\n",name); return;}
 getline(fp,kommentar,160);
 getline(fp,zeile,80); sscanf(zeile,"%d",&nx);
 getline(fp,zeile,80); sscanf(zeile,"%d",&ny);
 xfeld=new double[nn=nx*ny];
 yfeld=new double[nn];
 zfeld=new double[nn];
 for(i=0;getline(fp,zeile,80) && i<nn;i++)
  {sscanf(zeile,"%lf %lf %lf",&xfeld[i],&yfeld[i],&zfeld[i]);
  }
 fclose(fp);
}

void Potentialflaeche::angleichung_berechnen(int id)
{
 switch(id)
   {case GERADEN: break;
    case SPLINE: break;
    case FLAECHENANGLEICH:
       {int nn=nx*ny; //Anzahl Sttzpunke gespeichert in xfeld[nn] .. zfeld[nn]
        int n=NPOLY; //Polynomgrad der Anpassung
	int n21=n*2+1;
	//const int N21=MAXNPOLY*2+1;
	int i,j,k,kn,jn;
	double xi,yi,zi,ga[N21][N21],gb[N21],*loesungen;
	double xik,yik,xij,yij; //x[i]^k, y[i]^k, x[i]^j, y[i]^j
        if(npoly>=0) {delete aa; delete bb;}
	aa=new double[n]; bb=new double[n]; npoly=n;
	for(i=0;i<n21;i++)
	  {gb[i]=0;
	   for(j=0;j<n21;j++) ga[i][j]=0;
	  }
	ga[0][0] = nn;
	for(i=0;i<nn;i++)
	  {zi=zfeld[i]; xi=xfeld[i]; yi=yfeld[i];
	   gb[0] += zi;
	   //Ergebnisspalte und Matrix C-Spalte: nur k ndert, nicht j
	   for(k=1,xik=xi,yik=yi;k<=n;k++,xik*=xi,yik*=yi)
	     {gb[k] += zi*xik; gb[k+n] += zi*yik;
	      ga[k][0] += xik; ga[k+n][0] += yik;
	     }
	   //Matrix unterste Zeile: nur j ndert, nicht k
	   for(j=1,xij=xi,yij=yi;j<=n;j++,xij*=xi,yij*=yi)
	     {ga[0][j] += xij; ga[0][j+n] += yij;}
	   //Matrix ab A0-Spalte und 2.Zeile: j ndert und k ndert
	   for(k=1,xik=xi,yik=yi;k<=n;k++,xik*=xi,yik*=yi)
	     {kn=k+n;
	      for(j=1,xij=xi,yij=yi;j<=n;j++,xij*=xi,yij*=yi)
		{jn=j+n;
		 ga[k][j] += xij*xik;
		 ga[k][jn] += yij*xik;
		 ga[kn][j] += xij*yik;
		 ga[kn][jn] += yij*yik;
		}
	     }
	  }
	loesungen=lgs_gauss(n21,ga,gb); //lineares Gleichungssystem lsen
	cc=loesungen[0];
	for(j=0;j<n;j++)
	  {aa[j]=loesungen[1+j]; bb[j]=loesungen[1+n+j];}
	delete loesungen;
       }
       break;
    }
}
vektor Potentialflaeche::xflaechenpunkt(int j,int kmax)
{
 j1=j; i1=0; //y bleibt konstant, x ndert
 k1max=kmax+1;  k1=0;
 int n=ny*i1+j1;
 x1=xfeld[n]; y1=yfeld[n];
 delta=xfeld[n+ny]-x1;
 return dplot->getpixcoord(x1,y1,zberechnen_aus_polynom(x1,y1));
}
vektor Potentialflaeche::yflaechenpunkt(int i,int kmax)
{
 j1=0; i1=i; //y ndert, x bleibt konstant
 k1max=kmax+1;  k1=0;
 int n=ny*i1+j1;
 x1=xfeld[n]; y1=yfeld[n];
 delta=yfeld[n+1]-y1;
 return dplot->getpixcoord(x1,y1,zberechnen_aus_polynom(x1,y1));
}
bool Potentialflaeche::xflaechenpunkt(vektor* p)
{
 if(k1>=k1max)
   {if(++i1>=nx) return false;
    else if(i1<nx-1)
      {x1=xfeld[ny*i1+j1];
       delta=xfeld[ny*(i1+1)+j1]-x1;
       k1=0;
      }
    //else (i1==nx-1): der letzte Punkt mit k1==k1max auch zeichnen
   }
 double x,z, g=double(k1)/k1max;
 x=x1+delta*g;
 z=zberechnen_aus_polynom(x,y1);
 k1++;
 *p = dplot->getpixcoord(x,y1,z);
 return true;
}
bool Potentialflaeche::yflaechenpunkt(vektor* p)
{
 if(k1>=k1max)
   {if(++j1>=ny) return false;
    else if(j1<ny-1)
      {y1=yfeld[ny*i1+j1];
       delta=yfeld[ny*i1+(j1+1)]-y1;
       k1=0;
      }
    //else (j1==ny-1): der letzte Punkt mit k1==k1max auch zeichnen
   }
 double y,z, g=double(k1)/k1max;
 y=y1+delta*g;
 z=zberechnen_aus_polynom(x1,y);
 k1++;
 *p = dplot->getpixcoord(x1,y,z);
 return true;
}

class EpsPainter
{
 FILE *fp;
 bool movflag,strokflag;
 vektor movp;
 int nd,maxnd;
 void stroke()
  {if(strokflag) {print("s\n"); strokflag=false; nd=0;}
  }
 void move()
  {if(movflag) {print("%lg %lg m ",movp.x,movp.y); movflag=false; ++nd;}
  }
public:
 EpsPainter() {fp=NULL; movflag=strokflag=true; nd=0; maxnd=80;}
 ~EpsPainter() {if(fp) end();}
 void print(char *s) {if(fp) fprintf(fp,s);}
 void print(char *s,char *p) {if(fp) fprintf(fp,s,p);}
  // void print(char *s,int x,int y) {if(fp) fprintf(fp,s,x,y);}
 void print(char *s,double r,double g,double b=0, double h=0)
  {if(fp) fprintf(fp,s,r,g,b,h);}
 void begin(const char *name)
  {fp=fopen(name,"w");
   if(fp==NULL) {printf("Error: cant open %s\n",name); return;}
   print("%%!PS-Adobe-2.0 EPSF-1.2\n");
   print("%%%%Creator: EpsPainter %s\n",VERSION);
   print("%%%%BoundingBox: 0 0 596 843\n");
   print("%%%%BeginProlog\n");
   print("/m /moveto load def /d /lineto load def /s /stroke load def\n");
   print("%%%%EndProlog\n");
   print("save\n1 -1 scale\n0 -800 translate\n");
   print("gsave\n");
  }
 void end()
  {if(fp!=NULL)
    {stroke(); print("\ngrestore\nrestore\n"); fclose(fp); fp=NULL;}
   nd=0;
  }
 void drawLine(vektor p2)
  {move();
   print("%lg %lg d",p2.x,p2.y);
   if(++nd>=maxnd) {print(" s\n"); nd=0; movp=p2; movflag=true;}
   else
     {if(nd%4==0) print("\n"); else print(" ");}
  }
 void drawLine(vektor p1,vektor p2)
  {stroke();
   print("%lg %lg m %lg %lg d s\n",p1.x,p1.y,p2.x,p2.y);
  }
 void setPen(QPen stift)
  {//provi. nur Farbe gesetzt
   stroke();
   QColor c=stift.color(); const double f=1.0/255;
   print("%lg %lg %lg setrgbcolor\n",c.red()*f,c.green()*f,c.blue()*f);
  }
};

/************************* Hauptprogramm ******************************/
class MalFenster:public QWidget
{
 Q_OBJECT
public:
 MalFenster(Potentialflaeche* p)
  {potf=p;
   darstellung=GITTER; angleich=GERADEN;
   setBackgroundMode(NoBackground);
   dateimenu=new QPopupMenu;
   dateimenu->insertItem("&Save PostScript ...",this,SLOT(SavepsSlot()));
   dateimenu->insertItem("&Quit",qApp,SLOT(quit()));
   darmenu=new QPopupMenu;
   darmenu->insertItem("&Gitter",GITTER);
   darmenu->insertItem("&Flchen",FLAECHEN);
   QObject::connect(darmenu, SIGNAL(activated(int)),
		    this, SLOT(darMenuSlot(int)));
   angmenu=new QPopupMenu;
   angmenu->insertItem("&ohne Angleichsrechnung",GERADEN);
   angmenu->insertItem("&Splinekurven",SPLINE);
   angmenu->insertItem("&Flchenangleich",FLAECHENANGLEICH);
   angmenu->insertItem("&Polynomgrad ...",POLYNOMGRAD);
   QObject::connect(angmenu, SIGNAL(activated(int)),
		    this, SLOT(angMenuSlot(int)));
   hilfemenu=new QPopupMenu;
   hilfemenu->insertItem("&About this Program",this,SLOT(AboutSlot()));
   hilfemenu->insertItem("A&bout Qt",this,SLOT(AboutQtSlot()));
   menubalken=new QMenuBar(this);
   menubalken->insertItem("Datei",dateimenu);
   menubalken->insertItem("Darstellung",darmenu);
   menubalken->insertItem("Angleich",angmenu);
   menubalken->insertSeparator();
   menubalken->insertItem("&Hilfe",hilfemenu);
   meinDrucker=new QPrinter;
   meinDrucker->setPrintProgram("lpr");
  }
 ~MalFenster() {}
protected:
 virtual void mousePressEvent(QMouseEvent* event)
  {letztepos=event->pos();}
 virtual void mouseMoveEvent(QMouseEvent* event)
  {
   QPoint p=event->pos();
   if(event->state()&MidButton) //bei mittlerer Maustaste: verschieben
     {double x=letztepos.x()-p.x(), y=p.y()-letztepos.y();
      if(event->state()&ShiftButton)
	potf->schieben(x,0.0,y);
      else if(event->state()&ControlButton)
	potf->schieben(0.0,x,y);
      else if(event->state()&AltButton) //geht auf Mac mit Exodus nicht!
	potf->schieben(0.0,x,y);
      else
	potf->schieben(x,y,0.0);
     }
   else if(event->state()&RightButton) //rechte Maustaste: Strecken in z-Richt.
     {double z=(letztepos.y()+512)/(p.y()+512.0);
      potf->streckenz(z);
     }
   else
     {int dx=p.x()-letztepos.x(), dy=p.y()-letztepos.y();
      potf->drehen(dx*360.0/512, -dy*360.0/512, 0.0, true);
     }
   zeichnen();
   letztepos=event->pos();
  }
 virtual void paintEvent(QPaintEvent*)
  {zeichnen();
  }
 virtual void resizeEvent(QResizeEvent* event)
  {QPixmap save(puffer);
   puffer.resize(event->size());
   puffer.fill(white);
   bitBlt(&puffer,0,0,&save);
  }
 virtual void mouseDoubleClickEvent(QMouseEvent*)
  {int ok=meinDrucker->setup(this);
   if(ok)
    {QPainter p(meinDrucker);
     p.drawPixmap(0,0,puffer);
     p.drawRect(puffer.rect());
    }
  }
private slots:
 void SavepsSlot()
  {QString dateiname=QFileDialog::getSaveFileName(".","*.eps\n*",this);
   if(!dateiname.isEmpty())
     eps_zeichnen(dateiname.latin1());
  }
 void AboutSlot()
  {QMessageBox::information(this,"qpot","Potentialkurven darstellen\n");}
 void AboutQtSlot() {QMessageBox::aboutQt(this,"About Qt");}
 void darMenuSlot(int id) {darstellung=id; zeichnen();}
 void angMenuSlot(int id)
  {if(id==POLYNOMGRAD)
    {potf->NPOLY=QInputDialog::getInteger("Polynomgrad","NPOLY",potf->NPOLY);
     id=FLAECHENANGLEICH;
     if(potf->NPOLY<0)
       for(int i=0,imax= -potf->NPOLY; (potf->NPOLY=i)<imax; i++)
	 {potf->angleichung_berechnen(angleich=id); zeichnen(); usleep(500000);}
    }
   potf->angleichung_berechnen(angleich=id); zeichnen();
  }
private:
 int i,j,darstellung,angleich;
 QPoint letztepos;
 vektor pos1,pos2;
 QPixmap puffer;
 QMenuBar* menubalken;
 QPopupMenu *dateimenu, *darmenu, *angmenu, *hilfemenu;
 QPrinter *meinDrucker;
 Potentialflaeche* potf;
 void zeichnen()
  {
   puffer.fill(white);
   myQPainter pMaler;
   pMaler.begin(&puffer);
   //Achsen zeichnen
   QPen stift,rotstift; rotstift.setColor(red); pMaler.setPen(rotstift);
   pos1=potf->getpoint(2.2,2.2,-609.45);
   pMaler.drawLine(pos1,potf->getpoint(6.5,2.2,-609.45));
   stift.setColor(blue); pMaler.setPen(stift); //y-Achse blau
   pMaler.drawLine(pos1,potf->getpoint(2.2,6.5,-609.45));
   stift.setColor(green); pMaler.setPen(stift); //z-Achse gruen
   pMaler.drawLine(pos1,potf->getpoint(2.2,2.2,-608.45));
   stift.setColor(black); pMaler.setPen(stift);
   //Potentialflaeche zeichnen
   if(angleich==SPLINE)
     {const int kmax=20; //Anzahl Zwischenpunkte
      for(j=0;j<potf->ny;j++)
       {pos1=potf->xsplinebegin(j,kmax);
        while(potf->xsplinenext(&pos2))
	  {pMaler.drawLine(pos1,pos2); pos1=pos2;}
       }
      for(i=0;i<potf->nx;i++)
       {pos1=potf->ysplinebegin(i,kmax);
        while(potf->ysplinenext(&pos2))
	  {pMaler.drawLine(pos1,pos2); pos1=pos2;}
       }
     }
   else if(angleich==FLAECHENANGLEICH)
     {const int kmax=20; //Anzahl Zwischenpunkte
      for(j=0;j<potf->ny;j++)
	{pos1=potf->xflaechenpunkt(j,kmax);
	 while(potf->xflaechenpunkt(&pos2))
	   {pMaler.drawLine(pos1,pos2); pos1=pos2;}
	}
      for(i=0;i<potf->nx;i++)
       {pos1=potf->yflaechenpunkt(i,kmax);
        while(potf->yflaechenpunkt(&pos2))
	  {pMaler.drawLine(pos1,pos2); pos1=pos2;}
       }
     }
   else
     {for(j=0;j<potf->ny;j++)
       for(i=0;i<potf->nx;i++)
	 {if(i==0)
	   {pos2=potf->getpoint(i,j);}
	  else
	    {pos1=pos2; pos2=potf->getpoint(i,j);
	     pMaler.drawLine(pos1,pos2);
	    }
	 }
      for(i=0;i<potf->nx;i++)
	for(j=0;j<potf->ny;j++)
	  {if(j==0)
	    {pos2=potf->getpoint(i,j);}
	   else
	     {pos1=pos2; pos2=potf->getpoint(i,j);
	      pMaler.drawLine(pos1,pos2);
	     }
	  }
     }
   pMaler.end();
   bitBlt(this,0,0,&puffer);
  }
 void eps_zeichnen(const char *dateiname)
  {
   EpsPainter pMaler;
   pMaler.begin(dateiname);
   //Achsen zeichnen
   QPen stift; stift.setColor(red); pMaler.setPen(stift);
   pos1=potf->getpoint(2.2,2.2,-609.45);
   pMaler.drawLine(pos1,potf->getpoint(6.5,2.2,-609.45));
   pMaler.drawLine(pos1,potf->getpoint(2.2,6.5,-609.45));
   pMaler.drawLine(pos1,potf->getpoint(2.2,2.2,-608.45));
   stift.setColor(black); pMaler.setPen(stift);
   //Potentialflaeche zeichnen
   if(angleich==SPLINE)
     {const int kmax=20; //Anzahl Zwischenpunkte
      for(j=0;j<potf->ny;j++)
       {pos1=potf->xsplinebegin(j,kmax);
        while(potf->xsplinenext(&pos2))
	  {pMaler.drawLine(pos1,pos2);
	   pos1=pos2;
	  }
       }
      for(i=0;i<potf->nx;i++)
       {pos1=potf->ysplinebegin(i,kmax);
        while(potf->ysplinenext(&pos2))
	  {pMaler.drawLine(pos1,pos2);
	   pos1=pos2;
	  }
       }
     }
   else if(angleich==FLAECHENANGLEICH)
     {const int kmax=20; //Anzahl Zwischenpunkte
      for(j=0;j<potf->ny;j++)
	{pos1=potf->xflaechenpunkt(j,kmax);
	 while(potf->xflaechenpunkt(&pos2))
	   {pMaler.drawLine(pos1,pos2); pos1=pos2;}
	}
      for(i=0;i<potf->nx;i++)
       {pos1=potf->yflaechenpunkt(i,kmax);
        while(potf->yflaechenpunkt(&pos2))
	  {pMaler.drawLine(pos1,pos2); pos1=pos2;}
       }
     }
   else
     {for(j=0;j<potf->ny;j++)
       for(i=0;i<potf->nx;i++)
	 {if(i==0)
	   {pos2=potf->getpoint(i,j);}
	  else
	    {pos1=pos2; pos2=potf->getpoint(i,j);
	     pMaler.drawLine(pos1,pos2);
	    }
	 }
      for(i=0;i<potf->nx;i++)
	for(j=0;j<potf->ny;j++)
	  {if(j==0)
	    {pos2=potf->getpoint(i,j);}
	   else
	     {pos1=pos2; pos2=potf->getpoint(i,j);
	      pMaler.drawLine(pos1,pos2);
	     }
	  }
     }
   pMaler.end();
  }
};

#include "qpot.moc"

main(int argc,char *argv[])
{
 QApplication myapp(argc,argv);
 Dreidplot* dplot=new Dreidplot(512,512,
				200, //Brennweite
				700, //Kameraabstand
				Vektor3d(4,4,-609.2), //Offset
				Vektor3d(100,100,500), //Skalierung
				-45,60,0 //Drehungen in Grad
			       );
 Potentialflaeche* potf=new Potentialflaeche(argv[1],dplot);
 MalFenster* mywidget=new MalFenster(potf);
 mywidget->setGeometry(20,20,640,512);
 myapp.setMainWidget(mywidget);
 mywidget->show();
 return myapp.exec();
}
