/* rndcheck.cc			letzte nderung: 30.6.1995 */
#define VERSION "Version 0.0"
/*
Uebersetzen:
;AVAX> cx rndcheck
;AVAX> blink rndcheck,[PFISTER.OBJ]XTEKPLOT1
;AVAX> pur rndcheck.exe
;> c++ rndcheck.cc h:amitekplot1.o h:amigalib.a -o rndcheck

 Zufallszahlengenerator testen

History:
29.6.1995	Erstellung (RPf)
*/

#define XWINDOWS

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ulong.h>
#ifdef XWINDOWS
#include <xtekplot1.h>
#endif
#ifdef AMIGA
#include "h:amitekplot1.h"
#endif

static int exitflag=0;
void menu_exit() {exitflag=1;}

typedef double (*Funkzeiger)();
void rahmen(double x0,double y0,double x1,double y1);
void binomino(double x0,double y0,long imax,Funkzeiger zuf);
void zombi(double x0,double y0,long imax,Funkzeiger zuf);

/***************************** Kleinkram ******************************/
inline double random01()        // Zufallszahl zwischen 0. und 1.
{
 return (1. - rand()/(double)RAND_MAX);//Variante fuer VAX/ALPHA
}

double zufall()  // liefert Zufallszahl zwischen 0.0 und 1.0
{		 // gibt Streifen im Flchentest
 static double x=1.3757;
 double y;
// if(y!=0.) x=y;
 x=(100.+x)/(100.*(x-(long)(x))+0.7);
 y=10.*x;
 return (y-(long)(y));
}

double zufall3()
{
 static double x=1.7;
 double y;
 if(x==0.) {x=1.7; printf("Testpunkt 2\n");}
 if(x>100.) x=x/1163.;
 else x*=773.;
 y=10.*(x-(long)(x));
 return (y-(long)(y));
}
double zufall4()
{
 static double x=581;
 double y;
 if(x==0.) {x=1.; printf("Testpunkt 1\n");}
 x/=1.163;
 x-=(long)(x);
 y=10.*x;
 x*=1000.;
 return (y-(long)(y));
}
double zufall_pseudogauss()
{
 const double n=100,p=0.5,euler=0.57721,
	mittelwert=0.5,streuung=0.1;
 //mit mittelwert=0.5 und streuung=0.04 sind alle Punkte zwischen 0.0 und 1.0
 long i;
 double summe,st,mw=n*p,result;
 st=sqrt(n*p*(1-p))*euler;
 for(summe=0,i=0;i<n;i++) summe+=random01();
 result=(summe-mw)/st*streuung+mittelwert;
 if(result<=0.) result=1e-30;
 else if(result>=1.0) result=1.0-1e-12;
 return result;
}

void inputd(char *s,int *x)
{
 printf("(%d) %s",*x,s); scanf("%d",x);
}
void inputf(char *s,double *x)
{
 printf("(%lf) %s",*x,s); scanf("%lf",x);
}

/************************* Hauptprogramm ******************************/
/** zu testende Zufallsfunktion hier einsetzen: **/
#define ZUFALL random01
#define ZUFALL2 zufall
#define ZUFALL3 zufall_pseudogauss
#define ZUFALL4 zufall4

/** Globale Variablen **/
double zot=5.0,zobase=0.;
int nbalk=20;

main(int argc,char *argv[])
{
 long i,imax=100000;
 int testmethode;
 double xymax=2.0;
/* double xmin= -0.15,xmax= 1.15,ymin= -0.02,ymax=1.02, x,y;*/
 double xmin= -0.225,xmax= 2.225,ymin= -0.02,ymax=2.02, x,y;
 printf("Testmethoden:\n");
 printf(" 1 = Flchentest, sollte eine graue Flche ohne Streifen geben\n");
 printf(" 2 = Binominalverteilung, sollte gausshnlichen Buckel geben\n");
 printf(" 3 = Zombitest, negative Exponentialfunktion\n");
 printf("Auswahl:"); scanf("%d",&testmethode);
 printf("(%ld) Anzahl ZufallsPunkte:",imax); scanf("%ld",&imax);
 if(testmethode>=2) inputd("Anzahl Balken:",&nbalk);
 if(testmethode==3) {inputf("Durchschnittlicher Zeitabstand:",&zot);
		     inputf("Position der Zombitr (0.0 bis 0.9) :",&zobase);
		    }
 setmenu(1,"File");
 setmenu(1,"Exit",&menu_exit);
 inital(xmin,ymin,xmax,ymax);
 rahmen(0.,0.,1.,1.); rahmen(1.,0.,2.,1.);
 rahmen(0.,1.,1.,2.); rahmen(1.,1.,2.,2.);
 term_refresh();
 switch(testmethode)
  {case 2: binomino(0.,0.,imax,ZUFALL);
	   binomino(1.,0.,imax,ZUFALL2);
	   binomino(0.,1.,imax,ZUFALL3);
	   binomino(1.,1.,imax,ZUFALL4);
   CASE 3: zombi(0.,0.,imax,ZUFALL);
	   zombi(1.,0.,imax,ZUFALL2);
	   zombi(0.,1.,imax,ZUFALL3);
	   zombi(1.,1.,imax,ZUFALL4);
   CASE 1: default: printf("Flchentest\n");
    inital_new();
    for(i=0;i<imax;i++)
	{x=ZUFALL(); y=ZUFALL(); tek_punkt(x,y,1);
	 x=ZUFALL2(); y=ZUFALL2(); tek_punkt(x+1.,y,1);
	 x=ZUFALL3(); y=ZUFALL3(); tek_punkt(x,y+1.,1);
	 x=ZUFALL4(); y=ZUFALL4(); tek_punkt(x+1.,y+1.,1);
	}
    term_refresh();
  }
 printf("fertig\n");
 while(exitflag==0 && waitmenu(1)==0)
            ;/* auf Benutzereingaben warten */
 term_exit();
 return 0;
}/* ende von main */

void rahmen(double x0,double y0,double x1,double y1)
{
 plot(x0,y0,PENUP); plot(x0,y1,PENDOWN); plot(x1,y1,PENDOWN);
 plot(x1,y0,PENDOWN); plot(x0,y0,PENDOWN);
}

#define ZWIBALK 0.01
void binomino(double x0,double y0,long imax,Funkzeiger zuf)
{
 long j,*balken=new long[nbalk];
 int i,n;
// double x,y,dx=1./nbalk-ZWIBALK,dy=1./(imax*4./nbalk);
 double x,y,dx=1./nbalk-ZWIBALK,dy=1./(imax*0.5/log(nbalk-7.));
 for(i=0;i<nbalk;i++) balken[i]=0;
 for(j=0;j<imax;j++)
  {for(i=n=0;++i<nbalk;)
	{x=(*zuf)();
	 if(x>=0.5) n++;
	}
   balken[n]++;
  }
 inital_new();
 for(i=0,x0-=ZWIBALK/2.;i<nbalk;i++,x0+=dx)
  {x0+=ZWIBALK;
   y=y0+balken[i]*dy;
   fillbox(x0,y0,x0+dx,y);
  }
 delete balken;
 term_refresh();
}

void zombi(double x0,double y0,long imax,Funkzeiger zuf)
{
 long j,*balken=new long[nbalk];
 int i,n,ntuer;
 ntuer=(nbalk>100) ? nbalk : 100;
 double grenze=1./ntuer+zobase;
 double x,y,dx=1./nbalk-ZWIBALK,dy=1./(imax*0.65*2./(zot+1.));
 for(i=0;i<nbalk;i++) balken[i]=0;
 for(j=0;j<imax;j++)
  {for(n=0;;n++)
	{x=(*zuf)();
	 if(x<grenze && x>=zobase) break;
	}
   n=int(n*zot/ntuer);
   if(n<nbalk) balken[n]++;
  }
 inital_new();
 for(i=0,x0-=ZWIBALK/2.;i<nbalk;i++,x0+=dx)
  {x0+=ZWIBALK;
   y=y0+balken[i]*dy;
   fillbox(x0,y0,x0+dx,y);
  }
 delete balken;
 term_refresh();
}
