//ortmot.cc

#include <stdio.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <sys/ipc.h>
#include <sys/shm.h>
#include <termios.h>

#include "ortmot.h"
int myRICHTMINUS=RICHTMINUS;

/*********************** Kleinkram ************************************/
int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

/********************* Schrittmotor ************************************/
const int TIMEOUT=5,TICKS_PER_SECOND=50; //stark Hardwareabhaengig!

class Command
{
 long id;
 daemonport *ptr;
public:
 Command();
 ~Command();
 void command(int wer,int kommando,double data,int wie);
 double getcomparam() {return ptr->rx;}
};
Command::Command()
{
 FILE* fp=fopen(IDDATEI,"r");
 if(fp==NULL)
   {printf("kann '%s' nicht finden\n",IDDATEI);
    printf("bitte zuerst stepcontrol starten !\n");
    exit(0);
   }
 fscanf(fp,"%ld",&id);
 fclose(fp);
 shmget(id,sizeof(daemonport),SHM_R|SHM_W);
 ptr=(daemonport*)shmat(id,0,0);
 if(ptr==(daemonport*)(-1) || ptr==NULL)
   {printf("error shmat() --> %ld  vermutlich 'stepcontrol' noch nicht gestartet\n",long(ptr));
    exit(0);
   }
}
Command::~Command()
{
 shmdt((char*)ptr);
}
char *geterrortext(int err)
{
 static char str[40];
 switch(err)
   {case UNKNOWN_COMMAND: return "unknown command";
    case WRONG_DATA: return "wrong data";
   }
 sprintf(str,"%d",err);
 return str;
}
void Command::command(int wer,int kommando,double data,int wie)
{
 int i,imax=TIMEOUT*TICKS_PER_SECOND;
 ptr->wer=wer; ptr->wcommand=kommando; ptr->wx=data; ptr->wie=wie;
 ptr->sync |= SYNC_AW;
 for(i=0;i<imax && (ptr->sync & SYNC_AW)!=0;i++) usleep(1);
 if(i==imax) printf("Timeout -- stepcontrol antwortet nicht!\n");
 while((ptr->sync & SYNC_DW)==0) usleep(1000);
 if(ptr->err < 0) printf("Error stepcontrol: %s\n",geterrortext(ptr->err));
 ptr->sync &= ~SYNC_DW;
}

static Command com;

void command(int wer,int kommando,double data=0,int wie=EGAL)
{
 com.command(wer,kommando,data,wie);
}

double getcomparam()
{
 return com.getcomparam();
}

/********************** Ortec *******************************************/
//static char *sername="/dev/ttyS1"; //funktionsfaehig auf altem PC
static char *sername="/dev/ttyS0";
static int fdr,fdw;

/**
#define AMAX 200
#define DONTSEND 1
#define DONTWAIT 2

void ortec_command(char *str,int flag=0)
{
 static char buf[AMAX],*s;
 char c,*wbuf=NULL;
 int i,n;
 n=strlen(str);
 if(!(flag&DONTSEND))
   {wbuf=new char[n+2];
    sprintf(wbuf,"%s\n",str);
    write(fdw,wbuf,n+1);
   }
 if(!(flag&DONTWAIT))
   {for(i=1,s=buf;i<AMAX;)
     {read(fdr,&c,1);
      //if(c=='\n' || c=='\r') break;
      if(c=='\n') break;
      if(c==0) printf("Null empfagen\n");//test
      else
	{*s++ = c; i++;}
     }
    *s=0;
    if(i==AMAX) printf("Fehler: zu lange Zeile erhalten\n");//provi
    printf("'%s'\n",buf);
   }
 if(wbuf) delete wbuf;
}

void ortec_getdata() //provi.
{
 ortec_command(" ",DONTSEND);
}
**/

/********************* Hauptprogramm ************************************/
void noecho(int fd)
{
 struct termios buf;
 if(tcgetattr(fd,&buf)<0)
   {printf("tcgetattr() Error\n"); return;}
 buf.c_lflag &= ~ECHO;
 if(tcsetattr(fd,TCSAFLUSH,&buf)<0)
   {printf("tcsetattr() Error\n"); return;}
}

void ortec_init()
{
 int mode=0;
 fdr=open(sername,O_RDWR|mode);
 if(fdr<0) {printf("Fehler: fdr = %d\n",fdr); exit(0);}
	   //wenn dieser Fehler kommt sollte /dev/ttyS1 ueberprueft werden
	   //Zugriffsberechtigung freigeben: chmod a+rw /dev/ttyS1
	   //oder vielleicht /dev/ttyS0
 noecho(fdr);
 fdw=fdr;
}

void ortec_close()
{
 close(fdr);
}

void ortec_putser(char *str)
{
 int n=strlen(str);
 char *wbuf=new char[n+2];
 sprintf(wbuf,"%s\n",str);
 write(fdw,wbuf,n+1);
 delete wbuf;
}

void ortec_getser(char *str,int max)
{
 int i;
 char *s,c;
 for(i=1,s=str;i<max;)
   {read(fdr,&c,1);
    if(c=='\n') break;
    if(c==0) printf("ortec_getser() Null empfagen\n");//test
    else
      {*s++ = c; i++;}
   }
 *s=0;
 if(s!=str && *--s<' ')
   {printf("letztes Zeichen = %02X verworfen\n",*s); *s=0;}//test
 if(i==max)
   {printf("Fehler: in ortec_getser() zu lange Zeile erhalten\n");
    printf("'%s'\n",str);
   }
}

void ortmot_go_start(double x,int wer)
{
 command(wer,GO,x,myRICHTMINUS);
}

void ortmot_go(double x,int wer)
{
 command(wer,GO,x,myRICHTMINUS);
 command(wer,WAIT);
}

void ortmot_calib(double x,int wer)
{
 command(wer,CALIB,x);
}

/**
main()
{
 char zeile[80];
 double x;
 int i,c;
 int mode=0;
 fdr=open(sername,O_RDWR|mode);
 if(fdr<0) {printf("Fehler: fdr = %d\n",fdr); exit(0);}
 fdw=fdr;
 for(;;)
   {printf("XX "); getline(stdin,zeile,80);
    if(*zeile=='q' || *zeile=='Q') break;
    switch(*zeile)
     {case 'c':  sscanf(zeile,"cal %lf",&x);
		 command(OLGA,CALIB,x);
      CASE 'g':  sscanf(zeile,"go %lf",&x);
		 command(OLGA,GO,x);
      CASE 'w':  command(OLGA,WAIT);
      CASE 't':  sscanf(zeile,"test %d",&c); command(c,TEST);
      CASE '>': ortec_command(&zeile[1]);
      CASE '$': ortec_command(&zeile[1],DONTWAIT);
      CASE '<': ortec_getdata();
     }
   }
 close(fdr);
}
**/
