/* ser.cc  Serielle Schnittstelle ansprechen    letzte nderung: 16.2.2004 */
#define VERSION "Version 0.1"
/*
History:
7.2.2004	Erstellung (RP)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <termios.h>
#include <unistd.h>

/*************************** kleinkram ***************************/
int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/*********************** Serielle Schnittstelle ***********************/
static char sername[80]="/dev/ttyS0";
static int baudrate=0;
static int fdr,fdw;

static int baudcodliste[]={50,B50, 75,B75, 110,B110, 134,B134, 150,B150,
   300,B300, 600,B600, 1200,B1200, 1800,B1800, 2400,B2400, 4800,B4800,
   9600,B9600, 19200,B19200, 38400,B38400,
   57600,B57600, 115200,B115200,
   230400,B230400, 460800,B460800, 500000,B500000, 576000,B576000,
   921600,B921600, 1000000,B1000000, 1152000,B1152000, 1500000,B1500000,
   2000000,B2000000, 2500000,B2500000, 3000000,B3000000, 3500000,B3500000,
   4000000,B4000000, 0,0};

int ibaud(int x) //Baudcode in Baudrate umrechnen
{
 int *co,a;
 for(co=baudcodliste;(a= *co++)!=0;co++)
    if(x== *co) return a;
 printf("Fehler: unbekannter Baudratecode %d\n",x);
 return 0;
}
int baudi(int x) //Baudrate in Baudcode umrechnen
{
 int *co,b,min=0;
 for(co=baudcodliste;(b= *co++)>0;co++)
     if(x==b) return *co;
     else if(x>b) {min= *co;}
 printf("Warnung: unbekannte Baudrate %d, auf %d abgerundet\n",x,min);
 return min;
}

void noecho(int fd)
{
 struct termios buf;
 if(tcgetattr(fd,&buf)<0)
   {printf("tcgetattr() Error\n"); return;}
 buf.c_lflag &= ~ECHO;
 if(baudrate!=0)
     {cfsetispeed(&buf,baudi(baudrate));
      cfsetospeed(&buf,baudi(baudrate));
     }
 if(tcsetattr(fd,TCSAFLUSH,&buf)<0)
   {printf("tcsetattr() Error\n"); return;}
 int a=cfgetispeed(&buf),b=cfgetospeed(&buf);
 printf("Baudraten: %d %d\n",ibaud(a),ibaud(b));
}
void seriell_open()
{
 int mode=0;
 fdr=open(sername,O_RDWR|mode);
 if(fdr<0) {printf("Fehler: fdr = %d\n",fdr); exit(0);}
	   //wenn dieser Fehler kommt sollte /dev/ttyS0 ueberprueft werden
	   //Zugriffsberechtigung freigeben: chmod a+rw /dev/ttyS0
	   //oder vielleicht /dev/ttyS1
 noecho(fdr);
 fdw=fdr;
}
void seriell_close()
{
 close(fdr);
}
void seriell_readline(char *str,int max)
{
 int i;
 char *s,c;
 for(i=1,s=str;i<max;)
   {read(fdr,&c,1);
    if(c=='\n') break;
    if(c==0) printf("Null-Zeichen empfangen\n");//test
    else
      {*s++ = c; i++;}
   }
 if(s!=str && s[-1] == '\r') {--s; printf("CR empfangen\n");}
 *s=0;
}
void seriell_writeline(char *str)
{
 int n=strlen(str);
 char *wbuf=new char[n+3];
 if(argflag['C']) sprintf(wbuf,"%s\r\n",str);
 else sprintf(wbuf,"%s\n",str);
 write(fdw,wbuf,n+1);
 delete wbuf;
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char name[80],zeile[80],rzeile[80];
 int i,j,wahl=1,c=0;
 name[0]=0;
 for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(name,argv[i]);
	         else if(j==2) sscanf(argv[i],"%d",&baudrate);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("ser  %s\n",VERSION);
	 printf("Anwendung: ser [-flags] [/dev/ttyS1] [Baudrate]\n");
	 printf("   flags: c=CR vor LF senden\n");
	 exit(0);
	}
 if(j>=1)
     {if(isdigit(*name)) sprintf(sername,"/dev/ttyS%c",*name);
      else sprintf(sername,"%s",name);
     }
 printf("versuche '%s' zu oeffnen\n",sername);
 seriell_open();
 for(;;)
 {printf("Modus-Auswahl:\n");
  printf("0  Programm verlassen\n");
  printf("1  Zeilenweise schreiben/lesen\n");
  printf("2  Zeilenweise lesen/schreiben\n");
  printf("3  Einzelzeichen schreiben/lesen\n");
  printf("4  Einzelzeichen lesen/schreiben\n");
  printf("5  je 100000 Zeichen senden\n");
  printf("Auswahl:"); getline(stdin,zeile,80); sscanf(zeile,"%d",&wahl);
  if(wahl<1) break;
  if(wahl==1)
    {for(;;)
	{printf("(q=Abbruch) senden:"); getline(stdin,zeile,80);
	 if(*zeile=='q') break;
	 if(*zeile!=0) seriell_writeline(zeile);
	 do {
	  seriell_readline(rzeile,80);
	  printf("  zeile empfangen:'%s'\n",rzeile);
	 }while(*rzeile==0);
	}
    }
  else if(wahl==2)
    {for(;;)
	{do {
	  seriell_readline(rzeile,80);
	  printf("   Zeile empfangen:'%s'\n",rzeile);
	 }while(*rzeile==0);
	 printf("(q=Abbruch) senden:"); getline(stdin,zeile,80);
	 if(*zeile=='q') break;
	 if(*zeile!=0) seriell_writeline(zeile);
	}
    }
  else if(wahl==3)
    {for(;;)
	{printf("(q=Abbruch) senden:"); c=getc(stdin);
	 if(c=='q') break;
	 write(fdw,&c,1);
	 read(fdr,&c,1);
	 printf("Zeichen  empfangen: 0x%02X\n",c);
	}
    }
  else if(wahl==4)
    {for(;;)
	{read(fdr,&c,1);
	 printf("Zeichen  empfangen: 0x%02X\n",c);
	 printf("(q=Abbruch) senden:"); c=getc(stdin);
	 if(c=='q') break;
	 write(fdw,&c,1);
	}
    }
  else if(wahl==5)
    {for(;;)
	{printf("(q=Abbruch) senden:"); c=getc(stdin);
	 if(c=='q') break;
	 for(i=0;i<100000;i++) write(fdw,&c,1);
	}
    }
  getc(stdin);
 }
 seriell_close();
 return 0;
}/* ende von main */
