//ser0.cc	Serielle Schnittstelle ansprechen

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <sys/ipc.h>
#include <sys/shm.h>

#include <termios.h>

const int N=10;

void showstat(char *name)
{
 struct stat stbuf;
 stat(name,&stbuf);
 printf("%s  st_mode=0x%X  st_size=%d\n",name,stbuf.st_mode,stbuf.st_size);
}

int input(char *zeile)
{
 char *s=zeile;
 int i,c;
 printf("Eingabe:\n");
 for(i=3;i<80 && (c=getc(stdin))!='\n';i++)
     *s++ = c;
 *s++='\r';
 *s++='\n';
 *s=0;
 return zeile[0];
}

void termios_speichern(termios *p)
{
 FILE *fp=fopen("ser.termios","w");
 fprintf(fp,"%d\n",p->c_iflag);
 fprintf(fp,"%d\n",p->c_oflag);
 fprintf(fp,"%d\n",p->c_cflag);
 fprintf(fp,"%d\n",p->c_lflag);
 for(int i=0;i<NCCS;i++) fprintf(fp,"%d ",p->c_cc[i]);
 fprintf(fp,"\n");
 fclose(fp);
}
void termios_print(char *cstr,termios *p)
{
 printf("%s\n",cstr);
 printf(" c_iflag=0x%04X\n",p->c_iflag);
 printf(" c_oflag=0x%04X\n",p->c_oflag);
 printf(" c_cflag=0x%04X\n",p->c_cflag);
 printf(" c_lflag=0x%04X\n",p->c_lflag);
 printf(" c_cc=");
 for(int i=0;i<NCCS;i++) printf("%02X ",p->c_cc[i]);
 printf("\n");
}

main()
{
 char buf[200],buf2[200];
 int i,c;
 int fd,fdr,fdw;
// int mode=O_NOCTTY|O_NONBLOCK;
 int mode=0;
 char name[80]="/dev/ttyS1";
 // printf("Name: "); scanf("%s",name);
 showstat("/dev/ttyS0"); showstat("/dev/ttyS1");
 showstat("/dev/cua0"); showstat("/dev/cua1");
 printf("sizeof(struct termios)=%d\nNCCS=%d\n",sizeof(struct termios),NCCS);//test
 printf("Modus-Auswahl:\n");
 printf("1  lesen\n2  schreiben\n3  lesen und echo\n");
 printf("4  Zeilenweise schreiben/lesen\n");
 printf("Auswahl:"); scanf("%d",&c);
 if(c==4)
  {char *s;
   fdr=open(name,O_RDWR);
   if(fdr<0) {printf("Fehler: fdr = %d\n",fdr); exit(0);}
   termios tio,tio0;
   tcgetattr(fdr,&tio);
   termios_speichern(&tio);
   tio0=tio;
   //printf("sizeof(tcflag_t)=%d  NCCS=%d\n",sizeof(tcflag_t),NCCS);//test
   //printf("sizeof(cc_t)=%d\n",sizeof(cc_t));//test
   termios_print("Inhalt von termios-Struktur:",&tio);
   printf("voreingestellte Geschwindigkeiten: %d %d\n",
	  cfgetispeed(&tio),cfgetospeed(&tio));
   cfsetispeed(&tio,B9600);
   cfsetospeed(&tio,B9600);
/*
   termios_print("nach setospeed",&tio);
   tio.c_iflag=IGNBRK|IGNCR;
   tio.c_oflag=OPOST|ONLCR;
   tio.c_cflag=CLOCAL|CREAD|CS8;
   tio.c_lflag=0;
   termios_print("neue Einstellungen:",&tio);
*/
   tcsetattr(fdr,TCSANOW,&tio);
   printf("neue Geschwindigkeiten: %d %d\n",
	  cfgetispeed(&tio),cfgetospeed(&tio));
   fdw=fdr;
   getc(stdin);
   for(c=input(buf);c!='q';c=input(buf))
     {printf("c=0x%02X strlen(buf)=%d\n",c,strlen(buf));//test
      if(c>' ') write(fdw,buf,strlen(buf));
      else printf("c=0x%02X\n",c);//test
      for(i=1,c=0,s=buf2;i<80 && c!='\n';i++) //Zeile oder max 80 Zeichen lesen
        {read(fdr,buf,1);
	 c= *buf & 0xFF;
	 if(isprint(c)) printf("%02X %c\n",c,c);
	 else printf("%02X\n",c);
	 *s++ = c;
	}
      --s;
      while(i>1 && c<' ') {c= *--s;}
      *++s = 0;
      printf("gelesen: '%s'\n",buf2);
     }
   //close(fdw);
   tcsetattr(fdr,TCSANOW,&tio0);
   close(fdr);
  }
 if(c==3)
  {fdr=open(name,O_RDWR|mode);
   if(fdr<0) {printf("Fehler: fdr = %d\n",fdr); exit(0);}
   //fdw=open("/dev/cua1",O_RDONLY|mode);
   //if(fdw<0) {printf("Fehler: fdw = %d\n",fdw); close(fdr); exit(0);}
   fdw=fdr;
   while(c!='q')
     {read(fdr,buf,1);
      c= *buf & 0xFF;
      if(isprint(c)) printf("%02X %c\n",c,c);
      else printf("%02X\n",c);
      sprintf(buf,"%02X",c);
      write(fdw,buf,strlen(buf));
     }
   //close(fdw);
   close(fdr);
  }
 else if(c==2)
  {fd=open(name,O_RDWR);
   if(fd<0) {printf("Fehler open() --> %d\n",fd); exit(0);}
   for(int j=0;j<1000;j++) {
   for(i=0,c='A';i<N;i++,c++)
     buf[i]=c;
   buf[N-1]='\n';
   write(fd,buf,N);
   }
   close(fd);
  }
 else //if(c==1)
  {fd=open(name,O_RDONLY);
   while(c!='q')
     {usleep(500000);
      read(fd,buf,1);
      c = *buf & 0xFF;
      if(isprint(c)) printf("%02X %c\n",c,c);
      else printf("%02X\n",c);
     }
   close(fd);
  }
 printf("fertig\n");
 return 0;
}
