/* uart.cc       letzte Aenderung: 9.8.2010
UART Ansteuerung
teilweise von mikrocontroller.net kopiert:
http://www.mikrocontroller.net/articles/AVR-GCC-Tutorial/Der_UART

 Version: 0.01
 Prozessor: ATmega32, ATmega8
 Schaltung:
   Senden:    PD1 (TxD)
   Empfangen: PD0 (RxD)

 Autor: Rolf Pfister
 Copyright: Freeware
 History:
 9.8.2010	Erstellung
 11.11.2010	erweitert auf vollstaendiges Programm

Verwendung im Hauptprogramm:
#include <inttypes.h>
#include <avr/io.h>
#include <stdio.h>
#include "uart.cc"

*/
#define HAUPTPROGRAMM  //auskommentieren wenn wie oben eingefuegt

#ifdef HAUPTPROGRAMM
#include <inttypes.h>
#include <avr/io.h>
#include <stdio.h>
#endif

#ifndef F_CPU
#warning "F_CPU war noch nicht definiert, wird nun nachgeholt mit 8000000"
#define F_CPU 8000000UL  // Systemtakt in Hz - Definition als unsigned long
                         // Ohne ergeben sich unten Fehler in der Berechnung
#endif
 
#define BAUD 9600UL      // Baudrate
 
// Berechnungen
#define UBRR_VAL ((F_CPU+BAUD*8)/(BAUD*16)-1)   // clever runden
#define BAUD_REAL (F_CPU/(16*(UBRR_VAL+1)))     // Reale Baudrate
#define BAUD_ERROR ((BAUD_REAL*1000)/BAUD) // Fehler in Promille, 1000 = kein Fehler.
 
#if ((BAUD_ERROR<990) || (BAUD_ERROR>1010))
  #error Systematischer Fehler der Baudrate grsser 1% und damit zu hoch! 
#endif 

void uart_init()
{
 UBRRH = UBRR_VAL >> 8;
 UBRRL = UBRR_VAL & 0xFF;
 //UBRR = UBRR_VAL; //sollte mit neueren Compilern auch gehen

 //UCSRB |= (1<<TXEN); // UART TX einschalten
 //UCSRB |= (1<<RXEN); // UART RX einschalten
 UCSRB = (1<<RXEN) | (1<<TXEN); // UART RX und TX einschalten

 //UCSRC |= (1<<URSEL)|(1<<UCSZ1)|(1<<UCSZ0); // Asynchron 8N1 Atmega16
 //UCSRC = (1<<URSEL)|(1<<USBS)|(3<<UCSZ0); // 8data, 2stop bit (8N2) Atmega32
 //UCSRC = (1<<URSEL)|(2<<UPM0)|(3<<UCSZ0); // 8data, 1stop, Even Parity
 //UCSRC = (1<<URSEL)|(3<<UPM0)|(3<<UCSZ0); // 8data, 1stop, Odd Parity
 UCSRC = (1<<URSEL)|(3<<UCSZ0); // Asynchron 8N1 Atmega32 oder Atmega8
}

void uart_putc(char c)
{
 while (!(UCSRA & (1<<UDRE))) ;/* warten bis Senden moeglich */
 UDR = c;                      /* sende Zeichen */
}

bool uart_getcheck()
{
 return !(!(UCSRA & (1<<RXC))); //true wenn ein Zeichen verfuegbar
}
char uart_getc(void)
{
 while (!(UCSRA & (1<<RXC))) ;// warten bis Zeichen verfuegbar
 return UDR; // Zeichen aus UDR an Aufrufer zurueckgeben
}

void uart_write(const char *s)
{
 char c;
 while((c= *s++)!=0) uart_putc(c);
}

static char uartpuffer[80];

void uart_printf(const char *cstr,int n)
{
 sprintf(uartpuffer,cstr,n);
 uart_write(uartpuffer);
}

#ifdef HAUPTPROGRAMM
int main()
{
 char c,i;
 uart_init();
 uart_write("Hallo Welt\r\n");
 while(1)
  {
   if(uart_getcheck())
     {c=uart_getc();
      uart_write("Zeichen empfangen: ");
      uart_putc(c);
      uart_putc('\n');
      if(c=='x')
       {for(i=0;;i++)
	 uart_printf("Schlaufen-test: i=%d\n",i);
       }
     }
  }
 return 0;
}
#endif
