/* turnier.cc			letzte nderung: 28.3.2007 */
#define VERSION "Version 0.0"
/*
 Berechnung optimaler Verteilung von Spielern an Turniertischen

History:
28.3.2007	Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>

/************************* Vordeklarationen ***************************/
void unterprog();

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/*************************** Klassen **********************************/
const int NSPIELER=6,NMAN=4,NPLAETZE=8,NTISCHE=3,NRUNDEN=3;

class Team
{
public:
 int a,b;
 void set(int a0,int b0) {a=a0; b=b0;}
};
class Manschaft
{
public:
 int spieler[NSPIELER];
 Team team[NSPIELER/2];
};
class Tisch
{
public:
 int platz[NPLAETZE];
};
class Runde
{
public:
 Tisch tisch[NTISCHE];
 void print(char *titel,int n=0);
};

static Manschaft manschaft[NMAN];
static Runde runde[NRUNDEN];

/************************* Hauptprogramm ******************************/
//Alle Paarungs-Moeglichkeiten fuer NSPIELER==6:
int paarung[5][6]={
  {0, 1,  2, 3,  4, 5},
  {0, 2,  1, 5,  3, 4},
  {0, 3,  1, 4,  2, 5},
  {0, 4,  1, 2,  3, 5},
  {0, 5,  1, 3,  2, 4}};

int izufall(int a,int b) //ganzzalige Zufallszahl zwischen a und b inklusive
{
 int n=int(double(b+1-a)/RAND_MAX*random())+a;
 if(n>b) return b; //passiert wenn RAND_MAX==random(), also sehr selten
 return n;
}

void unterprog()
{
 int i,j,k,t,p,m,nr,tr;
 if(NSPIELER!=6) {printf("geht nur mit NSPIELER=6\n"); exit(0);}
 for(m=0;m<NMAN;m++)
   for(k=0;k<NSPIELER/2;k++)
     manschaft[m].team[k].set(paarung[0][2*k],paarung[0][2*k+1]);
 for(t=0;t<NTISCHE;t++)
   for(i=t,m=p=0;p<NPLAETZE;m++)
     {runde[0].tisch[t].platz[p++]=manschaft[m].team[i].a+100*m;
      runde[0].tisch[t].platz[p++]=manschaft[m].team[i].b+100*m;
     }
 runde[0].print("1. Runde");
 printf("RAND_MAX=%d\n",RAND_MAX);//test
 for(j=1;j<3;j++)
   {
    for(m=0;m<NMAN;m++)//provi.
      {nr=izufall(0,4);//zufaellige Paarung
       tr=izufall(0,2);//zufaellige Teamreihenfolge
       for(k=0;k<NSPIELER/2;k++,tr=(tr+1)%3)
	  manschaft[m].team[tr].set(paarung[nr][2*tr],paarung[nr][2*tr+1]);
      }
    for(t=0;t<NTISCHE;t++)
      for(i=t,m=p=0;p<NPLAETZE;m++)
	{runde[j].tisch[t].platz[p++]=manschaft[m].team[i].a+100*m;
	 runde[j].tisch[t].platz[p++]=manschaft[m].team[i].b+100*m;
	}
   
    runde[j].print("%d. Runde",j+1);
   }
}

main(int argc,char *argv[])
{
 char quellname[80],zielname[80];
 FILE *fp1,*fp2;
 int i,j,c;
 quellname[0]=zielname[0]=0;
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
		 else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("turnier  %s\n",VERSION);
	//printf("Anwendung: Turnier Quelle [Ziel]\n");
	 exit(0);
	}
 unterprog();
 return 0;
}/* ende von main */

/********************** Klassen-Funktionen ****************************/
void Runde::print(char *titel,int n)
{
 int t,p,c;
 printf(titel,n); printf("\n");
 for(t=0;t<NTISCHE;t++)
   {printf("Tisch %d:",t+1);
    for(p=0;p<NPLAETZE;p++)
      {c=tisch[t].platz[p]/100+'A';
      //printf("tisch[%d].platz[%d]=%d c=%d\n",t,p,tisch[t].platz[p],c);//test
       printf(" %c%d",c,tisch[t].platz[p]%100+1);
      }
    printf("\n");
   }
 printf("\n");
}
