/* turnier.cc			letzte nderung: 2.4.2007 */
#define VERSION "Version 0.3"
/*
 Berechnung optimaler Verteilung von Spielern an Turniertischen

History:
28.3.2007	Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>

/************************* Vordeklarationen ***************************/
void unterprog(int anzahl);

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/*************************** Klassen **********************************/
const int NSPIELER=6,NMAN=4,NPLAETZE=8,NTISCHE=3,NRUNDEN=3;

class Team
{
public:
 int paar[2];
 void set(int a,int b) {paar[0]=a; paar[1]=b;}
};
class Manschaft
{
public:
 int spieler[NSPIELER];
 Team team[NRUNDEN][NSPIELER/2]; //Team-Zusammensetzung fuer jede Runde
};
class Tisch
{
public:
 int platz[NPLAETZE];
 Tisch operator=(Tisch x)
	{for(int i=0;i<NPLAETZE;i++) platz[i]=x.platz[i];
	 return *this;
	}
};
class Runde
{
public:
 Tisch tisch[NTISCHE];
 void print(char *titel,int n=0);
 Runde operator=(Runde x)
	{for(int i=0;i<NTISCHE;i++) tisch[i]=x.tisch[i];
	 return *this;
	}
};

static Manschaft manschaft[NMAN];
static Runde runde[NRUNDEN],besterunden[10][NRUNDEN];
static int bestewertungen[10];

/************************* Hauptprogramm ******************************/
//Alle Paarungs-Moeglichkeiten fuer NSPIELER==6:
int paarung[6*5][6]={
  {0, 1,  2, 3,  4, 5},
  {0, 2,  1, 5,  3, 4},
  {0, 3,  1, 4,  2, 5},
  {0, 4,  1, 2,  3, 5},
  {0, 5,  1, 3,  2, 4},

  {0, 1,  4, 5,  2, 3}, //Reihenfolge 0 2 1
  {0, 2,  3, 4,  1, 5},
  {0, 3,  2, 5,  1, 4},
  {0, 4,  3, 5,  1, 2},
  {0, 5,  2, 4,  1, 3},

  {2, 3,  0, 1,  4, 5}, //Reihenfolge 1 0 2
  {1, 5,  0, 2,  3, 4},
  {1, 4,  0, 3,  2, 5},
  {1, 2,  0, 4,  3, 5},
  {1, 3,  0, 5,  2, 4},

  {2, 3,  4, 5,  0, 1}, //Reihenfolge 1 2 0
  {1, 5,  3, 4,  0, 2},
  {1, 4,  2, 5,  0, 3},
  {1, 2,  3, 5,  0, 4},
  {1, 3,  2, 4,  0, 5},

  {4, 5,  0, 1,  2, 3}, //Reihenfolge 2 0 1
  {3, 4,  0, 2,  1, 5},
  {2, 5,  0, 3,  1, 4},
  {3, 5,  0, 4,  1, 2},
  {2, 4,  0, 5,  1, 3},

  {4, 5,  2, 3,  0, 1}, //Reihenfolge 2 1 0
  {3, 4,  1, 5,  0, 2},
  {2, 5,  1, 4,  0, 3},
  {3, 5,  1, 2,  0, 4},
  {2, 4,  1, 3,  0, 5}
};

//Alle Moeglichkeiten in welcher Reihenfolge die 3 Paare einzusetzen:
int reihenfolge[6][3]={
  {0, 1, 2},
  {0, 2, 1},
  {1, 0, 2},
  {1, 2, 0},
  {2, 0, 1},
  {2, 1, 0}};

int izufall(int a,int b) //ganzzalige Zufallszahl zwischen a und b inklusive
{
 int n=int(double(b+1-a)/RAND_MAX*random())+a;
 if(n>b) return b; //passiert wenn RAND_MAX==random(), also sehr selten
 return n;
}
void zufallsbeispiele(int anzahl)
{
 int i,j,k,t,p,m,nm,nr,tr,re,maxre,su[NMAN],summe,bestesumme=0;
 //printf("RAND_MAX=%d\n",RAND_MAX);//test
 for(int probe=0;probe<anzahl;probe++) //einige zufaellige Probedurchlaeufe
  {
   runde[0].print("1. Runde");
   for(j=1;j<3;j++)
    {
     for(m=0;m<NMAN;m++)//provi.
      {nr=izufall(0,4);//zufaellige Paarung
       re=izufall(0,5);//zufaellige Teamreihenfolge
       for(k=0;k<NSPIELER/2;k++)
	  {tr=2*reihenfolge[re][k];
	   manschaft[m].team[0][k].set(paarung[nr][tr],paarung[nr][tr+1]);
	  }
      }
     for(t=0;t<NTISCHE;t++)
      for(nm=m=p=0;p<NPLAETZE;m++,nm+=NSPIELER)
	{runde[j].tisch[t].platz[p++]=manschaft[m].team[0][t].paar[0]+nm;
	 runde[j].tisch[t].platz[p++]=manschaft[m].team[0][t].paar[1]+nm;
	}
     runde[j].print("%d. Runde",j+1);
    }
   printf("Bewertung:\n");
   //jeder sollte gegen moeglichst viele Gegner spielen:
   for(summe=m=0;m<NMAN;m++)
   {int gegner[6],n,a,a1,liste[NSPIELER*NMAN];
    int m2=2*m,m21=2*m+1;
    for(i=0;i<6;i++) gegner[i]=0;//Liste loeschen
    for(a=0;a<6;a++)
     {a1=a+NSPIELER*m;
      for(i=0;i<NSPIELER*NMAN;i++) liste[i]=0;//Liste loeschen
      for(j=0;j<3;j++)
       for(t=0;t<NTISCHE;t++)
        if(runde[j].tisch[t].platz[m2]==a1 ||
	   runde[j].tisch[t].platz[m21]==a1)
	  for(k=0;k<NPLAETZE;k++)
	    if(k!=m2 && k!=m21)
	      {n=runde[j].tisch[t].platz[k];
	       if(liste[n]==0) {liste[n]=1; gegner[a]++;}
	      }
     }
    for(su[m]=a=0;a<6;a++)
     {printf("%d ",gegner[a]); su[m]+=gegner[a]; summe+=gegner[a];}
    printf("  %d\n",su[m]);
   }
   if(su[0]==su[1] && su[0]==su[2] && su[0]==su[3]) summe+=9000;
   else if(su[0]>=summe/4-1 && su[0]<=summe/4+1 &&
	   su[1]>=summe/4-1 && su[1]<=summe/4+1 &&
	   su[2]>=summe/4-1 && su[2]<=summe/4+1 &&
	   su[3]>=summe/4-1 && su[3]<=summe/4+1) summe+=8000;
   printf("Totalbewertung=%d\n\n",summe);
   if(summe>bestesumme) bestesumme=summe;
  }
 printf("Beste Bewertung: %d\n",bestesumme);
}

int bewertung(int dru=0)
{
 int summe,su[NMAN],m,i,j,k,t;
 if(dru>=2) for(i=0;i<NRUNDEN;i++) runde[i].print("%d. Runde",i+1);
 for(summe=m=0;m<NMAN;m++)
   {int gegner[6],n,a,a1,liste[NSPIELER*NMAN];
    int m2=2*m,m21=2*m+1;
    for(i=0;i<6;i++) gegner[i]=0;//Liste loeschen
    for(a=0;a<6;a++)
     {a1=a+NSPIELER*m;
      for(i=0;i<NSPIELER*NMAN;i++) liste[i]=0;//Liste loeschen
      for(j=0;j<3;j++)
       for(t=0;t<NTISCHE;t++)
        if(runde[j].tisch[t].platz[m2]==a1 ||
	   runde[j].tisch[t].platz[m21]==a1)
	  for(k=0;k<NPLAETZE;k++)
	    if(k!=m2 && k!=m21)
	      {n=runde[j].tisch[t].platz[k];
	       if(liste[n]==0) {liste[n]=1; gegner[a]++;}
	      }
     }
    for(su[m]=a=0;a<6;a++)
     {su[m]+=gegner[a]; summe+=gegner[a];
      if(dru) printf(" %d",gegner[a]);
     }
    if(dru) printf("  %d\n",su[m]);
   }
 if(dru) printf("Totalbewertung=%d\n",summe);
 if(argflag['F'])
   {int smin1=summe/4-2,smax1=summe/4+2;
    int smin2=smin1-1,smax2=smax1+1;
    if(su[0]==su[1] && su[0]==su[2] && su[0]==su[3]) summe+=30;
    else if(su[0]>=smin1 && su[0]<=smax1 &&
	    su[1]>=smin1 && su[1]<=smax1 &&
	    su[2]>=smin1 && su[2]<=smax1 &&
	    su[3]>=smin1 && su[3]<=smax1) summe+=20;
    else if(su[0]>=smin2 && su[0]<=smax2 &&
	    su[1]>=smin2 && su[1]<=smax2 &&
	    su[2]>=smin2 && su[2]<=smax2 &&
	    su[3]>=smin2 && su[3]<=smax2) summe+=10;
   }
return summe;
}

void unterprog(int anzahl)
{
 int i,j,k,t,p,m,nm,summe,bestesumme=0;
 if(NSPIELER!=6) {printf("geht nur mit NSPIELER=6\n"); exit(0);}
 //1. Runde. nur eine einzige Moeglichkeit:
 for(m=0;m<NMAN;m++)
   for(k=0;k<NSPIELER/2;k++)
     manschaft[m].team[0][k].set(paarung[0][2*k],paarung[0][2*k+1]);
 for(t=0;t<NTISCHE;t++)
   for(nm=m=p=0;p<NPLAETZE;m++,nm+=NSPIELER)
     {runde[0].tisch[t].platz[p++]=manschaft[m].team[0][t].paar[0]+nm;
      runde[0].tisch[t].platz[p++]=manschaft[m].team[0][t].paar[1]+nm;
     }
 //runde[0].print("Runde[0]");//test
 zufallsbeispiele(anzahl);
 //2. und 3. Runde alle Moeglichkeiten durchrechnen:
 //4*24^3*3*18^3=967'458'816 Moeglichkeiten
 int ru,nr[NMAN],nr2[NMAN],re[NMAN],re2[NMAN],*pa,durchlauf=0;
 for(int i=0;i<10;i++) bestewertungen[i]=0;
 re[0]=re2[0]=0; //fuer erste Manschaft nur eine Reihenfolge relevant
 for(nr[0]=1;nr[0]<5;nr[0]++) //alle Paarungsmoeglichkeiten fuer Manschaft A
 for(nr[1]=1;nr[1]<5;nr[1]++) //alle Paarungsmoeglichkeiten fuer Manschaft B
 for(re[1]=0;re[1]<6;re[1]++) //alle Reihenfolgen fuer Manschaft B
 for(nr[2]=1;nr[2]<5;nr[2]++) //alle Paarungsmoeglichkeiten fuer Manschaft C
 for(re[2]=0;re[2]<6;re[2]++) //alle Reihenfolgen fuer Manschaft C
 for(nr[3]=1;nr[3]<5;nr[3]++) //alle Paarungsmoeglichkeiten fuer Manschaft D
 for(re[3]=0;re[3]<6;re[3]++) //alle Reihenfolgen fuer Manschaft D
 for(nr2[0]=1;nr2[0]<5;nr2[0]++) //alle Paarungsmoeglichkeiten fuer Manschaft A
 if(nr2[0]!=nr[0])
 for(nr2[1]=1;nr2[1]<5;nr2[1]++) //alle Paarungsmoeglichkeiten fuer Manschaft B
 if(nr2[1]!=nr[1])
 for(re2[1]=0;re2[1]<6;re2[1]++) //alle Reihenfolgen fuer Manschaft B
 for(nr2[2]=1;nr2[2]<5;nr2[2]++) //alle Paarungsmoeglichkeiten fuer Manschaft C
 if(nr2[2]!=nr[2])
 for(re2[2]=0;re2[2]<6;re2[2]++) //alle Reihenfolgen fuer Manschaft C
 for(nr2[3]=1;nr2[3]<5;nr2[3]++) //alle Paarungsmoeglichkeiten fuer Manschaft D
 if(nr2[3]!=nr[3])
 for(re2[3]=0;re2[3]<6;re2[3]++) //alle Reihenfolgen fuer Manschaft D
  {//dieser Teil wird also 967'458'816 mal durchlaufen.
   if(++durchlauf%10000000==0 && durchlauf<100000000 || durchlauf%100000000==0)
       printf("%d Millionster Durchlauf\n",durchlauf/1000000);//test
   //if(durchlauf>=20000000) goto endausdruck; //test
   for(ru=1;ru<3;ru++) //2. und 3. Runde
     for(nm=p=m=0;m<NMAN;m++,nm+=NSPIELER,p+=2)
       {pa = (ru==1) ? paarung[nr[m]+5*re[m]] : paarung[nr2[m]+5*re2[m]];
	for(t=0;t<NTISCHE;t++)
          {runde[ru].tisch[t].platz[p] = *pa++ + nm;
	   runde[ru].tisch[t].platz[p+1] = *pa++ + nm;
	  }
       }
   //Bewertung und beste speichern:
   summe=bewertung();
   if(summe>bestesumme)
       {printf("Bisher Beste: %d  (%d. Durchlauf)\n",
	       bestesumme=summe,durchlauf);
        for(int j=9;j>0;--j) 
	    {for(int i=0;i<NRUNDEN;i++) besterunden[j][i]=besterunden[j-1][i];
	     bestewertungen[j]=bestewertungen[j-1];
	    }
        for(int i=0;i<NRUNDEN;i++) besterunden[0][i]=runde[i];
	bestewertungen[0]=bestesumme;
	if(summe>300) bewertung(2);
       }
  }
 endausdruck:
 printf("totale Anzahl Durchlaeufe: %d\n",durchlauf);//test
 printf("Beste Bewertungen:\n");
 for(int j=0;j<10 && bestewertungen[j]>0;j++)
   {printf("%d. Rang Bewertung=%d:\n",j+1,bestewertungen[j]);
    for(int i=0;i<NRUNDEN;i++) runde[i]=besterunden[j][i];
    bewertung(2);
   }
}

void unterprog2(int anzahl)
{
 int i,j,k,t,p,m,nm,summe,bestesumme=0;
 if(NSPIELER!=6) {printf("geht nur mit NSPIELER=6\n"); exit(0);}
 //1. Runde. nur eine einzige Moeglichkeit:
 for(m=0;m<NMAN;m++)
   for(k=0;k<NSPIELER/2;k++)
     manschaft[m].team[0][k].set(paarung[0][2*k],paarung[0][2*k+1]);
 for(t=0;t<NTISCHE;t++)
   for(nm=m=p=0;p<NPLAETZE;m++,nm+=NSPIELER)
     {runde[0].tisch[t].platz[p++]=manschaft[m].team[0][t].paar[0]+nm;
      runde[0].tisch[t].platz[p++]=manschaft[m].team[0][t].paar[1]+nm;
     }
 //runde[0].print("Runde[0]");//test
 zufallsbeispiele(anzahl);
 //2. und 3. Runde alle Moeglichkeiten mit jeweils nur einer Aenderung
 //der Paarungen:
 //4*((4+12)*6*6)^3=4*(16*36)^3=764'411'904 Moeglichkeiten ?
 int ru,nr[NMAN],nr2[NMAN],re[NMAN],re2[NMAN],*pa,durchlauf=0;
 for(int i=0;i<10;i++) bestewertungen[i]=0;
 re[0]=re2[0]=0; //fuer erste Manschaft nur eine Reihenfolge relevant
 nr[0]=0; //Manschaft A verwendet bei 2. Runde selbe Paarungsmoeglichkeit
 for(nr[1]=0;nr[1]<5;nr[1]++) //alle Paarungsmoeglichkeiten fuer Manschaft B
 for(re[1]=0;re[1]<6;re[1]++) //alle Reihenfolgen fuer Manschaft B
 for(nr[2]=0;nr[2]<5;nr[2]++) //alle Paarungsmoeglichkeiten fuer Manschaft C
 for(re[2]=0;re[2]<6;re[2]++) //alle Reihenfolgen fuer Manschaft C
 for(nr[3]=0;nr[3]<5;nr[3]++) //alle Paarungsmoeglichkeiten fuer Manschaft D
 for(re[3]=0;re[3]<6;re[3]++) //alle Reihenfolgen fuer Manschaft D
 for(nr2[0]=1;nr2[0]<5;nr2[0]++) //alle Paarungsmoeglichkeiten fuer Manschaft A
 for(nr2[1]=0;nr2[1]<5;nr2[1]++) //alle Paarungsmoeglichkeiten fuer Manschaft B
 //Test auf Verwendung von genau 2 mal selber Paarungsmoeglichkeit fur B:
 if((nr[1]==0 && nr2[1]!=0) || (nr[1]!=0 && (nr2[1]==0 || nr2[1]==nr[1])))
 for(re2[1]=0;re2[1]<6;re2[1]++) //alle Reihenfolgen fuer Manschaft B
 for(nr2[2]=0;nr2[2]<5;nr2[2]++) //alle Paarungsmoeglichkeiten fuer Manschaft C
 if((nr[2]==0 && nr2[2]!=0) || (nr[2]!=0 && (nr2[2]==0 || nr2[2]==nr[2])))
 for(re2[2]=0;re2[2]<6;re2[2]++) //alle Reihenfolgen fuer Manschaft C
 for(nr2[3]=0;nr2[3]<5;nr2[3]++) //alle Paarungsmoeglichkeiten fuer Manschaft D
 if((nr[3]==0 && nr2[3]!=0) || (nr[3]!=0 && (nr2[3]==0 || nr2[3]==nr[3])))
 for(re2[3]=0;re2[3]<6;re2[3]++) //alle Reihenfolgen fuer Manschaft D
  {//dieser Teil wird also 764'411'904 mal durchlaufen ?
   if(++durchlauf%10000000==0 && durchlauf<100000000 || durchlauf%100000000==0)
       printf("%d Millionster Durchlauf\n",durchlauf/1000000);//test
   //if(durchlauf>=20000000) goto endausdruck; //test
   for(ru=1;ru<3;ru++) //2. und 3. Runde
     for(nm=p=m=0;m<NMAN;m++,nm+=NSPIELER,p+=2)
       {pa = (ru==1) ? paarung[nr[m]+5*re[m]] : paarung[nr2[m]+5*re2[m]];
	for(t=0;t<NTISCHE;t++)
          {runde[ru].tisch[t].platz[p] = *pa++ + nm;
	   runde[ru].tisch[t].platz[p+1] = *pa++ + nm;
	  }
       }
   //Bewertung und beste speichern:
   summe=bewertung();
   if(summe>bestesumme)
       {printf("Bisher Beste: %d  (%d. Durchlauf)\n",
	       bestesumme=summe,durchlauf);
        for(int j=9;j>0;--j) 
	    {for(int i=0;i<NRUNDEN;i++) besterunden[j][i]=besterunden[j-1][i];
	     bestewertungen[j]=bestewertungen[j-1];
	    }
        for(int i=0;i<NRUNDEN;i++) besterunden[0][i]=runde[i];
	bestewertungen[0]=bestesumme;
	if(summe>300) bewertung(2);
       }
  }
 endausdruck:
 printf("totale Anzahl Durchlaeufe: %d\n",durchlauf);//test
 printf("Beste Bewertungen:\n");
 for(int j=0;j<10 && bestewertungen[j]>0;j++)
   {printf("%d. Rang Bewertung=%d:\n",j+1,bestewertungen[j]);
    for(int i=0;i<NRUNDEN;i++) runde[i]=besterunden[j][i];
    bewertung(2);
   }
}

main(int argc,char *argv[])
{
 char quellname[80],zielname[80];
 FILE *fp1,*fp2;
 int i,j,c,anzahl=0;
 quellname[0]=zielname[0]=0;
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) sscanf(argv[i],"%d",&anzahl);
	 //else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
   {printf("turnier  %s\n",VERSION);
    printf("Anwendung: Turnier [-flags] [anzahlzufallsversuche]\n");
    printf("  flags: p=Paarbildung bei jeder Manschaft 2 mal gleich\n");
    printf("         f=Fairflag, bessere Wertung wenn alle Manschaften gegen\n");
    printf("           moeglichst gleichviele Gegner spielen.\n");
    printf("           macht nur Sinn zusammen mit p-Flag (sonst gleiche Resultate)\n");
    exit(0);
   }
 if(argflag['P']) unterprog2(anzahl);
 else unterprog(anzahl);
 return 0;
}/* ende von main */

/********************** Klassen-Funktionen ****************************/
void Runde::print(char *titel,int n)
{
 int t,p,c;
 printf(titel,n); printf("\n");
 for(t=0;t<NTISCHE;t++)
   {printf("Tisch %d:",t+1);
    for(p=0;p<NPLAETZE;p++)
      {c=tisch[t].platz[p]/NSPIELER+'A';
       //printf("tisch[%d].platz[%d]=%d c=%d\n",t,p,tisch[t].platz[p],c);//test
       printf(" %c%d",c,tisch[t].platz[p]%NSPIELER+1);
      }
    printf("\n");
   }
 printf("\n");
}
