/* ep.cc			letzte nderung: 3.11.2000 */
#define VERSION "Version 0.0"
/*

 Kurzbeschreibung: BoundingBox lesen und Umrechnung machen

History:
0.3.2000	Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>

/************************* Vordeklarationen ***************************/

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 3
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/*************************** kleinkram ***************************/
int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char quellname[80],zeile[80];
 FILE *fp;
 int i,j,c,gefunden=0;
 double xwert=100,ywert=0,x1,y1,x2,y2,dx,dy;
 quellname[0]=0;
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
	         else if(j==2) sscanf(argv[i],"%lf",&xwert);
	         else if(j==3) sscanf(argv[i],"%lf",&ywert);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("ep  %s\n",VERSION);
	 printf("Anwendung: ep name.eps xwert [ywert]\n");
	 printf("  xwert oder ywert muss 0 sein, als Resultat erhaelt\n");
	 printf("  man dann den richtig skalierten Wert.\n");
	 exit(0);
	}
 if(*quellname==0) {printf("EPS-Datei:"); scanf("%s",quellname);}
 if(fp=fopen(quellname,"r"))
   {while(getline(fp,zeile,80))
	  {if(strncmp("%%BoundingBox:",zeile,14)==0)
	    {sscanf(&zeile[14],"%lf %lf %lf %lf",&x1,&y1,&x2,&y2);
	     printf("%lf %lf %lf %lf\n",x1,y1,x2,y2);//test
	     dx=x2-x1; dy=y2-y1;
	     if(xwert==0) {xwert=ywert/dy*dx;}
	     else {ywert=xwert/dx*dy;}
	     printf("x=%.0lf  y=%.0lf\n",xwert,ywert);
	     gefunden=1;
	     break;
	    }
	  }
    if(!gefunden) printf("keine BoundingBox gefunden\n");
   }
 else
   {printf("Datei '%s' nicht gefunden\n",quellname);}
 if(fp) fclose(fp);
 return 0;
}/* ende von main */

void unterprog(FILE *fp1,FILE *fp2)
{
 printf("unterprog() erreicht\n");
}
