/* ersatz.c */
/*
@LINK ersatz,SYS$INPUT/OPT
SYS$SHARE:DECW$XLIBSHR/SHARE
;>gcc ersatz.c -o ersatz -O2

History:
ca. 1993	Erstellung (RPF)
 26.2.95	Test ob es wirklich was zu ersetzen gibt (hatwas)
13.10.95	Anpassung an Amiga, Einfhrung des -Q Flags
10.7.97		Weiteres Flags: M fuer Mehrere Dateien,
				i fuer nur Ersatz innerhalb #include-Zeile
3.12.98		Fehler korrigiert: ersatz[2]=NULL gesetzt
*/

/*#define VAX /**/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
typedef char *STRING;
STRING ersatz[3];
/* Vordeklarationen (von C2CPP erzeugt): */
char *einlesen(char* quelle);
void ersatzcopy(char* p1,FILE* fp2);
char **intabelle(int c,char** pp1);
int hatwas(char* p1);
/* Ende der Vordeklarationen */

static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

main(int argc,char *argv[])
{
 FILE *fp2;
 char *quelle,*ziel,*p1;
 int i,j,c,moderz,i1,imax;
 for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) ersatz[0]=argv[i];
		 else if(j==2) ersatz[1]=argv[i];
		 else if(j==3) quelle=argv[i1=i];
		 else if(j==4) ziel=argv[i];
	}	}
 ersatz[2]=NULL;
 //printf("ersatz[]='%s' '%s'\n",ersatz[0],ersatz[1]);//test
 moderz=(argflag['M'] || argflag['Z']);
 if(argflag['?'] || j<3 || (argflag['M'] && argflag['Z'])
    || (!moderz && j>3) || (argflag['Z'] && j<4))
  {printf("Anwendung: ersatz [-Flags] \"SuchText\" \"ErsatzText\" Dateiname [Zielname]\n");
   printf("  Anfhrungszeichen in einem String: \"\\\"geht so\\\"\"\n");
   printf("  Flags: Q = keine Kommentare ausgeben (quiet)\n");
   printf("         M = Mehrere Dateien durchsuchen\n");
   printf("             (in diesem Fall darf keine Zieldatei angegeben werden)\n");
   printf("         Z = Zieldatei angegeben (somit darf M nicht gesetzt sein)\n");
   printf("         i = nur Ersatz innerhalb #include-Zeilen machen\n");
   printf("             (Typische Anwendung: ersatz -im \"\\\\\" \"/\" *.c)\n");
   exit(0);
  }
 imax = (argflag['M']) ? j-2+i1 : i1+1;
// printf("j=%d i1=%d imax=%d\n",j,i1,imax);//test
 for(i=i1;i<imax;i++)
  {p1=einlesen(quelle=argv[i]);
   if(hatwas(p1))
     {if(!argflag['Z']) ziel=quelle;
      fp2=fopen(ziel,"w");
      if(fp2==NULL) {printf("Fehler beim Oeffnen von '%s'\n",ziel); exit(0);}
      ersatzcopy(p1,fp2);
      fclose(fp2);
     }
  }
}/* ende von main */

#ifdef VAX
char *einlesen(char* quelle)
{
 char str[80],*p1,*p;
 FILE *fp,*fp2;
 int blocks,nbytes,c;
 if(!(fp=fopen(quelle,"r")))
	{printf("'%s' nicht gefunden\n",quelle); exit(0);}
 sprintf(str,"dir/size/output=temp.dat %s",quelle);
 system(str);
 fp2=fopen("temp.dat","r");
 if(fp2!=NULL)
  {fscanf(fp2,"%s %s %s %d",str,str,str,&blocks);
   fclose(fp2);
   system("del temp.dat;");
  }
 else printf("Fehler fp2\n");
 nbytes=512*blocks;
 p1=(char*)calloc(1,nbytes);
 if(p1==NULL) printf("Fehler: calloc(1,%d)\n",nbytes);
 for(p=p1;(c=getc(fp))!=EOF;)  *p++ = c;
 *p=0;
 fclose(fp);
 return p1;
}

#else /* allgemeine Variante - aber langsamer */

char *einlesen(char* quelle)
{
 char *p1,*p;
 FILE *fp,*fp2;
 long nbytes;
 int c;
 if(!(fp=fopen(quelle,"r")))
	{printf("'%s' nicht gefunden\n",quelle); exit(0);}
 for(nbytes=1;(c=getc(fp))!=EOF;nbytes++) ;
 fclose(fp); fp=fopen(quelle,"r");
 p1=(char*)calloc(1,nbytes);
 if(p1==NULL) printf("Fehler: calloc(1,%ld)\n",nbytes);
 for(p=p1;(c=getc(fp))!=EOF;)  *p++ = c;
 *p=0;
 fclose(fp);
 return p1;
}
#endif

void ersatzcopy1(char* p1,FILE* fp2)
{
 int c;
 char *s,*s1,**ps;
 while(c= *p1++)
	{if((ps=intabelle(c,&p1))==NULL)
		putc(c,fp2);
	 else
		{s1= *ps++; s= *ps;
		 if(!argflag['Q']) printf("'%s' ersetzt durch '%s'\n",s1,s);
		 while(c= *s++) putc(c,fp2);
		}
	}
 return;
}

char **intabelle(int c,char** pp1)
{
 char *p,*p1;
 STRING *s;
 int c1,c2;
 p1= *pp1;
 for(s=ersatz; p= *s; s+=2)
	{if(c!= *p) continue;
	 while(c2= *++p)
		if((c1= *p1++)==0 || c1!=c2) break;
	 if(c2==0)
		{*pp1=p1; return s;}
	 p1= *pp1;
	}
 return NULL;
}

int hatwas1(char* p1)
{
 int c;
 char *s,**ps;
 while(c= *p1++)
	{if((ps=intabelle(c,&p1))!=NULL) return 1;}
 return 0;
}

int hatwas(char* p1)
{
 int c,incflag=0;
 char *s,**ps;
 if(!argflag['I']) {return hatwas1(p1);}
 while(c= *p1++)
   {if(c=='#' && strncmp(p1,"include",7)==0) incflag=1;
    else if(c=='\n') incflag=0;
    if(incflag && (ps=intabelle(c,&p1))!=NULL) return 1;
   }
 return 0;
}

void ersatzcopy(char* p1,FILE* fp2)
{
 int c,incflag=0;
 char *s,*s1,**ps;
 if(!argflag['I']) {ersatzcopy1(p1,fp2); return;}
 while(c= *p1++)
   {if(c=='#' && strncmp(p1,"include",7)==0) incflag=1;
    else if(c=='\n') incflag=0;
    if(incflag && (ps=intabelle(c,&p1))!=NULL)
	{s1= *ps++; s= *ps;
	 if(!argflag['Q']) printf("'%s' ersetzt durch '%s'\n",s1,s);
	 while(c= *s++) putc(c,fp2);
	}
    else
	putc(c,fp2);
   }
 return;
}
